/* --------------------------------- notes.h -------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Define notes stuff for tunes.c.
*/

/* pitch */

#define	RR	0		/* rest */

#define	CN	2093		/* note pitch */
#define	CSH	2217
#define	DFL	2217
#define	DN	2349
#define	DSH	2489
#define	EFL	2489
#define	EN	2637
#define	FN	2794
#define	FSH	2960
#define	GFL	2960
#define	GN	3136
#define	GSH	3322
#define	AFL	3322
#define	AN	3520
#define	ASH	3729
#define	BFL	3729
#define	BN	3951

#define	H	1L		/* C5=32.7Hz */
#define	I	2L		/* C6=65.4Hz */
#define	J	4L		/* C7=130.8Hz */
#define	K	8L		/* C8=261.6Hz [A8=440Hz]*/
#define	L	16L		/* C9=523.3Hz */
#define	M	32L		/* C10=1046.5Hz */
#define	N	64L		/* C11=2093Hz */


/* duration */

#define	T1		(16*64*4*3)		/* 1 = 4*millisecs */
#define	T2		(T1/2)
#define	T4		(T1/4)
#define	T8		(T1/8)
#define	T16		(T1/16)
#define	T32		(T1/32)
#define	T64		(T1/64)
#define	TT1		(T1*2/3)
#define	TT2		(TT1/2)
#define	TT4		(TT1/4)
#define	TT8		(TT1/8)
#define	TT16		(TT1/16)
#define	TT32		(TT1/32)
#define	TT64		(TT1/64)
#define	D1		(T1*3/2)
#define	D2		(D1/T2)
#define	D4		(D1/T4)
#define	D8		(D1/T8)
#define	D16		(D1/T16)
#define	D32		(D1/T32)
#define	D64		(D1/T64)
#define	DD1		(T1*7/4)
#define	DD2		(DD1/2)
#define	DD4		(DD1/4)
#define	DD8		(DD1/8)
#define	DD16		(DD1/16)
#define	DD32		(DD1/32)
#define	DD64		(DD1/64)


/* articulation */

#define	SLUR	0	/* macro P */
#define	LEGATO	1/16	/* macro PL */
#define	SLEG	1/8	/* macro PSL */
#define	SSLEGA	1/4	/* macro PSSL */
#define	STACO	1/2	/* macro PST */
#define	SSTACO	5/8	/* macro PSST */


/* macros */

#define	P(o,n,d)	(int)(n*o/N),(int)(d)
#define	R(d)		RR,(int)(d)
#define	PL(o,n,d)	(int)(n*o/N),(int)((d)-(d)*LEGATO), \
			RR,(int)((d)*LEGATO)
#define	PSL(o,n,d)	(int)(n*o/N),(int)((d)-(d)*SLEG), \
			RR,(int)((d)*SLEG)
#define	PSSL(o,n,d)	(int)(n*o/N),(int)((d)-(d)*SSLEG), \
			RR,(int)((d)*SSLEG)
#define	PST(o,n,d)	(int)(n*o/N),(int)((d)-(d)*STACO), \
			RR,(int)((d)*STACO)
#define	PSST(o,n,d)	(int)(n*o/N),(int)((d)-(d)*SSTACO), \
			RR,(int)((d)*SSTACO)

#define	CEND		-1
#define	CGO		-2
#define	CRPT		-3

#define	GOTO(a)		CGO,a
#define	REPEAT(a,n)	CRPT,a,n,0
#define	END		CEND,0

