/* --------------------------------- drivers.c ------------------------------ */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* User defined lists of drivers.
 *
 * Associated with the player we have one of each:
 *  Graphics Driver (output)
 *  Sound Driver (output)
 *  Keyboard Driver (input)
 *  Pointer Driver (input)
 *  Network Drivers (i/o)
*/

#include "fly.h"

extern struct GrDriver GrQc;
extern struct GrDriver GrT4k;

extern struct GrDriver *GrDrivers[] = {
	&GrQc,		/* default */
	&GrT4k,
0};


extern struct SndDriver SndSpeaker;

extern struct SndDriver *SndDrivers[] = {
	&SndSpeaker,
0};


extern struct PtrDriver PtrKeypad;
extern struct PtrDriver PtrMouse;
extern struct PtrDriver PtrAstick;
extern struct PtrDriver PtrBstick;
extern struct PtrDriver PtrRandom;

extern struct PtrDriver *PtrDrivers[] = {
	&PtrKeypad,
	&PtrMouse,
	&PtrAstick,
	&PtrBstick,
	&PtrRandom,
0};


extern struct KbdDriver KbdConsole;

extern struct KbdDriver *KbdDrivers[] = {
	&KbdConsole,
0};


extern struct NetDriver NetCom;
extern struct NetDriver NetPack;
extern struct NetDriver NetSlip;

extern struct NetDriver *NetDrivers[] = {
	&NetCom,
	&NetPack,
	&NetSlip,
0};


extern Uchar *StFont1[];
extern Uchar *StFont2[];

extern Uchar **StFonts[] = {
	StFont1,
	StFont2,
	StFont1,
	StFont1,
	StFont1,
	StFont1,
	StFont1,
	StFont1,
	StFont1,
	StFont1
};
