/* --------------------------------- stick.c -------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Handler for the joy-stick as a pointing device.
 * Amiga joy-stick routines by Michael Taylor
*/

#include <stdio.h>
#include <stdlib.h>

#include "fly.h"

#define PO	p->opt

/*
	the following is the header for the joystick routines
	
* JOY.asm
*
* subroutine for checking Amiga's gameports
* this source for a68k
*
* by Oliver Wagner, Landsberge 5, 4322 Sprockhvel, West Germany
*
* This is Public Domain, Enjoy!
*

*/

#define JOY_LEFT 1
#define JOY_RIGHT 2
#define JOY_UP 4
#define JOY_DOWN 8
#define JOY_FIRE 16

extern short joy0(),joy1();

static int
init ()
{
        return (0);
}

static int far
read (POINTER *p)
/*
 * Read joy-stick. Values are adjusted to 0...200.
 *
 */
{
	int		px, py;
	unsigned int	x, y;
	
	short		codeval;

	codeval = joy1 ();
	
	p->b[PO[5]] = (codeval&JOY_FIRE && JOY_FIRE);	/* left button */

	x = -1*((codeval&JOY_LEFT) && JOY_LEFT) +
		1*((codeval&JOY_RIGHT) && JOY_RIGHT);	/* range is -1 to 1 */
		 
	y = -1*((codeval&JOY_DOWN) && JOY_DOWN) +
		1*((codeval&JOY_UP) && JOY_UP);		/* range is -1 to 1 */

calcpos:
	px = PO[1];
	py = PO[3];

#define	REF	100		/* expected full range */
#define	EDGE	10		/* movement increment  */

	p->a[px] += x * EDGE * PO[0];
	if (p->a[px] > REF)
		p->a[px] = REF;
	else if (p->a[px] < -REF)
		p->a[px] = -REF;
	p->a[py] += y * EDGE * PO[2];
	if (p->a[py] > REF)
		p->a[py] = REF;
	else if (p->a[py] < -REF)
		p->a[py] = -REF;

	return (0);
}

static int far
cal (POINTER *p)
/*
 * Calibrate joy-stick. Paddle must be at center!
 *
 */
{
	p->c[PO[1]] = 0;
	p->c[PO[3]] = 0;
	p->a[PO[1]] = p->a[PO[3]] = 0;
	return (0);  /* this function always works */
}

static void far
term (POINTER *p)
{
	return;
}

static int far
center (POINTER *p)
{
	p->a[PO[1]] = p->a[PO[3]] = 0;
	p->l[PO[1]] = p->l[PO[3]] = 0;

	return (0);
}

struct PtrDriver PtrAstick = {
	"ASTICK",
	0,
	cal,			/* init */
	term,
	cal,
	center,
	read,
	std_key
};

struct PtrDriver PtrBstick = {
	"BSTICK",
	0,
	cal,			/* init */
	term,
	cal,
	center,
	read,
	std_key
};
