//contains header information for the yakWindows classes; at this
//stage, just yakWindowPane
#ifndef YAKWIN.H
#define YAKWIN.H

#include "stddefs.h"
#include "xlib.h"
#include <stdlib.h>

class yakWindowPane
{
public:
  word x, y, width, bWidth, height, myOffset;  //bwidth is width in nibbles
  far byte * myGraphicData;
  yakWindowPane(void) {x = y = bWidth = height = myOffset = 0; myGraphicData = NULL;};
  yakWindowPane(word x1, word y1, word x2, word y2);
  ~yakWindowPane() {delete myGraphicData;};
  void reSave(word x1, word y1, word x2, word y2, word offset);
  void save(word x1, word y1, word offset);
  void save(void);
  void restore(word offset);
  void restore(void);
};

class yakWindow : public yakWindowPane
{
public:
  static yakWindow * killPointer;
  enum flags {isSizeable = 0x01, isDraggable = 0x02, isCloseable = 0x04, isTemporary = 0x08};
  word myNumber;
  flags myFlags;
  byte titleBarColor, textColor, boxColor;
  char title[80];
  yakWindow * nextWindow, * prevWindow;
  static yakWindow * bottomWindow, * topWindow;
  static yakWindow * activeWindow;
  yakWindow(int x1, int y1, int x2, int y2);
  void open(void);
  void close(void);
  void showActivated(void);
  void showActivated(word offset);
  void showDeActivated(void);
  void showDeActivated(word offset);
  virtual void draw(word offset); //redefine this one!
  virtual void draw(void);
  void shuffleToTop(void);
  virtual word interpretMouseClick(void);
  virtual word interpretKeyStroke(char myChar);
  void drag(void);
  void size(void);
  virtual int isSelected(void);
  virtual int isDragSelected(void);
  virtual int isSizeSelected(void);
  virtual int isCloseSelected(void);
  static void drawAll(void);
  static void selectToTop(void);
  static word advance(void);
};

#endif