COMMENT *

	By: Henry A. Groover
	CSV: 70741,417

	This little TSR remaps the strange Tandy keyboard so
	that decent normal programs that expect decent normal
	BIOS codes (like MS Word, Norton Commander, etc.) get
	what they want.  On an IBM-PC, when you press the grey
	+ key, a code of 4E2B hexadecimal becomes available to
	our programs.  We can therefore have the grey plus key
	look for 4E2B hex and distinguish that from the code 
	produced by the regular + key.

	However, Tandy, in its infinite wisdom, has departed
	grossly from the standard codes IBM has so carefully
	maintained all the way from the most primitive PC to
	the AT.  Shame on you, Tandy!  And the keyboard has a
	lousy touch also, somewhere between the 'Chiclet' key-
	board on the extinct PCjr and a Taiwanese off-brand
	keyboard.

	This program, when compiled and included in your AUTOEXEC.BAT
	file, will make your Tandy keyboard look just like an IBM
	keyboard to anything except maybe some hardcore game programs
	which don't follow the rules of compatible programming.

	To compile: (type in the semicolons!)
MASM TANDY;
LINK TANDY;
EXE2BIN TANDY.EXE TANDY.COM
	and you're done.

	If you don't have MASM or ASM, cut the following out into a file
	named TEMP.TXT:
-------- don't include this line -------
235  84 144   0   0   0   0 251
 10 228 117  69 156  46 255  30
  3   1  61  45  83 117   4 184
 45  74 207  61  43  85 117   4
184  43  78 207  61  46  86 117
  4 184  46  83 207  61 126  72
117   4 184 126  41 207  61  96
 80 117   4 184  96  41 207  61
124  75 117   4 184 124  43 207
 61  92  71 117   3 184  92  43
207  46 255  46   3   1 140 203
142 219 176  22 180  53 205  33
 87 191   3   1 137  29 140  69
  2  95 140 203 142 219 186   7
  1 176  22 180  37 205  33 140
203 142 219 186  86   1 205  39
-------- and don't include this line ---

	and type the following program into BASIC (everyone has BASIC):
10 OPEN "I",#1,"TEMP.TXT"
15 OPEN "O",#2,"TANDY.COM"
20 INPUT #1,B
30 PRINT #2,CHR$(B);
40 IF NOT EOF(1) THEN GOTO 20
50 CLOSE: END
RUN

	and that's all.  The command
TANDY
	should be inserted into your AUTOEXEC.BAT file before any other TSR's
	like SideKick, etc.

* ; end of comments

DOS_call                       equ     16H   ; kbd IO vector
DOS_function                   equ     21H   ; DOS function
DOS_replace_vector             equ     16H   ; 15H for debugging
DOS_terminate_resident         equ     27H   ; Terminate, stayres
get_vector                     equ     35H   ; Get vector function
set_vector                     equ     25H   ; Set vector function

CSEG SEGMENT
        assume        cs:cseg, ds:cseg
        org           100H

; jump over interceptor code to initialize
start:
        jmp            initialize

; application begins here:

old_call               dd  ?   ; old keyboard vector

; keyboard intercept routine
call_interceptor              proc far
       assume          cs:cseg,ds:cseg     ; default segments
       sti                                 ; enable interrupts
       or              ah,ah               ; Is AH = 0 (read request)?
       jnz             ki2                 ; If not so, do special routine
       pushf                               ; simulates INT call
       assume          ds:nothing          ; Rather than rewrite keyboard
       call            old_call            ; handler, we use it.
	Cmp	ax, 532dh		; replace bogus Tandy codes w/ normal; grey -
	Jne	Not_esc			; values
	Mov	ax, 4a2dh
	Iret				; and we're done
Not_esc:
	Cmp	ax, 552bh		; check for grey +
	Jne	Del_dot
	Mov	ax, 4e2bh		; replace with proper value
	Iret
Del_dot:
	Cmp	ax, 562eh
	Jne	Tilde
	Mov	ax, 532eh
	Iret
Tilde:
	Cmp	ax, 487eh
	Jne	back_accent
	Mov	ax, 297eh
	Iret
Back_accent:
	Cmp	ax, 5060h
	Jne	Pipe
	Mov	ax, 2960h
	Iret
Pipe:
	Cmp	ax, 4b7ch
	Jne	Backslash
	Mov	ax, 2b7ch
	Iret
Backslash:
	Cmp	ax, 475ch
	Jne	ki1
	Mov	ax, 2b5ch
ki1:   iret                                ; interrupt return
ki2:   assume          ds:nothing          ; for other than READ requests
       jmp             old_call            ; turn off all assumptions
call_interceptor   endp
; end of application code
initialize:
       mov             bx,cs               ; make DSEG = CSEG
       mov             ds,bx               ;

       mov             al,DOS_call         ; get old vector
       mov             ah,get_vector       ; getv func
       int             DOS_function        ; call it
       push            di
       mov             di,offset old_call
       mov             ds:[di],bx          ; old vector in ES:BX
       mov             ds:[di+2],es
       pop             di
       mov             bx,cs               ; setting keyboard vector to ours
       mov             ds,bx               ; seg:ofs in DS:DX
       mov             dx,offset call_interceptor
       mov             al,DOS_Replace_vector
       mov             ah,set_vector       ; set new vector with DOS call
       int             DOS_function        ;
       mov             bx,cs               ; knock off initialize address
       mov             ds,bx               ;
       mov             dx,offset initialize; End program but leave handler
       int             DOS_terminate_resident ; KEEP

CSEG ENDS
     END START
