;
; SCANROM.ASM
;
; This program scans for option ROM's and displays their addresses if found.
;

		ORG	100h
		JMP	START
;
; Data.
;
RSEGSTR	DB	4 DUP ?
RSEGSTR_LEN	EQU	$-OFFSET RSEGSTR
RSEGSTR_COLOR	DB	02h
RSEGSTR_ROW	DB	0
RSEGSTR_COLUMN	DB	3
HEADER		DB	"Segment addresses of option ROMS: "
HEADER_LEN	EQU	$-OFFSET HEADER
HEADER_COLOR	DB	07h
HEADER_ROW	DB	0
HEADER_COLUMN	DB	0

;
; Code. CS=DS=SS=ES.
;
START:
	CLD
	MOV	AX,1
	INT	10h
	MOV	AH,1
	MOV	CH,20
	INT	10h
	LEA	SI,HEADER
	MOV	CX,HEADER_LEN
	MOV	BH,HEADER_COLOR
	MOV	AL,HEADER_ROW
	MOV	BL,HEADER_COLUMN
	CALL	SHOWSTR
	MOV	AX,0C000h
MAINLP:
	CALL	CHKROM
	JNE	NOROM
	CALL	SHOWADDR
NOROM:
	ADD	AX,80h
	CMP	AX,0E000h
	JBE	MAINLP
	MOV	AH,0
	INT	16h
	MOV	AX,4C00h
	INT	21h

;
; Check for an option ROM at the address in AX, set ZF if found.
;
CHKROM:
	PUSH	ES
	MOV	ES,AX
	CMP	WORD PTR ES:[0],0AA55h
	POP	ES
	RET

;
; Display the pattern ROM address in AX on the screen.
;
SHOWADDR:
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	SI
	PUSH	DI
	MOV	BX,AX
	LEA	DI,RSEGSTR
	CLD
	MOV	AL,BH
	MOV	CL,4
	SHR	AL,CL
	CALL	HEXCHAR
	STOSB
	MOV	AL,BH
	AND	AL,0Fh
	CALL	HEXCHAR
	STOSB
	MOV	AL,BL
	MOV	CL,4
	SHR	AL,CL
	CALL	HEXCHAR
	STOSB
	MOV	AL,BL
	AND	AL,0Fh
	CALL	HEXCHAR
	STOSB
	CALL	SHOWFIND
	LEA	SI,RSEGSTR
	MOV	CX,RSEGSTR_LEN
	MOV	BH,RSEGSTR_COLOR
	MOV	AL,RSEGSTR_ROW
	MOV	BL,RSEGSTR_COLUMN
	CALL	SHOWSTR
	POP	DI
	POP	SI
	POP	CX
	POP	BX
	POP	AX
	RET

;
; Find location for next ROM address on the screen.
;
SHOWFIND:
	INC	RSEGSTR_ROW
	CMP	RSEGSTR_ROW,24
	JBE	SHOWFIND_DONE
	MOV	RSEGSTR_ROW,1
	ADD	RSEGSTR_COLUMN,10
	JMP	SHOWFIND_DONE
SHOWFIND_DONE:
	RET

;
; On entry, AL=value 0-15.  On exit, AL=hex character.
;
HEXCHAR:
	CMP	AL,10
	JAE	HEXCHAR_LTR
	ADD	AL,30h
	JMP	HEXCHAR_END
HEXCHAR_LTR:
	ADD	AL,41h-10
HEXCHAR_END:
	RET

;
; Display some text on the screen.  On entry, SI->string to display, CX=
; length of string, BH=attribute, AL=row, BL=column.
;
SHOWSTR:
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	ES
	MOV	DX,0B800h	; ES->video buffer
	MOV	ES,DX
	MOV	AH,80		; 40 columns x 2 bytes per = 80 bytes/col.
	MUL	AH		; AX = starting address of row
	SHL	BL,1		; multiply column by 2
	ADD	AL,BL		; add to row address to get where string starts
	ADC	AH,0
	MOV	DI,AX		; ES:DI->where to put string w/attributes
	CLD
SHOWSTR_L:
	MOVSB			; save character
	MOV	ES:[DI],BH	; save attribute
	INC	DI
	LOOP	SHOWSTR_L	; loop if more characters
	POP	ES
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET
