; REFRESH1.ASM
;
; This program reprograms the DMA controller and the PIT for RAM refresh.
; This code is copied (more or less) from the 1000EX BIOS ROM.
;

		ORG	100h
		JMP	START
;
; Code.
;
START:
	CLI
	XOR	AL,AL		; clear page registers
	OUT	81h,AL
	JMP	$+2
	OUT	82h,AL
	JMP	$+2
	OUT	83h,AL
	JMP	$+2
	OUT	0Dh,AL		; master reset of DMA
	JMP	$+2
	MOV	AL,4		; disable controller
	OUT	08h,AL
	JMP	$+2
	XOR	DX,DX		; clear DMA count and address registers
	XOR	AL,AL
COPYDMA_M:
	OUT	DX,AL
	JMP	$+2
	OUT	DX,AL
	JMP	$+2
	INC	DX
	CMP	DX,8
	JNE	COPYDMA_M
	MOV	AL,58h		; DMA channel 0: single mode, address
	OUT	0Bh,AL		;   increment, autoinitialize, read transfer
	JMP	$+2
	MOV	AL,49h		; DMA channel 1: single mode, address
	OUT	0Bh,AL		;   increment, no autoinitialize, read transfer
	JMP	$+2
	MOV	AL,4Ah		; DMA channel 2: single mode, address
	OUT	0Bh,AL		;   increment, no autoinitialize, read transfer
	JMP	$+2
	MOV	AL,0Eh		; mask/disable all but channel 0
	OUT	0Fh,AL
	JMP	$+2
	MOV	AL,0FFh		; DMA channel 0 count = 0FFh = 255 (actually
	OUT	01h,AL		;   256)
	JMP	$+2
	MOV	AL,0		; memory-to-memory disable, controller enable,
	OUT	08h,AL		;   normal timing, fixed priority, late write,
	JMP	$+2		;   DREQ hi, DACK low
	MOV	AL,74h		; PIT counter 1, lsb then msb, rate generator,
	OUT	43h,AL		;   binary
	JMP	$+2
	MOV	AL,12h		; count = 12h (normal refresh rate)
	OUT	41h,AL
	JMP	$+2
	XOR	AL,AL
	OUT	41h,AL
	JMP	$+2
	STI
	INT	20h
