{
 Graphics procedures for the Tandy 1000.

 NOTE:  These procedures assume that either the memory  program  "MEM" 
        has been run,  or that graphics memory has been reserved using 
        by setting the Maximum Free Dynamic Memory Option to $8000  or 
        less  paragraphs.  MEM reserves an extra 16K of memory for use 
        with the 32K graphics modes and is the  only  way  to  protect 
        Turbo's  interactive  mode.   If  MEM  or  some  other  memory 
        allocation program or procedure is not  run,  SetCrtMode(9,  ) 
        and SetCrtMode(10, ) will crash the system.  

}

type
    registers = record
        case integer of
            1 : (ax, bx, cx, dx, bp, si, di, ds, es, flags : integer);
            2 : (al, ah, bl, bh, cl, ch, dl, dh : byte);
        end;

{
 Return current video mode
}
function GetCrtMode: integer;

var
   regs: registers;

begin
     regs.ah := $0f;
     intr($10, regs);
     GetCrtMode := regs.al;
end;

{
 Set video mode.  0-6 are standard IBM modes.  8 is 160x200 16 color mode,
 9 is 320x200 16 color mode, and 10 is 640x200 4 color mode.

 Clear is a boolean flag that instructs SetCrtMode to clear the video buffer
 upon entry (TRUE), or to avoid clearing the video buffer (FALSE).
}

procedure SetCrtMode(mode:integer; clear:boolean);

var
   regs: registers;

begin
     if(mode < 0) or (mode = 7) or (mode > 10) then
             exit;   { Don't set a garbage mode }

     if not clear then
        regs.ax := (mode or $0080)  { Bit 7 of al means don't clear buffer }
     else
        regs.ax := mode;

     intr($10, regs);
end;

{
 Plot a point at x,y with color color.
}
procedure plot(x, y, color: integer);

var
   regs: registers;

begin
     regs.dx := y;      { Doesn't check for valid points }
                        { If windowing is introduced, here is where it would
                          adjust (and test) for the window. }
     regs.cx := x;
     regs.ah := 12;
     regs.al := color;
     intr($10, regs);
end;

{
 Clear screen to specified color.  (Checks to see if 16K or 32K needs to be
 filled.)
}
procedure FillScreen(color: integer);

var
   vidmem:  array[0..32767] of byte absolute $b800:0000;
   onebyte: byte;

begin
     onebyte := byte(color shl 4);
     if (GetCrtMode > 8) then
         FillChar(vidmem, 32767, onebyte)  { 32K graphics mode }
     else
         FillChar(vidmem, 16384, onebyte); { 16K graphics mode }
end;

{
 Set border color
}
procedure border(color: integer);

var
   regs: registers;

begin
     regs.ax := $1001;  {ax = 16, al = 1 }
     regs.bh := byte(color);
     intr($10,regs);
end;

{
 Redefine color1 as color2, using the Tandy 1000 palette functions.
}
procedure remap(color1, color2: integer);
var
   regs: registers;

begin
     regs.ah := 16;
     regs.al := 0;
     regs.bl := color1;
     regs.bh := color2;
     intr($10,regs);
end;

{
 Draw a line from (x1,y1) to (x2,y2) using color c.
}
procedure draw(x1, y1, x2, y2, c:integer);

var
   count: integer;   {X or Y dimension, depending on which way line is
                      being drawn }
   slope: integer;   { Not really the slope, just a measurement of which
                       axis should be changed next. }
   ypos, ydirect, xpos, xdirect, xchange, ychange: integer;

begin
     ypos := y1;           { Initial Y position to be used in drawing line }
     ychange := y2 - y1;   { Direction and distance to end y position }

     if ychange < 0 then
        ydirect := -1      { Used as the line is being drawn from y1 to y2 }
     else if ychange > 0 then
        ydirect := +1
     else
        ydirect := 0;
     ychange := abs(ychange);{  Counter for units to be used }

     xpos := x1;
     xchange := x2 - x1;

     if xchange < 0 then
        xdirect := -1
     else if xchange > 0 then
        xdirect := +1
     else
        xdirect := 0;

     xchange := abs(xchange);
     if xchange <= ychange then begin  { X distance covered is less than Y
                                         distance covered, for best drawing of
                                         line the line must be drawn for each
                                         Y coordinate of the line }
         slope := xchange * 2 - ychange;
         for count := 0 to ychange do begin
             plot(xpos, ypos, c);
             if slope > 0 then begin
                slope := slope + 2 * (xchange - ychange);
                xpos := xpos + xdirect;
             end
             else begin
                  slope := slope + 2*xchange;
             end;
             ypos := ypos + ydirect;
         end;

         exit;
     end;
     { Otherwise, X distance is more than Y distance covered, and the process
       must be used over each X point in the line }
     slope := 2*ychange - xchange;
     for count := 0 to xchange do begin
         plot(xpos, ypos, c);
         if slope > 0 then begin
             slope := slope + 2*(ychange - xchange);
             ypos := ypos + ydirect;
         end
         else begin
             slope := slope + 2*ychange;
         end;
         xpos := xpos + xdirect;
     end;
end;

