/*

  Tandy BGI Driver demo

  Copyright (c) 1991 - Michael Chapin

*/

#include <stdio.h>
#include <graphics.h>
#include <bios.h>
#include <stdlib.h>
#include <conio.h>

#define XPARENT_LINE 5
#define XPARENT_PAT 4
#define PAT_BASE 6
#define LINE_BASE 22

struct pointtype zig[] = {{10, 10}, {140, 25}, {30, 88}, {110, 88}, {10, 10}};
char buf[16000];

int midscrx, midscry;

void drawscreen(void);
void firstscreen(void);
void secondscreen(void);
void xorcircle(void);
void polydemo(void);
void pauseit(int);

int huge getmode(void)  /* Must always be a huge function */
{
  char ch;

  printf("\n\n0 - Tandy 1000 160x200x16\n");
  printf("1 - Tandy 1000 320x200x16\n\n");
  printf("Choose Mode:");
  do{
    ch = getch();
  }while(!(ch == '0' || ch == '1'));
  return (ch - 48);
}

void main( )
{
  int drv = DETECT, mode = 0, result;
  int x, y;

  printf("BGI Tandy 1000 Driver Demo.\n");
  printf("Copyright (c) 1991, Michael Chapin\n\n");

  installuserdriver("T1000", getmode);

  initgraph(&drv, &mode, "" );
  result = graphresult();
  if(result)
    exit( result );
  midscrx = getmaxx() / 2;
  midscry = (getmaxy() - 12) / 2;
  firstscreen();
  secondscreen();
  xorcircle();
  polydemo();
  closegraph();
}

void drawscreen(void)
{
  cleardevice();
  setcolor(15);
  rectangle(0, 0, getmaxx(), getmaxy());
  line(0, 11, getmaxx(), 11);
}

void firstscreen(void)
{
  char strg[6];

  drawscreen();
  settextjustify(CENTER_TEXT, TOP_TEXT);
  setcolor(RED);
  outtextxy(midscrx, 2, "Tandy BGI Driver");
  setcolor(YELLOW);
  outtextxy(midscrx, 190, "<ESC> to end demo");
  moveto(3, 14);
  setcolor(7);
  settextjustify(LEFT_TEXT, TOP_TEXT);
  outtext("X resolution: ");
  setcolor(15);
  sprintf(strg, "%d", getmaxx() + 1);
  outtext(strg);
  moveto(3, 24);
  setcolor(7);
  outtext("Y resolution: ");
  setcolor(15);
  outtext("200");
  moveto(3, 34);
  setcolor(7);
  outtext("Max colors: ");
  setcolor(15);
  outtext("16");
  pauseit(4);
  setfillstyle(SLASH_FILL, 5);
  setwritemode(XPARENT_PAT);
  setcolor(5);
  bar3d(10, 10, 100, 100, 0, 0);
  pauseit(8);
}

void secondscreen(void)
{
  int x, y, z, i;

  drawscreen();
  setcolor(9);
  settextjustify(CENTER_TEXT, TOP_TEXT);
  outtextxy(midscrx, 2, "Lines");
  setlinestyle(DASHED_LINE, 0, NORM_WIDTH);
  z = (getmaxx() / 16) - 2;
  for(y = 0; y <= 15; y++)
  {
    setwritemode(LINE_BASE + y);
    i = 20;
    for(x = 0; x <= 15; x++)
    {
      setcolor(x);
      line(i, 12, i, 198);
      i += z;
    }
    pauseit(1);
  }
  pauseit(3);
}

void xorcircle(void)
{
  drawscreen();
  setcolor(11);
  settextjustify(CENTER_TEXT, TOP_TEXT);
  outtextxy(midscrx, 2, "XOR Circle");
  setfillstyle(SOLID_FILL, 14);
  bar(1, 12, midscrx - 1, 198);
  setwritemode(1);
  setcolor(6);
  circle(midscrx, midscry, 50);
  pauseit(3);
  setwritemode(0);
  setwritemode(XPARENT_PAT);
  setfillstyle(SLASH_FILL, 2);
  setcolor(2);
  fillellipse(midscrx, midscry, 50, 25);
  pauseit(2);
  setfillstyle(BKSLASH_FILL, 4);
  setcolor(4);
  setwritemode(PAT_BASE + LIGHTGRAY);
  fillellipse(midscrx, midscry - 10, 50, 25);
  pauseit(4);
}

void polydemo(void)
{
  drawscreen();
  setcolor(6);
  settextjustify(CENTER_TEXT, TOP_TEXT);
  outtextxy(midscrx, 2, "Poly. Fill");

  setfillstyle(SOLID_FILL, 14);
  bar(1, 12, midscrx - 1, 198);

  setwritemode(1);
  setwritemode(PAT_BASE + RED);
  setfillstyle(XHATCH_FILL, 7);
  setlinestyle(SOLID_LINE);
  setcolor(2);
  fillpoly(5, zig);
  pauseit(4);
}

void pauseit(int secs)
{
  long stop;
  char ch;

  secs = secs * 18;
  stop = biostime(0, 0) + (long)secs;
  ch = '\0';
  while(biostime(0, 0) < stop)
  {
    if(kbhit())
    {
      ch = getch();
      break;
    }
  }
  if(ch == 27)
  {
    closegraph();
    exit(0);
  }
}
