data	segment	public
	assume cs:data,ds:data,ss:data
	org	100h
program:
	jmp	printsnd
filehandle dw	0
grafix	db	1bh,'K',0,1,256 dup (0),13,10
newbyte	db	0
;number of chars from last GET, either 0 or 1
num_got	db	0
;current bit position, rotates from 80h to 1 and around again
bitmask	db	80h
;last byte, starts at 80h since that is mid-scale
oldbyte	db	80h
direction db	0ffh
printsnd:
;first get the name of the .SND file to print
	mov	bx,80h	;point to input character count
	mov	al,[bx]	;find out what it is
	cbw		;make word for memory access
	add	ax,bx	;almost points to last input character (CR)
	inc	ax	;now it does
	mov	bx,ax	;can't use AX as pointer
	mov	byte ptr [bx],0 ;clear it
	mov	dx,82h	;point to first char after <SPACE> or <TAB>
	mov	ax,3d00h ;open for read only
	int	21h	;call DOS "open file" function
	jc	error1	;trap error
	mov	bx,ax	;file handle into bx
;	jmp	step2	;only while debugging
	xor	ax,ax	;clear ax
	mov	dx,ax	; and byte count longword
	mov	cx,ax
	mov	dl,44	;number of bytes offset from beginning of file
	mov	ah,42h
	int	21h	;LSEEK
	jnc	step2	;go on if successful
error1:
	mov	ax,4c01h ;otherwise return with ERRORLEVEL 1
	int	21h
step2:
	mov	ax,cs	;make data and code segments one
	mov	ds,ax
	mov	es,ax	;also ES...
	mov	filehandle,bx ;save file handle
	call	cleanout ;start off with clean slate
	mov	byte ptr oldbyte,80h ;midrange value for "previous" byte
	mov	byte ptr bitmask,80h ;high bit set, top graphics line
	mov	dl,1bh	;set printer up for 7/72 LF
	mov	ah,5
	int	21h
	mov	dl,31h
	int	21h
mainloop:
	call	nextbyte
	call	drawline
	mov	al,newbyte		;make newbyte the oldbyte
	mov	oldbyte,al
	ror	byte ptr bitmask,1	;shift mask down to next line
	cmp	byte ptr bitmask,80h	;back to beginning?
	jne	mainloop		;not, keep looping
	cmp	byte ptr num_got,0	;nothing from last GET?
	je	finish_up		;if so, we're done
	call	printline		;else send line to PRN
	call	cleanout		;clear for next line of graphics data
	jmp	mainloop
finish_up:
	mov	dl,1bh	;set printer back to normal 1/6 LF
	mov	ah,5
	int	21h
	mov	dl,32h
	int	21h
	mov	ax,4c00h		;return with no error
	int	21h
nextbyte:
	mov	dx,offset newbyte	;point to one-byte buffer
	mov	cx,1	;just get one byte, let DOS worry about cacheing
	mov	bx,filehandle ;restore file handle
	mov	ah,3fh	;read from file
	int	21h	;DOS read function
	jnc	whichway ;move on if successful
	mov	ax,4c02h ;load 2 into ERRORLEVEL
	int	21h	;and abort
whichway:
;find out which direction to move when drawing line from newbyte to oldbyte
	mov	num_got,al ;save actual byte count
	mov	al,newbyte ;get just-gotten byte
	mov	ah,0	;use for "direction" when drawing lines
;if new byte less than old, direction must be set to +1, else -1
	cmp	al,oldbyte ;set carry if new less than old
	adc	ah,0	;and add carry flag to 0
	shl	ah,1	;make it 2 if not zero
	add	ah,0ffh	;this makes it either +1 or -1
	mov	direction,ah ;now store the direction byte
	ret
cleanout:
;clean the output block
	mov	di,offset grafix+4	;point to beginning
	mov	cx,100h	;256 bytes to clear
	xor	ax,ax	;clear accumulator
	rep
	stosb		;and clean the block
	ret
drawline:
	mov	al,num_got ;see if we just got anything
	or	al,al	;if not, we skip this step
	je	draw_ret ;by jumping directly to end
	mov	bh,0	;clear high byte, can't use cbw with unsigned numbers
	mov	bl,newbyte ;use magnitude as index into graphics string
	mov	cl,direction ;and get the -1 or +1 into CL
	mov	al,bitmask ;get current bit for line to be drawn
drawloop:
	or	grafix+4[bx],al ;and set each bit accordingly
	cmp	bl,oldbyte ;are we done yet?
	pushf		;save the answer
	add	bl,cl	;add or subtract one according to contents of CL
	popf		;get flags back
	jne	drawloop ;loop if not done
draw_ret:
	ret	;else return
printline:
	mov	cx,262	;escseq+grafix+CRLF
	mov	bx,offset grafix ;get address of string into BX
	mov	ah,5	;DOS printchr function
printloop:
	mov	dl,[bx]	;get next character
	int	21h	;send it to PRN
	inc	bx	;point to next byte in graphics string
	loop	printloop ;and loop CX times
	ret
data	ends
	end	program
