// =====================================================================
// talk.h - Header file for talk.
//
// (C) 1993, 1994 by Michael Ringe, Institut fuer Theoretische Physik,
// RWTH Aachen, Aachen, Germany (michael@thphys.physik.rwth-aachen.de)
//
// This program is free software; see the file COPYING for details.
// =====================================================================


#if !defined(VERSION)
#define VERSION "[no version number]"
#endif


// ---------------------------------------------------------------------
// Debugging
// ---------------------------------------------------------------------

#if !defined(DEBUG)
#define DEBUG 0		// Debugging
#define NONET 0		// Disable network
#endif

#if (DEBUG)
#define DB_puts(s) puts(s)
#define DB_printf(s) printf s
#define DB_ipsplit(ip) (int)((ip)>>24) & 0xff,(int)((ip)>>16) & 0xff,\
	(int)((ip) >> 8) & 0xff,(int)(ip) & 0xff
#else
#define DB_puts(s)
#define DB_printf(s)
#define DB_ipsplit(ip) 0
#endif

#if (NONET)
#define tcp_tick(s) 1
#define sock_init() tcp_config(NULL)
#define	sock_putc(s,ch)
#define sock_fastread(s,b,sz) 0
#define resolve(h) 0x13141516
#endif

// ---------------------------------------------------------------------
// Ports used by talk
// ---------------------------------------------------------------------

#define MY_DATA_PORT 1050	// Our local data port
#define MY_CTL_PORT 1051	// Our local control port
#define TALK_PORT 518		// Talk daemon port
#define O_TALK_PORT 517		// Old style talk


// ---------------------------------------------------------------------
// Various default values
// ---------------------------------------------------------------------

#define LOGFILENAME "talk.log"	// Log file name
#define TIMEOUT 900		// Time out
#define ANSWERMODE_TIMEOUT 120	// Time out in answer mode


// ---------------------------------------------------------------------
// Global data
// ---------------------------------------------------------------------

extern char
    localuser[],		// Local user name
    remoteuser[],		// Remote user name
    remotetty[],		// Remote terminal
    *remotehost,		// Remote machine name
    *userarg;			// Argument on command line
extern longword remoteip;	// Remote IP address
extern char version[];		// Version string
extern tcp_Socket ds;		// Socket for talking
extern int answermode;		// Operate as answering machine

// ---------------------------------------------------------------------
// Utility functions (util.c):
// ---------------------------------------------------------------------

char *mystrncpy(char *dest, char *src, int len);
char *dostime(void);
unsigned int xtoi(char *c);
void setsockaddr(struct sockaddr *s, word port, longword ip);



// ---------------------------------------------------------------------
// Screen and keyboard i/o (screen.c)
// ---------------------------------------------------------------------

// Key codes returned by readkey()

#define CR	0x000d
#define ESC	0x001b
#define ALT_R	0x1300
#define ALT_S	0x1F00
#define ALT_L	0x2600
#define ALT_C	0x2E00
#define F1	0x3b00
#define HOME	0x4700
#define LEFT	0x4b00
#define DEL	0x5300
#define C_LEFT	0x7300

// Global data

extern int quiet;		// Quiet mode
extern int log;			// Log session to log file
extern char scrnmode;		// Screen mode: 0=single window, 1=split
extern int autocr;		// Automatically insert CR's
extern int quiet;		// Quiet mode
extern char *logfilename;	// Log file name

// Screen colors

#define PAL_SIZE 5		// Palette size
#define P_LOCAL 0		// Palette indexes
#define P_REMOTE 1
#define P_STATUS 2
#define P_STATUSL 3
#define P_STATUSR 4
#define A_NORM 0x07

extern unsigned short a[2][PAL_SIZE];

// Edit characters.

#define EC_SIZE 3
#define EC_ERASE 0	// Erase char
#define EC_KILL 1	// Kill line
#define EC_WERASE 2	// Erase word

extern char my_ec[3], his_ec[3];

// Functions

int init_video(void);
void select(int win);
void cleanup(int i);
void init_screen(void);
void openlog(int mode);
unsigned short readkey(void);
void myputch(char ch);


// ---------------------------------------------------------------------
// Talk daemon (message.c)
// ---------------------------------------------------------------------

int wait_invite(void);
int invite(void);
int o_invite(void);


// ---------------------------------------------------------------------
// Host name lookup (ghba.c)
// ---------------------------------------------------------------------

int gethostbyaddr(longword ip, char *name);

