{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
=-=-=-=-=-=-                                                     -=-=-=-=-=-=
-=-=-=                         INI File Manager                        =-=-=-
=-=-                                                                     -=-=
-=-=-=                     Coded by: Chris Lattner                     -=-=-=
=-=-=-=-=-=-                        1996                         -=-=-=-=-=-=
-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
UNIT INI_Mgr;

INTERFACE
TYPE
  FieldType = RECORD
    Field, Value : STRING;  { Holds one record from the INI file }
  END;
  FieldArray = ARRAY[1..120] OF FieldType;{ This is actually variable sized }
  FieldArrayPtr = ^FieldArray;

FUNCTION LoadINISection(Filename, Section : STRING;
         NumFields : INTEGER; Fields : FieldArrayPtr) : BOOLEAN;
(*    LoadINISection - Seeks to a section in a INI file and reads out the
  desired records.  First it goes to the section of the file specified in
  the "Section" string.  Then it reads each record and compares the name of
  record to all of the names in the "Fields" array.  If it finds a match, it
  reads the value of the record into the array.  It continues until it gets
  to the end of the file.                                                  *)

FUNCTION UpdateINISection(Filename, Section : STRING;
           NumFields : INTEGER; Fields : FieldArrayPtr) : BOOLEAN;
(*     UpdateINISection - Updates an INI files with the Fields array.  It
  first seeks to a section in the INI file, and then it compares each record
  in that section with the record names in "Fields".  If it finds a match,
  It updates the record.                                                   *)

IMPLEMENTATION

FUNCTION UCase(S : STRING) : STRING;  { Uppercases a string }
VAR
  Result : STRING;
  I      : INTEGER;
  C : CHAR;
BEGIN
  Result[0] := S[0];
  FOR I := 1 TO LENGTH(S) DO
    Result[I] := UpCase(S[I]);

  UCase := Result;
END;

FUNCTION StripLine(VAR Line : STRING) : INTEGER;
                                          { Removes comments and whitespace }
VAR
  I, J : INTEGER;
  Quotes : BOOLEAN;
BEGIN
  StripLine := -1;
  Quotes := FALSE;
  I := 1; J := LENGTH(Line);
  WHILE I <= J DO
  BEGIN
    IF Line[I] = '"' THEN
      Quotes := NOT Quotes                     { We are now in quotes...     }
    ELSE IF (NOT Quotes) THEN
    BEGIN
      IF (Line[I] = ' ') THEN                  { Strip out spaces...         }
      BEGIN
        Move(Line[I+1], Line[I], LENGTH(Line)-I);{ Shift string left one char}
        DEC(Line[0]); DEC(J);
        DEC(I);                                { Do this one again...        }
      END
      ELSE IF (Line[I] = ';') THEN             { Strip off the comments      }
      BEGIN
        J := I-1;
        Line[0] := CHR(J);                     { Truncate the string!        }
      END
      ELSE IF (Line[I] = '=') THEN
        StripLine := I;
    END;
    INC(I);
  END;
END;

FUNCTION LoadINISection(Filename, Section : STRING;
         NumFields : INTEGER; Fields : FieldArrayPtr) : BOOLEAN;
VAR
  F : TEXT;
  I, EqualPos : INTEGER;

  CurLine,
  Item, Value : STRING;

  InSection : BOOLEAN;
BEGIN
  LoadINISection := TRUE;  { Defaults to an error }
  ASSIGN(F, Filename);
  IF IOResult <> 0 THEN EXIT;
  RESET(F);
  IF IOResult <> 0 THEN EXIT;

  InSection := FALSE;
  WHILE NOT EOF(F) DO
  BEGIN
    READLN(F, CurLine);
    EqualPos := StripLine(CurLine);  { Returns position of equal sign }

    IF UCase(CurLine) = ('['+UCase(Section)+']') THEN
      InSection := TRUE
    ELSE IF CurLine[1] = '[' THEN
      InSection := FALSE;

    IF InSection AND (EqualPos <> -1) THEN
    BEGIN
      Item[0] := CHR(EqualPos-1);                       { Extract the item  }
      Move(CurLine[1], Item[1], EqualPos-1);
      Item := UCase(Item);

      Value[0] := CHR(LENGTH(CurLine)-EqualPos);        { Extract the value }
      Move(CurLine[EqualPos+1], Value[1], LENGTH(CurLine)-EqualPos);

      FOR I := 1 TO NumFields DO
        IF UCASE(Fields^[I].Field) = Item THEN
          Fields^[I].Value := Value;                    { Assign the value  }
    END;
  END;
  CLOSE(F);
  LoadINISection := FALSE;  { Survived all the way through! }
END;

FUNCTION UpdateINISection(Filename, Section : STRING;
           NumFields : INTEGER; Fields : FieldArrayPtr) : BOOLEAN;
VAR
  F, FOut : TEXT;
  I, EqualPos : INTEGER;

  OldLine, CurLine,
  Item, Value : STRING;

  UpdatedLine,
  InSection : BOOLEAN;
BEGIN
  ASSIGN(F, Filename);
  RESET(F);

  ASSIGN(FOut, '$$$$$$A$.TMP');     { Create a temporary file         }
  REWRITE(FOut);

  InSection := FALSE;
  WHILE NOT EOF(F) DO
  BEGIN
    UpdatedLine := FALSE;
    READLN(F, CurLine);
    OldLine := CurLine;
    EqualPos := StripLine(CurLine);  { Returns position of equal sign }

    IF CurLine = ('['+Section+']') THEN
      InSection := TRUE
    ELSE IF CurLine[1] = '[' THEN
      InSection := FALSE;

    IF InSection AND (EqualPos <> -1) THEN
    BEGIN
      Item[0] := CHR(EqualPos-1);                       { Extract the item  }
      Move(CurLine[1], Item[1], EqualPos-1);

      Value[0] := CHR(LENGTH(CurLine)-EqualPos);        { Extract the value }
      Move(CurLine[EqualPos+1], Value[1], LENGTH(CurLine)-EqualPos);

      FOR I := 1 TO NumFields DO
        IF UCASE(Fields^[I].Field) = UCase(Item) THEN
          IF Fields^[I].Value <> Value THEN
          BEGIN
            Value := Fields^[I].Value;                  { Assign the value  }
            UpdatedLine := TRUE;
          END;
    END;

    IF NOT UpdatedLine THEN
      WRITELN(FOut, OldLine)
    ELSE
      WRITELN(FOut, Item+' = '+Value);
  END;
  CLOSE(F);
  Close(FOut);
  Erase(F);                   { Erase the old one            }
  Rename(FOut, Filename);     { Replace the old with the new }
END;
END.
