unit QzHtmlMarquee2;
{*********************************************************}
{*                    QzHTMLMarquee2.pas                 *}
{*              Quick Zip HTML Marquee component         *}
{*     Copyright (c) 2003 Joseph Leung Yat Chun          *}
{*                 All rights reserved.                  *}
{*********************************************************}

interface

uses
  SysUtils, Classes, Controls, ExtCtrls, StdCtrls, Messages, QzMiniHtml2, Dialogs, Graphics;

const interval = 100;
      rate2    = 2;
      rate1    = 2;
type

  TQzHtmlMarquee2 = class(TLabel)
  private
    { Private declarations }
     InputHtml : TQzHtmlRec;
     Input : string;
     NeedUpdateDyna : boolean;
     procedure SetHtml(Value : TQzHtmlRec);
     function GetHtml : TQzHtmlRec;
     procedure SetInput(Value : string);
     function GetInput : string;
     procedure SetDynamicUpdate(value : TDynamicUpdateEvent);
     function GetDynamicUpdate : TDynamicUpdateEvent;
     procedure SetLinkClicked(value : TLinkClickedEvent);
     function GetLinkClicked : TLinkClickedEvent;
     procedure SetFormElementClicked(value : TFormElementClickedEvent);
     function GetFormElementClicked : TFormElementClickedEvent;
     procedure SetUserDefinedUpdate(value : TUserDefinedUpdateEvent);
     function GetUserDefinedUpdate : TUserDefinedUpdateEvent;
     procedure SetUserDefinedDraw(value : TUserDefinedDrawEvent);
     function GetUserDefinedDraw : TUserDefinedDrawEvent;

     procedure Timer1Timer(Sender: TObject);

     procedure CMMouseEnter( var Message : TMessage ); message CM_MOUSEENTER;
     procedure CMMouseLeave( var Message : TMessage ); message CM_MOUSELEAVE;

     procedure MMouseMove(Sender: TObject; Shift: TShiftState; X,Y: Integer);
     procedure MMouseDown(Sender: TObject; Button: TMouseButton;
                          Shift: TShiftState; X, Y: Integer);
     procedure MMouseUp(Sender: TObject; Button: TMouseButton;
                        Shift: TShiftState; X, Y: Integer);

     function TranslateYaxis(y : integer) : integer;
  protected
    { Protected declarations }
  public
    { Public declarations }
    modified : boolean;
    enableMarquee : boolean;
    QzMiniHtml2 : TQzMiniHtml2;
    Timer1 : TTimer;
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
    procedure paint; override;

    procedure updatecaption;
    procedure OnHtmlUpdate(Sender: TObject; newHtml : string; newHKey : char);
    procedure UpdateMiniHtml;
    procedure NullDynamicUpdate(Sender: TObject;dynamicID: String; var Text: String);
    procedure StartMarquee;
    procedure StopMarquee;
  published
    { Published declarations }
    property HtmlEditor : TQzHtmlRec read getHtml write setHtml;
    property Html : String read GetInput write SetInput;
    property  OnDynamicUpdate : TDynamicUpdateEvent read GetDynamicUpdate write SetDynamicUpdate;
    property OnLinkClicked   : TLinkClickedEvent read GetLinkClicked write SetLinkClicked;
    property OnFormElementClicked : TFormElementClickedEvent read GetFormElementClicked write SetFormElementClicked;
    property OnUserDefinedUpdate : TUserDefinedUpdateEvent read GetUserDefinedUpdate write SetUserDefinedUpdate;
    property OnUserDefinedDraw : TUserDefinedDrawEvent read GetUserDefinedDraw write SetUserDefinedDraw;
  end;

procedure Register;

implementation

procedure TQzHtmlMarquee2.UpdateMiniHtml;
begin
  QzMiniHtml2.Width := Width;
  QzMiniHtml2.Height := Height;
  QzMiniHtml2.Color := Color;
  QzMiniHtml2.Top := 0;
  QzMiniHtml2.Left := 0;
end;

procedure TQzHtmlMarquee2.NullDynamicUpdate(Sender: TObject;dynamicID: String; var Text: String);
begin
  NeedUpdateDyna := true;
end;

procedure TQzHtmlMarquee2.SetDynamicUpdate(value : TDynamicUpdateEvent);
begin
  QzMiniHtml2.OnDynamicUpdate := value;
end;

function TQzHtmlMarquee2.GetDynamicUpdate : TDynamicUpdateEvent;
begin
  Result := QzMiniHtml2.OnDynamicUpdate;
end;

procedure TQzHtmlMarquee2.SetLinkClicked(value : TLinkClickedEvent);
begin
  QzMiniHtml2.OnLinkClicked := value;
end;

function TQzHtmlMarquee2.GetLinkClicked : TLinkClickedEvent;
begin
  Result := QzMiniHtml2.OnLinkClicked;
end;

procedure TQzHtmlMarquee2.SetFormElementClicked(value : TFormElementClickedEvent);
begin
  QzMiniHtml2.OnFormElementClicked := value;
end;

function TQzHtmlMarquee2.GetFormElementClicked : TFormElementClickedEvent;
begin
  Result := QzMiniHtml2.OnFormElementClicked;
end;

procedure TQzHtmlMarquee2.SetUserDefinedUpdate(value : TUserDefinedUpdateEvent);
begin
  QzMiniHtml2.OnUserDefinedUpdate := value;
end;

function TQzHtmlMarquee2.GetUserDefinedUpdate : TUserDefinedUpdateEvent;
begin
  Result := QzMiniHtml2.OnUserDefinedUpdate;
end;

procedure TQzHtmlMarquee2.SetUserDefinedDraw(value : TUserDefinedDrawEvent);
begin
  QzMiniHtml2.OnUserDefinedDraw := value;
end;

function TQzHtmlMarquee2.GetUserDefinedDraw : TUserDefinedDrawEvent;
begin
  Result := QzMiniHtml2.OnUserDefinedDraw;
end;

destructor TQzHtmlMarquee2.Destroy;
begin
  QzMiniHtml2.free;
  Timer1.free;
  Inherited Destroy;
end;

procedure TQzHtmlMarquee2.OnHtmlUpdate(Sender: TObject; newHtml : string; newHKey : char);
begin
  Input := newHtml;
end;

constructor TQzHtmlMarquee2.Create(AOwner:TComponent);
begin
  Inherited Create(AOwner);
  AutoSize := False;
  ParentColor := True;
  EnableMarquee := false;
  Timer1 := TTimer.Create(Self);
  Timer1.Enabled := False;
  Timer1.Interval := INTERVAL;
  Timer1.OnTimer := Timer1Timer;

  QzMiniHtml2 := TQzMiniHtml2.Create(Self);
  QzMiniHtml2.MouseKBHandler1 := TNormalHandler.Create(Self,QzMiniHtml2);
  QzMiniHtml2.MouseKBHandler2 := TFormElementHandler.Create(Self,QzMiniHtml2);
  QzMiniHtml2.Canvas := Canvas;
  QzMiniHtml2.Owner := Self;
  Modified := true;
  NeedUpdateDyna := False;
  UpdateMiniHtml;
  InputHtml := QzMiniHtml2.Caption;
  OnMouseMove := MMouseMove;
  OnMouseDown := MMouseDown;
  OnMouseUp := MMouseUp;
  QzMiniHtml2.Caption.Html := Html;
  QzMiniHtml2.Caption.FHtmlUpdate := OnHtmlUpdate;
  HtmlEditor.Html := Html;
  QzMinihtml2.OnDynamicUpdate := NullDynamicUpdate;
end;

procedure TQzHtmlMarquee2.updatecaption;
begin
  Invalidate;
end;

procedure TQzHtmlMarquee2.paint;
var h : integer;
begin
  UpdateMiniHtml;
  if Html <> '' then Caption := '';
  inherited Paint;

  if Html <> '' then
  if (QzMiniHtml2.CacheBitmap.Width = 0) or Modified or NeedUpdateDyna then
       begin
        NeedUpdateDyna := False;
        InputHtml.Html := Html;
        QzMiniHtml2.LoadFromCaption;
        Modified := False;
       end else
       begin

        with QzMiniHtml2 do
        if ScrollTop < 0 then
        begin
        Canvas.Lock;        
        h := CacheBitmap.Height - (CacheBitmap.Height - Abs(ScrollTop));
        Canvas.BrushCopy(
                  Rect(Left,Top,Left+CacheBitmap.Width,Top+h),
                  CacheBitmap,
                  Rect(ScrollLeft,CacheBitmap.Height-h,ScrollLeft+CacheBitmap.Width,CacheBitmap.Height),
                  WebColor2TColor(TransparentColor));

        Canvas.BrushCopy(
                  Rect(Left,Top+h,Left+CacheBitmap.Width,Height),
                  CacheBitmap,
                  Rect(ScrollLeft,0,ScrollLeft+CacheBitmap.Width,(Height-Top-h)),
                  WebColor2TColor(TransparentColor));
        Canvas.UnLock;
        end
        else
        QzMiniHtml2.ReDraw;
       end;

end;


procedure TQzHtmlMarquee2.SetHtml(Value : TQzHtmlRec);
begin
  Input := Value.Html;
  InputHtml.Html := Input;
  QzMiniHtml2.Clear;
  Modified := true;
  Invalidate;
end;

procedure TQzHtmlMarquee2.SetInput(Value : string);
begin
  Input := Value;
  InputHtml.Html := Value;
  QzMiniHtml2.Clear;
  Modified := true;
  Invalidate;
end;

function TQzHtmlMarquee2.GetInput : string;
begin
  result := Input;
end;


function TQzHtmlMarquee2.GetHtml : TQzHtmlRec;
begin
  InputHtml.Html := Input;
  Result := InputHtml;
end;

procedure TQzHtmlMarquee2.Timer1Timer(Sender: TObject);
begin
   with qzMiniHtml2 do
   begin
   if ScrollTop > 0 then
   Inc(ScrollTop,Rate1) else
   Inc(ScrollTop,Rate2);
   if ScrollTop + Height > CacheBitmap.height then
    ScrollTop := (CacheBitmap.height - ScrollTop)* -1 ;
   InValidate;
   end;
end;

procedure TQzHtmlMarquee2.StartMarquee;
begin
  if Parent is TWinControl then
    TWinControl(Parent).DoubleBuffered := true;
  Timer1.Enabled := true;
  EnableMarquee := true;
end;

procedure TQzHtmlMarquee2.StopMarquee;
begin
  Timer1.Enabled := false;
  EnableMarquee := false;
end;

procedure TQzHtmlMarquee2.CMMouseEnter(var Message: TMessage);
begin
     Timer1.Enabled := false;
end;

procedure TQzHtmlMarquee2.CMMouseLeave(var Message: TMessage);
begin
     if EnableMarquee then
      Timer1.Enabled := true;
end;

function TQzHtmlMarquee2.TranslateYaxis(y : integer) : integer;
var h : integer;
begin
      with QzMiniHtml2 do
      begin
      h := CacheBitmap.Height - (CacheBitmap.Height - Abs(ScrollTop));
      if h < Y then
        Result := y-h else
        Result := CacheBitmap.Height-h+y;
      end;
end;

procedure TQzHtmlMarquee2.MMouseMove(Sender: TObject; Shift: TShiftState; X,Y: Integer);
begin
  Timer1.Enabled := false;
  with QzMiniHtml2 do
  if ScrollTop >= 0 then
    MouseMove(Sender,Shift,X,Y) else
    begin
    MouseMove(Sender,Shift,X,TranslateYaxis(Y));
    Invalidate;
    end;
end;

procedure TQzHtmlMarquee2.MMouseDown(Sender: TObject; Button: TMouseButton;
                      Shift: TShiftState; X, Y: Integer);
begin
  with QzMiniHtml2 do
  if ScrollTop >= 0 then
    MouseDown(Sender,Button,Shift,X,Y) else
    MouseDown(Sender,Button,Shift,X,TranslateYaxis(Y));
  Invalidate;
end;

procedure TQzHtmlMarquee2.MMouseUp(Sender: TObject; Button: TMouseButton;
                        Shift: TShiftState; X, Y: Integer);
begin
  with QzMiniHtml2 do
  if ScrollTop >= 0 then
    MouseUp(Sender,Button,Shift,X,Y) else
    MouseUp(Sender,Button,Shift,X,TranslateYaxis(Y));
  Invalidate;
end;


procedure Register;
begin
  RegisterComponents('Qzip', [TQzHtmlMarquee2]);
end;

end.
