#!/usr/bin/perl

###############################################################################
#
# _AADel.cgi - Delete Announcements
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/08/21 17:50:51 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

$FileRevision = '$Id: _AADel.cgi,v 1.29.2.2 2001/08/21 17:50:51 stepper Exp $';
$Version = '1.4.0';

if (@ARGV[0] eq "-v" || @ARGV[0] eq "--version") {
	print "File:		$0\n";
	print "Revision:	$FileRevision\n";
	print "Version:	$Version\n";
	exit();
}

require "F_Init.pl";

###############################################################################
#
# Process submitted data

$Class = $CGIQuery->param('fid');
$func = $CGIQuery->param('func');
$section = $CGIQuery->param('group');

if ($Class eq "") {
	&showErrorHTML("$CorF not specified");
	exit();
}
	
&lookupClass;
	
&loadColors($ColorQueryString);

if ($CGIEnvUser eq "") {
	&showErrorBackHTML("You are not properly logged in. Please log in and come back.");
	exit();
}

&lookupUser($CGIEnvUser);

&checkCookieGuest($CGIEnvUser, $C_authtype);

# Kick the user out if they have the wrong permissions
if (!&IS_ADMIN($U_Perms) && !&IS_FAC($U_Perms)) {
	&showErrorBackHTML("You do not have permission to access this resource.");
	exit();
}

if ($func ne "menu") {
	$BodyTag = &makeBodyTag("Content");
} else {
	$BodyTag = &makeBodyTag("Threads");
}

if ($func eq "domsgdel") {
	if ($Demo) {
		print $CGIQuery->redirect("Demo.html");
		exit();
	}
	&doMsgsDel;

} elsif ($func eq "gather") {
	
	################################
	# Print list of messages
	################################

	if ($date eq "NULL") {
		&showHeaderBackHTML("Choose the messages to retrieve above");
		exit();
	}
	
	# What's today?
	($tsec, $tmin, $thr, $tday, $tmon, $tyr, $tdow, $tdoy, $tdls) = localtime(time());
	$tmon += 1;
	
	$todaystart = time() - ($thr * 3600) - ($tmin * 60) - $tsec;
	$todayend = $todaystart + 86400;
	
	$head = "Announcements for " . $C_Sects{$section}{"name"};

	$helplink = "file=AnnDeleteCORP_Admin.html&anchor=AnnDeleteEdtFSummary";
	$helplink .= "&helptitle=Announcement%20Deletion%20Editing%20Frame";
	&showHeaderBackHTML("$head", "", 0, 0, 1, $helplink);
	
	# Print some javascript to select multiple boxes
	&printCheckSelJS;

	# Get the posts

	$anndbfile = $DBFILE_ANNPRE . $C_Sects{$section}{"num"} . ".db";
	$dbfile = "$C_rootpath/$DIR_CLASSANNOUNCE/$anndbfile";
	
	foreach (`$prtDB $dbfile -tbtree -q -a -r`) {
		# Errors are ignored. It just means there are no announcments.
		# NOTE: \n, \t, \\ and \r have been escaped (-q)
		($key, $value) = split(/\t/, $_);
		$value = &UnEscape($value);
		
		$status = &dbErrorCheck($?, $key);
		if (! $status) {
			push (@keys, $key);
			push (@values, $value);
		}
	}
	
	&printJavascript;
	
	if (@keys > 0) {
		print "<br>$FontRed Note:</font> Click the title to view ";
		print "the announcement content.<br>\n";
	
		print "<form action=$CGIEnvScript method=POST>\n";
		print "<input type=hidden name=fid value=$Class>\n";
		print "<input type=hidden name=func value=domsgdel>\n";
	}
	
	print "<table cellpadding=0 cellspacing=0 border=0>\n";
	
	if (@keys > 0) {
		print "<tr bgcolor=$FCmsgheadhilight>";
		print "<td bgcolor=$FCmsgheadhilight><b>", $FontFace, $FontSize2;
		print "&nbsp;Delete$ImgIndent";
		print "</td>\n";
	
		print "<td width=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td>\n";
	
		print "<td bgcolor=$FCmsgheadhilight><b>", $FontFace, $FontSize2;
		print "&nbsp;Date$ImgIndent";
		print "</td>\n";
	
		print "<td width=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td>\n";
	
		print "<td bgcolor=$FCmsgheadhilight><b>", $FontFace, $FontSize2;
		print "&nbsp;Title$ImgIndent";
		print "</td>\n";
	
		print "<td width=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td>\n";
	
		print "<td bgcolor=$FCmsgheadhilight><b>", $FontFace, $FontSize2;
		print "&nbsp;Posted By $ImgIndent";
		print "</td>\n";
		
		print "<td width=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td>\n";
		
		print "<td bgcolor=$FCmsgheadhilight><b>", $FontFace, $FontSize2;
		print "&nbsp;Posted To $SorGs $ImgIndent";
		print "</td>\n";
		
		print "</tr>\n\n";
	
		print "<tr><td colspan=9 height=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td></tr>\n\n";
	}
	
	for ($i=0; $i < @keys; $i++) {
		($posterid, $posteremail, $postclass, $anntype, $sectlist, $title, $content) = split(/\t/, @values[$i]);
		$pdate = &formatDate(@keys[$i]);
		
		if ($i % 2) {
			$bg = " bgcolor=$FCmsghilight";
		} else {
			$bg = "";
		}
		
		print "<tr", $bg, ">";
		print "<td align=center", $bg, ">", $FontFace, $FontSize;
		print "<input type=checkbox name=delmsg value=\"" , @keys[$i];
		print ":", $title, "\">";
		print "</td>\n";
		
		print "<td width=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td>\n";
		
		print "<td", $bg, ">", $FontFace, $FontSize;
		print "&nbsp;", $pdate, $ImgIndent;
		print "</td>\n";
		
		print "<td width=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td>\n";
		
		print "<td", $bg, ">", $FontFace, $FontSize;
		print "&nbsp;";
		print "<a href=\"javascript:openwin('";
		print $CGI_AnnViewOne, "?fid=$Class\&mid=", @keys[$i];
		print "\&group=$section','600','400','annview')\">";
		print $title, "</a>", $ImgIndent;
		print "</td>\n";
		
		print "<td width=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td>\n";
		
		print "<td", $bg, ">", $FontFace, $FontSize;
		print "&nbsp;<a href=\"mailto:", $posteremail, "\">", $posterid, "</a>";
		print $ImgIndent;
		print "</td>\n";
		
		print "<td width=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td>\n";
		
		print "<td", $bg, " nowrap>", $FontFace, $FontSize;
		print "&nbsp;";
		@sectList = split(/\,/, $sectlist);
		@sectList = &unique(@sectList);
		for ($j = 0; $j < @sectList; $j++) {
			if (@sectList[$j] == $section) {
				print "<b>";
			}
			print $C_Sects{@sectList[$j]}{"name"};
			if (@sectList[$j] == $section) {
				print "</b>";
			}
			if ($j < @sectList - 1) {
				print ", ";
			}
		}
		splice(@sectList, 0);
		print $ImgIndent;
		print "</td>\n";
		
		print "</tr>\n\n";
		
	}
	
	if (@keys == 0) {
		print "<tr><td colspan=7>";
		print "$ImgIndent</td></tr>\n\n";
	
		print "<tr><td colspan=9>", $FontFace, $FontSize;
		print "No announcements found for this $sorg.</td></tr>\n\n";
	} elsif (@keys > 1) {
		print "<tr><td colspan=9 height=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td></tr>\n\n";
		
		print "<tr><td>", $FontFace, $FontSize;
		print "<br>&nbsp;<a href=javascript:selectAll('delmsg')>Select All</a>&nbsp;";
		print "<br>&nbsp;<a href=javascript:deselectAll('delmsg')>Deselect All</a>&nbsp;";
		print "<br>&nbsp;<a href=javascript:selectInverse('delmsg')>Select Inverse</a>&nbsp;<br>&nbsp;";
		print "</td>\n";
	
		print "<td width=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td>\n";
		
		print "<td colspan=7>", $FontFace, $FontSize;
		print "&nbsp;";
		print "</td></tr>\n\n";
	}
	if (@keys > 0){
		print "<tr><td colspan=9 height=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td></tr>\n\n";
	
		print "<tr><td colspan=9>", $FontFace, $FontSize;
		print "<input type=checkbox name=delfromall value=\"YES\"> ";
		print " Delete selected announcement(s) from ALL $sorgs.";
		print "</td></tr>\n\n";
	}
		
	print "<tr><td colspan=9 height=1 bgcolor=$FCheaderback>";
	print "$ImgClearDot</td></tr>\n\n";
	
	print "</table>\n";
	print "<input type=hidden name=group value=$section>\n";
	
	if ($Demo) {
		print $BtnFormSubmitDemo;
	} else {
		print $BtnFormSubmit;
	}

	print "</form>\n";
	

##########################################################	
	
} elsif ($func eq "nothing" ) {

	&printEmptyTaskFrame("Choose the announcements to retrieve above.");
	
} elsif ($func eq "menu") {
	$helplink = "file=AnnDeleteCORP_Admin.html&anchor=AnnDeleteTskFSummary";
	$helplink .= "&helptitle=Announcement%20Deletion%20Task%20Frame";
	&showHeaderBackHTML("Delete Announcements for $CorF - $Class", 
		"", 0, 1, 0, $helplink);

	# Start Form
	print "<form action=$CGIEnvScript method=POST target=msgdel>\n";
	print "<input type=hidden name=fid value=\"$Class\">\n\n";
	print "<input type=hidden name=func value=gather>\n\n";

	# Print form
	print "<table cellpadding=0 cellspacing=0 border=0>\n";
	print "<tr><td valign=middle align=left>";
	print $FontFace, $FontSize, $ImgClear88;
	print "Show Announcements for $sorg: ";
	print "<select name=group>";

	for ($i = 1; $i <= $C_Sect_n; $i++) {
		print "<option value=", $C_Sects{$i}{"num"}, "> ", $C_Sects{$i}{"name"}, "\n";
	}
	
	print "</select>";
	print "$BtnFormSubmit";
	
	print "</td></tr>\n\n";

	print "</table>\n";
	print "</form>\n";
} else {

	# Print out frameset
	# print $CGIQuery->header(-expires=>'-1d');
	print $CGIQuery->header;
	print "<html><head><title>$Class Announcement Deletion</title>\n";
	&printJavascript();
	print "</head>\n";
	print "<frameset rows='120,*' border=2>\n";
	print "	<frame name=msgdelmenu src=$CGIEnvScript?fid=$Class&func=menu ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "	<frame name=msgdel src=$CGIEnvScript?fid=$Class&func=nothing ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "</frameset>\n";
}

#
########

sub doMsgsDel {
	local($i, $j);
	$confirm = $CGIQuery->param('confirm');
	
	if ($confirm eq "") {
		&confirmdel;
		exit();
	} elsif ($confirm ne "YES") {
		&showHeaderBackHTML("Deletion Cancelled", "Announcement deletion cancelled", 0);
		exit();
	}

	@delmsg = $CGIQuery->param('delmsg');
	$delfromall = $CGIQuery->param('delfromall');
	
	if ($delfromall eq "YES") {
		for ($i = 1; $i <= $C_Sect_n; $i++) {
			push (@sections, $i);
		}
	} else {
		@sections = ($section);
	}
	&showHeaderBackHTML("Deleting Announcements", "", 0, 0, 1);
	
	# Turn on signal Handling
	$trapSignals = 1;
	
	for ($i=0; $i < @delmsg; $i++) {
	
		($msgid, $title) = split(/\:/, @delmsg[$i]);
		
		for ($j=0; $j < @sections; $j++) {
			print "Deleting Announcement: \"$title\" from ";
			print $C_Sects{@sections[$j]}{"name"}, "<br>\n";
					
			&delFromAnn($msgid, @sections[$j]);
		}
	}
	
	# Rebuild the Announcements html pages.
	@output = `./$CGI_AnnBuild \"$Class\"`;
	
	# If we got a signal, exit here.
	if ($gotSignal) {
		close(DEVNULL);
		exit(0);
	}
	
	print "<p>Finished!\n";
	
}

sub delFromAnn {
	local($msgid, $sect) = @_;
	local($err, $dbfile, $anndbfile, $DB, $db, %dbh);
	
	$anndbfile = $DBFILE_ANNPRE . $sect . ".db";
	$dbfile = "$C_rootpath/$DIR_CLASSANNOUNCE/$anndbfile";
	
	if (! -e $dbfile) {
		return;
	}
	@retval = `$delDB $dbfile -tbtree -k \"$msgid\"`;
	$status = &dbErrorCheck($?, @retval[0]);
	if ($status) {
		&showErrorBackHTML("$status<p>Unable to delete Announcement ID $msgid from $dbfile.");
		exit();
	}
}	

sub confirmdel {
	local($i, $j, @names, $title, $junk, @vals, @gettitles);
	# Print class deletion confirmation page.
	$helplink = "file=AnnDeleteCORP_Admin.html&anchor=AnnDeleteEdtFSummary";
	$helplink .= "&helptitle=Announcement%20Deletion%20Editing%20Frame";
	&showHeaderBackHTML("Are you Sure?", "", 0, 0, 0, $helplink);

	@gettitles = $CGIQuery->param("delmsg");
	
	print $FontSize2, "$FontRed<b>Are you sure you want to ";
	print "permanently delete the following Announcements? <br>\n";
	print "</font></font>\n";
	print $FontSize;
	
	print "<ul>";
	for ($i=0; $i < @gettitles; $i++) {
		($junk, $title) = split(/\:/, @gettitles[$i]);
		print "<li>", $title, "</li>\n";
	}
	print "</ul><br>\n";
	
	print "<form action=$CGIEnvScript method=POST>\n";
	
	@names = $CGIQuery->param;
	for ($i=0; $i < @names; $i++) {
		@vals = $CGIQuery->param("@names[$i]");
		for ($j=0; $j < @vals; $j++) {
			print "<input type=hidden name=", @names[$i];
			print " value=\"", @vals[$j];
			print "\">\n";
		}
	}
	print "<input type=radio name=confirm value=\"YES\"> Yes\n";
	print "<input type=radio name=confirm value=\"NO\" checked> No<br>\n";
	print $BtnFormDel;
	print "</form>";
}
