<?php
//============================================================+
// File name   : cp_config.php                                 
// Begin       : 2001-10-23                                    
// Last Update : 2003-04-28                                    
//                                                             
// Description : CLIENT Base cofiguration file                 
//                                                             
//                                                             
// Author: Nicola Asuni                                        
//                                                             
// (c) Copyright:                                              
//               Tecnick.com S.r.l.                            
//               Via Ugo Foscolo n.19                          
//               09045 Quartu Sant'Elena (CA)                  
//               ITALY                                         
//               www.tecnick.com                               
//               info@tecnick.com                              
//============================================================+

// -- INCLUDE files -- 
require_once('../../shared/config/cp_extension.inc');
require_once('../../shared/config/cp_config.'.CP_EXT);

// -- Language -- 
define ("K_DEFAULT_LANGUAGE", "eng"); //default public site language

// -- DEFAULT META Tags --
define ("K_SITE_TITLE", "Site name"); //default site name
define ("K_SITE_DESCRIPTION", "Site Description"); //default site description
define ("K_SITE_AUTHOR", "Your Name"); //default site author
define ("K_SITE_REPLY", "you@yourdomain.com"); //default page reply email
define ("K_SITE_KEYWORDS", "default,site,keywords"); //default keywords
define ("K_SITE_ICON", "../favicon.ico"); //default icon
define ("K_SITE_STYLE", K_PATH_STYLE_SHEETS."default.css"); //default stylesheet

// -- Options / COSTANTS --
define ("K_MAX_ROWS_PER_PAGE", 20); //max number of rows to display in tables
define ("K_MAX_UPLOAD_SIZE", 1000000); //max size to be uploaded in bytes
define ("K_USE_ERROR_LOG", FALSE); //enable error log (../log/cp_errors.log)
define ("K_MAX_EXECUTION_TIME", 300); // [seconds] Limits the maximum execution time for a script
define ("K_DISPLAY_QUICK_HELP", TRUE); // if TRUE display form fields description using overlib
define ("K_USE_SITE_STATISTICS", TRUE); // if TRUE collect site statistics data
define ("K_LANG_ON_MENU", TRUE); // if TRUE display language selector on public menu
define ("K_MAX_MEMORY_LIMIT", "32M"); // max memory limit for a PHP script

define ("K_MAIN_PAGE", "cp_dpage.".CP_EXT."?aiocp_dp=_main"); // main page (homepage)

// -- Frame settings ---
define ("K_USE_FRAMES", FALSE); // set to TRUE if your site use frames
define ("K_MAIN_FRAME_NAME", "_top"); // name of the main frame (central frame)
define ("K_CHECK_JAVASCRIPT", FALSE); // set to TRUE to check if client browser support javascript
define ("K_REDIRECT_JAVASCRIPT_ERROR", "../code/cp_javascript_error.".CP_EXT); // page to be redirected if Javascript is not supported

//disable graphic buttons in xhtml basic mode
if (isset($_REQUEST['xhtmlb'])) {
	define ("K_USE_GRAPHIC_BUTTONS", FALSE);
}
else {
	define ("K_USE_GRAPHIC_BUTTONS", TRUE); // if true graphics buttons instead normal form buttons
	define ("K_GRAPHIC_BUTTON_STYLE", "default"); // name of the graphic button style
}

// -- INCLUDE files -- 
require_once('../../public/code/cp_functions_errmsg.'.CP_EXT);
require_once('../../shared/config/cp_db_config.'.CP_EXT);
require_once('../../shared/code/cp_db_connect.'.CP_EXT);
require_once('../../shared/code/cp_functions_general.'.CP_EXT);
require('../../shared/code/cp_languages.'.CP_EXT);
require_once('../../shared/code/cp_currency.'.CP_EXT);

set_time_limit(K_MAX_EXECUTION_TIME); //Limit the maximum execution time
ini_set("memory_limit", K_MAX_MEMORY_LIMIT); //set memory limit
ini_set("session.use_trans_sid", 0); //if =1 use PHPSESSID (for clients that do not support cookies)

//============================================================+
// END OF FILE                                                 
//============================================================+
?>
