// ==============================================================
//
//  Copyright (c) 2002-2003 by Alex Vinokur.
//
//  For conditions of distribution and use, see
//  copyright notice in version.h
//
// ==============================================================


// ##############################################################
//
//  SOFTWARE : C/C++ Program Perfometer
//  FILE     : t_file.cpp
//
//  DESCRIPTION :
//         Implementation of measured/compared functions
//
// ##############################################################


// ===============
#include "tests.h"

#if ((defined UNIX_ENV) && !(defined DJGPP_ENV))
// -------------------
#include <fcntl.h>
#include <sys/mman.h>
// -------------------
#endif

// ===============

// ===============
typedef unsigned long long    ullong;

#define MAX_FILENAME_LEN	20
#define MAX_FILESIZE_LEN	((sizeof(ullong) * CHAR_BIT) - 2)	
#define MAX_FILESIZE_VALUE	(static_cast<ullong>(1) << (MAX_FILESIZE_LEN))


// #########################################
// --------------------------------------
static bool get_file_size (const string& filename_i, ullong& filesize_o)
{
ifstream fin (filename_i.c_str());
  if (fin.fail()) return false;

ullong	start_pos, end_pos;
  start_pos = fin.tellg();
  fin.seekg(0, ios::end); 
  end_pos = fin.tellg();

  filesize_o = end_pos - start_pos;
  assert (filesize_o < MAX_FILESIZE_VALUE);

  return true;

}


// --------------------------------------
static ullong get_file_size (const string& filename_i)
{
string	ret_string;
ullong  filesize;	
bool	ret_bool = get_file_size (filename_i, filesize);
  assert (ret_bool);
  return filesize;
}

// --------------------------------------
static ulong get_file_rows (const string& filename_i)
{
string line;
ulong  counter = 0;
ifstream infile (filename_i.c_str());
  assert (infile.is_open());

  while (getline (infile, line)) counter++;

  return counter;
}



// #########################################
// ----------------------------------------
// Functions ReadFile1 - ReadFile6 are 
//    lightly changed functions from the arctile :
// --------
// From: "Tom Hines" <tom_hines@yahoo.com>
// Subject: Re: How to efficiently read contents from file into one string?
// Newsgroup: comp.lang.c++.moderated
// Date: Thursday, January 30, 2003 3:55 PM
// ----------------------------------------


// ---------
static void ReadFile1 (const string& filename_i, unsigned long& str_size_o)
{
  // --- Using getline() ---

string line, str;
ifstream infile (filename_i.c_str());
  assert (infile.is_open());

  while (getline (infile, line))
  {
    str.append(line);
    line.erase();
  }

  str_size_o = str.size();
}


// ---------
static void ReadFile2(const string& filename_i, unsigned long& str_size_o)
{
  // --- Using vector char at a time ---

ifstream infile (filename_i.c_str());
  assert (infile.is_open());

vector<char> v;
char ch;

  while (infile.get(ch)) if (ch != '\n') v.push_back(ch);

string str (v.empty() ? string() : string (v.begin(), v.end()));

  str_size_o = str.size();
}

// ---------
static void ReadFile3(const string& filename_i, unsigned long& str_size_o)
{
  // --- Using string, char at a time ---

ifstream infile (filename_i.c_str(), ios::in | ios::ate);
  assert (infile.is_open());

streampos sz = infile.tellg();

 infile.seekg(0, ios::beg);

char ch;
string str(sz, '0');

int i = 0;
  for (i = 0; infile.get(ch); ) if (ch != '\n') str[i++] = ch;

  str.erase (i);

  str_size_o = str.size();
}

// ---------
static void ReadFile4(const string& filename_i, unsigned long& str_size_o)
{
  // --- Using vector, reading whole file at once ---

ifstream infile (filename_i.c_str(), ios::in | ios::ate);
  assert (infile.is_open());

streampos sz = infile.tellg();

  infile.seekg(0, ios::beg);

vector<char> v(sz);

  infile.read(&v[0], sz);
  // v.erase(remove(v.begin(), v.end(), '\n'), v.end());

string str (v.empty() ? string() : string (v.begin(), v.end()).c_str());

  str_size_o = str.size();
}


////////////////////////////////////////////////
#if ((defined UNIX_ENV) && !(defined DJGPP_ENV))
////////////////////////////////////////////////
// ---------
static void ReadFile5(const string& filename_i, unsigned long& str_size_o)
{
  // --- Using mmap ---
int fd = open(filename_i.c_str(), O_RDONLY);
  assert (fd > 2);

off_t sz = lseek(fd, 0, SEEK_END);
char* ptr = (char*)mmap(0, sz, PROT_READ, MAP_SHARED, fd, 0);

  str_size_o = 0;

  if (ptr == MAP_FAILED)
  {
    close(fd);
    return;
  }

  assert (ptr != MAP_FAILED);

string str(ptr, ptr + sz);
  munmap(ptr, sz);

  // str.erase(remove(str.begin(), str.end(), '\n'), str.end());
  // str.erase(remove(str.begin(), str.end(), '\r'), str.end());

  close(fd);

  str_size_o = str.size();

}
//////
#endif
//////

// ---------
static void ReadFile6 (const string& filename_i, unsigned long& str_size_o)
{
  // --- Using iterator ---
ifstream infile (filename_i.c_str());
  assert (infile.is_open());

  infile >> noskipws;

istream_iterator<char> iter(infile), eos;
string str(iter, eos);

  // str.erase(remove(str.begin(), str.end(), '\n'), str.end());

  str_size_o = str.size();
}


// #########################################

#define TEST_INFILE_0	"t_file_0.in"
#define TEST_INFILE_1	"t_file_1.in"
#define TEST_INFILE_2	"t_file_2.in"
#define TEST_INFILE_3	"t_file_3.in"
#define TEST_INFILE_4	"t_file_4.in"
#define TEST_INFILE_5	"t_file_5.in"


// -------------------------------------------
#define NUMBER_OF_TEST_INFILE_SIZES	6
static const char *t_afiles[] = {TEST_INFILE_0, TEST_INFILE_1, TEST_INFILE_2, TEST_INFILE_3, TEST_INFILE_4, TEST_INFILE_5};
static vector<string> t_vfiles (t_afiles, t_afiles + NUMBER_OF_TEST_INFILE_SIZES);
// -------------------------------------------


// #########################################
// #
// #  Functions To Be Measured (Compared)
// #  Prototypes are in file tests.h
// #
// #########################################




// =============================
void file_action (void)
{
  // --- Using getline() ---

const string htext__using_getline ("getline                   ");
const string htext__vector_char   ("vector, reading char      ");
const string htext__string_char   ("string, reading char      ");
const string htext__vector_whole  ("vector, reading whole file");
const string htext__mmap          ("mmap                      ");
const string htext__iterator      ("iterator                  ");


  // -------------------------------
  for (size_t i = 0; i < t_vfiles.size(); i++)
  {
    ulong contents_file_size;
    const string cur_infile_name (t_vfiles[i]);
    const ullong cur_infile_size = get_file_size (cur_infile_name);
    const ulong  cur_infile_rows = get_file_rows (cur_infile_name);
		 
    {
      contents_file_size = 0;
      TURN_ON_DEFAULT_TIMER (htext__using_getline, cur_infile_size) 
      {
        ReadFile1 (cur_infile_name, contents_file_size);
      }
      assert (contents_file_size <= cur_infile_size);
      // assert (contents_file_size == (cur_infile_size - 2 * cur_infile_rows));
      assert (contents_file_size >= (cur_infile_size - 2 * cur_infile_rows));
    }

    {
      contents_file_size = 0;
      TURN_ON_DEFAULT_TIMER (htext__vector_char, cur_infile_size) 
      {
        ReadFile2 (cur_infile_name, contents_file_size);
      }
      assert (contents_file_size <= cur_infile_size);
      // assert (contents_file_size == (cur_infile_size - 2 * cur_infile_rows));
      assert (contents_file_size >= (cur_infile_size - 2 * cur_infile_rows));
    }

    {
      contents_file_size = 0;
      TURN_ON_DEFAULT_TIMER (htext__string_char, cur_infile_size) 
      {
        ReadFile3 (cur_infile_name, contents_file_size);
      }
      assert (contents_file_size <= cur_infile_size);
      // assert (contents_file_size == (cur_infile_size - 2 * cur_infile_rows));
      assert (contents_file_size >= (cur_infile_size - 2 * cur_infile_rows));
    }

    {
      contents_file_size = 0;
      TURN_ON_DEFAULT_TIMER (htext__vector_whole, cur_infile_size) 
      {
        ReadFile4 (cur_infile_name, contents_file_size);
      }
      assert (contents_file_size <= cur_infile_size);
      // assert (contents_file_size == (cur_infile_size - 2 * cur_infile_rows));
      assert (contents_file_size >= (cur_infile_size - 2 * cur_infile_rows));
    }

////////////////////////////////////////////////
#if ((defined UNIX_ENV) && !(defined DJGPP_ENV))
////////////////////////////////////////////////

    {
      contents_file_size = 0;
      TURN_ON_DEFAULT_TIMER (htext__mmap, cur_infile_size) 
      {
        ReadFile5 (cur_infile_name, contents_file_size);
      }
      assert (contents_file_size <= cur_infile_size);
      // assert (contents_file_size == (cur_infile_size - 2 * cur_infile_rows));
      assert (contents_file_size >= (cur_infile_size - 2 * cur_infile_rows));
    }

//////
#endif
//////

    {
      contents_file_size = 0;
      TURN_ON_DEFAULT_TIMER (htext__iterator, cur_infile_size) 
      {
        ReadFile6 (cur_infile_name, contents_file_size);
      }
      assert (contents_file_size <= cur_infile_size);
      // assert (contents_file_size == (cur_infile_size - 2 * cur_infile_rows));
      assert (contents_file_size >= (cur_infile_size - 2 * cur_infile_rows));
    }


  } // for (size_t i = 0; i < t_vfiles.size(); i++)


} // file_action


///////////////
// End-Of-File
///////////////

