// #########################################################
// === File #3 of 14 : macro.h =============================
// ------------------- C++ code : BEGIN --------------------

// ==============================================================
//
//  Copyright (c) 2002 by Alex Vinokur.  This work and all works
//  derived from it may be copied and modified without any
//  restrictions other than that a copy of this copyright notice
//  must be included in any copy of this work or any derived work.
//
// ==============================================================
// #########################################################
// ## mailto:alexvn@go.to, mailto:alexv@hitechclub.com
// ## http://up.to/alexv, http://go.to/alexv_math
// #########################################################
// ==============================================================


// ##############################################################
//
//  SOFTWARE : C/C++ Program Perfometer
//  FILE     : macro.h
//
//  DESCRIPTION :
//         Various Macro
//
// ##############################################################




////////////////
#ifndef _MACRO_H
#define _MACRO_H
////////////////


//#########################################
//#
//#  macro
//#
//#########################################

#define	DEBUG_MODE	0

//=============================
#define DOUT(x)	\
	cout	<< "DBG"	\
		<< " ["		\
		<< setw(10)	\
		<< __FILE__	\
		<< ", #"	\
		<< __LINE__	\
		<< "] "		\
		x		\
		<< endl

#define DOUT1_VAL(x, t1)	DOUT(<< t1 << " : " << #x << " = <" << x << ">")	
#define DOUT2_VAL(x, t1, t2)	DOUT(<< t1 << " : " << #x << " = <" << x << "> " << t2)	

//=============================
#define I_AM_X(x)				\
	cout	<< ""				\
		<< x				\
		<< " ["		      		\
		<< setw(10)			\
		<< string (__FILE__).c_str()	\
		<< ", #"			\
		<< setw(4)			\
		<< __LINE__			\
		<< "] "				\
		<< __PRETTY_FUNCTION__		\
		<< endl

#define I_AM_Y(y, n)				\
	cout	<< ""				\
		<< y				\
		<< "-"				\
		<< n				\
		<< " ["		      		\
		<< setw(10)			\
		<< string (__FILE__).c_str()	\
		<< ", #"			\
		<< setw(4)			\
		<< __LINE__			\
		<< "] "				\
		<< __PRETTY_FUNCTION__		\
		<< endl

#define I_AM_Z(z, n, m)				\
	cout	<< ""				\
		<< z				\
		<< "-"				\
		<< n				\
		<< "-"				\
		<< m				\
		<< " ["		      		\
		<< setw(10)			\
		<< string (__FILE__).c_str()	\
		<< ", #"			\
		<< setw(4)			\
		<< __LINE__			\
		<< "] "				\
		<< __PRETTY_FUNCTION__		\
		<< endl


#if (DEBUG_MODE)

  #define I_AM_TRACE		I_AM_X ("TRACE")	
  #define I_AM_CTOR		I_AM_X ("CTOR ")	
  #define I_AM_COPY_CTOR	I_AM_X ("COPY-CTOR ")	
  #define I_AM_DTOR		I_AM_X ("DTOR ")	

  #define I_AM_ITRACE(n)	I_AM_Y ("TRACE", n)	
  #define I_AM_IJTRACE(n, m)	I_AM_Z ("TRACE", n, m)	

  #define DBG_TMP_STR		__FILE__ << ", # " << __LINE__ << " ---> " << __PRETTY_FUNCTION__			

#else
  #define I_AM_TRACE	
  #define I_AM_CTOR	
  #define I_AM_COPY_CTOR	
  #define I_AM_DTOR	

  #define I_AM_ITRACE(n)		
  #define I_AM_IJTRACE(n, m)	

  #define DBG_TMP_STR	

#endif

//=============================
#define  MAX_VALUE(x,y)  ((x) > (y) ? (x) : (y))

#if ((defined __GNUC__)	|| (defined __GNUG__) || (defined __DJGPP__) || (defined __DJGPP) || (defined DJGPP))
  #define prettyFuncName	__PRETTY_FUNCTION__	
  #define funcName		__FUNCTION__	
#else
  #define prettyFuncName	"NoPrettyFunctionName"	
  #define funcName		"NoFunctionName"	
#endif


#define BASIC_TURN_ON_PERFOMETER(T1, T2, T3, descr_ARG, iterations_ARG)	\
	ulong total_meas_iterations = iterations_ARG;	\
	ulong i_meas_iterations;   	\
	ClassPerfoMeter<T1, T2, T3> ins_meter(	\
		perf_ins.get_cur_func_ptr(),	\
		prettyFuncName,		\
		funcName,		\
		__FILE__,		\
		__LINE__,		\
		descr_ARG,		\
		iterations_ARG		\
		);			\
		for (	i_meas_iterations = 0;	\
			i_meas_iterations < total_meas_iterations;	\
			i_meas_iterations++	\
			)
			 

#define TURN_ON_PERFOMETER(T1, T2, T3, descr_ARG) \
	BASIC_TURN_ON_PERFOMETER(T1, T2, T3, descr_ARG, perf_ins.get_current_total_iterations ())

#define TURN_ON	TURN_ON_PERFOMETER


//###################
#endif	// _MACRO_H
//###################


//#######################################
//############# END OF FILE #############
//#######################################


// ------------------- C++ code : END ----------------------
// === File #3 of 14 : macro.h =============================
