/*
 * Decompiled with CFR 0.152.
 */
package helliker.id3;

import helliker.id3.BinaryParser;
import helliker.id3.ID3v2FormatException;
import helliker.id3.ID3v2Frames;
import java.io.UnsupportedEncodingException;

public class ID3v2Frame {
    private final int FRAME_HEAD_SIZE = 10;
    private final int FRAME_FLAGS_SIZE = 2;
    private final int MAX_EXTRA_DATA = 5;
    private final String[] ENC_TYPES = new String[]{"ISO-8859-1", "UTF16", "UTF-16BE", "UTF-8"};
    private String id = null;
    private boolean tagAlterDiscard;
    private boolean fileAlterDiscard;
    private boolean readOnly;
    private boolean grouped;
    private boolean compressed;
    private boolean encrypted;
    private boolean unsynchronised;
    private boolean lengthIndicator;
    private byte group;
    private byte encrType;
    private int dataLength;
    private byte[] frameData;

    public ID3v2Frame(String string, byte[] byArray, byte[] byArray2) throws ID3v2FormatException {
        this(string, byArray2);
        this.parseFlags(byArray);
    }

    public ID3v2Frame(String string, byte[] byArray) {
        this.id = string;
        this.tagAlterDiscard = false;
        this.fileAlterDiscard = this.checkDefaultFileAlterDiscard();
        this.readOnly = false;
        this.grouped = false;
        this.compressed = false;
        this.encrypted = false;
        this.unsynchronised = false;
        this.lengthIndicator = false;
        this.group = 0;
        this.encrType = 0;
        this.dataLength = -1;
        this.parseData(byArray);
    }

    public ID3v2Frame(String string, byte[] byArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8) {
        this.id = string;
        this.tagAlterDiscard = bl;
        this.fileAlterDiscard = bl2;
        this.readOnly = bl3;
        this.grouped = bl4;
        this.compressed = bl5;
        this.encrypted = bl6;
        this.unsynchronised = bl7;
        this.lengthIndicator = bl8;
        this.group = 0;
        this.encrType = 0;
        this.dataLength = -1;
        this.parseData(byArray);
    }

    public void setFrameData(byte[] byArray) {
        if (!this.readOnly) {
            this.frameData = byArray;
        }
    }

    public byte[] getFrameData() {
        return this.frameData;
    }

    public int getFrameLength() {
        int n = this.frameData.length + 10;
        if (this.grouped) {
            ++n;
        }
        if (this.encrypted) {
            ++n;
        }
        if (this.lengthIndicator) {
            n += 4;
        }
        return n;
    }

    public byte[] getFrameBytes() {
        int n = this.frameData.length;
        int n2 = 0;
        byte[] byArray = this.getFlagBytes();
        byte[] byArray2 = this.getExtraDataBytes();
        if (this.grouped) {
            ++n;
        }
        if (this.encrypted) {
            ++n;
        }
        if (this.lengthIndicator) {
            n += 4;
        }
        byte[] byArray3 = new byte[n + 10];
        System.arraycopy(this.id.getBytes(), 0, byArray3, 0, this.id.length());
        System.arraycopy(BinaryParser.convertToBytes(n), 0, byArray3, n2 += this.id.length(), 4);
        System.arraycopy(byArray, 0, byArray3, n2 += 4, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, n2 += byArray.length, byArray2.length);
        System.arraycopy(this.frameData, 0, byArray3, n2 += byArray2.length, this.frameData.length);
        n2 += this.frameData.length;
        return byArray3;
    }

    public boolean getTagAlterDiscard() {
        return this.tagAlterDiscard;
    }

    public boolean getFileAlterDiscard() {
        return this.fileAlterDiscard;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public boolean getGrouped() {
        return this.grouped;
    }

    public boolean getCompressed() {
        return this.compressed;
    }

    public boolean getEncrypted() {
        return this.encrypted;
    }

    public boolean getUnsynchronised() {
        return this.unsynchronised;
    }

    public boolean getLengthIndicator() {
        return this.lengthIndicator;
    }

    public byte getGroup() {
        return this.group;
    }

    public byte getEncryptionType() {
        return this.encrType;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public String getDataString() throws ID3v2FormatException {
        String string = new String();
        if (this.frameData.length > 1) {
            try {
                if (this.id.charAt(0) == 'T' || this.id.equals(ID3v2Frames.OWNERSHIP_FRAME)) {
                    string = this.getDecodedString(this.frameData, 0, 1);
                } else if (this.id.charAt(0) == 'W') {
                    string = new String(this.frameData);
                } else if (this.id.equals(ID3v2Frames.USER_DEFINED_URL)) {
                    byte by = this.frameData[0];
                    byte[] byArray = new byte[this.frameData.length];
                    boolean bl = false;
                    int n = 0;
                    while (!bl && n < byArray.length) {
                        bl = this.frameData[n + 1] == 0;
                        if (bl) continue;
                        byArray[n] = this.frameData[n + 1];
                        ++n;
                    }
                    if (by >= 0 && by < this.ENC_TYPES.length) {
                        string = new String(byArray, 0, n, this.ENC_TYPES[by]);
                    }
                    string = String.valueOf(String.valueOf(string)).concat("\n");
                    string = string.concat(new String(this.frameData, n, this.frameData.length - n));
                } else if (this.id.equals(ID3v2Frames.UNSYNCHRONISED_LYRIC_TRANSCRIPTION) || this.id.equals(ID3v2Frames.COMMENTS) || this.id.equals(ID3v2Frames.TERMS_OF_USE)) {
                    string = this.getDecodedString(this.frameData, 0, 4);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new ID3v2FormatException(String.valueOf(String.valueOf(new StringBuffer("Frame: ").append(this.id).append(" has ").append(" not specified a valid encoding type."))));
            }
        }
        return string;
    }

    public boolean isEmpty() {
        return this.frameData.length <= 1;
    }

    public String toString() {
        String string = null;
        try {
            string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.id))).append("\nTagAlterDiscard:\t\t").append(this.tagAlterDiscard).append("\nFileAlterDiscard:\t\t").append(this.fileAlterDiscard).append("\nReadOnly:\t\t\t").append(this.readOnly).append("\nGrouped:\t\t\t").append(this.grouped).append("\nCompressed:\t\t\t").append(this.compressed).append("\nEncrypted:\t\t\t").append(this.encrypted).append("\nUnsynchronised:\t\t\t").append(this.unsynchronised).append("\nLengthIndicator:\t\t").append(this.lengthIndicator).append("\nData:\t\t\t\t").append(this.getDataString().toString())));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private byte[] getFlagBytes() {
        byte[] byArray = new byte[]{0, 0};
        if (this.tagAlterDiscard) {
            byArray[0] = BinaryParser.setBit(byArray[0], 6);
        }
        if (this.fileAlterDiscard) {
            byArray[0] = BinaryParser.setBit(byArray[0], 5);
        }
        if (this.readOnly) {
            byArray[0] = BinaryParser.setBit(byArray[0], 4);
        }
        if (this.grouped) {
            byArray[1] = BinaryParser.setBit(byArray[1], 6);
        }
        if (this.compressed) {
            byArray[1] = BinaryParser.setBit(byArray[1], 3);
        }
        if (this.encrypted) {
            byArray[1] = BinaryParser.setBit(byArray[1], 2);
        }
        if (this.unsynchronised) {
            byArray[1] = BinaryParser.setBit(byArray[1], 1);
        }
        if (this.lengthIndicator) {
            byArray[1] = BinaryParser.setBit(byArray[1], 0);
        }
        return byArray;
    }

    private byte[] getExtraDataBytes() {
        byte[] byArray = new byte[5];
        int n = 0;
        if (this.grouped) {
            byArray[n] = this.group;
            ++n;
        }
        if (this.encrypted) {
            byArray[n] = this.encrType;
            ++n;
        }
        if (this.lengthIndicator) {
            byte[] byArray2 = BinaryParser.convertToBytes(this.dataLength);
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            n += byArray2.length;
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray, 0, byArray3, 0, n);
        return byArray3;
    }

    private String getDecodedString(byte[] byArray, int n, int n2) throws UnsupportedEncodingException {
        String string = new String();
        byte by = byArray[n];
        if (by >= 0 && by < this.ENC_TYPES.length) {
            string = new String(byArray, n2, byArray.length - n2, this.ENC_TYPES[by]);
        }
        return string;
    }

    private boolean checkDefaultFileAlterDiscard() {
        return this.id.equals(ID3v2Frames.AUDIO_SEEK_POINT_INDEX) || this.id.equals(ID3v2Frames.AUDIO_ENCRYPTION) || this.id.equals(ID3v2Frames.EVENT_TIMING_CODES) || this.id.equals(ID3v2Frames.EQUALISATION) || this.id.equals(ID3v2Frames.MPEG_LOCATION_LOOKUP_TABLE) || this.id.equals(ID3v2Frames.POSITION_SYNCHRONISATION_FRAME) || this.id.equals(ID3v2Frames.SEEK_FRAME) || this.id.equals(ID3v2Frames.SYNCHRONISED_LYRIC) || this.id.equals(ID3v2Frames.SYNCHRONISED_TEMPO_CODES) || this.id.equals(ID3v2Frames.RELATIVE_VOLUME_ADJUSTMENT) || this.id.equals(ID3v2Frames.ENCODED_BY) || this.id.equals(ID3v2Frames.LENGTH);
    }

    private void parseFlags(byte[] byArray) throws ID3v2FormatException {
        if (byArray.length != 2) {
            throw new ID3v2FormatException(String.valueOf(String.valueOf(new StringBuffer("Error parsing flags of frame: ").append(this.id).append(".  Expected 2 bytes."))));
        }
        this.tagAlterDiscard = BinaryParser.bitSet(byArray[0], 6);
        this.fileAlterDiscard = BinaryParser.bitSet(byArray[0], 5);
        this.readOnly = BinaryParser.bitSet(byArray[0], 4);
        this.grouped = BinaryParser.bitSet(byArray[1], 6);
        this.compressed = BinaryParser.bitSet(byArray[1], 3);
        this.encrypted = BinaryParser.bitSet(byArray[1], 2);
        this.unsynchronised = BinaryParser.bitSet(byArray[1], 1);
        this.lengthIndicator = BinaryParser.bitSet(byArray[1], 0);
        if (this.compressed && !this.lengthIndicator) {
            throw new ID3v2FormatException(String.valueOf(String.valueOf(new StringBuffer("Error parsing flags of frame: ").append(this.id).append(".  Compressed bit set  ").append("without data length bit set."))));
        }
    }

    private void parseData(byte[] byArray) {
        int n = 0;
        if (this.grouped) {
            this.group = byArray[n];
            ++n;
        }
        if (this.encrypted) {
            this.encrType = byArray[n];
            ++n;
        }
        if (this.lengthIndicator) {
            byte[] byArray2 = new byte[4];
            System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
            this.dataLength = BinaryParser.convertToInt(byArray2);
            n += byArray2.length;
        }
        this.frameData = new byte[byArray.length - n];
        System.arraycopy(byArray, n, this.frameData, 0, this.frameData.length);
    }
}

