// ==============================================================
//
//  Copyright (c) 1999-2002 by Alex Vinokur.  This work and all works
//  derived from it may be copied and modified without any
//  restrictions other than that a copy of this copyright notice
//  must be included in any copy of this work or any derived work.
//
// ==============================================================

///////////////////////////////////////

#ifndef demotype_H
#define demotype_H

///////////////////////////////////////

static char id_demotype_H[] = "@(#)## n-ary Huffman Template Algorithm ## Author : Alex Vinokur ## "__FILE__;


// ##############################################################
// =================================
//  n-ary Huffman Template Algorithm
// ==================================
//
//  FILE : demotype.h
//
//  AUTHOR : Alex Vinokur
//
//  DESCRIPTION :
//
//         Definition of the following test classes :
//         ----------------------------------------------
//         - AAA        (non-char) symbol type
//         - BBB        (non-numerical) weight type
//         ----------------------------------------------
//
// ##############################################################


// =======================
#include <iostream>
using namespace std;
// =======================



// ###################################################
// ############## "Symbols" Test Class ###############
// ###################################################
class AAA
{
friend bool operator< (const AAA& inst1_i, const AAA& inst2_i);
friend ostream& operator<< (ostream& o, const AAA& instance_i);
        private :
                static unsigned int     counter_s;
                unsigned int            counter_;
        public :
                AAA ();
                ~AAA () {}
};


// ###################################################
// ############## "Weight" Test Class ################
// ###################################################
class BBB
{
friend ostream& operator<< (ostream& o, const BBB& instance_i);
friend bool operator< (const BBB& inst1_i, const BBB& inst2_i);
friend bool operator== (const BBB& inst1_i, const BBB& inst2_i);
friend BBB operator* (const BBB& inst1_i, unsigned int int_value_i);
friend BBB operator/ (const BBB& inst1_i, unsigned int int_value_i);
        private :
                int                     value_;
                static unsigned int     counter_s;
                unsigned int            counter_;

        public :
                BBB ();
                ~BBB () {}
                BBB& operator+= (const BBB& inst_i);

};


#endif	// demotype_H

// #######################################################
// ################ END OF FILE ##########################
// #######################################################

