/*
 * Decompiled with CFR 0.152.
 */
package jChatBox.Command;

import jChatBox.Chat.ChatException;
import jChatBox.Chat.Chatroom;
import jChatBox.Chat.ChatroomManager;
import jChatBox.Chat.ChatroomUser;
import jChatBox.Chat.Msg;
import jChatBox.Command.CommandException;
import jChatBox.Command.CommandParams;
import jChatBox.Command.ModeratorCommand;
import jChatBox.Util.Conf;
import jChatBox.Util.Debug;
import jChatBox.Util.XMLConfig;
import jChatBox.Util.XMLPropertyResourceBundle;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpSession;

public class UserCommand
extends ModeratorCommand {
    public String execute(String string, CommandParams commandParams, ChatroomUser chatroomUser) throws CommandException {
        if (string != null && !string.equals("")) {
            string = string.toUpperCase();
            ChatroomManager chatroomManager = ChatroomManager.getInstance();
            if (chatroomManager == null) {
                throw new CommandException(Conf.SYSTEMERROR);
            }
            if (string.equals("REFRESH")) {
                return Conf.COMMANDOK;
            }
            if (string.equals("LOGOUT")) {
                HttpSession httpSession = (HttpSession)commandParams.getParameter("session");
                if (httpSession != null) {
                    httpSession.invalidate();
                }
                return Conf.COMMANDOK;
            }
            if (string.equals("QUIT")) {
                HttpSession httpSession = (HttpSession)commandParams.getParameter("session");
                if (httpSession != null) {
                    httpSession.removeValue(XMLConfig.USERSESSIONID);
                }
                return Conf.COMMANDOK;
            }
            if (string.equals("CHAT")) {
                int n = chatroomUser.getParams().getChatroom();
                Chatroom chatroom = null;
                try {
                    chatroom = chatroomManager.getChatroom(n);
                }
                catch (ChatException chatException) {
                    throw new CommandException(Conf.CHATROOMNOTFOUND);
                }
                String string2 = (String)commandParams.getParameter("msg");
                String string3 = (String)commandParams.getParameter("to");
                if (string2 != null && !string2.trim().equals("") && string3 != null && !string3.equals("")) {
                    Msg msg = null;
                    msg = string3.toUpperCase().equals("ALL") ? new Msg(new Date(), chatroomUser.getName(), string3, string2) : new Msg(new Date(), chatroomUser.getName(), string3, string2, 3);
                    try {
                        chatroom.addMsg(msg);
                        return Conf.COMMANDOK;
                    }
                    catch (ChatException chatException) {
                        throw new CommandException(Conf.CHATROOMNOTFOUND);
                    }
                }
                return Conf.COMMANDOK;
            }
            if (string.equals("TIME")) {
                int n = chatroomUser.getParams().getChatroom();
                Chatroom chatroom = null;
                try {
                    chatroom = chatroomManager.getChatroom(n);
                }
                catch (ChatException chatException) {
                    throw new CommandException(Conf.CHATROOMNOTFOUND);
                }
                XMLPropertyResourceBundle xMLPropertyResourceBundle = (XMLPropertyResourceBundle)XMLConfig.RESOURCES.get(chatroom.getParams().getLanguage());
                return new SimpleDateFormat(xMLPropertyResourceBundle.getString("user.command.time.format")).format(new Date());
            }
            if (string.equals("HELP")) {
                int n = chatroomUser.getParams().getChatroom();
                Chatroom chatroom = null;
                try {
                    chatroom = chatroomManager.getChatroom(n);
                }
                catch (ChatException chatException) {
                    throw new CommandException(Conf.CHATROOMNOTFOUND);
                }
                XMLPropertyResourceBundle xMLPropertyResourceBundle = (XMLPropertyResourceBundle)XMLConfig.RESOURCES.get(chatroom.getParams().getLanguage());
                String string4 = (String)commandParams.getParameter("command");
                if (string4 != null && !string4.equals("")) {
                    String string5 = string4.toUpperCase();
                    if (string5.equals("TIME")) {
                        return Conf.TIMEHELP + xMLPropertyResourceBundle.getString("user.command.time.help");
                    }
                    if (string5.equals("CHAT")) {
                        return Conf.CHATHELP + xMLPropertyResourceBundle.getString("user.command.chat.help");
                    }
                    if (string5.equals("QUIT")) {
                        return Conf.QUITHELP + xMLPropertyResourceBundle.getString("user.command.quit.help");
                    }
                    if (string5.equals("REFRESH")) {
                        return Conf.REFRESHHELP + xMLPropertyResourceBundle.getString("user.command.refresh.help");
                    }
                    if (string5.equals("LOGOUT")) {
                        return Conf.LOGOUTHELP + xMLPropertyResourceBundle.getString("user.command.logout.help");
                    }
                    throw new CommandException(string5 + " : " + Conf.UNKNOWNCOMMAND);
                }
                return Conf.HELPHELP;
            }
            return super.execute(string, commandParams, chatroomUser);
        }
        throw new CommandException(Conf.UNKNOWNCOMMAND);
    }

    private void _$229(int n, String string) {
        Debug.log(n, this.getClass().getName(), string);
    }
}

