/*
 * Decompiled with CFR 0.152.
 */
package jChatBox.Chat;

import jChatBox.Chat.Blacklist;
import jChatBox.Chat.ChatException;
import jChatBox.Chat.ChatroomParams;
import jChatBox.Chat.ChatroomTimer;
import jChatBox.Chat.ChatroomUser;
import jChatBox.Chat.Event.ChatroomEvent;
import jChatBox.Chat.Event.ChatroomListener;
import jChatBox.Chat.Event.ChatroomTimerListener;
import jChatBox.Chat.LogListener;
import jChatBox.Chat.Msg;
import jChatBox.Util.Conf;
import jChatBox.Util.Debug;
import jChatBox.Util.XMLConfig;
import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class Chatroom
implements Serializable,
LogListener {
    private ChatroomParams _$428 = null;
    private Vector _$430;
    private transient Hashtable _$431 = null;
    private Blacklist _$433 = null;
    private Date _$434 = null;
    private transient Vector _$435 = null;
    private Vector _$436 = null;
    private transient Vector _$437 = null;

    public Chatroom(ChatroomParams chatroomParams) {
        this._$428 = chatroomParams;
        this._$430 = new Vector();
        this._$435 = new Vector();
        this._$436 = new Vector();
        this._$437 = new Vector();
        this._$431 = new Hashtable();
        this._$433 = new Blacklist();
        this._$229(1, "New Chatroom : " + this._$428.getName() + "/" + this._$428.getSubject() + "/" + this._$428.getMaxUsers());
    }

    public void open() {
        this._$434 = new Date();
        this.notifyListeners(new ChatroomEvent(0, this, "OPEN"));
        this._$229(1, "Open : " + this._$428.getName());
    }

    public boolean isOpened() {
        return this._$434 != null;
    }

    public void reOpen() {
        this._$431 = new Hashtable();
        this._$434 = new Date();
        this._$435 = new Vector();
        this._$437 = new Vector();
        int n = 0;
        while (n < this._$436.size()) {
            String string = (String)this._$436.elementAt(n);
            int n2 = 0;
            while (n2 < XMLConfig.LISTENERS.size()) {
                ChatroomListener chatroomListener = (ChatroomListener)XMLConfig.LISTENERS.elementAt(n2);
                if (chatroomListener.getID().equals(string)) {
                    this.addListener(chatroomListener);
                }
                ++n2;
            }
            ++n;
        }
        this.notifyListeners(new ChatroomEvent(0, this, "REOPEN"));
        this._$229(1, "reOpen : " + this._$428.getName());
    }

    public void addListener(ChatroomListener chatroomListener) {
        if (!this._$436.contains(chatroomListener.getID())) {
            this._$436.addElement(chatroomListener.getID());
        }
        if (!this._$435.contains(chatroomListener)) {
            this._$435.addElement(chatroomListener);
            this.runTimer(chatroomListener);
        }
    }

    protected void runTimer(ChatroomListener chatroomListener) {
        if (chatroomListener instanceof ChatroomTimerListener) {
            ChatroomTimerListener chatroomTimerListener = (ChatroomTimerListener)chatroomListener;
            ChatroomTimer chatroomTimer = new ChatroomTimer(this, chatroomTimerListener);
            this._$437.addElement(chatroomTimer);
            Thread thread = new Thread(chatroomTimer);
            thread.start();
        }
    }

    public void removeListener(ChatroomListener chatroomListener) {
        if (this._$435 != null) {
            int n = 0;
            while (n < this._$435.size()) {
                ChatroomListener chatroomListener2 = (ChatroomListener)this._$435.elementAt(n);
                if (chatroomListener2.getID().equals(chatroomListener.getID())) {
                    if (chatroomListener instanceof ChatroomTimerListener) {
                        ChatroomTimerListener chatroomTimerListener = (ChatroomTimerListener)chatroomListener;
                        if (this._$437 != null) {
                            int n2 = 0;
                            while (n2 < this._$437.size()) {
                                ChatroomTimer chatroomTimer = (ChatroomTimer)this._$437.elementAt(n2);
                                ChatroomTimerListener chatroomTimerListener2 = chatroomTimer.getListener();
                                if (chatroomTimerListener2 == chatroomTimerListener) {
                                    chatroomTimer.setPeriod(-1L);
                                }
                                ++n2;
                            }
                        }
                    }
                    this._$435.removeElement(chatroomListener);
                    this._$436.removeElement(chatroomListener.getID());
                    break;
                }
                ++n;
            }
        }
    }

    protected void notifyListeners(ChatroomEvent chatroomEvent) {
        if (this._$435 != null) {
            int n = 0;
            while (n < this._$435.size()) {
                ChatroomListener chatroomListener = (ChatroomListener)this._$435.elementAt(n);
                chatroomListener.actionPerformed(chatroomEvent);
                ++n;
            }
        }
    }

    public Vector getListeners() {
        return this._$435;
    }

    public void close() {
        this._$434 = null;
        this.notifyListeners(new ChatroomEvent(1, this, null));
    }

    public Date getDate() {
        return this._$434;
    }

    public void addUser(ChatroomUser chatroomUser) throws ChatException {
        if (this._$434 == null) {
            throw new ChatException(Conf.CLOSED);
        }
        String string = chatroomUser.getName();
        if (this._$433.isKickedOff(chatroomUser)) {
            throw new ChatException(Conf.KICKEDOFF);
        }
        if (this._$433.isBanned(chatroomUser)) {
            throw new ChatException(Conf.BANNED);
        }
        if ((chatroomUser.getType() != 2 || chatroomUser.getType() != 1) && this._$431.size() > this._$428.getMaxUsers()) {
            throw new ChatException(Conf.NOVACANCIES);
        }
        ChatroomUser chatroomUser2 = (ChatroomUser)this._$431.get(string);
        if (chatroomUser2 == null) {
            if (chatroomUser.getName().toUpperCase().equals(XMLConfig.SYSTEMLOGIN.toUpperCase()) && chatroomUser.getType() != 2) {
                throw new ChatException(Conf.NAMENOTAVAILABLE);
            }
            if (XMLConfig.getModerator(chatroomUser.getName()) != null && chatroomUser.getType() != 1) {
                throw new ChatException(Conf.NAMENOTAVAILABLE);
            }
            this.notifyListeners(new ChatroomEvent(3, this, chatroomUser));
            if (chatroomUser.getName() != null) {
                this._$431.put(string, chatroomUser);
            }
        } else {
            throw new ChatException(Conf.NAMENOTAVAILABLE);
        }
        this.notifyListeners(new ChatroomEvent(4, this, chatroomUser));
        this.addMsg(new Msg(new Date(), "Manager", "ALL", string, 1));
    }

    public ChatroomUser getUser(String string) {
        ChatroomUser chatroomUser = (ChatroomUser)this._$431.get(string);
        return chatroomUser;
    }

    public int getTotalUsers() {
        return this._$431.size();
    }

    public ChatroomParams getParams() {
        return this._$428;
    }

    public void updateParams(ChatroomParams chatroomParams) {
        this._$428 = chatroomParams;
        this._$229(1, "Chatroom updated: " + this._$428.getName() + "/" + this._$428.getSubject() + "/" + this._$428.getMaxUsers());
    }

    public void addToBlacklist(ChatroomUser chatroomUser, String string) throws ChatException {
        this._$433.add(chatroomUser, string);
        this.notifyListeners(new ChatroomEvent(9, this, chatroomUser));
    }

    public void removeFromBlacklist(String string) {
        this._$433.remove(string);
        this.notifyListeners(new ChatroomEvent(10, this, string));
    }

    public void resetBlacklist() {
        this._$433.clear();
        this.notifyListeners(new ChatroomEvent(11, this, this._$433));
    }

    public Blacklist getBlacklist() {
        return this._$433;
    }

    public void removeUser(String string) throws ChatException {
        ChatroomUser chatroomUser = (ChatroomUser)this._$431.get(string);
        if (chatroomUser != null) {
            this.notifyListeners(new ChatroomEvent(5, this, chatroomUser));
            if (chatroomUser.getName() != null) {
                this._$431.remove(chatroomUser.getName());
            }
        } else {
            throw new ChatException(Conf.NAMENOTFOUND);
        }
        this.notifyListeners(new ChatroomEvent(6, this, chatroomUser));
        this.addMsg(new Msg(new Date(), "Manager", "ALL", chatroomUser.getName(), 2));
    }

    public void addMsg(Msg msg) throws ChatException {
        this.notifyListeners(new ChatroomEvent(7, this, msg));
        if (msg.getMsg() != null) {
            this._$430.addElement(msg);
        }
        this.notifyListeners(new ChatroomEvent(8, this, msg));
    }

    public Vector getChat() {
        return this._$430;
    }

    public Vector getChat(String string) {
        Vector<Msg> vector = new Vector<Msg>();
        Msg msg = null;
        int n = 0;
        while (n < this._$430.size()) {
            msg = (Msg)this._$430.elementAt(n);
            if (msg.getTo().equals(string) || msg.getTo().equals("ALL") || msg.getTo().equals("BROADCAST") || msg.getType() == 3 && msg.getFrom().equals(string)) {
                vector.addElement(msg);
            }
            ++n;
        }
        return vector;
    }

    public Hashtable getUsers() {
        return this._$431;
    }

    public void clear() {
        this._$430.removeAllElements();
        this.notifyListeners(new ChatroomEvent(2, this, null));
    }

    public void performLogout(ChatroomUser chatroomUser) {
        try {
            this.removeUser(chatroomUser.getName());
        }
        catch (Exception exception) {
            this._$229(2, "" + chatroomUser.getName() + " has already left room : " + this._$428.getName());
        }
    }

    public void performLogin(ChatroomUser chatroomUser) {
    }

    private void _$229(int n, String string) {
        Debug.log(n, this.getClass().getName(), string);
    }
}

