/*
 * Decompiled with CFR 0.152.
 */
package javazoom.download;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javazoom.download.DownloadSource;
import javazoom.download.util.Config;
import javazoom.download.util.FileInfo;

public class DownloadFolderSource
extends DownloadSource {
    public static int BUFFERSIZE = 4096;

    public DownloadFolderSource(Config config) {
        super(config);
    }

    public int getDataLength(FileInfo fileInfo) {
        File file = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(fileInfo.getPath()))).append(File.separatorChar).append(fileInfo.getFilename()))));
        if (!file.exists()) {
            return -1;
        }
        if (!file.canRead()) {
            return -1;
        }
        return (int)file.length();
    }

    public void download(FileInfo fileInfo, OutputStream outputStream) throws IOException {
        String string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(fileInfo.getPath()))).append(File.separatorChar).append(fileInfo.getFilename())));
        if (!fileInfo.isZipEnabled()) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            int n = 0;
            byte[] byArray = new byte[BUFFERSIZE];
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
            outputStream.flush();
            outputStream.close();
            bufferedInputStream.close();
        } else {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            int n = 0;
            byte[] byArray = new byte[BUFFERSIZE];
            ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
            ZipEntry zipEntry = new ZipEntry(fileInfo.getFilename());
            zipOutputStream.putNextEntry(zipEntry);
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                zipOutputStream.write(byArray, 0, n);
            }
            zipOutputStream.closeEntry();
            ((FilterOutputStream)zipOutputStream).flush();
            zipOutputStream.close();
            bufferedInputStream.close();
        }
    }
}

