/*
 * Decompiled with CFR 0.152.
 */
package cc.gammasoft.date;

import cc.gammasoft.date.WeekDayLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class WeekDayPanel
extends JComponent {
    private JPanel panelMain;
    private ArrayList weekDayLabels = new ArrayList();
    public static final int SHORT_WEEKDAY_NAME = 0;
    public static final int LONG_WEEKDAY_NAME = 1;

    WeekDayPanel() {
        this.initComponent();
    }

    private void initComponent() {
        this.panelMain = new JPanel();
        this.panelMain.setLayout(new GridLayout(0, 7));
        this.setLayout(new BorderLayout());
        this.add(this.panelMain);
    }

    public void setWeekDayNames(SimpleDateFormat dateFormat, int weekDayType) {
        if (dateFormat == null) {
            throw new NullPointerException("Null Date Format");
        }
        String[] name = weekDayType == 0 ? dateFormat.getDateFormatSymbols().getShortWeekdays() : dateFormat.getDateFormatSymbols().getWeekdays();
        this.weekDayLabels.clear();
        this.panelMain.removeAll();
        Calendar c = Calendar.getInstance();
        int i = c.getFirstDayOfWeek();
        while (i < name.length) {
            WeekDayLabel label = new WeekDayLabel(name[i]);
            this.panelMain.add(label);
            this.weekDayLabels.add(label);
            label.setOpaque(true);
            ++i;
        }
        int i2 = 1;
        while (i2 < c.getFirstDayOfWeek()) {
            WeekDayLabel label = new WeekDayLabel(name[i2]);
            this.panelMain.add(label);
            this.weekDayLabels.add(label);
            label.setOpaque(true);
            ++i2;
        }
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        Iterator it = this.getWeekDayLabels().iterator();
        while (it.hasNext()) {
            JLabel label = (JLabel)it.next();
            label.setBackground(c);
        }
    }

    public void setForeground(Color c) {
        super.setForeground(c);
        Iterator it = this.getWeekDayLabels().iterator();
        while (it.hasNext()) {
            JLabel label = (JLabel)it.next();
            label.setForeground(c);
        }
    }

    public void setBorder(Border b) {
        super.setBorder(b);
        Iterator it = this.getWeekDayLabels().iterator();
        while (it.hasNext()) {
            JLabel label = (JLabel)it.next();
            label.setBorder(b);
        }
    }

    public void setFont(Font f) {
        super.setFont(f);
        Iterator it = this.getWeekDayLabels().iterator();
        while (it.hasNext()) {
            JLabel label = (JLabel)it.next();
            label.setFont(f);
        }
    }

    public ArrayList getWeekDayLabels() {
        return this.weekDayLabels;
    }
}

