<%
' These variables will be available to all scripts.

Dim strMailboxURL, strInboxURL, strSentItemsURL, strDeletedItemsURL, strContactsURL
Dim strMailboxFileURL, strInboxFileURL, strSentItemsFileURL, strDeletedItemsFileURL, strContactsFileURL
Dim strPublicFileURL

Dim objSession, mb, objFolder, objTopPublicFolder
Dim objRenderApplication, objRenderer
Dim fn, mi
Dim mn, pg
Dim mt
Dim re, ry, rt, rc, rb
Dim mdy, hm
Dim st
Dim mp ' Miscellaneous parameter
Dim errorCode, noLineBreaks

Dim blnCanRead, blnCanReadMessages, blnCanReadFolders, blnCanModifyObject, blnCanCreateInFolder

CONST OPWFN = 1 : CONST OPWMN = 2 : CONST OPWMI = 4
CONST OPWMT = 8 : CONST OPWRE = 16 : CONST OPWRY = 32
CONST OPWRT = 64 : CONST OPWRC = 128 : CONST OPWRB = 256
CONST OPWMDY = 512 : CONST OPWHM = 1024
CONST OPWPG = 4096
CONST OPWMP = 8192
CONST OPWST = 16384

CONST OPWBOLD = 32768

CONST OPWDFILTER = 65536

CONST OPWCMN = 1 : CONST OPWCMR = 2 : CONST OPWCMF = 8
CONST OPWMTMASK = 31
CONST OPWFRMB = 32 : CONST OPWFRFO = 64 : CONST OPWFRMR = 128

'Miscellaneous Parameters

CONST OPWGSS = 4096 ' Get Sender and Subject from original msg when Replying/Forwarding ?

Dim bTopFolderFound

Function checkTopFolder(inFolder, inDefaultFolder)

  bTopFolderFound = False
  If inFolder.ID = objSession.GetDefaultFolder(inDefaultFolder).ID Then bTopFolderFound = True
  If inFolder.FolderID <> objSession.GetInfoStore(objSession.Inbox.StoreID).RootFolder.ID Then
    checkTopFolder objSession.GetFolder(inFolder.FolderID), inDefaultFolder
  End If
  checkTopFolder = bTopFolderFound

End Function

Sub clearMessage

  Dim filename, sh, key, profileDirectory, fso, f

  re = "" : ry = "" : rt = "" : rc = "" : rb = ""
  Session("attachment") = ""
  filename = Session("filename")
  If filename <> "" Then

    ' Get working directory from registry
    Set sh = Server.CreateObject("WScript.Shell")
    key = "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows Messaging Subsystem\ProfileDirectory"
    profileDirectory = sh.RegRead(key) & "\"
    Set sh = Nothing

    Set fso = Server.CreateObject("Scripting.FilesystemObject")
    Set f = fso.GetFile(profileDirectory & filename)
    f.Delete
    Set fso = Nothing
    Set f = Nothing

    Session("filename") = ""

  End If

End Sub

Sub clearObjects

  Set objAddressEntries = Nothing
  Set objAddressEntry = Nothing
  Set objAttachment = Nothing
  Set objField = Nothing
  Set objFilter = Nothing
  Set objFolder = Nothing
  Set objFolder2 = Nothing
  Set objFolders = Nothing
  Set objFolders2 = Nothing
  Set objGAL = Nothing
  Set objMessage = Nothing
  Set objMessages = Nothing
  Set objOneRecip = Nothing
  Set objTopPublicFolder = Nothing

End Sub

Function compressID(inID)

  inID = Replace(inID, "00000000", "g")
  inID = Replace(inID, "000000", "h")
  inID = Replace(inID, "0000", "i")
  inID = Replace(inID, "00", "j")
  inID = Replace(inID, "11", "k")
  inID = Replace(inID, "22", "l")
  inID = Replace(inID, "33", "m")
  inID = Replace(inID, "44", "n")
  inID = Replace(inID, "55", "o")
  inID = Replace(inID, "66", "p")
  inID = Replace(inID, "77", "q")
  inID = Replace(inID, "88", "r")
  inID = Replace(inID, "99", "s")
  inID = Replace(inID, "AA", "t")
  inID = Replace(inID, "BB", "u")
  inID = Replace(inID, "CC", "v")
  inID = Replace(inID, "DD", "w")
  inID = Replace(inID, "EE", "x")
  inID = Replace(inID, "FFFF", "y")
  inID = Replace(inID, "FF", "z")
  compressID = inID

End Function

Function displayEncode(textIn)

  ' Not doing &nbsp; to save page space.
  textIn = Server.HTMLEncode(textIn)
  textIn = Replace(textIn, "'", "&apos;")
  textIn = Replace(textIn, "$", "$$")
  textIn = Replace(textIn, vbCrLf, "<br/>" & vbCrLf)
  displayEncode = textIn

End Function

Function expandID(inID)

  inID = Replace(inID, "g", "00000000")
  inID = Replace(inID, "h", "000000")
  inID = Replace(inID, "i", "0000")
  inID = Replace(inID, "j", "00")
  inID = Replace(inID, "k", "11")
  inID = Replace(inID, "l", "22")
  inID = Replace(inID, "m", "33")
  inID = Replace(inID, "n", "44")
  inID = Replace(inID, "o", "55")
  inID = Replace(inID, "p", "66")
  inID = Replace(inID, "q", "77")
  inID = Replace(inID, "r", "88")
  inID = Replace(inID, "s", "99")
  inID = Replace(inID, "t", "AA")
  inID = Replace(inID, "u", "BB")
  inID = Replace(inID, "v", "CC")
  inID = Replace(inID, "w", "DD")
  inID = Replace(inID, "x", "EE")
  inID = Replace(inID, "y", "FFFF")
  inID = Replace(inID, "z", "FF")
  expandID = inID

End Function

Dim locFolderCounter

Sub findFolder

  If CStr(fn) = "0" Then
    Set objFolder = objSession.GetInfoStore(objSession.Inbox.StoreID).RootFolder
  Else
    locFolderCounter = 0
    Set locObjFolder = objSession.GetInfoStore(objSession.Inbox.StoreID).RootFolder
    findFolder2 locObjFolder, True
    Set locObjFolder = Nothing
  End If
  If objFolder Is Nothing Then
    rwbc "Can't get folder."
    Response.End
  End If
  getAccess(objFolder)

End Sub

Sub findFolder2(inObjFolder, inBlnFirstIteration)

  Dim locLngObjectACL, locBlnCanRead, locObjFolder

  locFolderCounter = locFolderCounter + 1

  ' Check access to folder (Exchange 5.5 fails without this).
  locLngObjectACL = inObjFolder.Fields(&H0FF40003) ' CdoPR_ACCESS
  locBlnCanRead = (locLngObjectACL And &H00000002) <> 0 ' MAPI_ACCESS_READ
  If locBlnCanRead Then
    If locFolderCounter = fn Then
      Set objFolder = inObjFolder
    Else
      For Each locObjFolder In inObjFolder.Folders
        If inBlnFirstIteration Then

          ' Need to correctly identify Calendar folder !
          If locObjFolder.IsSameAs(objSession.GetDefaultFolder(0)) Then Set locObjFolder = objSession.GetDefaultFolder(0)
        End If
        findFolder2 locObjFolder, False
      Next
      Set locObjFolder = Nothing
    End If
  End If

End Sub

Dim locFolderNumber

Function findFolderNumber(inFolderID)

  Dim locObjFolders, locObjFolder

  If inFolderID = objSession.GetInfoStore(objSession.Inbox.StoreID).RootFolder.ID Then
    locFolderNumber = 0
  Else
    locFolderCounter = 0
    Set locObjFolder = objSession.GetInfoStore(objSession.Inbox.StoreID).RootFolder
    findFolderNumber2 locObjFolder, inFolderID
    Set locObjFolder = Nothing
  End If
  findFolderNumber = locFolderNumber

End Function

Sub findFolderNumber2(inFolder, inFolderID)

  Dim locLngObjectACL, locBlnCanRead, locObjFolder

  locFolderCounter = locFolderCounter + 1
  If inFolder.ID = inFolderID Then locFolderNumber = locFolderCounter
  ' Check access to folder (Exchange 5.5 fails without this).
  locLngObjectACL = inFolder.Fields(&H0FF40003) ' CdoPR_ACCESS
  locBlnCanRead = (locLngObjectACL And &H00000002) <> 0 ' MAPI_ACCESS_READ
  If locBlnCanRead Then
    ' inFolder.Folders sometimes returned MAPI_E_NOT_FOUND(8004010F) error on THK E5.5 server
    locT = 0
    If SHOWERRORS Then On Error Resume Next
    locT = inFolder.Folders.Count
    If SHOWERRORS Then On Error Goto 0
    If locT > 0 Then
      For Each locObjFolder In inFolder.Folders
        findFolderNumber2 locObjFolder, inFolderID
      Next
    End If
  End If

End Sub

Sub findPFolder

  On Error Resume Next

  findTopPublicFolder
  If CStr(fn) = "0" Then
    Set objFolder = objTopPublicFolder
  Else
    locFolderCounter = 0
    Set locObjFolder = objTopPublicFolder
    findFolder2 locObjFolder, True
    Set locObjFolder = Nothing
  End if
  If objFolder Is Nothing Then
    rwbc "Can't get folder."
    Response.End
  End If
  getAccess(objFolder)

End Sub

Function findPFolderNumber(inFolderID)

  Dim locObjFolders, locObjFolder

  locFolderNumber = 0 ' Sometimes can't find a match!
  If inFolderID = objTopPublicFolder.ID Then
    locFolderNumber = 0
  Else
    locFolderCounter = 0
    findFolderNumber2 objTopPublicFolder, inFolderID
  End If
  findPFolderNumber = locFolderNumber

End Function

Sub findTopPublicFolder

  Dim locObjInfoStores, locObjInfoStore, locStrRootID

  Set locObjInfoStores = objSession.InfoStores
  For Each locObjInfoStore In locObjInfoStores
    Err.Clear
    locStrRootID = locObjInfoStore.Fields(&H66310102).Value
    If Err.Number = 0 Then

      ' Get root folder
      Set objTopPublicFolder = objSession.GetFolder(locStrRootID, locObjInfoStore.ID)
      Exit For
    End If
  Next
  Set locObjInfoStores = Nothing

End Sub

Sub getAccess(inObject)

  If Not(inObject Is Nothing) Then
    locLngObjectACL = inObject.Fields(&H0FF40003) ' CdoPR_ACCESS
    blnCanRead = (locLngObjectACL And &H00000002) <> 0 ' MAPI_ACCESS_READ
    blnCanModifyObject = (locLngObjectACL And &H00000001) <> 0 ' MAPI_ACCESS_MODIFY
    If inObject.Class = 2 Then
      If SHOWERRORS Then On Error Resume Next
      locD = inObject.Messages.Count
      locErrorCode = Err.Number
      If SHOWERRORS Then On Error Goto 0
      blnCanReadMessages = False : If locErrorCode = 0 Then blnCanReadMessages = True
      If SHOWERRORS Then On Error Resume Next
      locD = inObject.Folders.Count
      locErrorCode = Err.Number
      If SHOWERRORS Then On Error Goto 0
      blnCanReadFolders = False : If locErrorCode = 0 Then blnCanReadFolders = True
      blnCanCreateInFolder = (locLngObjectACL And &H00000010) <> 0 ' MAPI_ACCESS_CREATE_CONTENTS
    Else
      locLngObjectACL = objSession.GetFolder(inObject.folderID).Fields(&H0FF40003)
      blnCanCreateInFolder = (locLngObjectACL And &H00000010) <> 0
    End If
  End If

End Sub

Function getMessage(inMessageID)

  Dim locObjMessage, locObjMessage2

  On Error Resume Next

  Set locObjMessage = objSession.GetMessage(inMessageID)
  If locObjMessage Is Nothing Then
    For Each locObjInfoStore In objSession.InfoStores
      Set locObjMessage = objSession.GetMessage(inMessageID, locObjInfoStore.ID)
      If Not(locObjMessage Is Nothing) Then Exit For
    Next
  End If

  getAccess(locObjMessage)

  Set getMessage = locObjMessage

End Function

Function getMessageRecipient(inMessage)

  If USERENDERER Then
    objRenderer.DataSource = inMessage
    getMessageRecipient = objRenderer.RenderProperty(&H0E04001E, 0)
  Else
    getMessageRecipient = inMessage.Fields(&H0E04001E)
  End If

End Function

Function getMessageSender(inMessage)

  If USERENDERER Then
    objRenderer.DataSource = inMessage
    getMessageSender = objRenderer.RenderProperty(&H0C1A001E, 0)
  Else

    ' Message may have no visible sender
    If SHOWERRORS Then On Error Resume Next
    getMessageSender = inMessage.Fields(&H0C1A001E)
    If SHOWERRORS Then On Error Goto 0
  End If

End Function

Function getMessageText(inMessage)

  Dim strLocMessageText, strLocMessageText2, blnLocAddChar, intLocX, intLocN, chrLocT

  On Error Resume Next

  Err.Clear
  strLocMessageText = inMessage.Text
  If Err.Number <> 0 And USERENDERER Then
    objRenderer.DataSource = inMessage
    strLocMessageText2 = objRenderer.RenderProperty(&H10090102, 0)
    blnLocAddChar = True
    intLocX = Len(strLocMessageText2)
    For intLocN = 1 To intLocX
      chrLocT = Mid(strLocMessageText2, intLocN, 1)
      If chrLocT = "<" Then
        blnLocAddChar = False
      ElseIf chrLocT = ">" Then
        blnLocAddChar = True
      Else
        If blnLocAddChar Then
          strLocMessageText = strLocMessageText & chrLocT
        End If
      End If
    Next
    strLocMessageText = Replace(strLocMessageText, "&nbsp;", " ")
    strLocMessageText = Replace(strLocMessageText, "&lt;", "<")
    strLocMessageText = Replace(strLocMessageText, "&gt;", ">")
    strLocMessageText = Replace(strLocMessageText, "&quot;", """")
  End If
  getMessageText = strLocMessageText

End Function

Function getMessageTimeSent(inMessage)

  If USERENDERER Then
    objRenderer.DataSource = inMessage
    getMessageTimeSent = objRenderer.RenderProperty(&H00390040, 0)
  Else
    getMessageTimeSent = inMessage.Fields(&H00390040)
  End If

End Function

Sub getQueryParams

  mb = Request.QueryString("mb")
  If mb = "" Then mb = Request.Form("mb")
  fn = Request.QueryString("fn")
  If fn = "" Then fn = Request.Form("fn")
  mn = Int(Request.QueryString("mn"))
  If mn = "" Then mn = Request.Form("mn")
  If mn = 0 Then mn = 1
  pg = Request.QueryString("pg")
  If pg = "" Then pg = Request.Form("pg")
  If Int(pg) < 1 Then pg = 1
  mi = Request.QueryString("mi")
  If mi = "" Then mi = Request.Form("mi")
  mt = Request.QueryString("mt")
  If mt = "" Then mt = Request.Form("mt")
  If Int(mt) < 1 Then mt = 1
  re = Request.QueryString("re")
  ry = Request.QueryString("ry")
  If ry = "" Then ry = Request.Form("ry")
  If Int(ry) = 0 Then ry = 1
  rt = Request.QueryString("rt")
  rc = Request.QueryString("rc")
  rb = Request.QueryString("rb")
  mdy = Request.QueryString("mdy")
  If mdy = "" Then mdy = Request.Form("mdy")
  mp = Request.QueryString("mp")
  If mp = "" Then mp = Request.Form("mp")
  st = Request.QueryString("st")
  If st = "" Then st = Request.Form("st")

  If fn <> "" Then fn = expandID(fn)
  If IsNumeric(fn) Then fn = CInt(fn)
  If fn = "" Then fn = 0

  If mi <> "" Then mi = expandID(mi)

End Sub

Function getTimeZoneOffset

  timeZones = Array(24, 19, 14, 46, 38, 7, 9, _
   29, 26, 22, 45, 4, 35, 23, 18, 32, 49, _
   33, 11, 44, 10, 5, 39, 40, 1, 43, 50, _
   15, 42, 21, 34, 47, 27, 48, 2, 41, 52, _
   37, 30, 16, 31, 51, 12, 28, 0, 13, 3, _
   6, 8, 36, 25, 20, 16385, 17)

  offsets = Array(4, 9.5, -9, 6, -7, 2, -4, _
   -1, 3, 7, 8, 1, -5, 5.5, 10, -3, 2, _
   -4, -6, 9.5, -5, 2, -12, 12, 0, 10, 2, _
   -10, 10, 8, -5, 5, 2, 4.5, 0, 11, 0, _
   -6, -2, -11, 0, 3, -7, -3.5, 12, -8, 1, _
   1, -3, -6, 3.5, 9, 0, 12)

  locT = objSession.GetOption("TimeZone")
  locT = locT And Not(&H00004000)

  For locN = 0 To UBound(timeZones) - 1
    If locT = timeZones(locN) Then
      locT2 = offsets(locN)
      Exit For
    End If
  Next

  getTimeZoneOffset = locT2

End Function

Sub login

  Dim lstrProfile, lobjFolder

  Set objSession = Server.CreateObject("MAPI.Session")
  lstrProfile = SERVERNAME & vbLf & mb
  objSession.Logon "", "", False, True, 0, True, lstrProfile
  On Error Resume Next
  Err.Clear
  Set lobjFolder = objSession.Inbox
  errorCode = Err.Number
  If errorCode <> 0 Then
    rwbc UNABLETOOPENMAILBOXTEXT & COLONSPACETEXT & mb
    rwbc ERRORTEXT & COLONSPACETEXT & Err.Description
    rwbc EXCHANGESERVERNAMETEXT & COLONSPACETEXT & SERVERNAME
    rwbc USERNAMETEXT & COLONSPACETEXT & Request.ServerVariables("LOGON_USER")
  End If
  On Error Goto 0
  Set lobjFolder = Nothing

  ' Check if HTTP protocol is disabled for the current mailbox
  On Error Resume Next
  blnHTTPDisabled = False
  protocols = objSession.CurrentUser.Fields(&H81B6101F)
  For Each strProtocol in protocols
    If Instr(1, strProtocol, "HTTP", vbTextCompare) Then
      If "0" = Mid(strProtocol, 6, 1) Then blnHTTPDisabled = True
      Exit For
    End If
  Next
  On Error Goto 0
  If blnHTTPDisabled Then
    rwbc HTTPDISABLEDFORMAILBOXTEXT

    ' Bypass the remaining page output
    errorCode = 1
  End If

  If USERENDERER Then
    Set objRenderApplication = Application("RenderingApplication")
    Set objRenderer = objRenderApplication.CreateRenderer(2)
  End If

End Sub

Sub loginE2K

  Set info = createobject("adsysteminfo")
  Set infoNT = CreateObject("WinNTSystemInfo")
  strMailboxURL = "http://" & lcase(infoNT.ComputerName) & "." & Info.domaindnsname & "/exchange/" & mb
  strMailboxFileURL = "file://./backofficestorage/" & Info.domaindnsname & "/MBX/" & mb
  strPublicFileURL = "file://./backofficestorage/" & Info.domaindnsname & "/PUBLIC FOLDERS"
  Set info = Nothing : Set infoNT = Nothing

  Set conn = CreateObject("ADODB.Connection")
  Set rec = CreateObject("ADODB.Record")
  conn.Provider =  "ExOLEDB.DataSource"
  conn.Open strMailboxURL
  rec.Open strMailboxURL, conn
  strInboxURL = Rec.Fields("urn:schemas:httpmail:inbox")
  strSentItemsURL = Rec.Fields("urn:schemas:httpmail:sentitems")
  strDeletedItemsURL = Rec.Fields("urn:schemas:httpmail:deleteditems")
  strContactsURL = Rec.Fields("urn:schemas:httpmail:contacts")
  strContacts = Right(strContactsURL, Len(strContactsURL) - InstrRev(strContactsURL, "/"))
  strContactsFileURL = strMailboxFileURL & "/" & strContacts
   
  rec.Close : Set rec = Nothing
  conn.Close : Set conn = Nothing

End Sub

Sub logoff

  If USERENDERER Then
    Set objRenderApplication = Nothing
    Set objRenderer = Nothing
  End If

  objSession.Logoff
  Set objSession = Nothing

End Sub

Sub rw(inText)

  Response.Write inText

End Sub

Sub rwbc(inText)

  rwc inText & "<br/>"

End Sub

Sub rwc(inText)

  rw inText & vbCrLf

End Sub

Function validDate(inDay, inMonth, inYear)

  Dim lBlnValid

  lBlnValid = True
  Select Case inMonth
    Case 4, 6, 9, 11
      If inDay > 30 Then lBlnValid = False
    Case 1, 3, 5, 7, 8, 10, 12
      If inDay > 31 Then lBlnValid = False
    Case 2
      If inYear/4 = Int(inYear / 4) Then
        If inDay > 29 Then lBlnValid = False
      Else
        If inDay > 28 Then lBlnValid = False
      End If
  End Select
  validDate = lBlnValid

End Function

Sub writeLink(inTarget, inTitle, inFlags)

  Dim lfn, lmi

  If fn <> "" Then lfn = fn : lfn = compressID(lfn)
  If mi <> "" Then lmi = mi : lmi = compressID(lmi)

  rw "<a href='" & inTarget
  rw "?mb=" & Server.URLEncode(mb)
  If inFlags And OPWFN Then rw AMPCHARS & "fn=" & Server.URLEncode(lfn)
  If inFlags And OPWMN Then rw AMPCHARS & "mn=" & Server.URLEncode(mn)
  If inFlags And OPWMI Then rw AMPCHARS & "mi=" & Server.URLEncode(lmi)
  If inFlags And OPWMT Then rw AMPCHARS & "mt=" & Server.URLEncode(mt)
  If inFlags And OPWRE Then rw AMPCHARS & "re=" & Server.URLEncode(re)
  If inFlags And OPWRY Then rw AMPCHARS & "ry=" & Server.URLEncode(ry)
  If inFlags And OPWRT Then rw AMPCHARS & "rt=" & Server.URLEncode(rt)
  If inFlags And OPWRC Then rw AMPCHARS & "rc=" & Server.URLEncode(rc)
  If inFlags And OPWRB Then rw AMPCHARS & "rb=" & Server.URLEncode(rb)
  If inFlags And OPWMDY Then rw AMPCHARS & "mdy=" & Server.URLEncode(mdy)
  If inFlags And OPWHM Then rw AMPCHARS & "hm=" & Server.URLEncode(hm)
  If inFlags And OPWPG Then rw AMPCHARS & "pg=" & Server.URLEncode(pg)
  If inFlags And OPWMP Then rw AMPCHARS & "mp=" & Server.URLEncode(mp)
  If inFlags And OPWST Then rw AMPCHARS & "st=" & Server.URLEncode(st)
  If inFlags And OPWDFILTER Then rw AMPCHARS & "filter=$(filter)"
  If RANDOMURLPARAM Then
    Randomize
    rw AMPCHARS & "r=" & Int(100000 * Rnd)
  End If
  rw "'>"
  rw displayEncode(inTitle)
  rw "</a>"
  If Not noLineBreaks Then
    rwbc ""
  Else
    rwc " "
  End If

End Sub

Sub writeMailboxLink

  writeLink "MBX.asp", BACKTOMAILBOXTEXT, 0

End Sub

Sub writePageEnd

  rwc "</p>" & vbCrLf & "</card>" & vbCrLf & "</wml>"

End Sub

Sub writePageStart(inTitle)

  Response.ContentType = "text/vnd.wap.wml"
  Response.Buffer = True
  Response.AddHeader "Cache-control", "no-cache, must-revalidate"
  rwc "<?xml version='1.0'?>"
  rwc "<!DOCTYPE wml PUBLIC '-//WAPFORUM//DTD WML 1.1//EN' 'http://www.wapforum.org/DTD/wml_1_1.xml'>"
  rwc "<wml>"
  rwc "<card title='" & inTitle & "' newcontext='true'>"
  If centred Then
    rwc "<p align='center'>"
  Else
    rwc "<p>"
  End If

End Sub

Sub writePostfields

  Dim lfn, lmi

  If fn <> "" Then lfn = fn : lfn = compressID(lfn)
  If mi <> "" Then lmi = mi : lmi = compressID(lmi)

  rwc "<postfield name='mb' value='" & mb & "'/>"
  If lfn <> "" Then rwc "<postfield name='fn' value='" & lfn & "'/>"
  If lmi <> "" Then rwc "<postfield name='mi' value='" & lmi & "'/>"
  If st <> "" Then rwc "<postfield name='st' value='" & st & "'/>"
  If Int(mt) > 1 Then rwc "<postfield name='mt' value='" & mt & "'/>"

End Sub

Sub writeTitle(title)

 rwbc title

End Sub

Sub writeUnderline

 rwbc "---------------"

End Sub
%>
