CREATE TABLE Cust(
       Customer_ID  INT PRIMARY KEY,
       Company_Name VARCHAR2(20),
       City         VARCHAR2(20),
       Created_Date DATE NOT NULL)

CREATE TABLE Cust_Order(        
       Order_ID     INT PRIMARY KEY,
       Created_Date DATE NOT NULL, 
       Customer_ID,
       CONSTRAINT Customer_ID_FK FOREIGN KEY(Customer_ID) REFERENCES Cust(Customer_ID))

CREATE TABLE Product (
       Product_ID   INT PRIMARY KEY,
       Product_Name VARCHAR2(20),
       Created_Date DATE NOT NULL)

CREATE TABLE Order_Detail (
       Order_Type   VARCHAR2(20),
       Order_ID,
       Product_ID,
       CONSTRAINT OrderID_FK FOREIGN KEY(Order_ID) REFERENCES Cust_Order(Order_ID),
       CONSTRAINT ProductID_FK FOREIGN KEY(Product_ID) REFERENCES Product(Product_ID),
       CONSTRAINT OD_key PRIMARY KEY (Order_ID, Product_ID))
