/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.xerces.dom3.ls.DOMEntityResolver;
import org.apache.xerces.dom3.ls.DOMInputSource;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;

public class DOMEntityResolverWrapper
implements XMLEntityResolver {
    protected DOMEntityResolver fEntityResolver;

    public DOMEntityResolverWrapper() {
    }

    public DOMEntityResolverWrapper(DOMEntityResolver entityResolver) {
        this.setEntityResolver(entityResolver);
    }

    public void setEntityResolver(DOMEntityResolver entityResolver) {
        this.fEntityResolver = entityResolver;
    }

    public DOMEntityResolver getEntityResolver() {
        return this.fEntityResolver;
    }

    public XMLInputSource resolveEntity(XMLResourceIdentifier resourceIdentifier) throws XNIException, IOException {
        if (this.fEntityResolver != null) {
            try {
                DOMInputSource inputSource;
                DOMInputSource dOMInputSource = inputSource = resourceIdentifier == null ? this.fEntityResolver.resolveEntity(null, null, null) : this.fEntityResolver.resolveEntity(resourceIdentifier.getPublicId(), resourceIdentifier.getLiteralSystemId(), resourceIdentifier.getBaseSystemId());
                if (inputSource != null) {
                    String publicId = inputSource.getPublicId();
                    String systemId = inputSource.getSystemId();
                    String baseSystemId = inputSource.getBaseURI();
                    InputStream byteStream = inputSource.getByteStream();
                    Reader charStream = inputSource.getCharacterStream();
                    String encoding = inputSource.getEncoding();
                    XMLInputSource xmlInputSource = new XMLInputSource(publicId, systemId, baseSystemId);
                    xmlInputSource.setByteStream(byteStream);
                    xmlInputSource.setCharacterStream(charStream);
                    xmlInputSource.setEncoding(encoding);
                    return xmlInputSource;
                }
            }
            catch (Exception e) {
                throw new XNIException(e);
            }
        }
        return null;
    }
}

