#include "stdafx.h"
#include "sgRegExp.h"
#include "RegExp.h"

#pragma warning(disable:4310) // cast truncates constant value

#define ERROR_BASE 0x80004000


sgRegExp::sgRegExp()
{
	m_bCase  = false;
	m_RegExp = 0;
}

sgRegExp::~sgRegExp()
{
	delete m_RegExp;
}


//---------------------------------------------------------------------------------------
// ISupportsErrorInfo interface
//---------------------------------------------------------------------------------------
STDMETHODIMP sgRegExp::InterfaceSupportsErrorInfo(REFIID riid)
{
	static const IID* arr[] = 
	{
		&IID_IsgRegExp,
	};
	for (int i=0;i<sizeof(arr)/sizeof(arr[0]);i++)
	{
		if (InlineIsEqualGUID(*arr[i],riid))
			return S_OK;
	}
	return S_FALSE;
}

//---------------------------------------------------------------------------------------
// IsgRegExp interface
//---------------------------------------------------------------------------------------
STDMETHODIMP sgRegExp::put_Expression(/*[in]*/ BSTR expr)
{
	bstr_t bstr(expr, true);
	m_sRegExpr = (LPCTSTR)bstr;

	delete m_RegExp;
	m_RegExp = 0;
	m_RegExp = new Regexp(m_sRegExpr.c_str(), m_bCase);

	if (m_RegExp == 0)
		return E_OUTOFMEMORY;
	else
		return S_OK;
}

STDMETHODIMP sgRegExp::get_Expression(/*[out, retval]*/ BSTR* expr)
{
	if (expr == 0)
		return E_POINTER;

	bstr_t bstr(m_sRegExpr.c_str());
	*expr = bstr.copy();
	return S_OK;
}

STDMETHODIMP sgRegExp::put_IgnoreCase(/*[in]*/ VARIANT_BOOL ignoreCase)
{
	m_bCase = (ignoreCase == VARIANT_TRUE) ? true : false;

	if (!m_sRegExpr.empty())
	{
		delete m_RegExp;
		m_RegExp = 0;
		m_RegExp = new Regexp(m_sRegExpr.c_str(), m_bCase);
	}

	if (m_RegExp == 0)
		return E_OUTOFMEMORY;
	else
		return S_OK;
}

STDMETHODIMP sgRegExp::get_IgnoreCase(/*[out, retval]*/ VARIANT_BOOL* ignoreCase)
{
	if (ignoreCase == 0)
		return E_POINTER;

	*ignoreCase = m_bCase ? VARIANT_TRUE : VARIANT_FALSE;
	return S_OK;
}

STDMETHODIMP sgRegExp::Match(/*[in]*/ BSTR data, /*[in, optional, defaultvalue(-1)]*/ VARIANT startPos, /*[out, retval]*/ VARIANT_BOOL* res)
{
	if (res == 0)
		return E_POINTER;
	if (m_RegExp == 0)
		return AtlReportError(CLSID_RegExp, IDS_ERR_NOREGEXP, GUID_NULL, ERROR_BASE+IDS_ERR_NOREGEXP);

	*res = VARIANT_FALSE;

	bstr_t bstr(data, true);
	m_sData = (LPCTSTR)bstr;

	// Get matching start position
	long lStartPos = 0;
	if (startPos.vt != VT_I4)
	{
		HRESULT hr = ::VariantChangeType(&startPos, &startPos, 0, VT_I4);
		if (FAILED(hr))
			return AtlReportError(CLSID_RegExp, IDS_ERR_INVALIDSTARTPOS, GUID_NULL, ERROR_BASE+IDS_ERR_NOREGEXP);
	}
	lStartPos = startPos.lVal-1;
	if (lStartPos < 0)
		lStartPos = 0;

	*res = m_RegExp->Match(m_sData.c_str(), lStartPos) ? VARIANT_TRUE : VARIANT_FALSE;
	if (!m_RegExp->CompiledOK())
		return AtlReportError(CLSID_RegExp, m_RegExp->GetErrorString().c_str(), GUID_NULL, ERROR_BASE + m_RegExp->GetErrorNumber());

	return S_OK;
}

STDMETHODIMP sgRegExp::get_ReplaceString(/*[in]*/ BSTR source, /*[out, retval]*/ BSTR* res)
{
	if (res == 0)
		return E_POINTER;
	if (m_RegExp == 0)
		return AtlReportError(CLSID_RegExp, IDS_ERR_NOREGEXP, GUID_NULL, ERROR_BASE+IDS_ERR_NOREGEXP);

	bstr_t bstr(source, true);
	str_t sSource = (LPCTSTR)bstr;

	bstr_t bstrRes(m_RegExp->GetReplaceString(sSource.c_str()).c_str());
	*res = bstrRes.copy();

	return S_OK;
}

STDMETHODIMP sgRegExp::get_CompiledOK(/*[out, retval]*/ VARIANT_BOOL* res)
{
	if (res == 0)
		return E_POINTER;
	if (m_RegExp == 0)
		return AtlReportError(CLSID_RegExp, IDS_ERR_NOREGEXP, GUID_NULL, ERROR_BASE+IDS_ERR_NOREGEXP);

	*res = m_RegExp->CompiledOK() ? VARIANT_TRUE : VARIANT_FALSE;
	return S_OK;
}

STDMETHODIMP sgRegExp::get_Substrings(/*[out, retval]*/ ISubstrings** res)
{
	if (res == 0)
		return E_POINTER;
	if (m_RegExp == 0)
		return AtlReportError(CLSID_RegExp, IDS_ERR_NOREGEXP, GUID_NULL, ERROR_BASE+IDS_ERR_NOREGEXP);

	CComObject<Substrings>* subs;
	HRESULT hr = CComObject<Substrings>::CreateInstance(&subs);
	if(FAILED(hr))
		return AtlReportError(CLSID_RegExp, IDS_ERR_SUBSTRINGS_FAILED, GUID_NULL, hr);
	subs->AddRef();
	hr = subs->Init(*m_RegExp);
	if(FAILED(hr))
		return AtlReportError(CLSID_RegExp, IDS_ERR_SUBSTRINGS_FAILED, GUID_NULL, hr);

	*res = subs;
	return S_OK;
}


