/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jb.util;

import com.borland.jb.util.ChainedException;
import java.io.PrintStream;
import java.io.Serializable;

public class ExceptionChain
implements Serializable {
    private Throwable ex;
    private ExceptionChain next;

    public static String getOriginalMessage(Throwable ex) {
        ExceptionChain chain;
        while (ex instanceof ChainedException && (chain = ((ChainedException)((Object)ex)).getExceptionChain()) != null) {
            while (chain.getNext() != null) {
                chain = chain.getNext();
            }
            ex = chain.getException();
        }
        String message = ex.getMessage();
        if (message == null || message.length() == 0 || ex instanceof ArrayIndexOutOfBoundsException) {
            String name = ex.getClass().getName();
            message = message == null ? name : String.valueOf(new StringBuffer(String.valueOf(name)).append(" ").append(message));
        }
        return message;
    }

    public Throwable getException() {
        return this.ex;
    }

    public ExceptionChain getNext() {
        return this.next;
    }

    public boolean hasExceptions() {
        return this.ex != null;
    }

    private void printStackTrace(ExceptionChain exChain, PrintStream out) {
        if (exChain != null && exChain.next != null) {
            exChain.printStackTrace(exChain.next, out);
        }
        if (this.ex != null) {
            this.ex.printStackTrace(out);
        }
    }

    public void printDiagnosticStackTrace() {
        if (this.next != null) {
            this.next.printDiagnosticStackTrace();
        }
        if (this.ex != null) {
            // empty if block
        }
    }

    public void printStackTrace(PrintStream out) {
        this.printStackTrace(this, out);
    }

    public void append(Throwable ex) {
        if (this.ex == null) {
            this.ex = ex;
        } else {
            this.next = new ExceptionChain(this.next, ex);
        }
    }

    private ExceptionChain(ExceptionChain next, Throwable ex) {
        this.next = next;
        this.ex = ex;
    }

    public ExceptionChain() {
    }
}

