Attribute VB_Name = "Module3"

'FILE: dxcallp.bas

Global Const DX_CALLP = 1               ' Turn on Call Analysis

'Defines for Call Analysis modes ( ca_intflg field )
 
Global Const DX_OPTEN = 1               ' Enable Operator Intercept with Connect
Global Const DX_OPTDIS = 2              ' Disable Operator Intercept
Global Const DX_OPTNOCON = 3            ' Enable Operator Intercept w/o Connect
Global Const DX_PVDENABLE = 4           ' Enable PVD
Global Const DX_PVDOPTEN = 5            ' Enable PVD with OPTEN
Global Const DX_PVDOPTNOCON = 6         ' Enable PVD with OPTNOCON
Global Const DX_PAMDENABLE = 7          ' Enable PAMD
Global Const DX_PAMDOPTEN = 8           ' Enable PAMD with OPTEN

'Call Analysis termination type.
 
Global Const CR_BUSY = 7                     ' Line busy
Global Const CR_NOANS = 8                    ' No answer
Global Const CR_NORB = 9                     ' No ringback
Global Const CR_CNCT = 10                    ' Call connected
Global Const CR_CEPT = 11                    ' Operator intercept
Global Const CR_STOPD = 12                   ' Call analysis stopped
Global Const CR_NODIALTONE = 17              ' No dialtone detected
Global Const CR_FAXTONE = 18                 ' Fax tone detected
Global Const CR_ERROR = &H100                ' Call analysis error

'Tone ID types
 
Global Const TID_FIRST = 250
Global Const TID_DIAL_LCL = 250
Global Const TID_DIAL_INTL = 251
Global Const TID_DIAL_XTRA = 252
Global Const TID_BUSY1 = 253
Global Const TID_RNGBK1 = 254
Global Const TID_BUSY2 = 255
Global Const TID_RNGBK2 = 256
Global Const TID_DISCONNECT = 257
Global Const TID_FAX1 = 258
Global Const TID_FAX2 = 259
Global Const TID_LAST = 259

'Call Analysis Errors as returned by ATDX_CPERROR()
 
Global Const CR_MEMERR = 1             ' Out of Memory when Creating Temporary SIT Tone Templates
Global Const CR_TMOUTON = 2            ' Timeout Waiting for SIT Tone
Global Const CR_TMOUTOFF = 3           ' SIT Tone too long
Global Const CR_UNEXPTN = 4            ' Unexpected SIT Tone
Global Const CR_MXFRQERR = 5           ' Invalid ca_maxtimefrq field in DX_CAP
Global Const CR_UPFRQERR = 6           ' Invalid Upper Frequency Selection
Global Const CR_LGTUERR = 7            ' Lower Freq. Greater than Upper Freq.
Global Const CR_OVRLPERR = 8           ' Overlap in Selected SIT Tones

'Connection types ( ATDX_CONNTYPE() )
 
Global Const CON_CAD = 1               ' Cadence Break
Global Const CON_LPC = 2               ' Loop Current Drop
Global Const CON_PVD = 3               ' Positive Voice Detect
Global Const CON_PAMD = 4              ' Positive Answering Machine Detect

'PAMD equates
 
Global Const PAMD_FULL = 1             ' FULL decision on PAMD
Global Const PAMD_QUICK = 2            ' QUICK decision on PAMD
Global Const PAMD_ACCU = 3             ' ACCURACY more important than speed (recommended)

Global Const PAMD_QUAL1TMP = 11 ' Qualification template 1 for PAMD
Global Const PAMD_QUAL2TMP = 12 ' Qualification template 1 for PAMD

' Call Analysis Parameter Values

Global Const CA_nbrdna = 0                 ' # of rings before no answer.
Global Const CA_stdely = 1                 ' Delay after dialing before analysis.
Global Const CA_cnosig = 2                 ' Duration of no signal time out delay.
Global Const CA_lcdly = 3                  ' Delay after dial before lc drop connect
Global Const CA_lcdly1 = 4                 ' Delay after lc drop con. before msg.
Global Const CA_hedge = 5                  ' Edge of answer to send connect message.
Global Const CA_cnosil = 6                 ' Initial continuous noise timeout delay.
Global Const CA_lo1tola = 7                ' % acceptable pos. dev of short low sig.
Global Const CA_lo1tolb = 8                ' % acceptable neg. dev of short low sig.
Global Const CA_lo2tola = 9                ' % acceptable pos. dev of long low sig.
Global Const CA_lo2tolb = 10               ' % acceptable neg. dev of long low sig.
Global Const CA_hi1tola = 11               ' % acceptable pos. dev of high signal.
Global Const CA_hi1tolb = 12               ' % acceptable neg. dev of high signal.
Global Const CA_lo1bmax = 13               ' Maximum interval for shrt low for busy.
Global Const CA_lo2bmax = 14               ' Maximum interval for long low for busy.
Global Const CA_hi1bmax = 15               ' Maximum interval for 1st high for busy
Global Const CA_nsbusy = 16                ' Num. of highs after nbrdna busy check.
Global Const CA_logltch = 17               ' Silence deglitch duration.
Global Const CA_higltch = 18               ' Non-silence deglitch duration.
Global Const CA_lo1rmax = 19               ' Max. short low  dur. of double ring.
Global Const CA_lo2rmin = 20               ' Min. long low  dur. of double ring.
Global Const CA_intflg = 21                ' Operator intercept mode.
Global Const CA_intfltr = 22               ' Minimum signal to qualify freq. detect.
Global Const CA_rfu1 = 23                       ' reserved for future use
Global Const CA_rfu2 = 24                       ' reserved for future use
Global Const CA_rfu3 = 25                       ' reserved for future use
Global Const CA_rfu4 = 26                       ' reserved for future use
Global Const CA_hisiz = 27                 ' Used to determine which lowmax to use.
Global Const CA_alowmax = 28               ' Max. low before con. if high >hisize.
Global Const CA_blowmax = 29               ' Max. low before con. if high <hisize.
Global Const CA_nbrbeg = 30                ' Number of rings before analysis begins.
Global Const CA_hi1ceil = 31               ' Maximum 2nd high dur. for a retrain.
Global Const CA_lo1ceil = 32               ' Maximum 1st low dur. for a retrain.
Global Const CA_lowerfrq = 33              ' Lower allowable frequency in hz.
Global Const CA_upperfrq = 34              ' Upper allowable frequency in hz.
Global Const CA_timefrq = 35               ' Total duration of good signal required.
Global Const CA_rejctfrq = 36              ' Allowable % of bad signal.
Global Const CA_maxansr = 37               ' Maximum duration of answer.
Global Const CA_ansrdgl = 38               ' Silence deglitching value for answer.
Global Const CA_mxtimefrq = 39             ' max time for 1st freq to remain in bounds
Global Const CA_lower2frq = 40             ' lower bound for second frequency
Global Const CA_upper2frq = 41             ' upper bound for second frequency
Global Const CA_time2frq = 42              ' min time for 2nd freq to remains in bounds
Global Const CA_mxtime2frq = 43            ' max time for 2nd freq to remain in bounds
Global Const CA_lower3frq = 44             ' lower bound for third frequency
Global Const CA_upper3frq = 45             ' upper bound for third frequency
Global Const CA_time3frq = 46              ' min time for 3rd freq to remains in bounds
Global Const CA_mxtime3frq = 47            ' max time for 3rd freq to remain in bounds
Global Const CA_dtn_pres = 48              ' Length of a valid dial tone (def=1sec)
Global Const CA_dtn_npres = 49             ' Max time to wait for dial tone (def=3sec)
Global Const CA_dtn_deboff = 50            ' The dialtone off debouncer (def=100ms)
Global Const CA_pamd_failtime = 51         ' Wait for AMD/PVD after cadence break(default=4sec)
Global Const CA_pamd_minring = 52          ' min allowable ring duration (def=1.9sec)
Global Const CA_pamd_spdval = 53           ' char Set to 2 selects quick decision (def=1)
Global Const CA_pamd_qtemp = 54            ' char The Qualification template to use for PAMD
Global Const CA_noanswer = 55              ' time before no answer after first ring (default=30sec)
Global Const CA_maxintering = 56           ' Max inter ring delay before connect (8 sec)





