/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;

public class gRichText
extends ScrollPane {
    protected RealChatClient applet;
    public static gRichTextCanvas theRichText;
    public static final char CR = '\n';
    public static final char PLAIN = '0';
    public static final char BOLD = '1';
    public static final char ITALIC = '2';
    public static final char BOLDITALIC = '3';
    public static final char BLACK = '4';
    public static final char GRAY = '5';
    public static final char RED = '6';
    public static final char GREEN = '7';
    public static final char BLUE = '8';
    public static final char CYAN = '9';
    public static final char MAGENTA = 'a';
    public static final char PURPLE = 'b';
    public static final char ORANGE = 'c';
    public static final char BROWN = 'd';
    public static final char LBLUE = 'e';
    public static final char LRED = 'f';
    public static final char LGRAY = 'g';
    static Cursor cHand;
    static Cursor cArrow;

    gRichText(RealChatClient realChatClient) {
        super(0);
        this.applet = realChatClient;
        theRichText = new gRichTextCanvas(this, 1200, 2500, RealChatClient.chatFont);
        this.add(theRichText);
        CListener cListener = new CListener();
        this.addComponentListener(cListener);
        this.doLayout();
    }

    public void cleanUp() {
        theRichText.cleanUp();
    }

    public void append(String string) {
        if (theRichText != null) {
            theRichText.append(string);
        }
    }

    public void clear() {
        if (theRichText != null) {
            theRichText.clear();
        }
    }

    public void setFont(Font font) {
        if (theRichText != null) {
            theRichText.setFont(font);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (theRichText != null) {
            gRichText.theRichText.bgColor = color;
        }
    }

    public Font getFont() {
        if (theRichText != null) {
            return gRichText.theRichText.plain;
        }
        return super.getFont();
    }

    public void setStyles(boolean bl) {
        if (theRichText != null) {
            gRichText.theRichText.showStyles = bl;
        }
    }

    public void setColors(boolean bl) {
        if (theRichText != null) {
            gRichText.theRichText.showColors = bl;
        }
    }

    public void setSmiles(boolean bl) {
        if (theRichText != null) {
            gRichText.theRichText.showSmiles = bl;
        }
    }

    public boolean stylesShowing() {
        return gRichText.theRichText.showStyles;
    }

    public boolean colorsShowing() {
        return gRichText.theRichText.showColors;
    }

    public boolean smilesShowing() {
        return gRichText.theRichText.showSmiles;
    }

    static {
        cHand = new Cursor(12);
        cArrow = new Cursor(0);
    }

    private class gRichTextCanvas
    extends Canvas {
        protected gRichText theScrollPane;
        String lines;
        String last;
        Image buffImage;
        Graphics offscreen;
        Dimension d;
        Insets i;
        Toolkit tk;
        protected Hashtable links;
        boolean initDone = false;
        boolean offDone = false;
        boolean fullRepaint = true;
        boolean showColors = true;
        boolean showStyles = true;
        boolean showSmiles = true;
        protected int x;
        protected int y;
        protected int ch;
        protected int imd;
        protected int bh;
        protected int ty;
        protected int th;
        protected int sw;
        protected int w;
        protected int maxWidth;
        protected int maxHeight;
        public Color bgColor;
        public Color fgColor;
        public Color black = new Color(0, 0, 0);
        public Color gray = new Color(0x808080);
        public Color red = new Color(0xEE5050);
        public Color green = new Color(43520);
        public Color blue = new Color(255);
        public Color cyan = new Color(43741);
        public Color magenta = new Color(0xFF00FF);
        public Color purple = new Color(0x9900FF);
        public Color orange = new Color(0xFF9900);
        public Color brown = new Color(0xAA6600);
        public Color lblue = new Color(0x6666FF);
        public Color lred = new Color(0xEE9999);
        public Color lgray = new Color(0xB0B0B0);
        public Font plain;
        public Font bold;
        public Font italic;
        public Font bolditalic;
        Graphics gr;
        public int maxLines;
        public int bufferSize = 20;
        public int LINES = 1;
        public int TEMPLINES = 0;

        gRichTextCanvas(gRichText gRichText3, int n, int n2, Font font) {
            this.tk = this.getToolkit();
            this.theScrollPane = gRichText3;
            this.maxWidth = n;
            this.maxHeight = n2;
            this.links = new Hashtable();
            this.clear();
            this.setFont(font);
            this.lines = "";
            this.bgColor = gRichText3.getBackground();
            this.fgColor = this.black;
            this.addMouseListener(new MListener());
            this.addMouseMotionListener(new MMListener());
            this.imd = 20;
            if (!gRichText.this.applet.iconsDone) {
                gRichText.this.applet.loadIcons();
            }
            if (!gRichText.this.applet.bigIconsDone) {
                gRichText.this.applet.loadBigIcons();
            }
        }

        public void setFont(Font font) {
            String string = font.getName();
            int n = font.getSize();
            this.plain = new Font(string, 0, n);
            this.bold = new Font(string, 1, n);
            this.italic = new Font(string, 2, n);
            this.bolditalic = new Font(string, 3, n);
            super.setFont(this.plain);
            this.ch = this.plain.getSize() * 14 / 10;
            this.bh = this.plain.getSize() * 4 / 10;
            this.maxLines = this.maxHeight / this.ch;
            this.maxHeight = this.maxLines * this.ch;
            this.clear();
        }

        public void append(String string) {
            if (string == null) {
                return;
            }
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n = 0;
            while (n < string.length()) {
                if (string.charAt(n) == '\n') {
                    ++this.LINES;
                }
                ++n;
            }
            while (this.LINES + this.TEMPLINES > this.bufferSize) {
                String string2;
                int n2 = this.lines.indexOf("\n");
                if (n2 != -1) {
                    try {
                        string2 = this.lines.substring(n2 + 1);
                        --this.LINES;
                    }
                    catch (Exception exception) {
                        string2 = this.lines;
                        this.LINES = 1;
                        this.TEMPLINES = 0;
                    }
                } else {
                    try {
                        string2 = this.lines.substring(string.length() + 1);
                        --this.LINES;
                    }
                    catch (Exception exception) {
                        string2 = this.lines;
                        this.LINES = 1;
                        this.TEMPLINES = 0;
                    }
                }
                this.lines = null;
                this.lines = string2;
            }
            this.last = string;
            this.lines = this.lines + string;
            this.TEMPLINES = 0;
            this.initDone = false;
            this.repaint();
        }

        public void paint(Graphics graphics) {
            if (!this.initDone) {
                this.initpaint(graphics);
            }
            graphics.drawImage(this.buffImage, 0, -(this.maxHeight - this.th), this);
            graphics.drawImage(this.buffImage, 0, this.th, this);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void clear() {
            this.i = gRichText.this.getInsets();
            this.d = this.theScrollPane.getSize();
            this.w = this.d.width = this.d.width - this.i.left - this.i.right;
            this.d.height = this.d.height - this.i.top - this.i.bottom;
            this.initDone = false;
            this.fullRepaint = true;
            this.y = this.ch;
            this.ty = this.ch;
            this.links.clear();
            this.repaint();
        }

        public void cleanUp() {
            this.buffImage = null;
        }

        public void initpaint(Graphics graphics) {
            try {
                if (!this.offDone) {
                    this.buffImage = this.createImage(this.maxWidth, this.maxHeight);
                    this.offscreen = this.buffImage.getGraphics();
                    this.offDone = true;
                    this.y = this.ch;
                    this.ty = this.ch;
                }
                this.x = 3;
                this.offscreen.setColor(this.bgColor);
                if (this.fullRepaint) {
                    this.offscreen.fillRect(0, 0, this.maxWidth, this.maxHeight);
                    this.drawBuffer(this.offscreen, this.lines);
                    this.offscreen.setColor(this.bgColor);
                    this.offscreen.fillRect(0, 0, this.maxWidth, this.ch);
                    this.fullRepaint = false;
                } else {
                    this.offscreen.fillRect(0, this.y - this.ch, this.maxWidth, this.ch * 2);
                    if (this.maxHeight - this.y == this.ch) {
                        this.offscreen.fillRect(0, 0, this.maxWidth, this.ch);
                    }
                    this.drawBuffer(this.offscreen, this.last);
                }
                this.th = this.maxHeight - this.ty % this.maxHeight;
                this.setSize(this.w, this.maxHeight);
                this.theScrollPane.setScrollPosition(0, this.maxHeight);
                this.theScrollPane.doLayout();
                this.initDone = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void drawStr(Graphics graphics, String string) {
            this.sw = graphics.getFontMetrics().stringWidth(string);
            if (this.x + this.sw + this.ch > this.w) {
                this.y += this.ch;
                this.x = 3;
                graphics.setColor(this.bgColor);
                graphics.fillRect(0, this.y - this.ch, this.maxWidth, this.ch * 3);
                ++this.TEMPLINES;
            }
            graphics.setColor(this.fgColor);
            graphics.drawString(string, this.x, this.y - this.bh);
            if (this.y > this.maxHeight) {
                this.y = this.ch;
            }
            this.ty = this.y;
            this.x += this.sw;
        }

        public void drawLn(Graphics graphics) {
            this.y += this.ch;
            this.x = 3;
            graphics.setColor(this.bgColor);
            graphics.fillRect(0, this.y - this.ch, this.maxWidth, this.ch * 3);
            if (this.y > this.maxHeight) {
                this.y = this.ch;
            }
            this.ty = this.y;
        }

        public void drawIcon(Graphics graphics, int n) {
            if (this.x + 28 > this.w) {
                this.y += this.ch;
                this.y += this.ch;
                this.x = 3;
                ++this.TEMPLINES;
            }
            this.x += this.ch;
            graphics.drawImage(gRichText.this.applet.icon[n], this.x - 12, this.y - this.ch + this.bh, this);
            if (this.y > this.maxHeight) {
                this.y = this.ch;
            }
            this.ty = this.y;
        }

        public void drawBigIcon(Graphics graphics, int n) {
            if (this.x + 2 * this.ch > this.w) {
                this.y += this.ch;
                this.y += this.ch;
                this.x = 3;
                ++this.TEMPLINES;
            }
            this.x += this.ch;
            graphics.drawImage(gRichText.this.applet.bigIcon[n], this.x - this.ch, this.y - this.ch - this.bh / 2, this);
            if (this.y > this.maxHeight) {
                this.y = this.ch;
            }
            this.ty = this.y;
        }

        public void drawLink(Graphics graphics, String string) {
            Color color = this.fgColor;
            this.fgColor = this.showColors ? this.blue : this.black;
            this.sw = graphics.getFontMetrics().stringWidth(string);
            graphics.setColor(this.showColors ? this.blue : this.black);
            graphics.drawString(string, this.x, this.y - this.bh);
            graphics.drawLine(this.x, this.y - this.bh + 1, this.x + this.sw, this.y - this.bh + 1);
            this.fgColor = color;
            if (string.startsWith("www.")) {
                string = "http://" + string;
            }
            this.links.put(string, new rLink(string, null, new Rectangle(this.x, this.y - this.ch, this.sw, this.ch)));
            this.x += this.sw;
        }

        public void drawNickLink(Graphics graphics, String string) {
            this.sw = graphics.getFontMetrics().stringWidth(string);
            graphics.setColor(this.fgColor);
            graphics.drawString(string, this.x, this.y - this.bh);
            this.links.put(string, new rLink(null, string, new Rectangle(this.x, this.y - this.ch, this.sw, this.ch)));
            this.x += this.sw;
        }

        public void drawBuffer(Graphics graphics, String string) {
            String string2 = "";
            String string3 = "";
            String string4 = "";
            int n = 0;
            int n2 = 0;
            while (n2 < string.length()) {
                switch (string.charAt(n2)) {
                    case '\n': {
                        this.drawStr(graphics, string2);
                        this.drawLn(graphics);
                        string2 = "";
                        graphics.setFont(this.plain);
                        n = 0;
                        break;
                    }
                    case ' ': {
                        this.drawStr(graphics, string2);
                        string2 = " ";
                        break;
                    }
                    case ',': {
                        this.drawStr(graphics, string2);
                        string2 = ",";
                        break;
                    }
                    case '`': {
                        switch (string.charAt(n2 + 1)) {
                            case '4': {
                                this.drawStr(graphics, string2);
                                this.fgColor = this.showColors ? this.black : this.black;
                                string2 = "";
                                break;
                            }
                            case '5': {
                                this.drawStr(graphics, string2);
                                this.fgColor = this.showColors ? this.gray : this.black;
                                string2 = "";
                                break;
                            }
                            case '6': {
                                Color color;
                                this.drawStr(graphics, string2);
                                if (this.showColors) {
                                    color = this.red;
                                    this.fgColor = this.fgColor;
                                } else {
                                    color = this.black;
                                }
                                this.fgColor = color;
                                string2 = "";
                                break;
                            }
                            case '7': {
                                this.drawStr(graphics, string2);
                                this.fgColor = this.showColors ? this.green : this.black;
                                string2 = "";
                                break;
                            }
                            case '8': {
                                this.drawStr(graphics, string2);
                                this.fgColor = this.showColors ? this.blue : this.black;
                                string2 = "";
                                break;
                            }
                            case '9': {
                                this.drawStr(graphics, string2);
                                this.fgColor = this.showColors ? this.cyan : this.black;
                                string2 = "";
                                break;
                            }
                            case 'a': {
                                this.drawStr(graphics, string2);
                                this.fgColor = this.showColors ? this.magenta : this.black;
                                string2 = "";
                                break;
                            }
                            case 'b': {
                                this.drawStr(graphics, string2);
                                this.fgColor = this.showColors ? this.purple : this.black;
                                string2 = "";
                                break;
                            }
                            case 'c': {
                                this.drawStr(graphics, string2);
                                this.fgColor = this.showColors ? this.orange : this.black;
                                string2 = "";
                                break;
                            }
                            case 'd': {
                                this.drawStr(graphics, string2);
                                this.fgColor = this.showColors ? this.brown : this.black;
                                string2 = "";
                                break;
                            }
                            case 'f': {
                                this.drawStr(graphics, string2);
                                this.fgColor = this.showColors ? this.lred : this.gray;
                                string2 = "";
                                break;
                            }
                            case 'e': {
                                this.drawStr(graphics, string2);
                                this.fgColor = this.showColors ? this.lblue : this.gray;
                                string2 = "";
                                break;
                            }
                            case 'g': {
                                this.drawStr(graphics, string2);
                                this.fgColor = this.showColors ? this.lgray : this.gray;
                                string2 = "";
                                break;
                            }
                            case '0': {
                                this.drawStr(graphics, string2);
                                graphics.setFont(this.showStyles ? this.plain : this.plain);
                                string2 = "";
                                break;
                            }
                            case '1': {
                                this.drawStr(graphics, string2);
                                graphics.setFont(this.showStyles ? this.bold : this.plain);
                                string2 = "";
                                break;
                            }
                            case '2': {
                                this.drawStr(graphics, string2);
                                graphics.setFont(this.showStyles ? this.italic : this.plain);
                                string2 = "";
                                break;
                            }
                            case '3': {
                                this.drawStr(graphics, string2);
                                graphics.setFont(this.showStyles ? this.bolditalic : this.plain);
                                string2 = "";
                                break;
                            }
                            default: {
                                --n2;
                            }
                        }
                        ++n2;
                        break;
                    }
                    case ':': {
                        if (!this.showSmiles || gRichText.this.applet.icon[0] == null) {
                            string2 = string2 + string.charAt(n2);
                            break;
                        }
                        this.drawStr(graphics, string2);
                        string2 = "";
                        while (string.charAt(n2 + 1) == '-') {
                            ++n2;
                        }
                        switch (string.charAt(n2 + 1)) {
                            case 'Y': {
                                this.drawIcon(graphics, 6);
                                break;
                            }
                            case 'R': {
                                this.drawIcon(graphics, 7);
                                break;
                            }
                            case ')': {
                                this.drawIcon(graphics, 0);
                                break;
                            }
                            case ']': {
                                this.drawIcon(graphics, 0);
                                break;
                            }
                            case '(': {
                                this.drawIcon(graphics, 1);
                                break;
                            }
                            case '[': {
                                this.drawIcon(graphics, 1);
                                break;
                            }
                            case 'p': {
                                this.drawIcon(graphics, 2);
                                break;
                            }
                            case 'P': {
                                this.drawIcon(graphics, 2);
                                break;
                            }
                            case '\u0440': {
                                this.drawIcon(graphics, 2);
                                break;
                            }
                            case '\u0420': {
                                this.drawIcon(graphics, 2);
                                break;
                            }
                            case '0': {
                                this.drawIcon(graphics, 3);
                                break;
                            }
                            case 'O': {
                                this.drawIcon(graphics, 3);
                                break;
                            }
                            case 'o': {
                                this.drawIcon(graphics, 3);
                                break;
                            }
                            case '\u041e': {
                                this.drawIcon(graphics, 3);
                                break;
                            }
                            case '\u043e': {
                                this.drawIcon(graphics, 3);
                                break;
                            }
                            case '|': {
                                this.drawIcon(graphics, 5);
                                break;
                            }
                            default: {
                                this.drawStr(graphics, ":");
                                --n2;
                            }
                        }
                        ++n2;
                        break;
                    }
                    case ';': {
                        if (!this.showStyles) {
                            string2 = string2 + string.charAt(n2);
                            break;
                        }
                        this.drawStr(graphics, string2);
                        string2 = "";
                        while (string.charAt(n2 + 1) == '-') {
                            ++n2;
                        }
                        if (string.charAt(n2 + 1) == ')') {
                            this.drawIcon(graphics, 4);
                        } else {
                            this.drawStr(graphics, ";");
                            --n2;
                        }
                        ++n2;
                        break;
                    }
                    default: {
                        int n3;
                        int n4;
                        int n5;
                        string3 = string.substring(n2);
                        if (string3.startsWith("//")) {
                            n5 = string3.indexOf(32);
                            n4 = string3.indexOf(10);
                            int n6 = n3 = n5 != -1 ? n5 : n4;
                            if (n4 != -1 && n4 < n3) {
                                n3 = n4;
                            }
                            if (n3 > 1) {
                                this.drawStr(graphics, string2);
                                string2 = "";
                                if (this.showSmiles && ++n < 4) {
                                    try {
                                        int n7 = Integer.parseInt(string3.substring(2, n3));
                                        this.drawBigIcon(graphics, n7);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                n2 += n3 - 1;
                                break;
                            }
                        }
                        if ((string3 = string.substring(n2)).startsWith("http://") || string3.startsWith("www.") || string3.startsWith("mailto:")) {
                            n5 = string3.indexOf(32);
                            n4 = string3.indexOf(10);
                            int n8 = n3 = n5 != -1 ? n5 : n4;
                            if (n4 != -1 && n4 < n3) {
                                n3 = n4;
                            }
                            if (n3 <= 1) break;
                            this.drawStr(graphics, string2);
                            string2 = "";
                            this.drawLink(graphics, string3.substring(0, n3));
                            n2 += n3 - 1;
                            break;
                        }
                        if (string3.startsWith("_NL_")) {
                            n5 = string3.indexOf(32);
                            n4 = string3.indexOf(58);
                            int n9 = n3 = n5 != -1 ? n5 : n4;
                            if (n4 != -1 && n4 < n3) {
                                n3 = n4;
                            }
                            if (n3 <= 1) break;
                            this.drawStr(graphics, string2);
                            string2 = "";
                            this.drawNickLink(graphics, string3.substring(4, n3));
                            n2 += n3 - 1;
                            break;
                        }
                        string2 = string2 + string.charAt(n2);
                    }
                }
                ++n2;
            }
            this.drawStr(graphics, string2);
        }

        class rLink {
            protected String link;
            protected String nick;
            protected Rectangle rect;

            public rLink(String string, String string2, Rectangle rectangle) {
                this.link = string;
                this.nick = string2;
                this.rect = rectangle;
            }
        }

        class MMListener
        extends MouseMotionAdapter {
            MMListener() {
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                Enumeration enumeration = gRichTextCanvas.this.links.keys();
                mouseEvent.translatePoint(0, -gRichTextCanvas.this.th);
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    rLink rLink2 = (rLink)gRichTextCanvas.this.links.get(string);
                    if (rLink2.rect.contains(mouseEvent.getPoint())) {
                        gRichTextCanvas.this.setCursor(cHand);
                        break;
                    }
                    gRichTextCanvas.this.setCursor(cArrow);
                }
            }
        }

        class MListener
        extends MouseAdapter {
            MListener() {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                Enumeration enumeration = gRichTextCanvas.this.links.keys();
                mouseEvent.translatePoint(0, -gRichTextCanvas.this.th);
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    rLink rLink2 = (rLink)gRichTextCanvas.this.links.get(string);
                    if (!rLink2.rect.contains(mouseEvent.getPoint())) continue;
                    if (rLink2.link != null) {
                        try {
                            ((gRichTextCanvas)gRichTextCanvas.this).gRichText.this.applet.getAppletContext().showDocument(new URL(rLink2.link), "_blank");
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    gRichText.this;
                    TextField textField = RealChatClient.main.myChat;
                    StringBuffer stringBuffer = new StringBuffer();
                    gRichText.this;
                    StringBuffer stringBuffer2 = stringBuffer.append(translator.toASCII(rLink2.nick)).append(": ");
                    gRichText.this;
                    textField.setText(stringBuffer2.append(RealChatClient.main.myChat.getText()).toString());
                    gRichText.this;
                    TextField textField2 = RealChatClient.main.myChat;
                    gRichText.this;
                    textField2.setCaretPosition(RealChatClient.main.myChat.getText().length());
                    gRichText.this;
                    RealChatClient.main.myChat.requestFocus();
                }
            }
        }
    }

    class CListener
    extends ComponentAdapter {
        CListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (componentEvent.getComponent() == gRichText.this) {
                theRichText.clear();
            }
        }
    }
}

