/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;

public class Help
extends JPanel
implements HyperlinkListener {
    JEditorPane html;
    ToolBox TB;
    URL url;
    Cursor cursor;

    public Help() {
        this.TB = this.TB;
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setLayout(new BorderLayout());
        this.getAccessibleContext().setAccessibleName("HTML panel");
        this.getAccessibleContext().setAccessibleDescription("A panel for viewing HTML documents, and following their links");
        try {
            String string = String.valueOf(System.getProperty("user.dir")) + "/";
            URL uRL = new URL("file:///" + string + ToolBox.midiHelp);
            this.html = new JEditorPane(uRL);
            this.html.setEditable(false);
            this.html.addHyperlinkListener(this);
            JScrollPane jScrollPane = new JScrollPane();
            JViewport jViewport = jScrollPane.getViewport();
            jViewport.add(this.html);
            jViewport.setBackingStoreEnabled(true);
            this.add((Component)jScrollPane, "Center");
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Malformed URL: " + malformedURLException);
        }
        catch (IOException iOException) {
            System.out.println("IOException: " + iOException);
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.linkActivated(hyperlinkEvent.getURL());
        }
    }

    protected void linkActivated(URL uRL) {
        Cursor cursor = this.html.getCursor();
        Cursor cursor2 = Cursor.getPredefinedCursor(3);
        this.html.setCursor(cursor2);
        SwingUtilities.invokeLater(new PageLoader(uRL, cursor));
    }

    class PageLoader
    implements Runnable {
        PageLoader(URL uRL, Cursor cursor) {
            Help.this.url = uRL;
            Help.this.cursor = cursor;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            if (Help.this.url == null) {
                Help.this.html.setCursor(Help.this.cursor);
                Container container = Help.this.html.getParent();
                container.repaint();
                return;
            }
            Document document = Help.this.html.getDocument();
            try {
                try {
                    Help.this.html.setPage(Help.this.url);
                }
                catch (IOException iOException) {
                    Help.this.html.setDocument(document);
                    Help.this.getToolkit().beep();
                }
                Object var3_3 = null;
                Help.this.url = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                Help.this.url = null;
                SwingUtilities.invokeLater(this);
                throw throwable;
            }
            SwingUtilities.invokeLater(this);
        }
    }
}

