// BEEP - a Win32 batch utility to play simple sounds through a PC's internal speaker.

// Copyright (C) 2000 Clem Dye

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


#include <stdio.h>
#include <windows.h>

void main(int argc, char *argv[], char *envp[])

{

	BOOL bBeep;
	char cLitValue[8];
	long lFrequency;
	long lFrequency_low = 37; // API's lowest value.
	long lFrequency_high = 10000; // No point going much beyond this frequency. API will however support values up to ~32K.
	long lDuration;

	if (argc < 3)
	{
		printf("%s usage: %s <Sound Frequency> <Duration>\n\n", argv[0], argv[0]);
		printf("<Sound frequency> (in hertz) can have a value between %d and %d.\n", lFrequency_low, lFrequency_high);
		printf("<Duration> is the time (in seconds) that the sound should be made for.\n");
		printf("Command-line arguments must be supplied in the order specified.\n");
		exit(1);
	}

	lFrequency = atol(argv[1]);		// Validate the first command-line argument.
	if (lFrequency == 0)			// We didn't find any numeric data in the first command-line argument .....
	{
		printf("First command-line argument supplied (%s) contains non-numeric or invalid data ... terminating.\n", argv[1]);
		exit(1);
	}
	if (lFrequency < 0)
	{
		printf("First command-line argument supplied (%d) contains a negative value ... correcting.\n", lFrequency);
		lFrequency = lFrequency * -1;
	}
	if (lFrequency < lFrequency_low || lFrequency > lFrequency_high)
	{
		printf("First command-line argument supplied (%d) contains an out-of-range value ... terminating.\n", lFrequency);
		exit(1);
	}

	lDuration = atol(argv[2]);	// Validate the second command-line argument.
	if (lDuration == 0)			// We didn't find any numeric data in the second command-line argument .....
	{
		printf("Second command-line argument supplied (%s) contains non-numeric or invalid data ... terminating.\n", argv[2]);
		exit(1);
	}
	if (lDuration < 0)
	{
		printf("Second command-line argument supplied (%d) contains a negative value ... correcting.\n", lDuration);
		lDuration = lDuration * -1;
	}

	if (lDuration == 1)
		strcpy(cLitValue,"second\0");
	else
		strcpy(cLitValue,"seconds\0");

	printf("Using a frequency of %d hertz for %d %s.\n", lFrequency, lDuration, cLitValue);


	bBeep = Beep(lFrequency, lDuration * 1000);
	if (! bBeep)
	{
		printf("Failed to process sound instruction. Error %d occured.\n", GetLastError());
		exit(1);
	}

	exit(0);

}
