REM     The Personal BASIC Language Interpretter.
REM     Copyright (C) Sandul Yura Valentinovich.
REM     (W) Sunday, 27 April 2003 year - Tuesday, 20 May 2003 year.
REM     All rights are reserved.
REM
REM     This program is free software; you can redistribute it and/or modify
REM it under the terms of the GNU General Public License as published by the
REM Free Software Foundation; either version 2 of the License, or (at your
REM option) any later version.
REM     This program is distributed in the hope that it will be useful, but
REM WITHOUT ANY WARRANTY; without even the implied warranty of
REM MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
REM Public License for more details.
REM     You should have received a copy of the GNU General Public License
REM along with this program; if not, write to the Free Software Foundation,
REM Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
REM
REM  ANSI.SYS 
REM   
REM
REM Defines functions that change display graphics, control cursor movement,
REM and reassign keys. The ANSI.SYS device driver supports the use of ANSI
REM escape sequences to control the system's screen and keyboard.
REM
REM Parameters used in ANSI escape sequences
REM Pn  Numeric paramter. Specifies a decimal number.
REM
REM Ps  Selective parameter. Specifies a decimal number that you use to
REM     select a function. You can specify more than one function by
REM     separating the parameters with semicolons.
REM
REM PL  Line parameter. Specifies a decimal number that represents one of
REM     the lines on your display or on another device.
REM
REM Pc  Column parameter. Specifies a decimal number that represents one
REM     of the columns on your screen or on another device.
REM
REM ANSI escape sequences
REM In the following list of ANSI escape sequences, the abbreviate ESC
REM represents the ASCII escape character 27 (1Bh), which appears at the
REM beginning of each escape sequence.
REM
REM ESC[PL;PcH or ESC[PL;Pcf
REM   Cursor Position. Moves the cursor to the specified location
REM   (coordinates). If you do not specify a position, the cursor moves
REM   to the home position (home 0, column 0).
REM
REM ESC[PnA
REM   Cursor Up. Moves the cursor up by the specified number of lines
REM   without changing columns.
REM
REM ESC[PnB
REM   Cursor Down. Moves the cursor down by the sepcified number of lines
REM   without changing columns.
REM
REM ESC[PnC
REM   Cursor Forward. Moves the cursor forward by the specified number of
REM   columns without changing lines.
REM
REM ESC[PnD
REM   Cursor Backward. Moves the cursor back by the specified number of
REM   columns without changing lines.
REM
REM ESC[s
REM   Save Cursor Position. Saves the current position. You can move the
REM   cursor to the saved cursor position by using the Restore Cursor
REM   Position sequence.
REM
REM ESC[u
REM   Restore Cursor Position. Returns the cursor to the position saved by
REM   the Save Cursor Position sequence.
REM
REM ESC[2J
REM   Erase Display. Clears the screen and moves the cursor to the home
REM   position (line 0, column 0).
REM
REM ESC[K
REM   Erase Line. Clears all characters from the cursor position to the
REM   end of the line.
REM
REM ESC[Ps;...;Psm
REM   Set Graphics Mode. Calls the graphics functions specified by the
REM   following values. These functions remain active until the next
REM   occurrence of this escape sequence.
REM
REM   Text attributes
REM          0    All attributes off
REM          1    Bold on
REM          4    Underscore (on monochrome display adapter only)
REM          5    Blink on
REM          7    Reverse video on
REM          8    Concealed on
REM
REM   Foreground colors
REM          30   Black
REM          31   Red
REM          32   Green
REM          33   Yellow
REM          34   Blue
REM          35   Magenta
REM          36   Cyan
REM          37   White
REM
REM   Background colors
REM          40   Black
REM          41   Red
REM          42   Green
REM          43   Yellow
REM          44   Blue
REM          45   Magenta
REM          46   Cyan
REM          47   White
REM
REM   Parameters 30 through 47 meet the ISO 6429 standard.
REM
REM $DYNAMIC
DECLARE SUB ANSIOut (ANSISymbol$)
DECLARE SUB ClearAll (ClearLines%)
DECLARE SUB ClearANSI (ClearCursor%)
DECLARE SUB DeleteLine (LineNumber%)
DECLARE SUB Hang ()
DECLARE SUB Help ()
DECLARE SUB RunLine (InLine$)
DECLARE SUB SetVariable (VariableName$, VariableType%, VariableData$)
DECLARE SUB WriteLine (OutLine$)
DECLARE SUB WriteLineCRLF (OutLine$)
DECLARE FUNCTION Calculate$ (InLine$)
DECLARE FUNCTION DayName$ (DayNumber%)
DECLARE FUNCTION DayOfWeek% (DayValue%, MonthValue%, YearValue%)
DECLARE FUNCTION DaysCount# (DayValue%, MonthValue%, YearValue%)
DECLARE FUNCTION FindLine% (LineNumber%)
DECLARE FUNCTION InDefFn$ (DefFnName$, DefFnType%, InLine$)
DECLARE FUNCTION InMeaning$ (InLine$)
DECLARE FUNCTION InName$ (InLine$)
DECLARE FUNCTION InNumber# (InLine$)
DECLARE FUNCTION InVariable$ (VariableName$, VariableType%)
DECLARE FUNCTION LeapYear% (YearValue%)
DECLARE FUNCTION MonthDays% (MonthValue%, YearValue%)
DECLARE FUNCTION MonthDaysCount% (MonthValue%, YearValue%)
DECLARE FUNCTION MonthName$ (MonthNumber%)
DECLARE FUNCTION ParseCalculate$ (InLine$)
DECLARE FUNCTION ParseInMeaning$ (InLine$)
DECLARE FUNCTION ParseInNumber$ (InLine$)
DECLARE FUNCTION ParseRunLine$ (InLine$)
DECLARE FUNCTION SquareRoot# (Meaning#)
DECLARE FUNCTION WeekNumber% (DayValue%, MonthValue%, YearValue%)
OPTION BASE 1
CONST False% = 0
CONST True% = NOT False%
CONST BASICLinesCount% = 64
CONST DefFnSCount% = 4
CONST DefFnSArgsCount% = 4
CONST VariablesCount% = 4
CONST FilesCount% = 4
CONST WhilesCount% = 4
CONST FromsCount% = 4
CONST GoSubSCount% = 4
CONST ArgumentsCount% = 4
CONST Black% = 0
CONST Blue% = 1
CONST Green% = 2
CONST Cyan% = 3
CONST Red% = 4
CONST Magenta% = 5
CONST Brown% = 6
CONST White% = 7
CONST Gray% = 8
CONST LightBlue% = 9
CONST LightGreen% = 10
CONST LightCyan% = 11
CONST LightRed% = 12
CONST LightMagenta% = 13
CONST Yellow% = 14
CONST BrightWhite% = 15
CLEAR , , 7326
DIM SHARED BASICLines$(BASICLinesCount%)
DIM SHARED BASICLinesCountValue%
DIM SHARED DefFnS$(DefFnSCount%)
DIM SHARED DefFnSCountValue%
DIM SHARED DefFnSArgs$(DefFnSCount%, DefFnSArgsCount%)
DIM SHARED DefFnSArgsCountValue%(DefFnSCount%)
DIM SHARED CurrentDefFn%
DIM SHARED DefFnMode%
DIM SHARED Variables$(VariablesCount%)
DIM SHARED VariablesCountValue%
DIM SHARED OpenFiles$(FilesCount%)
DIM SHARED Whiles$(WhilesCount%)
DIM SHARED Froms$(FromsCount%)
DIM SHARED GoSubS%(GoSubSCount%)
DIM SHARED GoSubSCountValue%
DIM SHARED CurrentLine%
DIM SHARED NumStr%
DIM SHARED RunMode%
DIM SHARED TraceMode%
DIM SHARED DebugMode%
DIM SHARED CursorRow%
DIM SHARED CursorColumn%
DIM SHARED CursorSaved%
DIM SHARED Arguments%(ArgumentsCount%)
DIM SHARED ArgumentsCountValue%
DIM SHARED NumberLine$
DIM SHARED ANSIMode%
DIM SHARED Prompt$
DIM Errors$(88)
DIM BASICLine$
DIM LineNumber%
DIM Index%
DIM SubIndex%
Errors$(1) = "NEXT without FROM"
Errors$(2) = "Syntax error"
Errors$(3) = "RETURN without GOSUB"
Errors$(4) = "Out of DATA"
Errors$(5) = "Illegal function call"
Errors$(6) = "Overflow"
Errors$(7) = "Out of memory"
Errors$(8) = "Label not defined"
Errors$(9) = "Subscript out of range"
Errors$(10) = "Duplicate definition"
Errors$(11) = "Division by zero"
Errors$(12) = "Illegal in direct mode"
Errors$(13) = "Type mismatch"
Errors$(14) = "Out of string space"
Errors$(15) = "User - defined function is not declare"
Errors$(16) = "String formula too complex"
Errors$(17) = "Cannot continue"
Errors$(18) = "Function not defined"
Errors$(19) = "No RESUME"
Errors$(20) = "RESUME without error"
Errors$(21) = "Too many calculated user - defined functions per one time"
Errors$(22) = "Too many arguments for the user - defined function"
Errors$(23) = "Unknown statement"
Errors$(24) = "Device timeout"
Errors$(25) = "Device fault"
Errors$(26) = "FROM without NEXT"
Errors$(27) = "Out of paper"
Errors$(28) = "File already closed"
Errors$(29) = "WHILE without WEND"
Errors$(30) = "WEND without WHILE"
Errors$(31) = "Too many declared user - defined functions"
Errors$(32) = "Cannot end not runned program"
Errors$(33) = "Duplicate label"
Errors$(34) = "Program already running"
Errors$(35) = "Subprogram not defined"
Errors$(36) = "Nothing to run"
Errors$(37) = "Argument - count mismatch"
Errors$(38) = "Array not defined"
Errors$(39) = "Cannot run debugged program"
Errors$(40) = "Variable required"
Errors$(41) = "Debug mode is already turned to ON"
Errors$(42) = "Debug mode is already turned to OFF"
Errors$(43) = "Nothing to debug"
Errors$(44) = "Cannot trace not debugged program"
Errors$(45) = "Variable type mismatch"
Errors$(46) = "Invalid line number"
Errors$(47) = "Too many lines"
Errors$(48) = "User - defined function must begin with FN"
Errors$(49) = "Line not found"
Errors$(50) = "FIELD overflow"
Errors$(51) = "Internal error"
Errors$(52) = "Bad file name or number"
Errors$(53) = "File not found"
Errors$(54) = "Bad file mode"
Errors$(55) = "File already open"
Errors$(56) = "FIELD statement active"
Errors$(57) = "Device I/O error"
Errors$(58) = "File already exists"
Errors$(59) = "Bad record length"
Errors$(60) = "Cannot turn to on debug mode with program is running"
Errors$(61) = "Disk full"
Errors$(62) = "Input past end of file"
Errors$(63) = "Bad record number"
Errors$(64) = "Bad file name"
Errors$(65) = "Too many running FROM's per one time"
Errors$(66) = "Cannot run FROM cycle without program is running or debug"
Errors$(67) = "Too many files"
Errors$(68) = "Device unavailable"
Errors$(69) = "Communication - buffer overflow"
Errors$(70) = "Permission denied"
Errors$(71) = "Disk not ready"
Errors$(72) = "Disk - media error"
Errors$(73) = "Feature unavailable"
Errors$(74) = "Rename across disks"
Errors$(75) = "Path/File access error"
Errors$(76) = "Path not found"
Errors$(77) = "Too many running GO SUB's per one time"
Errors$(78) = "Cannot run GO TO or GO SUB, or RETURN without program is running or debug"
Errors$(79) = "Invalid line number range"
Errors$(80) = "Blank line in file"
Errors$(81) = "BASIC lines in input file must be begin with line number"
Errors$(82) = "Nothing to save"
Errors$(83) = "Too many running WHILE's per one time"
Errors$(84) = "Cannot run WHILE cycle without program is running or debug"
Errors$(85) = "Invalid year"
Errors$(86) = "Invalid month"
Errors$(87) = "Invalid day number in the month of the year"
Errors$(88) = "Too many variables"
Prompt$ = "Personal(GNU)$BASIC="
CALL ClearAll(True%)
KEY 1, "Help!" + CHR$(13)
KEY 2, "Save" + CHR$(34) + "Save.bas" + CHR$(34)
KEY 3, "Load" + CHR$(34) + "Load.bas" + CHR$(34)
KEY 4, "List" + CHR$(13)
KEY 5, "Cls" + CHR$(13)
KEY 6, "Debug On" + CHR$(13)
KEY 7, "Debug Off" + CHR$(13)
KEY 8, "Trace" + CHR$(13)
KEY 9, "New" + CHR$(13)
KEY 10, "System" + CHR$(13)
KEY ON
SCREEN 0, 1, 0, 0
COLOR White%, Black%
CLS
LOCATE 1, 1, 1, 7, 8
PRINT "    The Personal BASIC Language Interpretter."
PRINT "    Copyright (C) Sandul Yura Valentinovich."
PRINT "    (W) Sunday, 27 April 2003 year - Tuesday, 20 May 2003 year."
PRINT "    All rights are reserved."
PRINT "********************************************************************************"
PRINT "    This program is free software; you can redistribute it and/or modify it"
PRINT "under the terms of the GNU General Public License as published by the Free"
PRINT "Software Foundation; either version 2 of the License, or (at your option) any"
PRINT "later version."
PRINT "    This program is distributed in the hope that it will be useful, but WITHOUT"
PRINT "ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS"
PRINT "FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details."
PRINT "    You should have received a copy of the GNU General Public License along with"
PRINT "this program; if not, write to the Free Software Foundation, Inc., 675 Mass Ave,"
PRINT "Cambridge, MA 02139, USA."
PRINT
ON ERROR GOTO BASICError
DO
 PRINT "Current date: " + DayName$(DayOfWeek%(VAL(MID$(DATE$, 4, 2)), VAL(LEFT$(DATE$, 2)), VAL(MID$(DATE$, 7, 4)))) + ", " + LTRIM$(STR$(VAL(MID$(DATE$, 4, 2)))) + " " + MonthName$(VAL(LEFT$(DATE$, 2))) + " " + LTRIM$(STR$(VAL(MID$(DATE$, 7, 4)))) + " year, time: " + TIME$ + "."
 PRINT "Free stack space=" + LTRIM$(STR$(FRE(-2))) + " bytes."
 CALL WriteLine(Prompt$)
 LINE INPUT BASICLine$
 BASICLine$ = LTRIM$(RTRIM$(BASICLine$))
 IF BASICLine$ <> "" THEN
  SELECT CASE LEFT$(UCASE$(BASICLine$), 1)
  CASE "0" TO "9"
    LineNumber% = INT(InNumber#(BASICLine$))
    IF (LineNumber% < 1) OR (LineNumber% > BASICLinesCount%) THEN ERROR 46
    BASICLine$ = LTRIM$(BASICLine$)
    IF BASICLine$ = "" THEN ERROR 2
    IF NOT ((ASC(UCASE$(BASICLine$)) > (ASC("A") - 1)) AND (ASC(UCASE$(BASICLine$)) < (ASC("Z") + 1))) THEN ERROR 2
    BASICLine$ = ParseRunLine$(BASICLine$)
    IF BASICLinesCountValue% = 0 THEN
     BASICLinesCountValue% = 1
     BASICLines$(BASICLinesCountValue%) = STRING$(LEN(LTRIM$(STR$(BASICLinesCount%))) - LEN(LTRIM$(STR$(LineNumber%))), "0") + LTRIM$(STR$(LineNumber%)) + "=" + BASICLine$
    ELSE
     FOR Index% = 1 TO BASICLinesCountValue% + 1
      IF Index% = BASICLinesCountValue% + 1 THEN
       IF BASICLinesCountValue% = BASICLinesCount% THEN ERROR 47
       BASICLinesCountValue% = BASICLinesCountValue% + 1
       BASICLines$(BASICLinesCountValue%) = STRING$(LEN(LTRIM$(STR$(BASICLinesCount%))) - LEN(LTRIM$(STR$(LineNumber%))), "0") + LTRIM$(STR$(LineNumber%)) + "=" + BASICLine$
       FOR LineNumber% = 1 TO BASICLinesCountValue%
        FOR SubIndex% = 1 TO BASICLinesCountValue%
         IF BASICLines$(LineNumber%) < BASICLines$(SubIndex%) THEN SWAP BASICLines$(LineNumber%), BASICLines$(SubIndex%)
        NEXT SubIndex%
       NEXT LineNumber%
       EXIT FOR
      END IF
      IF VAL(MID$(BASICLines$(Index%), 1, INSTR(BASICLines$(Index%), "=") - 1)) = LineNumber% THEN
       BASICLines$(Index%) = STRING$(LEN(LTRIM$(STR$(BASICLinesCount%))) - LEN(LTRIM$(STR$(LineNumber%))), "0") + LTRIM$(STR$(LineNumber%)) + "=" + BASICLine$
       EXIT FOR
      END IF
     NEXT Index%
    END IF
  CASE "A" TO "Z"
    BASICLine$ = ParseRunLine$(BASICLine$)
    CALL RunLine(BASICLine$)
  CASE ELSE
    ERROR 2
  END SELECT
 END IF
BASICWork:
LOOP
BASICError:
 PRINT "ERROR: " + Errors$(ERR) + "."
 RESET
 CALL ClearAll(False%)
 RESUME BASICWork

SUB ANSIOut (ANSISymbol$)
 DIM Index%
 IF ANSISymbol$ = "" THEN EXIT SUB
 SELECT CASE ANSIMode%
 CASE 0
   SELECT CASE ANSISymbol$
   CASE CHR$(27)
     ANSIMode% = 1
   CASE ELSE
     SELECT CASE ASC(ANSISymbol$)
     CASE 10
       PRINT
     CASE IS > (ASC(SPACE$(1)) - 1)
       PRINT ANSISymbol$;
     END SELECT
     CALL ClearANSI(False%)
   END SELECT
 CASE 1
   SELECT CASE ANSISymbol$
   CASE "["
     ANSIMode% = 2
   CASE ELSE
     CALL ClearANSI(False%)
     CALL ANSIOut(ANSISymbol$)
   END SELECT
 CASE 2
   SELECT CASE ANSISymbol$
   CASE "H"
     IF Arguments%(1) < 1 THEN Arguments%(1) = 1
     IF Arguments%(2) < 1 THEN Arguments%(2) = 1
     IF Arguments%(1) > 25 THEN Arguments%(1) = 25
     IF Arguments%(2) > 80 THEN Arguments%(2) = 80
     SELECT CASE ArgumentsCountValue%
     CASE 0
       LOCATE 1, 1, 1, 7, 8
     CASE 1
       LOCATE Arguments%(1), 1, 7, 8
     CASE IS > 1
       LOCATE Arguments%(1), Arguments%(2), 1, 7, 8
     END SELECT
     CALL ClearANSI(False%)
   CASE "f"
     IF Arguments%(1) < 1 THEN Arguments%(1) = 1
     IF Arguments%(2) < 1 THEN Arguments%(2) = 1
     IF Arguments%(1) > 25 THEN Arguments%(1) = 25
     IF Arguments%(2) > 80 THEN Arguments%(2) = 80
     SELECT CASE ArgumentsCountValue%
     CASE 0
       LOCATE 1, 1, 1, 7, 8
     CASE 1
       LOCATE Arguments%(1), 1, 7, 8
     CASE IS > 1
       LOCATE Arguments%(1), Arguments%(2), 1, 7, 8
     END SELECT
     CALL ClearANSI(False%)
   CASE "A"
     IF Arguments%(1) < 1 THEN Arguments%(1) = 1
     IF (CSRLIN - Arguments%(1)) > 0 THEN LOCATE CSRLIN - Arguments%(1), POS(0), 1, 7, 8
     CALL ClearANSI(False%)
   CASE "B"
     IF Arguments%(1) < 1 THEN Arguments%(1) = 1
     IF (CSRLIN + Arguments%(1)) < 26 THEN LOCATE CSRLIN + Arguments%(1), POS(0), 1, 7, 8
     CALL ClearANSI(False%)
   CASE "C"
     IF Arguments%(1) < 1 THEN Arguments%(1) = 1
     IF (POS(0) + Arguments%(1)) < 81 THEN LOCATE CSRLIN, POS(0) + Arguments%(1), 1, 7, 8
     CALL ClearANSI(False%)
   CASE "D"
     IF Arguments%(1) < 1 THEN Arguments%(1) = 1
     IF (POS(0) - Arguments%(1)) > 0 THEN LOCATE CSRLIN, POS(0) - Arguments%(1), 1, 7, 8
     CALL ClearANSI(False%)
   CASE "s"
     CursorRow% = CSRLIN
     CursorColumn% = POS(0)
     CursorSaved% = True%
     CALL ClearANSI(False%)
   CASE "u"
     IF CursorSaved% THEN
      LOCATE CursorRow%, CursorColumn%, 1, 7, 8
      CursorSaved% = False%
     END IF
     CALL ClearANSI(False%)
   CASE "J"
     IF Arguments%(1) = 2 THEN
      CLS
      LOCATE 1, 1, 1, 7, 8
     END IF
     CALL ClearANSI(False%)
   CASE "K"
     Index% = POS(0)
     PRINT SPACE$(80 - POS(0));
     LOCATE CSRLIN, Index%, 1, 7, 8
     CALL ClearANSI(False%)
   CASE "m"
     IF ArgumentsCountValue% > 0 THEN
      FOR Index% = 1 TO ArgumentsCountValue%
       SELECT CASE Arguments%(Index%)
       CASE 0
         COLOR White%, Black%
       CASE 1
         COLOR BrightWhite%
       CASE 4
         COLOR Blue%
       CASE 5
         COLOR White%
       CASE 7
         COLOR Black%, White%
       CASE 8
         COLOR Black%, Black%
       CASE 30
         COLOR Black%
       CASE 31
         COLOR Red%
       CASE 32
         COLOR Green%
       CASE 33
         COLOR Brown%
       CASE 34
         COLOR Blue%
       CASE 35
         COLOR Magenta%
       CASE 36
         COLOR Cyan%
       CASE 37
         COLOR BrightWhite%
       CASE 40
         COLOR , Black%
       CASE 41
         COLOR , Red%
       CASE 42
         COLOR , Green%
       CASE 43
         COLOR , Brown%
       CASE 44
         COLOR , Blue%
       CASE 45
         COLOR , Magenta%
       CASE 46
         COLOR , Cyan%
       CASE 47
         COLOR , White%
       END SELECT
      NEXT Index%
     ELSE
      COLOR White%, Black%
     END IF
     CALL ClearANSI(False%)
   CASE "0" TO "9"
     CALL ClearANSI(False%)
     ANSIMode% = 3
     CALL ANSIOut(ANSISymbol$)
   CASE ";"
     CALL ClearANSI(False%)
     ANSIMode% = 3
     CALL ANSIOut(ANSISymbol$)
   CASE ELSE
     ANSIMode% = 0
     CALL ANSIOut(ANSISymbol$)
   END SELECT
 CASE 3
   SELECT CASE ANSISymbol$
   CASE "0" TO "9"
     IF LEN(NumberLine$) < 2 THEN NumberLine$ = NumberLine$ + ANSISymbol$
   CASE ";"
     IF ArgumentsCountValue% < ArgumentsCount% THEN
      ArgumentsCountValue% = ArgumentsCountValue% + 1
      Arguments%(ArgumentsCountValue%) = VAL(NumberLine$)
     END IF
     NumberLine$ = ""
   CASE ELSE
     IF ArgumentsCountValue% < ArgumentsCount% THEN
      ArgumentsCountValue% = ArgumentsCountValue% + 1
      Arguments%(ArgumentsCountValue%) = VAL(NumberLine$)
     END IF
     ANSIMode% = 2
     CALL ANSIOut(ANSISymbol$)
   END SELECT
 END SELECT
END SUB

FUNCTION Calculate$ (InLine$)
 DIM Result$
 DIM Value$
 DIM WorkLine$
 DIM ControlNumStr%
 Result$ = InMeaning$(InLine$)
 InLine$ = LTRIM$(InLine$)
 DO WHILE InLine$ <> ""
  SELECT CASE LEFT$(UCASE$(InLine$), 1)
  CASE "*"
    IF NumStr% THEN ERROR 13
    InLine$ = MID$(InLine$, 2)
    Value$ = InMeaning$(InLine$)
    IF NumStr% THEN ERROR 13
    Result$ = LTRIM$(STR$(VAL(Result$) * VAL(Value$)))
  CASE "+"
    InLine$ = MID$(InLine$, 2)
    ControlNumStr% = NumStr%
    Value$ = InMeaning$(InLine$)
    IF ControlNumStr% <> NumStr% THEN ERROR 13
    IF NumStr% THEN Result$ = Result$ + Value$ ELSE Result$ = LTRIM$(STR$(VAL(Result$) + VAL(Value$)))
  CASE "-"
    IF NumStr% THEN ERROR 13
    InLine$ = MID$(InLine$, 2)
    Value$ = InMeaning$(InLine$)
    IF NumStr% THEN ERROR 13
    Result$ = LTRIM$(STR$(VAL(Result$) - VAL(Value$)))
  CASE "/"
    IF NumStr% THEN ERROR 13
    InLine$ = MID$(InLine$, 2)
    Value$ = InMeaning$(InLine$)
    IF NumStr% THEN ERROR 13
    IF VAL(Value$) = 0# THEN ERROR 11
    Result$ = LTRIM$(STR$(VAL(Result$) / VAL(Value$)))
  CASE "\"
    IF NumStr% THEN ERROR 13
    InLine$ = MID$(InLine$, 2)
    Value$ = InMeaning$(InLine$)
    IF NumStr% THEN ERROR 13
    IF VAL(Value$) = 0# THEN ERROR 11
    Result$ = LTRIM$(STR$(VAL(Result$) / VAL(Value$)))
  CASE "^"
    IF NumStr% THEN ERROR 13
    InLine$ = MID$(InLine$, 2)
    Value$ = InMeaning$(InLine$)
    IF NumStr% THEN ERROR 13
    Result$ = LTRIM$(STR$(VAL(Result$) ^ VAL(Value$)))
  CASE "="
    InLine$ = LTRIM$(MID$(InLine$, 2))
    ControlNumStr% = NumStr%
    SELECT CASE LEFT$(InLine$, 1)
    CASE ">"
      InLine$ = MID$(InLine$, 2)
      Value$ = InMeaning$(InLine$)
      IF ControlNumStr% <> NumStr% THEN ERROR 13
      IF NumStr% THEN
       IF Result$ >= Value$ THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      ELSE
       IF VAL(Result$) >= VAL(Value$) THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      END IF
    CASE "<"
      InLine$ = MID$(InLine$, 2)
      Value$ = InMeaning$(InLine$)
      IF ControlNumStr% <> NumStr% THEN ERROR 13
      IF NumStr% THEN
       IF Result$ <= Value$ THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      ELSE
       IF VAL(Result$) <= VAL(Value$) THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      END IF
    CASE ELSE
      Value$ = InMeaning$(InLine$)
      IF ControlNumStr% <> NumStr% THEN ERROR 13
      IF NumStr% THEN
       IF Result$ = Value$ THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      ELSE
       IF VAL(Result$) = VAL(Value$) THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      END IF
    END SELECT
    NumStr% = False%
  CASE ">"
    InLine$ = LTRIM$(MID$(InLine$, 2))
    ControlNumStr% = NumStr%
    SELECT CASE LEFT$(InLine$, 1)
    CASE "<"
      InLine$ = MID$(InLine$, 2)
      Value$ = InMeaning$(InLine$)
      IF ControlNumStr% <> NumStr% THEN ERROR 13
      IF NumStr% THEN
       IF Result$ <> Value$ THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      ELSE
       IF VAL(Result$) <> VAL(Value$) THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      END IF
    CASE "="
      InLine$ = MID$(InLine$, 2)
      Value$ = InMeaning$(InLine$)
      IF ControlNumStr% <> NumStr% THEN ERROR 13
      IF NumStr% THEN
       IF Result$ >= Value$ THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      ELSE
       IF VAL(Result$) >= VAL(Value$) THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      END IF
    CASE ELSE
      Value$ = InMeaning$(InLine$)
      IF ControlNumStr% <> NumStr% THEN ERROR 13
      IF NumStr% THEN
       IF Result$ > Value$ THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      ELSE
       IF VAL(Result$) > VAL(Value$) THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      END IF
    END SELECT
    NumStr% = False%
  CASE "<"
    InLine$ = LTRIM$(MID$(InLine$, 2))
    ControlNumStr% = NumStr%
    SELECT CASE LEFT$(InLine$, 1)
    CASE ">"
      InLine$ = MID$(InLine$, 2)
      Value$ = InMeaning$(InLine$)
      IF ControlNumStr% <> NumStr% THEN ERROR 13
      IF NumStr% THEN
       IF Result$ <> Value$ THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      ELSE
       IF VAL(Result$) <> VAL(Value$) THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      END IF
    CASE "="
      InLine$ = MID$(InLine$, 2)
      Value$ = InMeaning$(InLine$)
      IF ControlNumStr% <> NumStr% THEN ERROR 13
      IF NumStr% THEN
       IF Result$ <= Value$ THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      ELSE
       IF VAL(Result$) <= VAL(Value$) THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      END IF
    CASE ELSE
      Value$ = InMeaning$(InLine$)
      IF ControlNumStr% <> NumStr% THEN ERROR 13
      IF NumStr% THEN
       IF Result$ < Value$ THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      ELSE
       IF VAL(Result$) < VAL(Value$) THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      END IF
    END SELECT
    NumStr% = False%
  CASE "A" TO "Z"
    WorkLine$ = InLine$
    SELECT CASE InName$(InLine$)
    CASE "AND"
      IF NumStr% THEN ERROR 13
      Value$ = InMeaning$(InLine$)
      IF NumStr% THEN ERROR 13
      Result$ = LTRIM$(STR$(VAL(Result$) AND VAL(Value$)))
    CASE "MOD"
      IF NumStr% THEN ERROR 13
      Value$ = InMeaning$(InLine$)
      IF NumStr% THEN ERROR 13
      Result$ = LTRIM$(STR$(VAL(Result$) MOD VAL(Value$)))
    CASE "OR"
      IF NumStr% THEN ERROR 13
      Value$ = InMeaning$(InLine$)
      IF NumStr% THEN ERROR 13
      Result$ = LTRIM$(STR$(VAL(Result$) OR VAL(Value$)))
    CASE "XOR"
      IF NumStr% THEN ERROR 13
      Value$ = InMeaning$(InLine$)
      IF NumStr% THEN ERROR 13
      Result$ = LTRIM$(STR$(VAL(Result$) XOR VAL(Value$)))
    CASE ELSE
      InLine$ = WorkLine$
      EXIT DO
    END SELECT
  CASE ELSE
    EXIT DO
  END SELECT
  InLine$ = LTRIM$(InLine$)
 LOOP
 Calculate$ = Result$
END FUNCTION

SUB ClearAll (ClearLines%)
 DIM Index%
 DIM SubIndex%
 IF ClearLines% THEN
  BASICLinesCountValue% = 0
  FOR Index% = 1 TO BASICLinesCount%
   BASICLines$(Index%) = ""
  NEXT Index%
 END IF
 FOR Index% = 1 TO DefFnSCount%
  DefFnS$(Index%) = ""
  DefFnSArgsCountValue%(Index%) = 0
  FOR SubIndex% = 1 TO DefFnSArgsCount%
   DefFnSArgs$(Index%, SubIndex%) = ""
  NEXT SubIndex%
 NEXT Index%
 FOR Index% = 1 TO VariablesCount%
  Variables$(Index%) = ""
 NEXT Index%
 FOR Index% = 1 TO FilesCount%
  OpenFiles$(Index%) = ""
 NEXT Index%
 FOR Index% = 1 TO WhilesCount%
  Whiles$(Index%) = ""
 NEXT Index%
 FOR Index% = 1 TO FromsCount%
  Froms$(Index%) = ""
 NEXT Index%
 FOR Index% = 1 TO GoSubSCount%
  GoSubS%(Index%) = 0
 NEXT Index%
 GoSubSCountValue% = 0
 CurrentLine% = 0
 DefFnSCountValue% = 0
 CurrentDefFn% = 0
 VariablesCountValue% = 0
 NumStr% = False%
 RunMode% = False%
 TraceMode% = False%
 DebugMode% = False%
 DefFnMode% = False%
 CALL ClearANSI(True%)
END SUB

SUB ClearANSI (ClearCursor%)
 DIM Index%
 IF ClearCursor% THEN
  CursorRow% = 0
  CursorColumn% = 0
  CursorSaved% = False%
 END IF
 FOR Index% = 1 TO ArgumentsCount%
  Arguments%(Index%) = 0
 NEXT Index%
 ArgumentsCountValue% = 0
 NumberLine$ = ""
 ANSIMode% = 0
END SUB

FUNCTION DayName$ (DayNumber%)
 SELECT CASE DayNumber%
 CASE 1
   DayName$ = "Monday"
 CASE 2
   DayName$ = "Tuesday"
 CASE 3
   DayName$ = "Wednesday"
 CASE 4
   DayName$ = "Thursday"
 CASE 5
   DayName$ = "Friday"
 CASE 6
   DayName$ = "Saturday"
 CASE 7
   DayName$ = "Sunday"
 END SELECT
END FUNCTION

FUNCTION DayOfWeek% (DayValue%, MonthValue%, YearValue%)
 SELECT CASE DaysCount#(DayValue%, MonthValue%, YearValue%) - (INT(DaysCount#(DayValue%, MonthValue%, YearValue%) / 7) * 7)
 CASE 0
   DayOfWeek% = 6
 CASE 1
   DayOfWeek% = 7
 CASE 2
   DayOfWeek% = 1
 CASE 3
   DayOfWeek% = 2
 CASE 4
   DayOfWeek% = 3
 CASE 5
   DayOfWeek% = 4
 CASE 6
   DayOfWeek% = 5
 END SELECT
END FUNCTION

FUNCTION DaysCount# (DayValue%, MonthValue%, YearValue%)
 DaysCount# = MonthDays%(MonthValue%, YearValue%) + (YearValue% * 365!) + INT(YearValue% / 4) + INT(YearValue% / 100) + DayValue%
END FUNCTION

SUB DeleteLine (LineNumber%)
 DIM NumberOfLine%
 DIM Index%
 NumberOfLine% = FindLine%(LineNumber%)
 BASICLines$(NumberOfLine%) = ""
 FOR Index% = NumberOfLine% TO BASICLinesCountValue% - 1
  BASICLines$(Index%) = BASICLines$(Index% + 1)
  BASICLines$(Index% + 1) = ""
 NEXT Index%
 BASICLinesCountValue% = BASICLinesCountValue% - 1
END SUB

FUNCTION FindLine% (LineNumber%)
 DIM Index%
 IF BASICLinesCountValue% = 0 THEN ERROR 49
 FOR Index% = 1 TO BASICLinesCountValue% + 1
  IF Index% = BASICLinesCountValue% + 1 THEN ERROR 49
  IF VAL(MID$(BASICLines$(Index%), 1, INSTR(BASICLines$(Index%), "=") - 1)) = LineNumber% THEN EXIT FOR
 NEXT Index%
 FindLine% = Index%
END FUNCTION

SUB Hang
 DIM HangCode%(32)
 DIM Index%
 DIM HangCode$
 HangCode$ = "BA0000529DBF40008EC7BF000026C6050083C70181FF010475F3B80000509D"
 HangCode$ = HangCode$ + "BB0000B90000BA0000BD0000BC0000BE0000BF00008EDA8EC7"
 HangCode$ = HangCode$ + "8ED4F0F4CD20CB"
 Index% = 0
 DEF SEG = VARSEG(HangCode%(1))
 WHILE HangCode$ <> ""
  POKE VARPTR(HangCode%(1)) + Index%, VAL("&H" + LEFT$(HangCode$, 2))
  Index% = Index% + 1
  HangCode$ = MID$(HangCode$, 3)
 WEND
 CALL Absolute(VARPTR(HangCode%(1)))
END SUB

SUB Help
 DIM HelpText$(281)
 DIM Key$
 DIM Index%
 DIM PageIndex%
 HelpText$(1) = "Statements:"
 HelpText$(2) = "       BEEP"
 HelpText$(3) = "Generates a beep sound from your computer's speaker."
 HelpText$(4) = "       CHDIR DirectoryName$"
 HelpText$(5) = "Changes a drive's default directory."
 HelpText$(6) = "       CLOSE #FileNumber%"
 HelpText$(7) = "Closes one open file or device."
 HelpText$(8) = "       CLS"
 HelpText$(9) = "Clears the screen."
 HelpText$(10) = "       COLOR ForeGroundColor% ON BackGroundColor%"
 HelpText$(11) = "Sets the screen display color."
 HelpText$(12) = "       DEBUG ON|OFF"
 HelpText$(13) = "Change current option of set the debugging mode."
 HelpText$(14) = "       DEF FNName[(Arg[,Arg...])]=Expression"
 HelpText$(15) = "Defines a user function."
 HelpText$(16) = "       DELETE LineNumber%[,EndLineNumber%]"
 HelpText$(17) = "Delete current program line(s)."
 HelpText$(18) = "       END"
 HelpText$(19) = "Ends a program."
 HelpText$(20) = "       FILES FileMask$"
 HelpText$(21) = "FILES displays the contents of the current directory or a specified"
 HelpText$(22) = "directory."
 HelpText$(23) = "       FROM VariableName%=StartValue TO EndValue [STEP=Value]"
 HelpText$(24) = "       NEXT VariableName%"
 HelpText$(25) = "Repeats a block of statements a specified number of times."
 HelpText$(26) = "       GO TO|SUB LineNumber%"
 HelpText$(27) = "Perform call GO TO or GO SUB statement."
 HelpText$(28) = "       HANG"
 HelpText$(29) = "Hang a computer."
 HelpText$(30) = "       HELP"
 HelpText$(31) = "Out this help."
 HelpText$(32) = "       IF Conditional% THEN Statement [ELSE Statement]"
 HelpText$(33) = "Executes a statement depending on specified conditions."
 HelpText$(34) = "       KEY {LIST|ON|OFF}|KeyNumber%,Line$"
 HelpText$(35) = "Assigns string values to function keys and, optionally, displays"
 HelpText$(36) = "key values."
 HelpText$(37) = "       KILL FileMask$"
 HelpText$(38) = "Deletes files from the disk."
 HelpText$(39) = "       LET VariableName=Value"
 HelpText$(40) = "Assigns the value of an expression to a variable."
 HelpText$(41) = "       LIST [LineNumber%[,EndLineNumber%]]"
 HelpText$(42) = "If line number's range is not specified, display all program lines,"
 HelpText$(43) = "else display lines of the current program in the specified range."
 HelpText$(44) = "       LOAD FileName$"
 HelpText$(45) = "Load the program from the disk text file."
 HelpText$(46) = "       LOCATE Column% IN Row%"
 HelpText$(47) = "Moves the cursor to a specified position on the screen."
 HelpText$(48) = "       MID$(StringVariable$,Position%,Count%)=Meaning$"
 HelpText$(49) = "The MID$ statement replaces part of a string variable with another"
 HelpText$(50) = "string."
 HelpText$(51) = "       MKDIR DirectoryName$"
 HelpText$(52) = "Creates a subdirectory."
 HelpText$(53) = "       NAME OldFileOrDirectoryName$ AS NewFileOrDirectoryName$"
 HelpText$(54) = "Renames a file or the directory."
 HelpText$(55) = "       NEW"
 HelpText$(56) = "Clear current program."
 HelpText$(57) = "       OPEN FileName$ FOR INPUT|OUTPUT|APPEND AS #FileNumber%"
 HelpText$(58) = "Open the file or device."
 HelpText$(59) = "       PRINT [#FileNumber%,]Value"
 HelpText$(60) = "Write data to the screen or to a file."
 HelpText$(61) = "       REBOOT"
 HelpText$(62) = "Reboot the computer."
 HelpText$(63) = "       REM Comment."
 HelpText$(64) = "Allows explanatory remarks to be inserted in a program."
 HelpText$(65) = "       RETURN"
 HelpText$(66) = "Return form the GO SUB subroutine."
 HelpText$(67) = "       RMDIR DirectoryName$"
 HelpText$(68) = "Removes a subdirectory."
 HelpText$(69) = "       RUN"
 HelpText$(70) = "Run current program."
 HelpText$(71) = "       SAVE FileName$"
 HelpText$(72) = "Save's current program to the disk text file."
 HelpText$(73) = "       SCREEN FOURTY|EIGHTY"
 HelpText$(74) = "If argument is: FOURTY, then sets screen resolution on: 40x25, else"
 HelpText$(75) = "- 80x25."
 HelpText$(76) = "       SOUND Frequency% WITH Duration%"
 HelpText$(77) = "Generates a sound through your computer's speaker. The frequency of"
 HelpText$(78) = "the sound in hertz; a value in the range 37 through 32767. The"
 HelpText$(79) = "number of system clock ticks the sound lasts; a value in the range"
 HelpText$(80) = "0 through 65535. There are 18.20648193359375 clock ticks per"
 HelpText$(81) = "second."
 HelpText$(82) = "       SWAP Variable AS Variable"
 HelpText$(83) = "Swap variable values."
 HelpText$(84) = "       SYSTEM"
 HelpText$(85) = "Closes all open files and returns control to the operating system."
 HelpText$(86) = "       TROFF"
 HelpText$(87) = "Turn to off trace mode."
 HelpText$(88) = "       TRON"
 HelpText$(89) = "Turn to on trace mode."
 HelpText$(90) = "       TRACE"
 HelpText$(91) = "Trace current program in the debug mode."
 HelpText$(92) = "       WHILE Conditional%"
 HelpText$(93) = "       WEND"
 HelpText$(94) = "Executes a series of statements as long as a specified condition is"
 HelpText$(95) = "true."
 HelpText$(96) = "System variables:"
 HelpText$(97) = "       DATE$"
 HelpText$(98) = "The DATE$ system variable contain the computer's current system"
 HelpText$(99) = "date in the format: MM-DD-YYYY."
 HelpText$(100) = "       PROMPT$"
 HelpText$(101) = "This variable contain the interpretter prompt."
 HelpText$(102) = "       TIME$"
 HelpText$(103) = "The TIME$ system variable contain the computer's current system"
 HelpText$(104) = "time in the format: HH:MM:SS."
 HelpText$(105) = "       RANDOM"
 HelpText$(106) = "If get value from this variable, then getting a single - precision"
 HelpText$(107) = "random number between 0 and 1. If set value to this variable, then"
 HelpText$(108) = "initializes the random - number generator."
 HelpText$(109) = "       ENVIRONMENT$"
 HelpText$(110) = "If set value to this system variable, then changes or adds an"
 HelpText$(111) = "environment string in the DOS environment table. Assigned value"
 HelpText$(112) = "must be:"
 HelpText$(113) = "VariableName=Value"
 HelpText$(114) = "Constants:"
 HelpText$(115) = "       FALSE%=0,TRUE%=-1,PI#=3.1415926535897932384626433832795,"
 HelpText$(116) = "       BLACK%=0,BLUE%=1,BRIGHTWHITE%=15,BROWN%=6,CYAN%=3,GRAY%=8,"
 HelpText$(117) = "       GREEN%=2,LIGHTBLUE%=9,LIGHTCYAN%=11,LIGHTGREEN%=10,"
 HelpText$(118) = "       LIGHTMAGENTA%=13,LIGHTRED%=12,MAGENTA%=5,RED%=4,WHITE%=7,"
 HelpText$(119) = "       YELLOW%=14"
 HelpText$(120) = "String functions:"
 HelpText$(121) = "       CHR$(SymbolCode%)"
 HelpText$(122) = "Returns the character corresponding to a specified ASCII code."
 HelpText$(123) = "       DAYNAME$(DayNumber%)"
 HelpText$(124) = "Returns the day name (1-Monday,... 7-Sunday)."
 HelpText$(125) = "       DAYOFWEEKNAME$(Day%,Month%,Year%)"
 HelpText$(126) = "Return day of the week name."
 HelpText$(127) = "       ENVIRONMENT$(VariableName$|VariableNumber%)"
 HelpText$(128) = "Returns a DOS environment string."
 HelpText$(129) = "       HEX$(Value%)"
 HelpText$(130) = "Returns a hexadecimal string representation of a number."
 HelpText$(131) = "       INKEY$"
 HelpText$(132) = "Reads a character from the keyboard. INKEY$ returns a null string"
 HelpText$(133) = "if there is no character to return. For standard keys, INKEY$"
 HelpText$(134) = "returns a 1-byte length string containing the character read. For"
 HelpText$(135) = "extended keys, INKEY$ returns a 2-byte string made up of the null"
 HelpText$(136) = "character (ASCII 0) and the keyboard scan code."
 HelpText$(137) = "       INPUT$[(#FileNumber%)]"
 HelpText$(138) = "Returns a string of characters read from a specified file, or, if"
 HelpText$(139) = "file number in parenthis is not specified, returns the string of"
 HelpText$(140) = "characters read from a keyboard."
 HelpText$(141) = "       LCASE$(Line$)"
 HelpText$(142) = "Convert strings to all lowercase letters."
 HelpText$(143) = "       LTRIM$(Line$)"
 HelpText$(144) = "Remove leading spaces from a string."
 HelpText$(145) = "       LEFT$(Line$,Count%)"
 HelpText$(146) = "Return a specified number of leftmost or rightmost characters in a"
 HelpText$(147) = "string."
 HelpText$(148) = "       MAX$(Line$[,Line$...])"
 HelpText$(149) = "Return the maximal line."
 HelpText$(150) = "       MID$(Line$,Position%,Count%)"
 HelpText$(151) = "The MID$ function returns part of a string (a substring)."
 HelpText$(152) = "       MIN$(Line$[,Line$...])"
 HelpText$(153) = "Return the minimal line."
 HelpText$(154) = "       MONTHNAME$(MonthNumber%)"
 HelpText$(155) = "Returns the month name (1-January,... 12-December)."
 HelpText$(156) = "       OCT$(Number%)"
 HelpText$(157) = "Returns an octal string representation of a number."
 HelpText$(158) = "       RTRIM$(Line$)"
 HelpText$(159) = "Remove trailing spaces from a string."
 HelpText$(160) = "       RIGHT$(Line$,Count%)"
 HelpText$(161) = "Return a specified number of leftmost or rightmost characters in a"
 HelpText$(162) = "string."
 HelpText$(163) = "       SPACE$(Count%)"
 HelpText$(164) = "Returns a string of spaces."
 HelpText$(165) = "       STR$(Value#)"
 HelpText$(166) = "Returns a string representation of a number."
 HelpText$(167) = "       STRING$(Count%,Line$|SymbolCode%)"
 HelpText$(168) = "Returns a string of a specified length made up of a repeating"
 HelpText$(169) = "character."
 HelpText$(170) = "       TRIM$(Line$)"
 HelpText$(171) = "Returns the string without leading and trailing spaces."
 HelpText$(172) = "       UCASE$(Line$)"
 HelpText$(173) = "Convert strings to all uppercase letters."
 HelpText$(174) = "Numeric functions:"
 HelpText$(175) = "       ATN(Value#)"
 HelpText$(176) = "Returns the arctangent of a specified numeric expression."
 HelpText$(177) = "       ABS(Value#)"
 HelpText$(178) = "Returns the absolute value of a number."
 HelpText$(179) = "       ASC(Line$)"
 HelpText$(180) = "Returns the ASCII code for the first character in a string"
 HelpText$(181) = "expression."
 HelpText$(182) = "       AVG(Value#[,Value#...])"
 HelpText$(183) = "Returns the average value of arguments."
 HelpText$(184) = "       COS(Value#)"
 HelpText$(185) = "Returns the cosine of a specified numeric expression."
 HelpText$(186) = "       CRC(Line$)"
 HelpText$(187) = "Returns the CRC-32 code of line."
 HelpText$(188) = "       CSRLIN"
 HelpText$(189) = "Returns the current row position of the cursor."
 HelpText$(190) = "       DAYOFWEEK(Day%,Month%,Year%)"
 HelpText$(191) = "Return the day of week number (1-Monday,... 7-Sunday)."
 HelpText$(192) = "       EOF(#FileNumber%)"
 HelpText$(193) = "Tests for the end of a file. EOF returns true (nonzero) if the end"
 HelpText$(194) = "of a file has been reached."
 HelpText$(195) = "       EXP(Value#)"
 HelpText$(196) = "EXP returns e raised to a specified power, where e is the base of"
 HelpText$(197) = "natural logarithms."
 HelpText$(198) = "       FIX(Value#)"
 HelpText$(199) = "Truncates a floating-point expression to its integer portion."
 HelpText$(200) = "       INSTR(Line$,SubLine$)"
 HelpText$(201) = "Returns the position of the first occurrence of a string in another"
 HelpText$(202) = "string."
 HelpText$(203) = "       INT(Value#)"
 HelpText$(204) = "Returns the largest integer less than or equal to a numeric"
 HelpText$(205) = "expression."
 HelpText$(206) = "       ISLEAPYEAR(Year%)"
 HelpText$(207) = "Returns the True, if year is leap, and False if year is not leap."
 HelpText$(208) = "       LEN(Line$)"
 HelpText$(209) = "Returns the number of characters in a string."
 HelpText$(210) = "       LOF(#FileNumber%)"
 HelpText$(211) = "Returns the length of a file in bytes."
 HelpText$(212) = "       LOG(Value#)"
 HelpText$(213) = "Returns the natural logarithm of a numeric expression."
 HelpText$(214) = "       MAX(Value#[,Value#...])"
 HelpText$(215) = "Returns the maximal value."
 HelpText$(216) = "       MIN(Value#[,Value#...])"
 HelpText$(217) = "Returns the minimal value."
 HelpText$(218) = "       POS(AnyExpressionOfAnyType)"
 HelpText$(219) = "Returns the current column position of the cursor."
 HelpText$(220) = "       SCREEN(Row%,Column%,SYMBOL|COLOR)"
 HelpText$(221) = "Returns the ASCII value or color attribute of a character at a"
 HelpText$(222) = "specified screen location."
 HelpText$(223) = "       SGN(Value#)"
 HelpText$(224) = "Returns a value indicating the sign of a numeric expression (1 if"
 HelpText$(225) = "the expression is positive, 0 if it is zero, or -1 if it is"
 HelpText$(226) = "negative)."
 HelpText$(227) = "       SIN(Value#)"
 HelpText$(228) = "Returns the sine of a specified angle."
 HelpText$(229) = "       SQR(Value#)"
 HelpText$(230) = "Returns the square root of a numeric expression."
 HelpText$(231) = "       TAN(Value#)"
 HelpText$(232) = "Returns the tangent of a specified angle."
 HelpText$(233) = "       TIMER"
 HelpText$(234) = "Returns the number of seconds elapsed since midnight."
 HelpText$(235) = "       VAL(Line$)"
 HelpText$(236) = "Converts a string representation of a number to a number."
 HelpText$(237) = "       WEEKNUMBER(Day%,Month%,Year%)"
 HelpText$(238) = "Returns the week number for the specified date from the start of"
 HelpText$(239) = "the specified year."
 HelpText$(240) = "Operators:"
 HelpText$(241) = "       Meaning[!|@|#|%|&]   *   Meaning[!|@|#|%|&]"
 HelpText$(242) = "       Meaning[!|@|#|$|%|&] +   Meaning[!|@|#|%|&]"
 HelpText$(243) = "       Meaning[!|@|#|%|&]   -   Meaning[!|@|#|%|&]"
 HelpText$(244) = "       Meaning[!|@|#|%|&]   \   Meaning[!|@|#|%|&]"
 HelpText$(245) = "       Meaning[!|@|#|%|&]   /   Meaning[!|@|#|%|&]"
 HelpText$(246) = "       Meaning[!|@|#|%|&]   ^   Meaning[!|@|#|%|&]"
 HelpText$(247) = "       Meaning[!|@|#|$|%|&] =   Meaning[!|@|#|$|%|&]"
 HelpText$(248) = "       Meaning[!|@|#|$|%|&] <>  Meaning[!|@|#|$|%|&]"
 HelpText$(249) = "       Meaning[!|@|#|$|%|&] <   Meaning[!|@|#|$|%|&]"
 HelpText$(250) = "       Meaning[!|@|#|$|%|&] >   Meaning[!|@|#|$|%|&]"
 HelpText$(251) = "       Meaning[!|@|#|$|%|&] <=  Meaning[!|@|#|$|%|&]"
 HelpText$(252) = "       Meaning[!|@|#|$|%|&] =>  Meaning[!|@|#|$|%|&]"
 HelpText$(253) = "       Meaning[!|@|#|$|%|&] =<  Meaning[!|@|#|$|%|&]"
 HelpText$(254) = "       Meaning[!|@|#|$|%|&] >=  Meaning[!|@|#|$|%|&]"
 HelpText$(255) = "       Meaning[!|@|#|%|&]   AND Meaning[!|@|#|%|&]"
 HelpText$(256) = "       Meaning[!|@|#|%|&]   MOD Meaning[!|@|#|%|&]"
 HelpText$(257) = "       Meaning[!|@|#|%|&]   OR  Meaning[!|@|#|%|&]"
 HelpText$(258) = "       Meaning[!|@|#|%|&]   XOR Meaning[!|@|#|%|&]"
 HelpText$(259) = "                            NOT Meaning[!|@|#|%|&]"
 HelpText$(260) = "System settings:"
 HelpText$(261) = "       BASIC lines numbers range: 1 - " + LTRIM$(STR$(BASICLinesCount%)) + "."
 HelpText$(262) = "       Maximal count of user - defined functions (DEF FN) is: " + LTRIM$(STR$(DefFnSCount%)) + "."
 HelpText$(263) = "       Maximal count of arguments for the user - defined"
 HelpText$(264) = "       function is: " + LTRIM$(STR$(DefFnSArgsCount%)) + "."
 HelpText$(265) = "       Maximal count of variables is: " + LTRIM$(STR$(VariablesCount%)) + "."
 HelpText$(266) = "       File numbers range is: 1 - " + LTRIM$(STR$(FilesCount%)) + "."
 HelpText$(267) = "       Maximal count of WHILE cycles running per one time is: " + LTRIM$(STR$(WhilesCount%)) + "."
 HelpText$(268) = "       Maximal count of FROM cycles running per one time is: " + LTRIM$(STR$(FromsCount%)) + "."
 HelpText$(269) = "       Maximal count of called per one time GO SUB subroutines"
 HelpText$(270) = "       is: " + LTRIM$(STR$(GoSubSCount%)) + "."
 HelpText$(271) = "       Maximal arguments count for ANSI sequences is: " + LTRIM$(STR$(ArgumentsCount%)) + "."
 HelpText$(272) = "Notes:"
 HelpText$(273) = "1.). In this BASIC language interpretter have internal ANSI escape"
 HelpText$(274) = "     sequences interpretter, and so on, you can include ANSI escape"
 HelpText$(275) = "     sequences into the outputted text for output to the screen"
 HelpText$(276) = "     with the PRINT statement."
 HelpText$(277) = "2.). Maximal length of all lines are 256 symbols."
 HelpText$(278) = "####################################################################"
 HelpText$(279) = "             The Personal BASIC Language Interpretter."
 HelpText$(280) = "              Copyright (C) Sandul Yura Valentinovich."
 HelpText$(281) = "    (W) Sunday, 27 April 2003 year - Tuesday, 20 May 2003 year."
 COLOR White%, Black%
 CLS
 LOCATE 1, 1, 1, 7, 8
 PageIndex% = 0
 FOR Index% = 1 TO 281
  PRINT HelpText$(Index%)
  PageIndex% = PageIndex% + 1
  IF PageIndex% = 23 THEN
   PageIndex% = 0
   PRINT "ENTER=Continue, ESC=Exit.";
   DO
    Key$ = INKEY$
   LOOP UNTIL (Key$ = CHR$(13)) OR (Key$ = CHR$(27))
   PRINT
   IF Key$ = CHR$(27) THEN EXIT FOR
  END IF
 NEXT Index%
END SUB

FUNCTION InDefFn$ (DefFnName$, DefFnType%, InLine$)
 DIM Index%
 DIM WorkDefFn$
 DIM OldDefFnMode%
 DIM WorkLine$
 DIM Work%
 IF DefFnSCountValue% = 0 THEN ERROR 15
 FOR Index% = 1 TO DefFnSCountValue% + 1
  IF Index% = DefFnSCountValue% + 1 THEN ERROR 15
  WorkDefFn$ = DefFnS$(Index%)
  WorkLine$ = InName$(WorkDefFn$)
  WorkDefFn$ = LTRIM$(WorkDefFn$)
  Work% = False%
  SELECT CASE LEFT$(WorkDefFn$, 1)
  CASE "$"
    Work% = True%
    WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
  CASE "!"
    WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
  CASE "@"
    WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
  CASE "#"
    WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
  CASE "%"
    WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
  CASE "&"
    WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
  END SELECT
  IF (WorkLine$ = DefFnName$) AND (Work% = DefFnType%) THEN EXIT FOR
 NEXT Index%
 IF CurrentDefFn% = DefFnSCount% THEN ERROR 21
 CurrentDefFn% = CurrentDefFn% + 1
 DefFnSArgsCountValue%(CurrentDefFn%) = 0
 FOR Index% = 1 TO DefFnSArgsCount%
  DefFnSArgs$(CurrentDefFn%, Index%) = ""
 NEXT Index%
 IF LEFT$(WorkDefFn$, 1) = "(" THEN
  WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
  DefFnSArgsCountValue%(CurrentDefFn%) = 1
  DO WHILE WorkDefFn$ <> ""
   WorkLine$ = InName$(WorkDefFn$)
   WorkDefFn$ = LTRIM$(WorkDefFn$)
   Work% = False%
   SELECT CASE LEFT$(WorkDefFn$, 1)
   CASE "$"
     Work% = True%
     WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
   CASE "!"
     WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
   CASE "@"
     WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
   CASE "#"
     WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
   CASE "%"
     WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
   CASE "&"
     WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
   END SELECT
   DefFnSArgs$(CurrentDefFn%, DefFnSArgsCountValue%(CurrentDefFn%)) = WorkLine$ + "[" + LTRIM$(STR$(ABS(Work%))) + "]="
   SELECT CASE LEFT$(WorkDefFn$, 1)
   CASE ","
     IF DefFnSArgsCountValue%(CurrentDefFn%) = DefFnSArgsCount% THEN ERROR 22
     WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
     DefFnSArgsCountValue%(CurrentDefFn%) = DefFnSArgsCountValue%(CurrentDefFn%) + 1
   CASE ")"
     EXIT DO
   CASE ELSE
     ERROR 2
   END SELECT
  LOOP
  IF DefFnSArgs$(CurrentDefFn%, DefFnSArgsCountValue%(CurrentDefFn%)) = "" THEN ERROR 2
  IF LEFT$(WorkDefFn$, 1) <> ")" THEN ERROR 2
  WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
  InLine$ = LTRIM$(InLine$)
  IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
  InLine$ = LTRIM$(MID$(InLine$, 2))
  Index% = 1
  DO WHILE InLine$ <> ""
   WorkLine$ = Calculate$(InLine$)
   IF ABS(NumStr%) <> VAL(MID$(DefFnSArgs$(CurrentDefFn%, Index%), INSTR(DefFnSArgs$(CurrentDefFn%, Index%), "[") + 1, 1)) THEN ERROR 13
   DefFnSArgs$(CurrentDefFn%, Index%) = DefFnSArgs$(CurrentDefFn%, Index%) + WorkLine$
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE ","
     IF Index% = DefFnSArgsCountValue%(CurrentDefFn%) THEN ERROR 37
     InLine$ = MID$(InLine$, 2)
     Index% = Index% + 1
   CASE ")"
     IF Index% <> DefFnSArgsCountValue%(CurrentDefFn%) THEN ERROR 37
     EXIT DO
   CASE ELSE
     ERROR 2
   END SELECT
  LOOP
  IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
  InLine$ = MID$(InLine$, 2)
 END IF
 IF LEFT$(WorkDefFn$, 1) <> "=" THEN ERROR 2
 WorkDefFn$ = MID$(WorkDefFn$, 2)
 OldDefFnMode% = DefFnMode%
 DefFnMode% = True%
 InDefFn$ = Calculate$(WorkDefFn$)
 IF NumStr% <> DefFnType% THEN ERROR 13
 DefFnMode% = OldDefFnMode%
 DefFnSArgsCountValue%(CurrentDefFn%) = 0
 FOR Index% = 1 TO DefFnSArgsCount%
  DefFnSArgs$(CurrentDefFn%, Index%) = ""
 NEXT Index%
 CurrentDefFn% = CurrentDefFn% - 1
END FUNCTION

FUNCTION InMeaning$ (InLine$)
 DIM Crc32Table&(256)
 DIM Crc&
 DIM CrcIndex%
 DIM Count%
 DIM Index%
 DIM WorkValue%
 DIM Result$
 DIM Value$
 DIM Meaning$
 DIM WorkName$
 InLine$ = LTRIM$(InLine$)
 SELECT CASE LEFT$(UCASE$(InLine$), 1)
 CASE CHR$(34)
   InLine$ = MID$(InLine$, 2)
   IF INSTR(InLine$, CHR$(34)) = 0 THEN ERROR 2
   InMeaning$ = MID$(InLine$, 1, INSTR(InLine$, CHR$(34)) - 1)
   InLine$ = MID$(InLine$, INSTR(InLine$, CHR$(34)) + 1)
   NumStr% = True%
 CASE "+"
   InLine$ = LTRIM$(MID$(InLine$, 2))
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   InMeaning$ = LTRIM$(STR$(0# + VAL(Result$)))
 CASE "-"
   InLine$ = LTRIM$(MID$(InLine$, 2))
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   InMeaning$ = LTRIM$(STR$(0# - VAL(Result$)))
 CASE "."
   NumStr% = False%
   InMeaning$ = LTRIM$(STR$(InNumber#(InLine$)))
 CASE "&"
   NumStr% = False%
   InMeaning$ = LTRIM$(STR$(InNumber#(InLine$)))
 CASE "0" TO "9"
   NumStr% = False%
   InMeaning$ = LTRIM$(STR$(InNumber#(InLine$)))
 CASE "("
   InLine$ = MID$(InLine$, 2)
   InMeaning$ = Calculate$(InLine$)
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
 CASE "A" TO "Z"
   WorkName$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   IF WorkName$ = "NOT" THEN
    Result$ = Calculate$(InLine$)
    IF NumStr% THEN ERROR 13
    InMeaning$ = LTRIM$(STR$(NOT VAL(Result$)))
   ELSE
    NumStr% = False%
    SELECT CASE LEFT$(InLine$, 1)
    CASE "$"
      NumStr% = True%
      InLine$ = LTRIM$(MID$(InLine$, 2))
    CASE "!"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    CASE "@"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    CASE "#"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    CASE "%"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    CASE "&"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    END SELECT
    IF NumStr% THEN
     SELECT CASE WorkName$
     CASE "CHR"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = CHR$(VAL(Result$))
       NumStr% = True%
     CASE "DATE"
       InMeaning$ = DATE$
     CASE "DAYNAME"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = DayName$(VAL(Result$))
       NumStr% = True%
     CASE "DAYOFWEEKNAME"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Meaning$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF (VAL(Meaning$) < 0) OR (VAL(Meaning$) > 32767) THEN ERROR 85
       IF (VAL(Value$) < 1) OR (VAL(Value$) > 12) THEN ERROR 86
       IF (VAL(Result$) < 1) OR (VAL(Result$) > MonthDaysCount%(VAL(Value$), VAL(Meaning$))) THEN ERROR 87
       InMeaning$ = DayName$(DayOfWeek%(VAL(Result$), VAL(Value$), VAL(Meaning$)))
       NumStr% = True%
     CASE "ENVIRONMENT"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF NumStr% THEN InMeaning$ = ENVIRON$(Result$) ELSE InMeaning$ = ENVIRON$(VAL(Result$))
       NumStr% = True%
     CASE "HEX"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = HEX$(VAL(Result$))
       NumStr% = True%
     CASE "INKEY"
       InMeaning$ = INKEY$
     CASE "INPUT"
       IF LEFT$(InLine$, 1) = "(" THEN
        InLine$ = LTRIM$(MID$(InLine$, 2))
        IF LEFT$(InLine$, 1) <> "#" THEN ERROR 2
        InLine$ = MID$(InLine$, 2)
        Result$ = Calculate$(InLine$)
        IF NumStr% THEN ERROR 13
        InLine$ = LTRIM$(InLine$)
        IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
        InLine$ = MID$(InLine$, 2)
        IF (INT(VAL(Result$)) < 1) OR (INT(VAL(Result$)) > FilesCount%) THEN ERROR 52
        IF OpenFiles$(INT(VAL(Result$))) = "" THEN ERROR 52
        IF MID$(OpenFiles$(INT(VAL(Result$))), 1, INSTR(OpenFiles$(INT(VAL(Result$))), "=") - 1) = "OUT" THEN ERROR 54
        LINE INPUT #INT(VAL(Result$)), Result$
        NumStr% = True%
       ELSE
        LINE INPUT Result$
       END IF
       InMeaning$ = Result$
     CASE "LCASE"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LCASE$(Result$)
     CASE "LTRIM"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(Result$)
     CASE "LEFT"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LEFT$(Result$, VAL(Value$))
       NumStr% = True%
     CASE "MAX"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       DO WHILE InLine$ <> ""
        SELECT CASE LEFT$(InLine$, 1)
        CASE ","
          InLine$ = MID$(InLine$, 2)
          Value$ = Calculate$(InLine$)
          IF NOT NumStr% THEN ERROR 13
          InLine$ = LTRIM$(InLine$)
          IF Value$ > Result$ THEN Result$ = Value$
        CASE ")"
          EXIT DO
        CASE ELSE
          ERROR 2
        END SELECT
       LOOP
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = Result$
     CASE "MID"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Meaning$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = MID$(Result$, VAL(Value$), VAL(Meaning$))
       NumStr% = True%
     CASE "MIN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       DO WHILE InLine$ <> ""
        SELECT CASE LEFT$(InLine$, 1)
        CASE ","
          InLine$ = MID$(InLine$, 2)
          Value$ = Calculate$(InLine$)
          IF NOT NumStr% THEN ERROR 13
          InLine$ = LTRIM$(InLine$)
          IF Value$ < Result$ THEN Result$ = Value$
        CASE ")"
          EXIT DO
        CASE ELSE
          ERROR 2
        END SELECT
       LOOP
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = Result$
     CASE "MONTHNAME"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = MonthName$(VAL(Result$))
       NumStr% = True%
     CASE "OCT"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = OCT$(VAL(Result$))
       NumStr% = True%
     CASE "PROMPT"
       InMeaning$ = Prompt$
     CASE "RTRIM"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = RTRIM$(Result$)
     CASE "RIGHT"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = RIGHT$(Result$, VAL(Value$))
       NumStr% = True%
     CASE "SPACE"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = SPACE$(VAL(Result$))
       NumStr% = True%
     CASE "STR"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(VAL(Result$)))
       NumStr% = True%
     CASE "STRING"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = Calculate$(InLine$)
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF NumStr% THEN InMeaning$ = STRING$(VAL(Result$), Value$) ELSE InMeaning$ = STRING$(VAL(Result$), VAL(Value$))
       NumStr% = True%
     CASE "TIME"
       InMeaning$ = TIME$
     CASE "TRIM"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(RTRIM$(Result$))
     CASE "UCASE"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = UCASE$(Result$)
     CASE ELSE
       IF LEFT$(WorkName$, 2) = "FN" THEN InMeaning$ = InDefFn$(WorkName$, True%, InLine$) ELSE InMeaning = InVariable$(WorkName$, True%)
       IF NOT NumStr% THEN ERROR 13
     END SELECT
    ELSE
     SELECT CASE WorkName$
     CASE "FALSE"
       InMeaning$ = LTRIM$(STR$(False%))
     CASE "TRUE"
       InMeaning$ = LTRIM$(STR$(True%))
     CASE "PI"
       InMeaning$ = "3.1415926535897932384626433832795"
     CASE "BLACK"
       InMeaning$ = LTRIM$(STR$(Black%))
     CASE "BLUE"
       InMeaning$ = LTRIM$(STR$(Blue%))
     CASE "BRIGHTWHITE"
       InMeaning$ = LTRIM$(STR$(BrightWhite%))
     CASE "BROWN"
       InMeaning$ = LTRIM$(STR$(Brown%))
     CASE "CYAN"
       InMeaning$ = LTRIM$(STR$(Cyan%))
     CASE "GRAY"
       InMeaning$ = LTRIM$(STR$(Gray%))
     CASE "GREEN"
       InMeaning$ = LTRIM$(STR$(Green%))
     CASE "LIGHTBLUE"
       InMeaning$ = LTRIM$(STR$(LightBlue%))
     CASE "LIGHTCYAN"
       InMeaning$ = LTRIM$(STR$(LightCyan%))
     CASE "LIGHTGREEN"
       InMeaning$ = LTRIM$(STR$(LightGreen%))
     CASE "LIGHTMAGENTA"
       InMeaning$ = LTRIM$(STR$(LightMagenta%))
     CASE "LIGHTRED"
       InMeaning$ = LTRIM$(STR$(LightRed%))
     CASE "MAGENTA"
       InMeaning$ = LTRIM$(STR$(Magenta%))
     CASE "RED"
       InMeaning$ = LTRIM$(STR$(Red%))
     CASE "WHITE"
       InMeaning$ = LTRIM$(STR$(White%))
     CASE "YELLOW"
       InMeaning$ = LTRIM$(STR$(Yellow%))
     CASE "ATN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(ATN(VAL(Result$))))
     CASE "ABS"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(ABS(VAL(Result$))))
     CASE "ASC"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF Result$ = "" THEN ERROR 5
       InMeaning$ = LTRIM$(STR$(ASC(Result$)))
       NumStr% = False%
     CASE "AVG"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       Count% = 1
       InLine$ = LTRIM$(InLine$)
       DO WHILE InLine$ <> ""
        SELECT CASE LEFT$(InLine$, 1)
        CASE ","
          InLine$ = MID$(InLine$, 2)
          Value$ = Calculate$(InLine$)
          IF NumStr% THEN ERROR 13
          InLine$ = LTRIM$(InLine$)
          Result$ = LTRIM$(STR$(VAL(Result$) + VAL(Value$)))
          Count% = Count% + 1
        CASE ")"
          EXIT DO
        CASE ELSE
          ERROR 2
        END SELECT
       LOOP
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(VAL(Result$) / Count%))
     CASE "COS"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(COS(VAL(Result$))))
     CASE "CRC"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       FOR Index% = 1 TO 256
        Crc& = Index% - 1
        FOR CrcIndex% = 1 TO 8
         IF ((INT(Crc& / 2) * 2) <> Crc&) THEN Crc& = INT(Crc& / 2) XOR &HEDB88320 ELSE Crc& = INT(Crc& / 2)
        NEXT CrcIndex%
        Crc32Table&(Index%) = Crc&
       NEXT Index%
       Crc& = &HFFFFFFFF
       WHILE Result$ <> ""
        WorkValue% = ABS((Crc& MOD &H100) XOR ASC(Result$))
        Result$ = MID$(Result$, 2)
        IF WorkValue% < 0 THEN WorkValue% = 0
        IF WorkValue% > 255 THEN WorkValue% = 255
        Crc& = Crc32Table&(WorkValue% + 1) XOR INT(Crc& / &H100)
       WEND
       InMeaning$ = LTRIM$(STR$(Crc&))
       NumStr% = False%
     CASE "CSRLIN"
       InMeaning$ = LTRIM$(STR$(CSRLIN))
     CASE "DAYOFWEEK"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Meaning$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF (VAL(Meaning$) < 0) OR (VAL(Meaning$) > 32767) THEN ERROR 85
       IF (VAL(Value$) < 1) OR (VAL(Value$) > 12) THEN ERROR 86
       IF (VAL(Result$) < 1) OR (VAL(Result$) > MonthDaysCount%(VAL(Value$), VAL(Meaning$))) THEN ERROR 87
       InMeaning$ = LTRIM$(STR$(DayOfWeek%(VAL(Result$), VAL(Value$), VAL(Meaning$))))
     CASE "EOF"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = LTRIM$(MID$(InLine$, 2))
       IF LEFT$(InLine$, 1) <> "#" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF (INT(VAL(Result$)) < 1) OR (INT(VAL(Result$)) > FilesCount%) THEN ERROR 52
       IF OpenFiles$(INT(VAL(Result$))) = "" THEN ERROR 52
       IF MID$(OpenFiles$(INT(VAL(Result$))), 1, INSTR(OpenFiles$(INT(VAL(Result$))), "=") - 1) = "OUT" THEN ERROR 54
       IF EOF(INT(VAL(Result$))) THEN InMeaning$ = LTRIM$(STR$(True%)) ELSE InMeaning$ = LTRIM$(STR$(False%))
     CASE "EXP"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(EXP(VAL(Result$))))
     CASE "FIX"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(FIX(VAL(Result$))))
     CASE "INSTR"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(INSTR(Result$, Value$)))
       NumStr% = False%
     CASE "INT"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(INT(VAL(Result$))))
     CASE "ISLEAPYEAR"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF (INT(INT(VAL(Result$)) / 4) * 4) = INT(VAL(Result$)) THEN InMeaning$ = LTRIM$(STR$(True%)) ELSE InMeaning$ = LTRIM$(STR$(False%))
     CASE "LEN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(LEN(Result$)))
       NumStr% = False%
     CASE "LOF"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = LTRIM$(MID$(InLine$, 2))
       IF LEFT$(InLine$, 1) <> "#" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF (INT(VAL(Result$)) < 1) OR (INT(VAL(Result$)) > FilesCount%) THEN ERROR 52
       IF OpenFiles$(INT(VAL(Result$))) = "" THEN ERROR 52
       InMeaning$ = LTRIM$(STR$(LOF(INT(VAL(Result$)))))
     CASE "LOG"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(LOG(VAL(Result$))))
     CASE "MAX"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       DO WHILE InLine$ <> ""
        SELECT CASE LEFT$(InLine$, 1)
        CASE ","
          InLine$ = MID$(InLine$, 2)
          Value$ = Calculate$(InLine$)
          IF NumStr% THEN ERROR 13
          InLine$ = LTRIM$(InLine$)
          IF VAL(Value$) > VAL(Result$) THEN Result$ = LTRIM$(STR$(VAL(Value$)))
        CASE ")"
          EXIT DO
        CASE ELSE
          ERROR 2
        END SELECT
       LOOP
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = Result$
     CASE "MIN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       DO WHILE InLine$ <> ""
        SELECT CASE LEFT$(InLine$, 1)
        CASE ","
          InLine$ = MID$(InLine$, 2)
          Value$ = Calculate$(InLine$)
          IF NumStr% THEN ERROR 13
          InLine$ = LTRIM$(InLine$)
          IF VAL(Value$) < VAL(Result$) THEN Result$ = LTRIM$(STR$(VAL(Value$)))
        CASE ")"
          EXIT DO
        CASE ELSE
          ERROR 2
        END SELECT
       LOOP
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = Result$
     CASE "POS"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(POS(0)))
       NumStr% = False%
     CASE "RANDOM"
       InMeaning$ = LTRIM$(STR$(RND))
     CASE "SCREEN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Meaning$ = InName$(InLine$)
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       SELECT CASE Meaning$
       CASE "SYMBOL"
         InMeaning$ = LTRIM$(STR$(SCREEN(VAL(Result$), VAL(Value$), 0)))
       CASE "COLOR"
         InMeaning$ = LTRIM$(STR$(SCREEN(VAL(Result$), VAL(Value$), 1)))
       CASE ELSE
         ERROR 2
       END SELECT
     CASE "SGN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(SGN(VAL(Result$))))
     CASE "SIN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(SIN(VAL(Result$))))
     CASE "SQR"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(SquareRoot#(VAL(Result$))))
     CASE "TAN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(TAN(VAL(Result$))))
     CASE "TIMER"
       InMeaning$ = LTRIM$(STR$(TIMER))
     CASE "VAL"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(VAL(Result$)))
       NumStr% = False%
     CASE "WEEKNUMBER"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Meaning$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF (VAL(Meaning$) < 0) OR (VAL(Meaning$) > 32767) THEN ERROR 85
       IF (VAL(Value$) < 1) OR (VAL(Value$) > 12) THEN ERROR 86
       IF (VAL(Result$) < 1) OR (VAL(Result$) > MonthDaysCount%(VAL(Value$), VAL(Meaning$))) THEN ERROR 87
       InMeaning$ = LTRIM$(STR$(WeekNumber%(VAL(Result$), VAL(Value$), VAL(Meaning$))))
     CASE ELSE
       IF LEFT$(WorkName$, 2) = "FN" THEN InMeaning$ = InDefFn$(WorkName$, False%, InLine$) ELSE InMeaning = InVariable$(WorkName$, False%)
       IF NumStr% THEN ERROR 13
     END SELECT
    END IF
   END IF
 CASE ELSE
   ERROR 2
 END SELECT
END FUNCTION

FUNCTION InName$ (InLine$)
 DIM OutName$
 OutName$ = ""
 InLine$ = LTRIM$(InLine$)
 DO WHILE InLine$ <> ""
  SELECT CASE LEFT$(UCASE$(InLine$), 1)
  CASE "A" TO "Z"
    OutName$ = OutName$ + LEFT$(UCASE$(InLine$), 1)
    InLine$ = MID$(InLine$, 2)
  CASE "0" TO "9"
    OutName$ = OutName$ + LEFT$(InLine$, 1)
    InLine$ = MID$(InLine$, 2)
  CASE ELSE
    EXIT DO
  END SELECT
 LOOP
 IF OutName$ = "" THEN ERROR 2
 InName$ = OutName$
END FUNCTION

FUNCTION InNumber# (InLine$)
 DIM OutNumber$
 DIM PointPresent%
 OutNumber$ = ""
 PointPresent% = False%
 InLine$ = LTRIM$(InLine$)
 SELECT CASE LEFT$(UCASE$(InLine$), 1)
 CASE "&"
   InLine$ = LTRIM$(MID$(InLine$, 2))
   SELECT CASE LEFT$(UCASE$(InLine$), 1)
   CASE "H"
     InLine$ = LTRIM$(MID$(InLine$, 2))
     DO WHILE InLine$ <> ""
      SELECT CASE LEFT$(UCASE$(InLine$), 1)
      CASE "0" TO "9"
        OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
        InLine$ = MID$(InLine$, 2)
      CASE "A" TO "F"
        OutNumber$ = OutNumber$ + LEFT$(UCASE$(InLine$), 1)
        InLine$ = MID$(InLine$, 2)
      CASE "G" TO "Z"
        ERROR 2
      CASE "."
        InLine$ = LTRIM$(MID$(InLine$, 2))
        IF InLine$ = "" THEN ERROR 2
        IF PointPresent% OR ((NOT ((ASC(InLine$) > (ASC("0") - 1)) AND (ASC(InLine$) < (ASC("9") + 1)))) AND (NOT ((ASC(UCASE$(InLine$)) > (ASC("A") - 1)) AND (ASC(UCASE$(InLine$)) < (ASC("F") + 1))))) OR ((ASC(UCASE$(InLine$)) > ASC("G")) AND (ASC(UCASE$(InLine$)) < (ASC("Z") + 1))) THEN ERROR 2
        PointPresent% = True%
        IF OutNumber$ = "" THEN OutNumber$ = "0." ELSE OutNumber$ = OutNumber$ + "."
      CASE ELSE
        EXIT DO
      END SELECT
     LOOP
     IF OutNumber$ = "" THEN ERROR 2
     InNumber# = VAL("&H" + OutNumber$)
   CASE "O"
     InLine$ = LTRIM$(MID$(InLine$, 2))
     DO WHILE InLine$ <> ""
      SELECT CASE LEFT$(InLine$, 1)
      CASE "0" TO "7"
        OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
        InLine$ = MID$(InLine$, 2)
      CASE "8" TO "9"
        ERROR 2
      CASE "."
        InLine$ = LTRIM$(MID$(InLine$, 2))
        IF InLine$ = "" THEN ERROR 2
        IF PointPresent% OR (NOT ((ASC(InLine$) > (ASC("0") - 1)) AND (ASC(InLine$) < (ASC("7") + 1)))) OR ((ASC(InLine$) > (ASC("8") - 1)) AND (ASC(InLine$) < (ASC("9") + 1))) THEN ERROR 2
        PointPresent% = True%
        IF OutNumber$ = "" THEN OutNumber$ = "0." ELSE OutNumber$ = OutNumber$ + "."
      CASE ELSE
        EXIT DO
      END SELECT
     LOOP
     IF OutNumber$ = "" THEN ERROR 2
     InNumber# = VAL("&O" + OutNumber$)
   CASE "0" TO "7"
     DO WHILE InLine$ <> ""
      SELECT CASE LEFT$(InLine$, 1)
      CASE "0" TO "7"
        OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
        InLine$ = MID$(InLine$, 2)
      CASE "8" TO "9"
        ERROR 2
      CASE "."
        InLine$ = LTRIM$(MID$(InLine$, 2))
        IF InLine$ = "" THEN ERROR 2
        IF PointPresent% OR (NOT ((ASC(InLine$) > (ASC("0") - 1)) AND (ASC(InLine$) < (ASC("7") + 1)))) OR ((ASC(InLine$) > (ASC("8") - 1)) AND (ASC(InLine$) < (ASC("9") + 1))) THEN ERROR 2
        PointPresent% = True%
        IF OutNumber$ = "" THEN OutNumber$ = "0." ELSE OutNumber$ = OutNumber$ + "."
      CASE ELSE
        EXIT DO
      END SELECT
     LOOP
     IF OutNumber$ = "" THEN ERROR 2
     InNumber# = VAL("&O" + OutNumber$)
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "0" TO "9"
   DO WHILE InLine$ <> ""
    SELECT CASE LEFT$(InLine$, 1)
    CASE "0" TO "9"
      OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
      InLine$ = MID$(InLine$, 2)
    CASE "."
      InLine$ = LTRIM$(MID$(InLine$, 2))
      IF InLine$ = "" THEN ERROR 2
      IF PointPresent% OR (NOT ((ASC(InLine$) > (ASC("0") - 1)) AND (ASC(InLine$) < (ASC("9") + 1)))) THEN ERROR 2
      PointPresent% = True%
      IF OutNumber$ = "" THEN OutNumber$ = "0." ELSE OutNumber$ = OutNumber$ + "."
    CASE ELSE
      EXIT DO
    END SELECT
   LOOP
   IF OutNumber$ = "" THEN ERROR 2
   InNumber# = VAL(OutNumber$)
 CASE "."
   PointPresent% = True%
   DO WHILE InLine$ <> ""
    SELECT CASE LEFT$(InLine$, 1)
    CASE "0" TO "9"
      OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
      InLine$ = MID$(InLine$, 2)
    CASE "."
      ERROR 2
    CASE ELSE
      EXIT DO
    END SELECT
   LOOP
   IF OutNumber$ = "" THEN ERROR 2
   InNumber# = VAL("0." + OutNumber$)
 CASE ELSE
   ERROR 2
 END SELECT
END FUNCTION

FUNCTION InVariable$ (VariableName$, VariableType%)
 DIM Index%
 IF DefFnMode% THEN
  IF DefFnSArgsCountValue%(CurrentDefFn%) = 0 THEN
   DefFnMode% = False%
   InVariable$ = InVariable$(VariableName$, VariableType%)
   DefFnMode% = True%
  ELSE
   FOR Index% = 1 TO DefFnSArgsCountValue%(CurrentDefFn%) + 1
    IF Index% = DefFnSArgsCountValue%(CurrentDefFn%) + 1 THEN
     DefFnMode% = False%
     InVariable$ = InVariable$(VariableName$, VariableType%)
     DefFnMode% = True%
     EXIT FOR
    END IF
    IF (MID$(DefFnSArgs$(CurrentDefFn%, Index%), 1, INSTR(DefFnSArgs$(CurrentDefFn%, Index%), "[") - 1) = VariableName$) AND (VAL(MID$(DefFnSArgs$(CurrentDefFn%, Index%), INSTR(DefFnSArgs$(CurrentDefFn%, Index%), "[") + 1, 1)) = ABS(VariableType%)) THEN
     InVariable$ = MID$(DefFnSArgs$(CurrentDefFn%, Index%), INSTR(DefFnSArgs$(CurrentDefFn%, Index%), "=") + 1)
     EXIT FOR
    END IF
   NEXT Index%
  END IF
 ELSE
  IF VariablesCountValue% = 0 THEN
   IF VariableType% THEN
    CALL SetVariable(VariableName$, True%, "")
    InVariable$ = ""
   ELSE
    CALL SetVariable(VariableName$, False%, "0.0")
    InVariable$ = "0.0"
   END IF
  ELSE
   FOR Index% = 1 TO VariablesCountValue% + 1
    IF Index% = VariablesCountValue% + 1 THEN
     IF VariableType% THEN
      CALL SetVariable(VariableName$, True%, "")
      InVariable$ = ""
     ELSE
      CALL SetVariable(VariableName$, False%, "0.0")
      InVariable$ = "0.0"
     END IF
     EXIT FOR
    END IF
    IF (MID$(Variables$(Index%), 1, INSTR(Variables$(Index%), "[") - 1) = VariableName$) AND (VAL(MID$(Variables$(Index%), INSTR(Variables$(Index%), "[") + 1, 1)) = ABS(VariableType%)) THEN
     InVariable$ = MID$(Variables$(Index%), INSTR(Variables$(Index%), "=") + 1)
     EXIT FOR
    END IF
   NEXT Index%
  END IF
 END IF
END FUNCTION

FUNCTION LeapYear% (YearValue%)
 LeapYear% = ABS((INT(YearValue% / 4) * 4) = YearValue%)
END FUNCTION

FUNCTION MonthDays% (MonthValue%, YearValue%)
 SELECT CASE MonthValue%
 CASE 1
   MonthDays% = 0
 CASE 2
   MonthDays% = 31
 CASE 3
   MonthDays% = 59 + LeapYear%(YearValue%)
 CASE 4
   MonthDays% = 90 + LeapYear%(YearValue%)
 CASE 5
   MonthDays% = 120 + LeapYear%(YearValue%)
 CASE 6
   MonthDays% = 151 + LeapYear%(YearValue%)
 CASE 7
   MonthDays% = 181 + LeapYear%(YearValue%)
 CASE 8
   MonthDays% = 212 + LeapYear%(YearValue%)
 CASE 9
   MonthDays% = 243 + LeapYear%(YearValue%)
 CASE 10
   MonthDays% = 273 + LeapYear%(YearValue%)
 CASE 11
   MonthDays% = 304 + LeapYear%(YearValue%)
 CASE 12
   MonthDays% = 334 + LeapYear%(YearValue%)
 END SELECT
END FUNCTION

FUNCTION MonthDaysCount% (MonthValue%, YearValue%)
 SELECT CASE MonthValue%
 CASE 1
   MonthDaysCount% = 31
 CASE 2
   MonthDaysCount% = 28 + LeapYear%(YearValue%)
 CASE 3
   MonthDaysCount% = 31
 CASE 4
   MonthDaysCount% = 30
 CASE 5
   MonthDaysCount% = 31
 CASE 6
   MonthDaysCount% = 30
 CASE 7
   MonthDaysCount% = 31
 CASE 8
   MonthDaysCount% = 31
 CASE 9
   MonthDaysCount% = 30
 CASE 10
   MonthDaysCount% = 31
 CASE 11
   MonthDaysCount% = 30
 CASE 12
   MonthDaysCount% = 31
 END SELECT
END FUNCTION

FUNCTION MonthName$ (MonthNumber%)
 SELECT CASE MonthNumber%
 CASE 1
   MonthName$ = "January"
 CASE 2
   MonthName$ = "February"
 CASE 3
   MonthName$ = "March"
 CASE 4
   MonthName$ = "April"
 CASE 5
   MonthName$ = "May"
 CASE 6
   MonthName$ = "June"
 CASE 7
   MonthName$ = "July"
 CASE 8
   MonthName$ = "August"
 CASE 9
   MonthName$ = "September"
 CASE 10
   MonthName$ = "October"
 CASE 11
   MonthName$ = "November"
 CASE 12
   MonthName$ = "December"
 END SELECT
END FUNCTION

FUNCTION ParseCalculate$ (InLine$)
 DIM Result$
 DIM WorkLine$
 Result$ = ParseInMeaning$(InLine$)
 InLine$ = LTRIM$(InLine$)
 DO WHILE InLine$ <> ""
  SELECT CASE LEFT$(UCASE$(InLine$), 1)
  CASE "*"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "*" + ParseInMeaning$(InLine$)
  CASE "+"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "+" + ParseInMeaning$(InLine$)
  CASE "-"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "-" + ParseInMeaning$(InLine$)
  CASE "/"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "/" + ParseInMeaning$(InLine$)
  CASE "\"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "/" + ParseInMeaning$(InLine$)
  CASE "^"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "^" + ParseInMeaning$(InLine$)
  CASE "="
    InLine$ = LTRIM$(MID$(InLine$, 2))
    SELECT CASE LEFT$(InLine$, 1)
    CASE ">"
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "=>" + ParseInMeaning$(InLine$)
    CASE "<"
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "<=" + ParseInMeaning$(InLine$)
    CASE ELSE
      Result$ = Result$ + "=" + ParseInMeaning$(InLine$)
    END SELECT
  CASE ">"
    InLine$ = LTRIM$(MID$(InLine$, 2))
    SELECT CASE LEFT$(InLine$, 1)
    CASE "<"
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "<>" + ParseInMeaning$(InLine$)
    CASE "="
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "=>" + ParseInMeaning$(InLine$)
    CASE ELSE
      Result$ = Result$ + ">" + ParseInMeaning$(InLine$)
    END SELECT
  CASE "<"
    InLine$ = LTRIM$(MID$(InLine$, 2))
    SELECT CASE LEFT$(InLine$, 1)
    CASE ">"
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "<>" + ParseInMeaning$(InLine$)
    CASE "="
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "<=" + ParseInMeaning$(InLine$)
    CASE ELSE
      Result$ = Result$ + "<" + ParseInMeaning$(InLine$)
    END SELECT
  CASE "A" TO "Z"
    WorkLine$ = InLine$
    SELECT CASE InName$(InLine$)
    CASE "AND"
      Result$ = Result$ + " And " + ParseInMeaning$(InLine$)
    CASE "MOD"
      Result$ = Result$ + " Mod " + ParseInMeaning$(InLine$)
    CASE "OR"
      Result$ = Result$ + " Or " + ParseInMeaning$(InLine$)
    CASE "XOR"
      Result$ = Result$ + " XOr " + ParseInMeaning$(InLine$)
    CASE ELSE
      InLine$ = WorkLine$
      EXIT DO
    END SELECT
  CASE ELSE
    EXIT DO
  END SELECT
  InLine$ = LTRIM$(InLine$)
 LOOP
 ParseCalculate$ = Result$
END FUNCTION

FUNCTION ParseInMeaning$ (InLine$)
 DIM Result$
 InLine$ = LTRIM$(InLine$)
 SELECT CASE LEFT$(UCASE$(InLine$), 1)
 CASE CHR$(34)
   InLine$ = MID$(InLine$, 2)
   IF INSTR(InLine$, CHR$(34)) = 0 THEN ERROR 2
   ParseInMeaning$ = CHR$(34) + MID$(InLine$, 1, INSTR(InLine$, CHR$(34)) - 1) + CHR$(34)
   InLine$ = MID$(InLine$, INSTR(InLine$, CHR$(34)) + 1)
 CASE "+"
   InLine$ = MID$(InLine$, 2)
   ParseInMeaning$ = ParseCalculate$(InLine$)
 CASE "-"
   InLine$ = MID$(InLine$, 2)
   ParseInMeaning$ = "-" + ParseCalculate$(InLine$)
 CASE "."
   ParseInMeaning$ = ParseInNumber$(InLine$)
 CASE "&"
   ParseInMeaning$ = ParseInNumber$(InLine$)
 CASE "0" TO "9"
   ParseInMeaning$ = ParseInNumber$(InLine$)
 CASE "("
   InLine$ = MID$(InLine$, 2)
   ParseInMeaning$ = "(" + ParseCalculate$(InLine$) + ")"
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
 CASE "A" TO "Z"
   Result$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   IF Result$ = "NOT" THEN
    ParseInMeaning$ = "Not " + ParseCalculate$(InLine$)
   ELSE
    Result$ = LEFT$(UCASE$(Result$), 1) + MID$(LCASE$(Result$), 2)
    SELECT CASE LEFT$(InLine$, 1)
    CASE "$"
      Result$ = Result$ + "$"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    CASE "!"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    CASE "@"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    CASE "#"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    CASE "%"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    CASE "&"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    END SELECT
    IF LEFT$(InLine$, 1) = "(" THEN
     InLine$ = LTRIM$(MID$(InLine$, 2))
     Result$ = Result$ + "("
     DO WHILE InLine$ <> ""
      IF LEFT$(InLine$, 1) = "#" THEN
       Result$ = Result$ + "#"
       InLine$ = MID$(InLine$, 2)
      END IF
      Result$ = Result$ + ParseCalculate$(InLine$)
      InLine$ = LTRIM$(InLine$)
      SELECT CASE LEFT$(InLine$, 1)
      CASE ","
        InLine$ = MID$(InLine$, 2)
        Result$ = Result$ + ","
      CASE ")"
        Result$ = Result$ + ")"
        EXIT DO
      CASE ELSE
        ERROR 2
      END SELECT
      InLine$ = LTRIM$(InLine$)
     LOOP
     IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
     InLine$ = MID$(InLine$, 2)
    END IF
    ParseInMeaning$ = Result$
   END IF
 CASE ELSE
   ERROR 2
 END SELECT
END FUNCTION

FUNCTION ParseInNumber$ (InLine$)
 DIM OutNumber$
 DIM PointPresent%
 OutNumber$ = ""
 PointPresent% = False%
 InLine$ = LTRIM$(InLine$)
 SELECT CASE LEFT$(UCASE$(InLine$), 1)
 CASE "&"
   InLine$ = LTRIM$(MID$(InLine$, 2))
   SELECT CASE LEFT$(UCASE$(InLine$), 1)
   CASE "H"
     InLine$ = LTRIM$(MID$(InLine$, 2))
     DO WHILE InLine$ <> ""
      SELECT CASE LEFT$(UCASE$(InLine$), 1)
      CASE "0" TO "9"
        OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
        InLine$ = MID$(InLine$, 2)
      CASE "A" TO "F"
        OutNumber$ = OutNumber$ + LEFT$(UCASE$(InLine$), 1)
        InLine$ = MID$(InLine$, 2)
      CASE "G" TO "Z"
        ERROR 2
      CASE "."
        InLine$ = LTRIM$(MID$(InLine$, 2))
        IF InLine$ = "" THEN ERROR 2
        IF PointPresent% OR ((NOT ((ASC(InLine$) > (ASC("0") - 1)) AND (ASC(InLine$) < (ASC("9") + 1)))) AND (NOT ((ASC(UCASE$(InLine$)) > (ASC("A") - 1)) AND (ASC(UCASE$(InLine$)) < (ASC("F") + 1))))) OR ((ASC(UCASE$(InLine$)) > ASC("G")) AND (ASC(UCASE$(InLine$)) < (ASC("Z") + 1))) THEN ERROR 2
        PointPresent% = True%
        IF OutNumber$ = "" THEN OutNumber$ = "0." ELSE OutNumber$ = OutNumber$ + "."
      CASE ELSE
        EXIT DO
      END SELECT
     LOOP
     IF OutNumber$ = "" THEN ERROR 2
     ParseInNumber$ = "&H" + OutNumber$
   CASE "O"
     InLine$ = LTRIM$(MID$(InLine$, 2))
     DO WHILE InLine$ <> ""
      SELECT CASE LEFT$(InLine$, 1)
      CASE "0" TO "7"
        OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
        InLine$ = MID$(InLine$, 2)
      CASE "8" TO "9"
        ERROR 2
      CASE "."
        InLine$ = LTRIM$(MID$(InLine$, 2))
        IF InLine$ = "" THEN ERROR 2
        IF PointPresent% OR (NOT ((ASC(InLine$) > (ASC("0") - 1)) AND (ASC(InLine$) < (ASC("7") + 1)))) OR ((ASC(InLine$) > (ASC("8") - 1)) AND (ASC(InLine$) < (ASC("9") + 1))) THEN ERROR 2
        PointPresent% = True%
        IF OutNumber$ = "" THEN OutNumber$ = "0." ELSE OutNumber$ = OutNumber$ + "."
      CASE ELSE
        EXIT DO
      END SELECT
     LOOP
     IF OutNumber$ = "" THEN ERROR 2
     ParseInNumber$ = "&O" + OutNumber$
   CASE "0" TO "7"
     DO WHILE InLine$ <> ""
      SELECT CASE LEFT$(InLine$, 1)
      CASE "0" TO "7"
        OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
        InLine$ = MID$(InLine$, 2)
      CASE "8" TO "9"
        ERROR 2
      CASE "."
        InLine$ = LTRIM$(MID$(InLine$, 2))
        IF InLine$ = "" THEN ERROR 2
        IF PointPresent% OR (NOT ((ASC(InLine$) > (ASC("0") - 1)) AND (ASC(InLine$) < (ASC("7") + 1)))) OR ((ASC(InLine$) > (ASC("8") - 1)) AND (ASC(InLine$) < (ASC("9") + 1))) THEN ERROR 2
        PointPresent% = True%
        IF OutNumber$ = "" THEN OutNumber$ = "0." ELSE OutNumber$ = OutNumber$ + "."
      CASE ELSE
        EXIT DO
      END SELECT
     LOOP
     IF OutNumber$ = "" THEN ERROR 2
     ParseInNumber$ = "&O" + OutNumber$
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "0" TO "9"
   DO WHILE InLine$ <> ""
    SELECT CASE LEFT$(InLine$, 1)
    CASE "0" TO "9"
      OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
      InLine$ = MID$(InLine$, 2)
    CASE "."
      InLine$ = LTRIM$(MID$(InLine$, 2))
      IF InLine$ = "" THEN ERROR 2
      IF PointPresent% OR (NOT ((ASC(InLine$) > (ASC("0") - 1)) AND (ASC(InLine$) < (ASC("9") + 1)))) THEN ERROR 2
      PointPresent% = True%
      IF OutNumber$ = "" THEN OutNumber$ = "0." ELSE OutNumber$ = OutNumber$ + "."
    CASE ELSE
      EXIT DO
    END SELECT
   LOOP
   IF OutNumber$ = "" THEN ERROR 2
   ParseInNumber$ = OutNumber$
 CASE "."
   PointPresent% = True%
   DO WHILE InLine$ <> ""
    SELECT CASE LEFT$(InLine$, 1)
    CASE "0" TO "9"
      OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
      InLine$ = MID$(InLine$, 2)
    CASE "."
      ERROR 2
    CASE ELSE
      EXIT DO
    END SELECT
   LOOP
   IF OutNumber$ = "" THEN ERROR 2
   ParseInNumber$ = "0." + OutNumber$
 CASE ELSE
   ERROR 2
 END SELECT
END FUNCTION

FUNCTION ParseRunLine$ (InLine$)
 DIM Statement$
 DIM WorkLine$
 DIM Work$
 DIM Result$
 DIM Value$
 DIM Meaning$
 DIM Index%
 DIM Work%
 Statement$ = InName$(InLine$)
 InLine$ = LTRIM$(InLine$)
 SELECT CASE Statement$
 CASE "BEEP"
   ParseRunLine$ = "Beep"
 CASE "CHDIR"
   ParseRunLine$ = "ChDir " + ParseCalculate$(InLine$)
 CASE "CLOSE"
   IF LEFT$(InLine$, 1) <> "#" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   ParseRunLine$ = "Close #" + ParseCalculate$(InLine$)
 CASE "CLS"
   ParseRunLine$ = "Cls"
 CASE "COLOR"
   Result$ = ParseCalculate$(InLine$)
   IF InName$(InLine$) <> "ON" THEN ERROR 2
   ParseRunLine$ = "Color " + Result$ + " On " + ParseCalculate$(InLine$)
 CASE "DEBUG"
   SELECT CASE InName$(InLine$)
   CASE "ON"
     ParseRunLine$ = "Debug On"
   CASE "OFF"
     ParseRunLine$ = "Debug Off"
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "DEF"
   Result$ = InName$(InLine$)
   IF LEFT$(Result$, 2) <> "FN" THEN ERROR 48
   Result$ = LEFT$(UCASE$(Result$), 3) + MID$(LCASE$(Result$), 4)
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     InLine$ = LTRIM$(MID$(InLine$, 2))
     Result$ = Result$ + "$"
   CASE "!"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "@"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "#"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "%"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "&"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   END SELECT
   IF LEFT$(InLine$, 1) = "(" THEN
    InLine$ = LTRIM$(MID$(InLine$, 2))
    Result$ = Result$ + "("
    Index% = 0
    DO WHILE InLine$ <> ""
     Value$ = InName$(InLine$)
     Result$ = Result$ + LEFT$(UCASE$(Value$), 1) + MID$(LCASE$(Value$), 2)
     InLine$ = LTRIM$(InLine$)
     SELECT CASE LEFT$(InLine$, 1)
     CASE "$"
       InLine$ = LTRIM$(MID$(InLine$, 2))
       Result$ = Result$ + "$"
     CASE "!"
       InLine$ = LTRIM$(MID$(InLine$, 2))
     CASE "@"
       InLine$ = LTRIM$(MID$(InLine$, 2))
     CASE "#"
       InLine$ = LTRIM$(MID$(InLine$, 2))
     CASE "%"
       InLine$ = LTRIM$(MID$(InLine$, 2))
     CASE "&"
       InLine$ = LTRIM$(MID$(InLine$, 2))
     END SELECT
     Index% = Index% + 1
     SELECT CASE LEFT$(InLine$, 1)
     CASE ","
       IF Index% = DefFnSArgsCount% THEN ERROR 22
       InLine$ = MID$(InLine$, 2)
       Result$ = Result$ + ","
     CASE ")"
       Result$ = Result$ + ")"
       EXIT DO
     CASE ELSE
       ERROR 2
     END SELECT
    LOOP
    IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
    InLine$ = LTRIM$(MID$(InLine$, 2))
   END IF
   IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   ParseRunLine$ = "Def " + Result$ + "=" + ParseCalculate$(InLine$)
 CASE "DELETE"
   Result$ = ParseCalculate$(InLine$)
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) = "," THEN
    InLine$ = MID$(InLine$, 2)
    ParseRunLine$ = "Delete " + Result$ + "," + ParseCalculate$(InLine$)
   ELSE
    ParseRunLine$ = "Delete " + Result$
   END IF
 CASE "END"
   ParseRunLine$ = "End"
 CASE "FILES"
   ParseRunLine$ = "Files " + ParseCalculate$(InLine$)
 CASE "FROM"
   Result$ = InName$(InLine$)
   Result$ = LEFT$(UCASE$(Result$), 1) + MID$(LCASE$(Result$), 2)
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     ERROR 45
   CASE "!"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "@"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "#"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "%"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "&"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   END SELECT
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Value$ = ParseCalculate$(InLine$)
   IF InName$(InLine$) <> "TO" THEN ERROR 2
   Meaning$ = ParseCalculate$(InLine$)
   InLine$ = LTRIM$(InLine$)
   IF InLine$ <> "" THEN
    IF InName$(InLine$) <> "STEP" THEN ERROR 2
    InLine$ = LTRIM$(InLine$)
    IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
    InLine$ = MID$(InLine$, 2)
    ParseRunLine$ = "From " + Result$ + "=" + Value$ + " To " + Meaning$ + " Step=" + ParseCalculate$(InLine$)
   ELSE
    ParseRunLine$ = "From " + Result$ + "=" + Value$ + " To " + Meaning$
   END IF
 CASE "GO"
   SELECT CASE InName$(InLine$)
   CASE "TO"
     ParseRunLine$ = "Go To " + ParseCalculate$(InLine$)
   CASE "SUB"
     ParseRunLine$ = "Go Sub " + ParseCalculate$(InLine$)
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "HANG"
   ParseRunLine$ = "Hang"
 CASE "HELP"
   IF LEFT$(InLine$, 1) = "!" THEN InLine$ = MID$(InLine$, 2)
   ParseRunLine$ = "Help!"
 CASE "IF"
   Result$ = ParseCalculate$(InLine$)
   IF InName$(InLine$) <> "THEN" THEN ERROR 2
   Value$ = ParseRunLine$(InLine$)
   InLine$ = LTRIM$(InLine$)
   IF InLine$ <> "" THEN
    IF InName$(InLine$) <> "ELSE" THEN ERROR 2
    ParseRunLine$ = "If " + Result$ + " Then " + Value$ + " Else " + ParseRunLine$(InLine$)
   ELSE
    ParseRunLine$ = "If " + Result$ + " Then " + Value$
   END IF
 CASE "KEY"
   SELECT CASE LEFT$(UCASE$(InLine$), 1)
   CASE "A" TO "Z"
     Work$ = InLine$
     SELECT CASE InName$(InLine$)
     CASE "ON"
       ParseRunLine$ = "Key On"
     CASE "OFF"
       ParseRunLine$ = "Key Off"
     CASE "LIST"
       ParseRunLine$ = "Key List"
     CASE ELSE
       Result$ = ParseCalculate$(Work$)
       Work$ = LTRIM$(Work$)
       IF LEFT$(Work$, 1) <> "," THEN ERROR 2
       Work$ = MID$(Work$, 2)
       ParseRunLine$ = "Key " + Result$ + "," + ParseCalculate$(Work$)
     END SELECT
   CASE ELSE
     Result$ = ParseCalculate$(InLine$)
     InLine$ = LTRIM$(InLine$)
     IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
     InLine$ = MID$(InLine$, 2)
     ParseRunLine$ = "Key " + Result$ + "," + ParseCalculate$(InLine$)
   END SELECT
 CASE "KILL"
   ParseRunLine$ = "Kill " + ParseCalculate$(InLine$)
 CASE "LET"
   Result$ = InName$(InLine$)
   Result$ = LEFT$(UCASE$(Result$), 1) + MID$(LCASE$(Result$), 2)
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     InLine$ = LTRIM$(MID$(InLine$, 2))
     Result$ = Result$ + "$"
   CASE "!"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "@"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "#"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "%"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "&"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   END SELECT
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   ParseRunLine$ = "Let " + Result$ + "=" + ParseCalculate$(InLine$)
 CASE "LIST"
   IF InLine$ <> "" THEN
    Result$ = ParseCalculate$(InLine$)
    InLine$ = LTRIM$(InLine$)
    IF LEFT$(InLine$, 1) = "," THEN
     InLine$ = MID$(InLine$, 2)
     ParseRunLine$ = "List " + Result$ + "," + ParseCalculate$(InLine$)
    ELSE
     ParseRunLine$ = "List " + Result$
    END IF
   ELSE
    ParseRunLine$ = "List"
   END IF
 CASE "LOAD"
   ParseRunLine$ = "Load " + ParseCalculate$(InLine$)
 CASE "LOCATE"
   Result$ = ParseCalculate$(InLine$)
   IF InName$(InLine$) <> "IN" THEN ERROR 2
   ParseRunLine$ = "Locate " + Result$ + " In " + ParseCalculate$(InLine$)
 CASE "MID"
   IF LEFT$(InLine$, 1) <> "$" THEN ERROR 2
   InLine$ = LTRIM$(MID$(InLine$, 2))
   IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Result$ = InName$(InLine$)
   Result$ = LEFT$(UCASE$(Result$), 1) + MID$(LCASE$(Result$), 2)
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "$" THEN ERROR 2
   InLine$ = LTRIM$(MID$(InLine$, 2))
   IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Value$ = ParseCalculate$(InLine$)
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Meaning$ = ParseCalculate$(InLine$)
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
   InLine$ = LTRIM$(MID$(InLine$, 2))
   IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   ParseRunLine$ = "Mid$(" + Result$ + "$," + Value$ + "," + Meaning$ + ")=" + ParseCalculate$(InLine$)
 CASE "MKDIR"
   ParseRunLine$ = "MkDir " + ParseCalculate$(InLine$)
 CASE "NAME"
   Result$ = ParseCalculate$(InLine$)
   IF InName$(InLine$) <> "AS" THEN ERROR 2
   ParseRunLine$ = "Name " + Result$ + " As " + ParseCalculate$(InLine$)
 CASE "NEW"
   ParseRunLine$ = "New"
 CASE "NEXT"
   Result$ = InName$(InLine$)
   Result$ = LEFT$(UCASE$(Result$), 1) + MID$(LCASE$(Result$), 2)
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     ERROR 45
   CASE "!"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "@"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "#"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "%"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "&"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   END SELECT
   ParseRunLine$ = "Next " + Result$
 CASE "OPEN"
   Result$ = ParseCalculate$(InLine$) + " For "
   IF InName$(InLine$) <> "FOR" THEN ERROR 2
   SELECT CASE InName$(InLine$)
   CASE "INPUT"
     Result$ = Result$ + "InPut"
   CASE "OUTPUT"
     Result$ = Result$ + "OutPut"
   CASE "APPEND"
     Result$ = Result$ + "Append"
   CASE ELSE
     ERROR 2
   END SELECT
   IF InName$(InLine$) <> "AS" THEN ERROR 2
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "#" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   ParseRunLine$ = "Open " + Result$ + " As #" + ParseCalculate$(InLine$)
 CASE "PRINT"
   IF LEFT$(InLine$, 1) = "#" THEN
    InLine$ = MID$(InLine$, 2)
    Result$ = ParseCalculate$(InLine$)
    InLine$ = LTRIM$(InLine$)
    IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
    InLine$ = MID$(InLine$, 2)
    ParseRunLine$ = "Print #" + Result$ + "," + ParseCalculate$(InLine$)
   ELSE
    ParseRunLine$ = "Print " + ParseCalculate$(InLine$)
   END IF
 CASE "REBOOT"
   ParseRunLine$ = "Reboot"
 CASE "REM"
   IF InLine$ <> "" THEN ParseRunLine$ = "Rem " + RTRIM$(InLine$) ELSE ParseRunLine$ = "Rem"
 CASE "RETURN"
   ParseRunLine$ = "Return"
 CASE "RMDIR"
   ParseRunLine$ = "RmDir " + ParseCalculate$(InLine$)
 CASE "RUN"
   ParseRunLine$ = "Run"
 CASE "SAVE"
   ParseRunLine$ = "Save " + ParseCalculate$(InLine$)
 CASE "SCREEN"
   SELECT CASE InName$(InLine$)
   CASE "FOURTY"
     ParseRunLine$ = "Screen Fourty"
   CASE "EIGHTY"
     ParseRunLine$ = "Screen Eighty"
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "SOUND"
   Result$ = ParseCalculate$(InLine$)
   IF InName$(InLine$) <> "WITH" THEN ERROR 2
   ParseRunLine$ = "Sound " + Result$ + " With " + ParseCalculate$(InLine$)
 CASE "SWAP"
   Result$ = InName$(InLine$)
   Result$ = LEFT$(UCASE$(Result$), 1) + MID$(LCASE$(Result$), 2)
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     InLine$ = LTRIM$(MID$(InLine$, 2))
     Result$ = Result$ + "$"
   CASE "!"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "@"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "#"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "%"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "&"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   END SELECT
   IF InName$(InLine$) <> "AS" THEN ERROR 2
   Value$ = InName$(InLine$)
   Value$ = LEFT$(UCASE$(Value$), 1) + MID$(LCASE$(Value$), 2)
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     InLine$ = LTRIM$(MID$(InLine$, 2))
     Value$ = Value$ + "$"
   CASE "!"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "@"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "#"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "%"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "&"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   END SELECT
   ParseRunLine$ = "Swap " + Result$ + " As " + Value$
 CASE "SYSTEM"
   ParseRunLine$ = "System"
 CASE "TROFF"
   ParseRunLine$ = "TrOff"
 CASE "TRON"
   ParseRunLine$ = "TrOn"
 CASE "TRACE"
   ParseRunLine$ = "Trace"
 CASE "WEND"
   ParseRunLine$ = "WEnd"
 CASE "WHILE"
   ParseRunLine$ = "While " + ParseCalculate$(InLine$)
 CASE ELSE
   ERROR 23
 END SELECT
END FUNCTION

SUB RunLine (InLine$)
 DIM Statement$
 DIM WorkLine$
 DIM Work$
 DIM Result$
 DIM Value$
 DIM Meaning$
 DIM Index%
 DIM SubIndex%
 DIM LineNumber%
 DIM Work%
 DIM WorkValue%
 DIM Count%
 DIM StartValue#
 DIM EndValue#
 DIM StepValue#
 DIM CurrentValue#
 DIM StartLine%
 DIM EndLine%
 DIM VariableName$
 DIM Conditional$
 Statement$ = InName$(InLine$)
 InLine$ = LTRIM$(InLine$)
 SELECT CASE Statement$
 CASE "BEEP"
   BEEP
 CASE "CHDIR"
   Result$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   CHDIR Result$
 CASE "CLOSE"
   IF LEFT$(InLine$, 1) <> "#" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   IF (INT(VAL(Result$)) < 1) OR (INT(VAL(Result$)) > FilesCount%) THEN ERROR 52
   IF OpenFiles$(INT(VAL(Result$))) = "" THEN ERROR 28
   CLOSE #INT(VAL(Result$))
   OpenFiles$(INT(VAL(Result$))) = ""
 CASE "CLS"
   CLS
 CASE "COLOR"
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   IF InName$(InLine$) <> "ON" THEN ERROR 2
   Value$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   COLOR VAL(Result$), VAL(Value$)
 CASE "DEBUG"
   SELECT CASE InName$(InLine$)
   CASE "ON"
     IF DebugMode% THEN ERROR 41
     IF RunMode% THEN ERROR 60
     IF BASICLinesCountValue% = 0 THEN ERROR 43
     DebugMode% = True%
     CurrentLine% = 1
     PRINT "Debug session is turned to On."
   CASE "OFF"
     IF NOT DebugMode% THEN ERROR 42
     DebugMode% = False%
     PRINT "Debug session is turned to Off."
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "DEF"
   IF DefFnSCountValue% = DefFnSCount% THEN ERROR 31
   DefFnSCountValue% = DefFnSCountValue% + 1
   Result$ = InName$(InLine$)
   IF LEFT$(Result$, 2) <> "FN" THEN ERROR 48
   Result$ = LEFT$(UCASE$(Result$), 3) + MID$(LCASE$(Result$), 4)
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     InLine$ = LTRIM$(MID$(InLine$, 2))
     Result$ = Result$ + "$"
   CASE "!"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "@"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "#"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "%"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "&"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   END SELECT
   IF LEFT$(InLine$, 1) = "(" THEN
    InLine$ = LTRIM$(MID$(InLine$, 2))
    Result$ = Result$ + "("
    Index% = 1
    DO WHILE InLine$ <> ""
     Value$ = InName$(InLine$)
     Result$ = Result$ + LEFT$(UCASE$(Value$), 1) + MID$(LCASE$(Value$), 2)
     InLine$ = LTRIM$(InLine$)
     SELECT CASE LEFT$(InLine$, 1)
     CASE "$"
       InLine$ = LTRIM$(MID$(InLine$, 2))
       Result$ = Result$ + "$"
     CASE "!"
       InLine$ = LTRIM$(MID$(InLine$, 2))
     CASE "@"
       InLine$ = LTRIM$(MID$(InLine$, 2))
     CASE "#"
       InLine$ = LTRIM$(MID$(InLine$, 2))
     CASE "%"
       InLine$ = LTRIM$(MID$(InLine$, 2))
     CASE "&"
       InLine$ = LTRIM$(MID$(InLine$, 2))
     END SELECT
     SELECT CASE LEFT$(InLine$, 1)
     CASE ","
       IF Index% = DefFnSArgsCount% THEN ERROR 22
       Index% = Index% + 1
       InLine$ = MID$(InLine$, 2)
       Result$ = Result$ + ","
     CASE ")"
       Result$ = Result$ + ")"
       EXIT DO
     CASE ELSE
       ERROR 2
     END SELECT
    LOOP
    IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
    InLine$ = LTRIM$(MID$(InLine$, 2))
   END IF
   IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   DefFnS$(DefFnSCountValue%) = Result$ + "=" + ParseCalculate$(InLine$)
 CASE "DELETE"
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) = "," THEN
    InLine$ = MID$(InLine$, 2)
    Value$ = Calculate$(InLine$)
    IF NumStr% THEN ERROR 13
    IF INT(VAL(Value$)) < INT(VAL(Result$)) THEN ERROR 79
    FOR Index% = INT(VAL(Result$)) TO INT(VAL(Value$))
     CALL DeleteLine(Index%)
    NEXT Index%
   ELSE
    CALL DeleteLine(INT(VAL(Result$)))
   END IF
 CASE "END"
   IF NOT RunMode% THEN ERROR 32
   RunMode% = False%
 CASE "FILES"
   Result$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   FILES Result$
 CASE "FROM"
   IF (NOT RunMode%) AND (NOT DebugMode%) THEN ERROR 66
   Result$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     ERROR 45
   CASE "!"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "@"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "#"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "%"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "&"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   END SELECT
   IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Value$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   IF InName$(InLine$) <> "TO" THEN ERROR 2
   Meaning$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   InLine$ = LTRIM$(InLine$)
   IF InLine$ <> "" THEN
    IF InName$(InLine$) <> "STEP" THEN ERROR 2
    InLine$ = LTRIM$(InLine$)
    IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
    InLine$ = MID$(InLine$, 2)
    Work$ = Calculate$(InLine$)
    IF NumStr% THEN ERROR 13
   ELSE
    Work$ = "1.0"
   END IF
   FOR Index% = 1 TO FromsCount% + 1
    IF Index% = FromsCount% + 1 THEN ERROR 65
    IF Froms$(Index%) = "" THEN EXIT FOR
   NEXT Index%
   Count% = 0
   FOR Work% = CurrentLine% + 1 TO BASICLinesCountValue% + 1
    IF Work% = BASICLinesCountValue% + 1 THEN ERROR 26
    WorkLine$ = MID$(BASICLines$(Work%), INSTR(BASICLines$(Work%), "=") + 1)
    SELECT CASE InName$(WorkLine$)
    CASE "FROM"
      Count% = Count% + 1
    CASE "NEXT"
      IF Count% = 0 THEN EXIT FOR
      Count% = Count% - 1
    END SELECT
   NEXT Work%
   IF VAL(Value$) < VAL(Meaning$) THEN
    IF VAL(Work$) > 0# THEN
     Froms$(Index%) = "Start value=(" + LTRIM$(STR$(VAL(Value$))) + "). End value=(" + LTRIM$(STR$(VAL(Meaning$))) + "). Step=(" + LTRIM$(STR$(VAL(Work$))) + "). Value=(" + LTRIM$(STR$(VAL(Value$))) + "). StartLine=(" + LTRIM$(STR$(CurrentLine%)) + "). EndLine=(" + LTRIM$(STR$(Work%)) + "). VariableName=" + Result$
     CALL SetVariable(Result$, False%, LTRIM$(STR$(VAL(Value$))))
    ELSE
     CurrentLine% = Work%
    END IF
   ELSEIF VAL(Value$) > VAL(Meaning$) THEN
    IF VAL(Work$) < 0# THEN
     Froms$(Index%) = "Start value=(" + LTRIM$(STR$(VAL(Value$))) + "). End value=(" + LTRIM$(STR$(VAL(Meaning$))) + "). Step=(" + LTRIM$(STR$(VAL(Work$))) + "). Value=(" + LTRIM$(STR$(VAL(Value$))) + "). StartLine=(" + LTRIM$(STR$(CurrentLine%)) + "). EndLine=(" + LTRIM$(STR$(Work%)) + "). VariableName=" + Result$
     CALL SetVariable(Result$, False%, LTRIM$(STR$(VAL(Value$))))
    ELSE
     CurrentLine% = Work%
    END IF
   END IF
 CASE "GO"
   IF (NOT RunMode%) AND (NOT DebugMode%) THEN ERROR 78
   SELECT CASE InName$(InLine$)
   CASE "TO"
     Result$ = Calculate$(InLine$)
     IF NumStr% THEN ERROR 13
     CurrentLine% = FindLine%(INT(VAL(Result$))) - 1
   CASE "SUB"
     Result$ = Calculate$(InLine$)
     IF NumStr% THEN ERROR 13
     IF GoSubSCountValue% = GoSubSCount% THEN ERROR 77
     GoSubSCountValue% = GoSubSCountValue% + 1
     GoSubS%(GoSubSCountValue%) = CurrentLine%
     CurrentLine% = FindLine%(INT(VAL(Result$))) - 1
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "HANG"
   CALL Hang
 CASE "HELP"
   IF LEFT$(InLine$, 1) = "!" THEN InLine$ = MID$(InLine$, 2)
   CALL Help
 CASE "IF"
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   IF InName$(InLine$) <> "THEN" THEN ERROR 2
   Value$ = ParseRunLine$(InLine$)
   InLine$ = LTRIM$(InLine$)
   IF InLine$ <> "" THEN
    IF InName$(InLine$) <> "ELSE" THEN ERROR 2
    Meaning$ = ParseRunLine$(InLine$)
    IF VAL(Result$) THEN CALL RunLine(Value$) ELSE CALL RunLine(Meaning$)
   ELSE
    IF VAL(Result$) THEN CALL RunLine(Value$)
   END IF
 CASE "KEY"
   SELECT CASE LEFT$(UCASE$(InLine$), 1)
   CASE "A" TO "Z"
     Work$ = InLine$
     SELECT CASE InName$(InLine$)
     CASE "ON"
       KEY ON
     CASE "OFF"
       KEY OFF
     CASE "LIST"
       KEY LIST
     CASE ELSE
       Result$ = Calculate$(Work$)
       IF NumStr% THEN ERROR 13
       Work$ = LTRIM$(Work$)
       IF LEFT$(Work$, 1) <> "," THEN ERROR 2
       Work$ = MID$(Work$, 2)
       Value$ = Calculate$(Work$)
       IF NOT NumStr% THEN ERROR 13
       KEY VAL(Result$), Value$
     END SELECT
   CASE ELSE
     Result$ = Calculate$(InLine$)
     IF NumStr% THEN ERROR 13
     InLine$ = LTRIM$(InLine$)
     IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
     InLine$ = MID$(InLine$, 2)
     Value$ = Calculate$(InLine$)
     IF NOT NumStr% THEN ERROR 13
     KEY VAL(Result$), Value$
   END SELECT
 CASE "KILL"
   Result$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   KILL Result$
 CASE "LET"
   Result$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   Work% = False%
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     Work% = True%
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "!"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "@"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "#"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "%"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "&"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   END SELECT
   IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Value$ = Calculate$(InLine$)
   IF NumStr% <> Work% THEN ERROR 13
   CALL SetVariable(Result$, Work%, Value$)
 CASE "LIST"
   IF InLine$ = "" THEN
    FOR Index% = 1 TO BASICLinesCountValue%
     PRINT BASICLines$(Index%)
    NEXT Index%
   ELSE
    Result$ = Calculate$(InLine$)
    IF NumStr% THEN ERROR 13
    InLine$ = LTRIM$(InLine$)
    IF LEFT$(InLine$, 1) = "," THEN
     InLine$ = MID$(InLine$, 2)
     Value$ = Calculate$(InLine$)
     IF NumStr% THEN ERROR 13
     IF INT(VAL(Value$)) < INT(VAL(Result$)) THEN ERROR 79
     FOR Index% = FindLine%(INT(VAL(Result$))) TO FindLine%(INT(VAL(Value$)))
      PRINT BASICLines$(Index%)
     NEXT Index%
    ELSE
     PRINT BASICLines$(FindLine%(INT(VAL(Result$))))
    END IF
   END IF
 CASE "LOAD"
   Result$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   CALL ClearAll(True%)
   OPEN Result$ FOR INPUT AS #FilesCount% + 1
   DO WHILE NOT EOF(FilesCount% + 1)
    LINE INPUT #FilesCount% + 1, WorkLine$
    WorkLine$ = LTRIM$(RTRIM$(WorkLine$))
    IF WorkLine$ = "" THEN
     CALL ClearAll(True%)
     ERROR 80
    END IF
    SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
    CASE "0" TO "9"
      LineNumber% = INT(InNumber#(WorkLine$))
      IF (LineNumber% < 1) OR (LineNumber% > BASICLinesCount%) THEN
       CALL ClearAll(True%)
       ERROR 46
      END IF
      WorkLine$ = LTRIM$(WorkLine$)
      IF WorkLine$ = "" THEN
       CALL ClearAll(True%)
       ERROR 2
      END IF
      IF NOT ((ASC(UCASE$(WorkLine$)) > (ASC("A") - 1)) AND (ASC(UCASE$(WorkLine$)) < (ASC("Z") + 1))) THEN
       CALL ClearAll(True%)
       ERROR 2
      END IF
      WorkLine$ = ParseRunLine$(WorkLine$)
      IF BASICLinesCountValue% = 0 THEN
       BASICLinesCountValue% = 1
       BASICLines$(BASICLinesCountValue%) = STRING$(LEN(LTRIM$(STR$(BASICLinesCount%))) - LEN(LTRIM$(STR$(LineNumber%))), "0") + LTRIM$(STR$(LineNumber%)) + "=" + WorkLine$
      ELSE
       FOR Index% = 1 TO BASICLinesCountValue% + 1
        IF Index% = BASICLinesCountValue% + 1 THEN
         IF BASICLinesCountValue% = BASICLinesCount% THEN
          CALL ClearAll(True%)
          ERROR 47
         END IF
         BASICLinesCountValue% = BASICLinesCountValue% + 1
         BASICLines$(BASICLinesCountValue%) = STRING$(LEN(LTRIM$(STR$(BASICLinesCount%))) - LEN(LTRIM$(STR$(LineNumber%))), "0") + LTRIM$(STR$(LineNumber%)) + "=" + WorkLine$
         FOR LineNumber% = 1 TO BASICLinesCountValue%
          FOR SubIndex% = 1 TO BASICLinesCountValue%
           IF BASICLines$(LineNumber%) < BASICLines$(SubIndex%) THEN SWAP BASICLines$(LineNumber%), BASICLines$(SubIndex%)
          NEXT SubIndex%
         NEXT LineNumber%
         EXIT FOR
        END IF
        IF VAL(MID$(BASICLines$(Index%), 1, INSTR(BASICLines$(Index%), "=") - 1)) = LineNumber% THEN
         BASICLines$(Index%) = STRING$(LEN(LTRIM$(STR$(BASICLinesCount%))) - LEN(LTRIM$(STR$(LineNumber%))), "0") + LTRIM$(STR$(LineNumber%)) + "=" + WorkLine$
         EXIT FOR
        END IF
       NEXT Index%
      END IF
    CASE ELSE
      CALL ClearAll(True%)
      ERROR 81
    END SELECT
   LOOP
   CLOSE #FilesCount% + 1
 CASE "LOCATE"
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   IF InName$(InLine$) <> "IN" THEN ERROR 2
   Value$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   LOCATE VAL(Value$), VAL(Result$), 1, 7, 8
 CASE "MID"
   IF LEFT$(InLine$, 1) <> "$" THEN ERROR 2
   InLine$ = LTRIM$(MID$(InLine$, 2))
   IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Result$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "$" THEN ERROR 2
   InLine$ = LTRIM$(MID$(InLine$, 2))
   IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Value$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Meaning$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
   InLine$ = LTRIM$(MID$(InLine$, 2))
   IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Work$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   WorkLine$ = InVariable$(Result$, True%)
   MID$(WorkLine$, VAL(Value$), VAL(Meaning$)) = Work$
   CALL SetVariable(Result$, True%, WorkLine$)
 CASE "MKDIR"
   Result$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   MKDIR Result$
 CASE "NAME"
   Result$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   IF InName$(InLine$) <> "AS" THEN ERROR 2
   Value$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   NAME Result$ AS Value$
 CASE "NEW"
   CALL ClearAll(True%)
 CASE "NEXT"
   IF (NOT RunMode%) AND (NOT DebugMode%) THEN ERROR 66
   Result$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     ERROR 45
   CASE "!"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "@"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "#"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "%"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "&"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   END SELECT
   FOR Index% = 1 TO FromsCount% + 1
    IF Index% = FromsCount% + 1 THEN ERROR 1
    IF Froms$(Index%) <> "" THEN
     WorkLine$ = MID$(Froms$(Index%), INSTR(Froms$(Index%), "(") + 1)
     StartValue# = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
     WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
     EndValue# = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
     WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
     StepValue# = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
     WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
     CurrentValue# = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
     WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
     StartLine% = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
     WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
     EndLine% = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
     VariableName$ = MID$(WorkLine$, INSTR(WorkLine$, "=") + 1)
     IF (EndLine% = CurrentLine%) AND (VariableName$ = Result$) THEN EXIT FOR
    END IF
   NEXT Index%
   CurrentValue# = CurrentValue# + StepValue#
   IF StartValue# < EndValue# THEN
    IF CurrentValue# > EndValue# THEN
     Froms$(Index%) = ""
    ELSE
     Froms$(Index%) = "Start value=(" + LTRIM$(STR$(StartValue#)) + "). End value=(" + LTRIM$(STR$(EndValue#)) + "). Step=(" + LTRIM$(STR$(StepValue#)) + "). Value=(" + LTRIM$(STR$(CurrentValue#)) + "). StartLine=(" + LTRIM$(STR$(StartLine%)) + "). EndLine=(" + LTRIM$(STR$(EndLine%)) + "). VariableName=" + VariableName$
     CALL SetVariable(Result$, False%, LTRIM$(STR$(CurrentValue#)))
     CurrentLine% = StartLine%
    END IF
   ELSEIF StartValue# > EndValue# THEN
    IF CurrentValue# < EndValue# THEN
     Froms$(Index%) = ""
    ELSE
     Froms$(Index%) = "Start value=(" + LTRIM$(STR$(StartValue#)) + "). End value=(" + LTRIM$(STR$(EndValue#)) + "). Step=(" + LTRIM$(STR$(StepValue#)) + "). Value=(" + LTRIM$(STR$(CurrentValue#)) + "). StartLine=(" + LTRIM$(STR$(StartLine%)) + "). EndLine=(" + LTRIM$(STR$(EndLine%)) + "). VariableName=" + VariableName$
     CALL SetVariable(Result$, False%, LTRIM$(STR$(CurrentValue#)))
     CurrentLine% = StartLine%
    END IF
   END IF
 CASE "OPEN"
   Result$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   IF InName$(InLine$) <> "FOR" THEN ERROR 2
   Work$ = InName$(InLine$)
   IF InName$(InLine$) <> "AS" THEN ERROR 2
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "#" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Value$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   IF (INT(VAL(Value$)) < 1) OR (INT(VAL(Value$)) > FilesCount%) THEN ERROR 52
   IF OpenFiles$(INT(VAL(Value$))) <> "" THEN ERROR 55
   SELECT CASE Work$
   CASE "INPUT"
     OPEN Result$ FOR INPUT AS #INT(VAL(Value$))
     OpenFiles$(INT(VAL(Value$))) = "IN=" + Result$
   CASE "OUTPUT"
     OPEN Result$ FOR OUTPUT AS #INT(VAL(Value$))
     OpenFiles$(INT(VAL(Value$))) = "OUT=" + Result$
   CASE "APPEND"
     OPEN Result$ FOR APPEND AS #INT(VAL(Value$))
     OpenFiles$(INT(VAL(Value$))) = "OUT=" + Result$
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "PRINT"
   IF LEFT$(InLine$, 1) = "#" THEN
    InLine$ = MID$(InLine$, 2)
    Result$ = Calculate$(InLine$)
    IF NumStr% THEN ERROR 13
    IF (INT(VAL(Result$)) < 1) OR (INT(VAL(Result$)) > FilesCount%) THEN ERROR 52
    IF OpenFiles$(INT(VAL(Result$))) = "" THEN ERROR 52
    IF MID$(OpenFiles$(INT(VAL(Result$))), 1, INSTR(OpenFiles$(INT(VAL(Result$))), "=") - 1) = "IN" THEN ERROR 54
    InLine$ = LTRIM$(InLine$)
    IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
    InLine$ = MID$(InLine$, 2)
    PRINT #INT(VAL(Result$)), Calculate$(InLine$);
   ELSE
    CALL WriteLine(Calculate$(InLine$))
   END IF
 CASE "REBOOT"
   DEF SEG = &HF000
   CALL Absolute(&HFFF0)
 CASE "REM"
   EXIT SUB
 CASE "RETURN"
   IF (NOT RunMode%) AND (NOT DebugMode%) THEN ERROR 78
   IF GoSubSCountValue% = 0 THEN ERROR 3
   CurrentLine% = GoSubS%(GoSubSCountValue%)
   GoSubS%(GoSubSCountValue%) = 0
   GoSubSCountValue% = GoSubSCountValue% - 1
 CASE "RMDIR"
   Result$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   RMDIR Result$
 CASE "RUN"
   IF RunMode% THEN ERROR 34
   IF DebugMode% THEN ERROR 39
   IF BASICLinesCountValue% = 0 THEN ERROR 36
   CALL ClearAll(False%)
   CurrentLine% = 1
   RunMode% = True%
   DO
    IF TraceMode% THEN PRINT "[" + LTRIM$(STR$(VAL(MID$(BASICLines$(CurrentLine%), 1, INSTR(BASICLines$(CurrentLine%), "=") - 1)))) + "]";
    WorkLine$ = MID$(BASICLines$(CurrentLine%), INSTR(BASICLines$(CurrentLine%), "=") + 1)
    WorkLine$ = ParseRunLine$(WorkLine$)
    CALL RunLine(WorkLine$)
    CurrentLine% = CurrentLine% + 1
   LOOP UNTIL (CurrentLine% > BASICLinesCountValue%) OR (NOT RunMode%)
   CurrentLine% = 0
   RunMode% = False%
 CASE "SAVE"
   Result$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   IF BASICLinesCountValue% = 0 THEN ERROR 82
   OPEN Result$ FOR OUTPUT AS #FilesCount% + 1
   FOR Index% = 1 TO BASICLinesCountValue%
    PRINT #FilesCount% + 1, MID$(BASICLines$(Index%), 1, INSTR(BASICLines$(Index%), "=") - 1) + SPACE$(1) + MID$(BASICLines$(Index%), INSTR(BASICLines$(Index%), "=") + 1)
   NEXT Index%
   PRINT #FilesCount% + 1, CHR$(26);
   CLOSE #FilesCount% + 1
 CASE "SCREEN"
   SELECT CASE InName$(InLine$)
   CASE "FOURTY"
     WIDTH 40
   CASE "EIGHTY"
     WIDTH 80
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "SOUND"
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   IF InName$(InLine$) <> "WITH" THEN ERROR 2
   Value$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   SOUND INT(VAL(Result$)), INT(VAL(Value$))
 CASE "SWAP"
   Result$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   Work% = False%
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     Work% = True%
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "!"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "@"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "#"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "%"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "&"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   END SELECT
   IF InName$(InLine$) <> "AS" THEN ERROR 2
   Value$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   WorkValue% = False%
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     WorkValue% = True%
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "!"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "@"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "#"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "%"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "&"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   END SELECT
   IF Work% <> WorkValue% THEN ERROR 45
   Meaning$ = InVariable$(Result$, Work%)
   CALL SetVariable(Result$, Work%, InVariable$(Value$, Work%))
   CALL SetVariable(Value$, WorkValue%, Meaning$)
 CASE "SYSTEM"
   WIDTH 80
   COLOR 7, 0
   CLS
   LOCATE 1, 1, 1, 7, 8
   SYSTEM
 CASE "TROFF"
   TraceMode% = False%
   PRINT "Trace mode is turned to OFF."
 CASE "TRON"
   TraceMode% = True%
   PRINT "Trace mode is turned to ON."
 CASE "TRACE"
   IF NOT DebugMode% THEN ERROR 44
   IF CurrentLine% > BASICLinesCountValue% THEN
    DebugMode% = False%
    CurrentLine% = 0
    PRINT "Debug session is ended."
   ELSE
    WorkLine$ = MID$(BASICLines$(CurrentLine%), INSTR(BASICLines$(CurrentLine%), "=") + 1)
    WorkLine$ = ParseRunLine$(WorkLine$)
    DO
     PRINT "Line:"
     PRINT "Number=" + LTRIM$(STR$(VAL(MID$(BASICLines$(CurrentLine%), 1, INSTR(BASICLines$(CurrentLine%), "=") - 1)))) + "."
     PRINT "  Line=" + WorkLine$ + "."
     PRINT "Run this line (Yes/No)?"
     LINE INPUT Work$
     Work$ = LTRIM$(RTRIM$(UCASE$(Work$)))
    LOOP UNTIL (Work$ = "YES") OR (Work$ = "NO")
    IF Work$ = "YES" THEN
     PRINT "Running..."
     CALL RunLine(WorkLine$)
     PRINT "Succefully runned line."
    END IF
    CurrentLine% = CurrentLine% + 1
    IF CurrentLine% > BASICLinesCountValue% THEN
     DebugMode% = False%
     CurrentLine% = 0
     PRINT "Debug session is ended."
    END IF
   END IF
 CASE "WEND"
   IF (NOT RunMode%) AND (NOT DebugMode%) THEN ERROR 84
   FOR Index% = 1 TO WhilesCount% + 1
    IF Index% = WhilesCount% + 1 THEN ERROR 30
    IF Whiles$(Index%) <> "" THEN
     WorkLine$ = MID$(Whiles$(Index%), INSTR(Whiles$(Index%), "(") + 1)
     StartLine% = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
     WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
     EndLine% = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
     Conditional$ = MID$(WorkLine$, INSTR(WorkLine$, "=") + 1)
     IF EndLine% = CurrentLine% THEN EXIT FOR
    END IF
   NEXT Index%
   Result$ = Calculate$(Conditional$)
   IF NumStr% THEN ERROR 13
   IF VAL(Result$) THEN CurrentLine% = StartLine% ELSE Whiles$(Index%) = ""
 CASE "WHILE"
   IF (NOT RunMode%) AND (NOT DebugMode%) THEN ERROR 84
   Conditional$ = InLine$
   Conditional$ = ParseCalculate$(Conditional$)
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   FOR Index% = 1 TO WhilesCount% + 1
    IF Index% = WhilesCount% + 1 THEN ERROR 83
    IF Whiles$(Index%) = "" THEN EXIT FOR
   NEXT Index%
   Count% = 0
   FOR Work% = CurrentLine% + 1 TO BASICLinesCountValue% + 1
    IF Work% = BASICLinesCountValue% + 1 THEN ERROR 29
    WorkLine$ = MID$(BASICLines$(Work%), INSTR(BASICLines$(Work%), "=") + 1)
    SELECT CASE InName$(WorkLine$)
    CASE "WHILE"
      Count% = Count% + 1
    CASE "WEND"
      IF Count% = 0 THEN EXIT FOR
      Count% = Count% - 1
    END SELECT
   NEXT Work%
   IF VAL(Result$) THEN Whiles$(Index%) = "StartLine=(" + LTRIM$(STR$(CurrentLine%)) + "). EndLine=(" + LTRIM$(STR$(Work%)) + "). Conditional=" + Conditional$ ELSE CurrentLine% = Work%
 CASE ELSE
   ERROR 23
 END SELECT
END SUB

SUB SetVariable (VariableName$, VariableType%, VariableData$)
 DIM Index%
 IF (VariableName$ = "DATE") AND VariableType% THEN
  DATE$ = VariableData$
 ELSEIF (VariableName$ = "TIME") AND VariableType% THEN
  TIME$ = VariableData$
 ELSEIF (VariableName$ = "ENVIRONMENT") AND VariableType% THEN
  ENVIRON VariableData$
 ELSEIF (VariableName$ = "PROMPT") AND VariableType% THEN
  Prompt$ = VariableData$
 ELSEIF (VariableName$ = "RANDOM") AND (NOT VariableType%) THEN
  RANDOMIZE VAL(VariableData$)
 ELSE
  IF VariablesCountValue% = 0 THEN
   VariablesCountValue% = 1
   Variables$(VariablesCountValue%) = VariableName$ + "[" + LTRIM$(STR$(ABS(VariableType%))) + "]=" + VariableData$
  ELSE
   FOR Index% = 1 TO VariablesCountValue% + 1
    IF Index% = VariablesCountValue% + 1 THEN
     IF VariablesCountValue% = VariablesCount% THEN ERROR 88
     VariablesCountValue% = VariablesCountValue% + 1
     Variables$(VariablesCountValue%) = VariableName$ + "[" + LTRIM$(STR$(ABS(VariableType%))) + "]=" + VariableData$
     EXIT FOR
    END IF
    IF (MID$(Variables$(Index%), 1, INSTR(Variables$(Index%), "[") - 1) = VariableName$) AND (VAL(MID$(Variables$(Index%), INSTR(Variables$(Index%), "[") + 1, 1)) = ABS(VariableType%)) THEN
     Variables$(Index%) = VariableName$ + "[" + LTRIM$(STR$(ABS(VariableType%))) + "]=" + VariableData$
     EXIT FOR
    END IF
   NEXT Index%
  END IF
 END IF
END SUB

FUNCTION SquareRoot# (Meaning#)
 DIM Value#
 DIM ControlValue#
 Value# = 1#
 ControlValue# = 0#
 WHILE Value# <> ControlValue#
  ControlValue# = Value#
  Value# = ((Meaning# / Value#) + Value#) / 2#
 WEND
 SquareRoot# = Value#
END FUNCTION

FUNCTION WeekNumber% (DayValue%, MonthValue%, YearValue%)
 WeekNumber% = INT((MonthDays%(MonthValue%, YearValue%) + DayValue%) / 7) + 1
END FUNCTION

SUB WriteLine (OutLine$)
 DIM Index%
 FOR Index% = 1 TO LEN(OutLine$)
  CALL ANSIOut(MID$(OutLine$, Index%, 1))
 NEXT Index%
END SUB

SUB WriteLineCRLF (OutLine$)
 CALL WriteLine(OutLine$ + CHR$(10))
END SUB

