/*
 * Samples.java
 *
 * Created on January 20, 2003, 11:11 PM
 */
package samples;

import com.speech4j.speech.*;
import com.speech4j.sound.*;
import javax.sound.sampled.*;
import java.io.*;

/**
 *
 * @author  Administrator
 */
public class Samples {
    private static void sample1() {
        System.out.println("sample 1 tests whether Speech4j is functional");
        NativeObject.testSpeech();
    }
    
    private static void sample2() throws SpeechException {
        System.out.println("sample 2 lists all TTS modes installed on your computer");
        TTSEnum enum=new TTSEnum();
        TTSModeInfo modeInfo;
        while ((modeInfo=enum.next())!=null) {
            System.out.println("------------------------------------------");
            System.out.println(modeInfo);
        }
    }
    
    private static void sample3() throws SpeechException {
        System.out.println("sample 3 says \"Hello, how are you today?\" to speakers with the first TTS mode");
        TTSEnum enum=new TTSEnum();
        TTSModeInfo modeInfo=enum.next();
        if (modeInfo==null) {
            System.out.println("No TTS mode found");
            System.exit(3);
        } else {
            TTSMode ttsMode=new TTSMode();
            ttsMode.create();
            ttsMode.init(modeInfo.getModeId());
            ttsMode.speakAndWait("Hello, how are you today?", false);
        }
    }
    
    private static void sample4() throws SpeechException {
        System.out.println("sample 4 says \"Hello, how are you today?\" to sample3.wav with the first TTS mode.");
        TTSEnum enum=new TTSEnum();
        TTSModeInfo modeInfo=enum.next();
        if (modeInfo==null) {
            System.out.println("No TTS mode found");
            System.exit(4);
        } else {
            AudioDestFile audioFile=new AudioDestFile("sample4.wav");
            TTSMode ttsMode=enum.select(modeInfo.getModeId(), audioFile);
            ttsMode.speakAndWait("Hello, how are you today?", false);
            audioFile.flushFile();
            audioFile.destroy();
        }
    }
    
    private static void sample5()
    throws SpeechException, SoundException, IOException, UnsupportedAudioFileException {
        System.out.println("sample 5 creates 2 voices dialog:");
        System.out.println("\tVoice 1: \"Hello, how are you today?\"");
        System.out.println("\t1 second pause...");
        System.out.println("\tVoice 2: \"I am fine, what about you?\"");
        System.out.println("in sample5.wav");
        
        TTSEnum enum=new TTSEnum();
        TTSModeInfo modeInfo1=enum.next();
        if (modeInfo1==null) {
            System.out.println("No TTS mode found for voice 1");
            System.exit(5);
        }
        
        TTSModeInfo modeInfo2=enum.next();
        if (modeInfo2==null) {
            System.out.println("No TTS mode found for voice 2");
            System.exit(6);
        }
        
        File tmpDir=new File(System.getProperty("java.io.tmpdir"));
        SpeechWaiter waiter=new SpeechWaiter();
        
        File file1=File.createTempFile("temp", ".wav", tmpDir);
        AudioDestFile audioFile1=new AudioDestFile(file1.getAbsolutePath());
        TTSMode ttsMode1=enum.select(modeInfo1.getModeId(), audioFile1);
        ttsMode1.addSink(waiter);
        
        File file2=File.createTempFile("temp", ".wav", tmpDir);
        AudioDestFile audioFile2=new AudioDestFile(file2.getAbsolutePath());
        TTSMode ttsMode2=enum.select(modeInfo2.getModeId(), audioFile2);
        ttsMode2.addSink(waiter);
        
        ttsMode1.speak("Hello, how are you today?");
        ttsMode2.speak("I am fine, what about you?");
        
        waiter.waitSpeech();
        
        audioFile1.flushFile();
        audioFile1.destroy();
        
        audioFile2.flushFile();
        audioFile2.destroy();
        
        AudioFormat outFormat=new AudioFormat(44100,16,2,true,false);
        AudioOutputStream aos=new AudioOutputStream(new FileOutputStream("sample5.wav"),outFormat);
        
        AudioInputStream ais1=AudioSystem.getAudioInputStream(file1);
        aos.write(ais1, ais1.available());
        ais1.close();
        
        AudioFormat format=new AudioFormat(11025,16,1,true,false);
        AudioBuffer pauseBuffer=Util.silence(1,format);
        aos.write(pauseBuffer);
        
        AudioInputStream ais2=AudioSystem.getAudioInputStream(file2);
        aos.write(ais2, ais2.available());
        ais2.close();
        
        aos.close();
        
        file1.delete();
        file2.delete();
    }
    
    private static class Speaker implements Runnable {
        TTSMode ttsMode;
        
        Speaker(TTSMode ttsMode) {
            if (ttsMode==null) {
                throw new NullPointerException("ttsMode==null");
            }
            this.ttsMode=ttsMode;
        }
        
        public void run() {
            try {
                ttsMode.speakAndWait("Hello, how are you today?", false);
            } catch (SpeechException e) {
                e.printStackTrace();
            } finally {
                synchronized (this) {
                    finished=true;
                }
            }
        }
        
        private boolean finished=false;
        
        public synchronized boolean isFinished() {
            return finished;
        }
    }
    
    private static void sample6() throws SpeechException, InterruptedException {
        System.out.println("sample 6 says \"Hello, how are you today?\" to speakers with the first TTS mode");
        System.out.println("from a new thread. Please note that it is necessary to start message pumping in the");
        System.out.println("main thread for threaded speaking to work. Don't forget to put");
        System.out.println("NativeObject.processMessages() into your Swing applications");
        
        TTSEnum enum=new TTSEnum();
        TTSModeInfo modeInfo=enum.next();
        if (modeInfo==null) {
            System.out.println("No TTS mode found");
            System.exit(3);
        } else {
            TTSMode ttsMode=new TTSMode();
            ttsMode.create();
            ttsMode.init(modeInfo.getModeId());
            Speaker speaker=new Speaker(ttsMode);
            Thread speakingThread=new Thread(speaker);
            speakingThread.start();
            while (!speaker.isFinished()) {
                NativeObject.processMessages();
                Thread.sleep(10);
            }
            speakingThread.join();
        }
    }
    
    private static void sample7() throws SpeechException {
        System.out.println("sample 7 says \"Hello, how are you today?\" to speakers with the default TTS mode");
        TTSMode mode=new TTSMode();
        mode.create();
        mode.init();
        mode.speakAndWait("Hello, how are you today? I'm going to have a cup of coffee. Will you join me?", false);
        mode.destroy();
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) throws Exception {
        if (args.length==0) {
            System.err.println("provide sample number");
            System.exit(1);
        } else if ("sample1".equals(args[0])) {
            sample1();
        } else if ("sample2".equals(args[0])) {
            sample2();
        } else if ("sample3".equals(args[0])) {
            sample3();
        } else if ("sample4".equals(args[0])) {
            sample4();
        } else if ("sample5".equals(args[0])) {
            sample5();
        } else if ("sample6".equals(args[0])) {
            sample6();
        } else if ("sample7".equals(args[0])) {
            sample7();
        } else {
            System.err.println("Invalid sample name");
        }
    }
}
