/*
 * Decompiled with CFR 0.152.
 */
class Enzyme {
    public static String EC = "ID";
    public static String Comments = "CC";
    public static String Description = "DE";
    public static String AltName = "AN";
    public static String Reaction = "CA";
    public static String Cofactors = "CF";
    public static String Diseases = "DI";
    public static String Prosite = "PR";
    public static String SwissProt = "DR";
    public static String End = "//";
    static int DiseaseRelated = 1;
    static int MembraneBound = 2;
    static int Transporter = 4;
    static int Problematic = 16;
    static int TransferredEntry = 16384;
    static int InvalidFlags = 32768;
    static int DeletedEntry = 65536;
    int[] n = new int[4];

    public Enzyme(String e) {
        int[] p = new int[4];
        try {
            p[0] = 0;
            int k = 1;
            while (k < 4) {
                p[k] = e.indexOf(46, p[k - 1] + 1);
                if (p[k] < 0) {
                    throw new NumberFormatException();
                }
                ++k;
            }
            p[0] = -1;
            k = 0;
            while (k < 4) {
                String s = k == 3 ? e.substring(p[k] + 1) : e.substring(p[k] + 1, p[k + 1]);
                this.n[k] = Integer.parseInt(s);
                ++k;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.n = null;
            return;
        }
    }

    public int compareTo(Enzyme x) {
        if (this.n[0] < x.n[0]) {
            return -1;
        }
        if (this.n[0] > x.n[0]) {
            return 1;
        }
        if (this.n[1] < x.n[1]) {
            return -1;
        }
        if (this.n[1] > x.n[1]) {
            return 1;
        }
        if (this.n[2] < x.n[2]) {
            return -1;
        }
        if (this.n[2] > x.n[2]) {
            return 1;
        }
        if (this.n[3] < x.n[3]) {
            return -1;
        }
        if (this.n[3] > x.n[3]) {
            return 1;
        }
        return 0;
    }

    public int getHashCode() {
        if (this.n == null) {
            return 0;
        }
        long p0 = 1L;
        long a = 500L;
        long p1 = p0 * a;
        long p2 = p1 * a;
        long p3 = p2 * a;
        long v = (long)this.n[3] * p0 + (long)this.n[2] * p1 + (long)this.n[1] * p2 + (long)this.n[0] * p3;
        if (v > Integer.MAX_VALUE) {
            v %= Integer.MAX_VALUE;
        }
        return (int)v;
    }

    public static boolean isECnumber(String n) {
        Enzyme x = new Enzyme(n);
        return x.n != null;
    }
}

