//<HTML><pre>
// KEHOME/java/Qname.java
// Sep/8/2003


import edu.stanford.TAP.Abbrev;
import edu.stanford.TAP.XML;
import edu.stanford.TAP.NamespacedTag;

public class Qname
{

/**
*   Basic terminology (w denotes whitespace)
*
*   a la MKR view (except CycL constant)    ::= yes(w/\) no(#)
*   full name  <==> individual or concept   ::= yes(w/\) no(#)
*   view name  <==> context		    ::= yes(w) no(/\#)
*   local name <==> root name or base name  ::= yes(w/\) no(#)
*   base name  <==> local name tail	    ::= yes(w) no(/\#)
*   root name  <==> root-to-base name	    ::= yes(w/) no(\#) begin(/)
*   class name <==> base-to-root name	    ::= yes(w\) no(/#) end(\)
*   Vname      <==> view name:local name
*
*   a la XML namespace (except %20)	    ::= yes(/#) no(w\)
*   full name  <==> URI			    ::= yes(/#) no(w\) begin(http://)
*   URL        <==> URI head		    ::= yes(/#) no(w\) begin(http://)
*   tag name   <==> URI tail		    ::= no(w/\#)
*   label name <==> nickname for URI head   ::= no(w/\#)
*   Qname      <==> label name:tag name
*
*/

    public String label;
    public String tag;
    public Qname(String arglabel, String argtag)
    {
	label = arglabel;
	tag   = argtag;
    } // end Qname()

/*
*  example: "foaf:homepage" => new Qname("foaf","homepage")
*  example: "homepage"      => new Qname("","homepage")
*  example: "http://server/homepage" => new Qname("http://server/","homepage")
*/
    public static Qname GetQname(String name)
    {
    String debug = "no";
    int x;
    int n = name.length();
    if (name.startsWith("http://")) {
	NamespacedTag Uname = XML.SplitNamespace(name);
	return new Qname(Uname.url,Uname.tag);
    }
    for (x = 1; x < n; ++x) {
	if (!Character.isLetter(name.charAt(x))) {
	    // first non-letter
	    if (name.charAt(x) == ':') {
		// found label
		String arglabel = name.substring(0,x);
		String argtag = name.substring(x+1,n);
		if (debug == "yes") {
		    System.out.println("# arglabel = " + arglabel);
		    System.out.println("# argtag = " + argtag);
		}
		return new Qname(arglabel,argtag);
	    } else {
		return new Qname("",name);
	    }
	}
    }
    return new Qname("",name);
    } // end GetQname()

/*
*  example: "foaf:homepage" => foafuri + "homepage"
*  example: "homepage"      => tapuri  + "homepage"
*  example: "http://server/homepage" => "http://server/homepage"
*/
    public static String GetNameURI(String name)
    {
	String tapuri = "http://tap.stanford.edu/data/";
	Qname qname = Qname.GetQname(name);
	if (qname.label.startsWith("http://")) {
	    return name;
	} else if (qname.label == "") {
	    if (!Abbrev.IsStandardTag(name)) {
		return tapuri + name;
	    } else {
		return name;
	    }
	} else {
	    return Abbrev.GetStdLabelURL(qname.label) + qname.tag;
	}
    } // end GetNameURI()

} // end class Qname

//</pre></HTML>
