/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <dos.h>
#include <dpmi.h>
#include <string.h>
#include <stdio.h>
#include <time.h>
#include <libp.h>
#include <errno.h>

static unsigned getdta(void)
{
	DPMI_REGS regs;
	regs.b.ah = 0x2f;
	regs.h.flags = 0x72;
	regs.h.ss = 0;
	regs.h.sp = 0;
   dpmi_simulate_real_interrupt(0x21,&regs);   return (regs.h.es << 16) + regs.h.bx;

}
static void setdta(unsigned dta)
{
	DPMI_REGS regs;
	regs.b.ah = 0x1a;
	regs.h.flags = 0x72;
	regs.h.ss = 0;
	regs.h.sp = 0;
	regs.h.ds = dta >> 16;
	regs.h.dx = dta & 0xffff;
	dpmi_simulate_real_interrupt(0x21,&regs);
}
int bdos(int func, unsigned regdx, int regal)
{
	DPMI_REGS regs;
	regs.b.ah = func;
	regs.b.al = regal;
	regs.h.dx = regdx;
	regs.h.flags = 0x72;
	regs.h.ss = 0;
	regs.h.sp = 0;
	dpmi_simulate_real_interrupt(0x21,&regs);
	return regs.b.al;
}
int _dos_getdrive(int *drive)
{
	DPMI_REGS regs;
	regs.b.ah = 0x19;
	regs.h.flags = 0x72;
	regs.h.ss = 0;
	regs.h.sp = 0;
	dpmi_simulate_real_interrupt(0x21,&regs);

	*drive = regs.b.al+1;
	return 0;
}
int _dos_setdrive(int drive, int *numdrives)
{
	DPMI_REGS regs;
	regs.b.ah = 0x0e;
	regs.b.dl = drive;
	regs.h.flags = 0x72;
	regs.h.ss = 0;
	regs.h.sp = 0;
	dpmi_simulate_real_interrupt(0x21,&regs);
	
}
int _dos_getpwd(char *buf, int drive)
{
	DPMI_REGS regs;
	SELECTOR sel,para;
	if (dpmi_alloc_real_memory(&sel,&para,0x5))
		return 8;
	regs.b.ah = 0x47;
	regs.h.flags = 0x72;
	regs.h.ss = 0;
	regs.h.sp = 0;
	regs.h.ds = para;
	regs.h.dx = drive;
	regs.h.si = 0;
	dpmi_simulate_real_interrupt(0x21,&regs);
	dpmi_copy_to_ds(buf,sel,0,65);
	dpmi_dealloc_real_memory(sel);
	return strlen(buf);
}
int _dos_setpwd(char *buf)
{
	DPMI_REGS regs;
	SELECTOR sel,para;
	if (dpmi_alloc_real_memory(&sel,&para,0x8))
		return 8;
	dpmi_copy_from_ds(sel,0,buf,strlen(buf)+1);
	regs.b.ah = 0x3b;
	regs.h.flags = 0x72;
	regs.h.ss = 0;
	regs.h.sp = 0;
	regs.h.ds = para;
	regs.h.dx = 0;
	dpmi_simulate_real_interrupt(0x21,&regs);
	dpmi_dealloc_real_memory(sel);
	return 0;
}
int _dos_findfirst(char *string, int attr, struct find_t *buf)
{
	DPMI_REGS regs;
	SELECTOR sel,para;
	SELECTOR nsel,npara;
   int dta = getdta();
	if (dpmi_alloc_real_memory(&sel,&para,0x3))
		return 8;
	if (dpmi_alloc_real_memory(&nsel,&npara,0x8)) {
		dpmi_dealloc_real_memory(sel);
		return 8;
	}
   setdta((int)para << 16);
	dpmi_copy_from_ds(nsel,0,string,strlen(string)+1);
	regs.b.ah = 0x4e;
	regs.h.flags = 0x72;
	regs.h.ss = 0;
	regs.h.sp = 0;
	regs.h.ds = npara;
	regs.h.dx = 0;
	regs.h.cx = attr;
	dpmi_simulate_real_interrupt(0x21,&regs);
	dpmi_copy_to_ds(buf,sel,0,48);
	dpmi_dealloc_real_memory(sel);
	dpmi_dealloc_real_memory(nsel);
	setdta(dta);
	if (regs.h.flags & 1)
		return regs.b.al;
	else
		return 0;
}
int _dos_findnext(struct find_t *buf)
{
	DPMI_REGS regs;
	SELECTOR sel,para;
   int dta = getdta();
	if (dpmi_alloc_real_memory(&sel,&para,0x3))
		return 8;
   setdta((int)para << 16);
	dpmi_copy_from_ds(sel,0,buf,48);
	regs.b.ah = 0x4f;
	regs.h.flags = 0x72;
	regs.h.ss = 0;
	regs.h.sp = 0;
	dpmi_simulate_real_interrupt(0x21,&regs);
	dpmi_copy_to_ds(buf,sel,0,48);
	dpmi_dealloc_real_memory(sel);
	setdta(dta);
	if (regs.h.flags & 1)
		return regs.b.al;
	else
		return 0;
}
void _ll_findclose (void *buf)
{
   (void)buf ;
}
unsigned _dos_open(char *name,int mode, int *fd)
{
   *fd = _ll_open(name,mode,0);
	if (*fd == 0)
		return 2;
	return 0;
}
unsigned _dos_close(int fd)
{
	_ll_close(fd);
	return 0;
}
unsigned _dos_creat(const char *__pathP, unsigned __attr, int *__fd)
{
	DPMI_REGS regs;
   regs.d.ecx = __attr;
   regs.h.dx = __nametodta(__pathP,0);
   if (!__doscall(0x3c,&regs)) {
      errno = regs.b.al ;
      return regs.b.al ;
   }
   *__fd = regs.h.ax ;
   return 0 ;
}
unsigned _dos_creatnew(const char *__pathP, unsigned __attr, int *__fd)
{

   if (!_dos_open( __pathP, __attr, __fd)) {
      _dos_close(*__fd) ;
      return EEXIST ;
   }
   return _dos_creat(__pathP, __attr, __fd) ;
}
void getdfree(unsigned char __drive, struct dfree *__dtable)
{
   struct diskfree_t x ;
   int rv = _dos_getdiskfree(__drive, &x) ;
   if (!rv) {
      __dtable->df_sclus = x.sectors_per_cluster;
      __dtable->df_bsec = x.bytes_per_sector ;
      __dtable->df_total = x.total_clusters ;
      __dtable->df_avail = x.avail_clusters ;
   }
   return rv ;
}
unsigned _dos_read(int __fd, void *__buf, unsigned __len, unsigned *__nread)
{
	DPMI_REGS regs;
   int mod = __len %2048,i, tsize = 0;
   for (i=0; i < (__len & -2048); i += 2048) {
		regs.h.dx = 0;
      regs.h.bx = __fd;
		regs.h.cx = 2048;
		__doscall(0x3f,&regs);
		if (regs.h.flags & 1)
         return errno = regs.b.al ;
      __dtatobuf((char *)__buf+i,2048);
		tsize += regs.h.ax;
      if (regs.h.ax < 2048) {
         *__nread = tsize ;
         return 0 ;
      }
	}
	regs.h.dx = 0;
   regs.h.bx = __fd;
	regs.h.cx = mod;
	__doscall(0x3f,&regs);
	tsize += regs.h.ax;
	if (regs.h.flags & 1)
         return errno = regs.b.al ;
   __dtatobuf((char *)__buf+i,mod);
   *__nread = tsize ;
   return 0;
}
unsigned _dos_write(int __fd, const void *__buf, unsigned __len, unsigned *__nread )
{
	DPMI_REGS regs;
   int mod = __len%2048,i,tsize = 0;
   for (i=0; i < (__len&-2048); i +=2048) {
      regs.h.dx = __buftodta((char *)__buf+i,2048);
      regs.h.bx = __fd;
		regs.h.cx = 2048;
		__doscall(0x40,&regs);
		if (regs.h.flags & 1)
         return errno = regs.b.al ;
		tsize += regs.h.ax;
	}
   regs.h.dx = __buftodta((char *)__buf+i,mod);
   regs.h.bx = __fd;
	regs.h.cx = mod;
	__doscall(0x40,&regs);
	if (regs.h.flags & 1)
         return errno = regs.b.al ;
	tsize += regs.h.ax;
   *__nread = tsize ;
   return 0;
}
unsigned _dos_setftime(int fd, unsigned short date, unsigned short time)
{
	DPMI_REGS regs;
	regs.b.al = 1;
	regs.h.bx = fd;
	regs.h.cx = time;
	regs.h.dx = date;
	if (!__doscall(0x57,&regs))
		return 2;
	return 0;
}
unsigned _dos_getftime(int fd, unsigned short *date, unsigned short *time)
{
	DPMI_REGS regs;
	regs.b.al = 0;
	regs.h.bx = fd;
	if (!__doscall(0x57,&regs))
		return 2;
	
	*date = regs.h.dx;
	*time = regs.h.cx;
	return 0;
}
unsigned _dos_getdiskfree(unsigned __drive,struct diskfree_t *__dtable)
{
   DPMI_REGS regs ;
   regs.h.ax = 0 ;
   regs.h.dx = __drive ;
   __doscall(0x36,&regs) ;
   if (regs.h.flags & 1) {
      errno = EINVAL ;
      return regs.b.al ;
   }
   __dtable->sectors_per_cluster = regs.h.ax ;
   __dtable->bytes_per_sector = regs.h.cx ;
   __dtable->total_clusters = regs.h.dx ;
   __dtable->avail_clusters = regs.h.bx ;
   return 0 ;
}
unsigned _dos_getfileattr(const char *__filename,unsigned *__attrib)
{
   DPMI_REGS regs ;
   regs.h.ax = 00 ;
   regs.h.dx = __nametodta(__filename,0);
   __doscall(0x43,&regs);
   if (regs.h.flags & 1) {
      errno = ENOENT ;
      return regs.b.al ;
   }
   *__attrib = regs.h.cx ;
   return 0 ;
}
unsigned _dos_setfileattr(const char *__filename,unsigned __attrib)
{
   DPMI_REGS regs ;
   regs.h.ax = 01 ;
   regs.h.cx = __attrib  ;
   regs.h.dx = __nametodta(__filename,0);
   __doscall(0x43,&regs);
   if (regs.h.flags & 1) {
      errno = ENOENT ;
      return regs.b.al ;
   }
   return 0 ;
}