/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <time.h>
#include <stdio.h>

extern char _monthdays[];
struct tm *localtime(const time_t *time)
{
	struct tm *t = gmtime(time);
/*	t->tm_hour += GMT_OFFS; */
	if (t->tm_hour > 23) {
		t->tm_hour -= 24;
		t->tm_mday++;
		if (_monthdays[t->tm_mon] < t->tm_mday) {
			t->tm_mon++;
			t->tm_mday = 1;
			if (t->tm_mon > 12) {
				t->tm_mon = 1;
				t->tm_year++;
			}
		}
	}
	return t;
}