/* 
   Copyright 2001-2003 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/

#include "winconst.h"
#include "lsctrl.h"

#ifdef BORLANDC
#define LLONG_TYPE long 
#else
#define LLONG_TYPE long long
#endif
#define MAX_COMBO_HISTORY 10

#define DID_TABWND 1
#define DID_WATCHWND 2
#define DID_ERRORWND 3
#define DID_ASMWND 4
#define DID_MEMWND 5
#define DID_STACKWND 6
#define DID_THREADWND 7

#define DID_EDITTOOL 20
#define DID_BUILDTOOL 21
#define DID_DEBUGTOOL 22

#define TAG_BP 0
#define TAG_FIF1 1
#define TAG_FIF2 2
#define TAG_BOOKMARK 3
#define TAG_MAX 4

#define BACKUP_FILES 1
#define BACKUP_PROJECTS 2
#define TABS_AS_SPACES 4

#define HELP_MSDN 0
#define HELP_SDK 1
#define HELP_SPECIFIED 2

#define ERR_BUILD_WINDOW 0
#define ERR_DEBUG_WINDOW 1
#define ERR_FIND1_WINDOW 2
#define ERR_FIND2_WINDOW 3

typedef struct dwinfo {
	char dwTitle[260] ;
	char dwName[260] ;
	HWND dwHandle ;
	int dwLineNo ;
   int breakpointLine ;
   FILETIME time ;
} DWINFO ;

typedef struct dependslist {
	struct dependslist *next ;
	char name[256] ;
	char title[256] ;
	HTREEITEM treeHandle ;
	FILETIME timex ;
} DEPENDSLIST ;
typedef struct filelist {
	struct filelist *next ;
	char name[256] ;
	char title[256] ;
	char output[256] ;
	HTREEITEM treeHandle ;
	DEPENDSLIST *depends ;
	FILETIME timex ;
	FILETIME outputTimex ;
	char rebuild ;
} FILELIST ;

#define BF_DEBUGINFO  1
#define BF_MAPFILE    2
#define BF_COMPILEVIAASM 4
#define BF_CRTDLL 8
#define BF_BROWSEINFO 16
#define BF_BREAKWINMAIN 0x10000
#define BF_BREAKDLL 0x20000
#define BF_DEBUGEXCEPTION 0x40000
#define BF_DEBUGTOOLTIPS 0x80000
#define BF_CHOSENPROJECT 0x80000000

typedef struct projlist {
	struct projlist *next ;
	char name[256] ;
	char title[256] ;
	char outputPath[256] ;
	char includePath[256] ;
	FILELIST *files ;
	HTREEITEM treeHandle ;
	FILETIME timex ;
	enum { BT_CONSOLE, BT_WINDOWS, BT_DLL, BT_LIBRARY, BT_DOS } buildType ;
   unsigned buildFlags ;
   char cmdline[256] ;
	char rebuild ;
   char compileopts[256] ;
   char assembleopts[256] ;
   char linkopts[256] ;
   char libopts[256] ;
} PROJLIST ;

typedef struct {
	int id ;
	char *text ;
} POPUPMENUTEXT ;

typedef struct {
	int start,end ;
	int color ;
	int italic ;
} EDITATTRIBS ;

typedef struct _bkpt {
	struct _bkpt *next ;
	int 	address ;
	unsigned char tempVal ;
	int active ;
   int linenum ;
   void *extra ; // to be defined later
   char module[256] ;
} BREAKPOINT ;

typedef struct _threads {
	struct _threads *next ;
	HANDLE hThread ;
	DWORD idThread ;
	BREAKPOINT breakpoint ;
} THREAD ;

typedef struct dbg_info {
   unsigned char *info ;
   int size ;
   int base ;
} DEBUG_INFO ;

typedef struct dll_info {
   struct dll_info *next ;
   DEBUG_INFO *dbg_info ;
   int base ;
   char name[512] ;
   int fUnicode ;
   int breakpoint ;
   HANDLE hFile ;
} DLL_INFO ;

typedef struct {
	HANDLE hProcess ;
	DWORD idProcess ;
	THREAD *threads ;
	BREAKPOINT breakpoints ;
	int idTempBpThread ;
   DEBUG_INFO *dbg_info ;
   DLL_INFO *dll_info ;
   int ExitAddr ;
} PROCESS ;
enum DebugState { notDebugging, SteppingOut, SteppingOver, SteppingIn, StepInOut,
       FinishStepOut, Running, atBreakpoint, atException, Aborting, nullState  } ;

typedef struct varinfo {
   TCData watchhead ;
   HTREEITEM hTreeItem ;
   struct varinfo *subtype ; /* for substructures */
   struct varinfo *link ; /* for next link in structure */
   char *typetab ;
   int type ;
   int address ;
   int offset ;
   int pointer :1 ;
   int enumx : 1 ;
   int structure : 1;
   int unionx : 1 ;
   int bitfield : 1 ;
   int array : 1 ;
   int bitstart: 5 ;
   int bitlength : 5 ;
   int outofscope : 1 ;
   int placeholder : 1 ;
   int editable : 1 ;
   int arraysize ;
   int watchindex ;
   char membername[256] ;
   char value[256] ;
} VARINFO ;

typedef struct {
   VARINFO *info ;
   char *typetab ;
   char *symtab ;
   DEBUG_INFO *dbg_info ;
} WATCHINFO ;

#include "ccide.p"
