#!/usr/bin/env python

import sys
import os

# this script must be called from the ctocpp directory

version = "C to C++ Converter Version: 1.2.0"


"""
    C to C++ Converter (c) 2001-2003 by D.G. Sureau

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    webmaster@scriptol.com
    http://www.scriptol.com
"""


false = 0
true = 1

# Syntax and options
# param 1 is the name of main c file
# param 2 is the name of the project with path without extension, without @

def usage():
  print "C to C++ Converter"
  print "Usage:"
  print "  ctocpp [options] mainfile project"
  print "  mainfile: the main c source file (holds 'main') with full path"
  print "  project:  the name of the project with the full path"
  print "            without extension nor @ prefix"
  print "Options:"
  print "  -h --help     display this text"
  print "  -v --version  display the version"
  print "  -l --list     build the list of sources from main file"
  print "  -i --include  build c++ header files from c sources"
  print "  -c --class    create classes from header files"
  print "  -a --allhead  make the list of all header files"
  print "  -p --prop     propagate changes to all references"
  print "No option:"
  print "  this is a full process as -licap"

  sys.exit(1)
  return


# build the list of option passed at command line in various formats

def makeoptions(initial):
  final = []
  for o in initial:
    # double dash option
    if( o[1] == '-' ):
      o = o[1 : 3]
      final.append(o)
    # single dash option
    elif ( len(o) == 2 ):
      final.append(o)
    # multiple options, one dash
    else:
      for x in o[1 : ]:
        final.append("-" + x)
  return final


# main process

def main():

 if (len(sys.argv) < 2):
   usage()

 flagList = false
 flagInclude = false
 flagClass = false
 flagAllhead = false
 flagCpp = false
 flagAll = true

 # options are pushed into a list

 initial = []
 offset = 1
 option = sys.argv[offset]
 while (option[0] == '-'):
   initial.append(option)
   if ((offset + 1) < len(sys.argv)):
     offset += 1
     option = sys.argv[offset]
   else:
     break

 final = makeoptions(initial)

 # options interpreter, help or version stop the program

 for o in final:
   o = o.lower()
   if (o == "-v"):
      print version
      sys.exit(0)
   if (o == "-h"):
      usage()
   if (o == "-l"):
      flagList = true
      flagAll = false
   elif (o == "-i"):
      flagInclude = true
      flagAll = false
   elif (o == "-c"):
      flagClass = true
      flagAll = false
   elif (o == "-a"):
      flagAllhead = true
      flagAll = false
   elif (o == "-p"):
      flagCpp = true
      flagAll = false

 if (offset >= (len(sys.argv) + 1)):
   usage()

 mainfile = sys.argv[offset]
 a2 = sys.argv[offset + 1]


 project = a2 + ".prj"
 hproj = a2 + ".hpj"
 listfile = "@" + project
 listheader = "@" + hproj
 

 # Making the list of c files
 if(flagList or flagAll):
   os.system("python mklist.py " + mainfile + " " + project)

 # Building C++ header files
 if(flagInclude or flagAll):
   os.system("python mkheader.py " + listfile  + " hpp")

 # Converting headers into class files
 if(flagClass or flagAll):
   os.system("python mkclass.py " + listfile)

 # Making the list of all hpp files
 if(flagAllhead or flagAll):
   os.system("python allhead.py " + mainfile + " " + hproj)

 # Converting variables and call to functions
 if(flagCpp or flagAll):
   os.system("python mkcpp.py " + listfile + " " + listheader)

 return 0

main()
