/*
**  CFGR_S.C
**
**  Win32 CONSOLE mode "Finger" server.
**
**  Connect using any finger client.
**
*/

#include <windows.h>
#include <winsock.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>
#include "wil.h"
#include "str.h"

#define MAX_STR  128
#define MAX_BUF  128
#define ONE_SEC 1000

#define FINGER_PORT  79
#define NBR_THREADS   5

static char Temp[MAX_BUF+8];
static char HostName[MAX_BUF+1];
static ULONG  HostAddr = 0;
static SOCKET ListenSock = 0;
static char Common1[] = "MarshallSoft Computing, Inc.\r\n";
static char Common2[] = "WWW: http://www.marshallsoft.com\r\n";
static char Common3[] = "Tel: 256-881-4630\r\n";

typedef struct FingerParamTag
{int    IsRunning;
 int    ThreadID;
 SOCKET DataSock;
 LPSTR  *Ptr;
} FingerParamType;

static FingerParamType FingerParamData[NBR_THREADS];

/* display error */

static void DisplayError(int Code, char * Msg)
{printf("ERROR: ");
 if(Msg) printf("%s",Msg);
 if(Code)
   {wilErrorText(Code,(char *)Temp,MAX_BUF);
    printf("%s\n",(char *)Temp);
   }
}

/* display error & exit (before calling wilAttach) */

void SayError(char *Msg)
{printf("ERROR: %s: %d\n", Msg, GetLastError() );
 exit(1);
}

void ShutDown(void)
{printf("%s\n","Shutting down.");
 wilRelease();
 exit(0);
}

/* Finger thread function */

void FingerThread(PVOID DataPtr)
{int Code;
 int ThreadID;
 SOCKET DataSock;
 FingerParamType *ParamPtr;
 LPSTR Ptr;
 char Temp[MAX_STR+1];
 char InBuffer[MAX_BUF+1];
 /* get params */
 ParamPtr = (FingerParamType *)DataPtr;
 DataSock = ParamPtr->DataSock;
 ThreadID = ParamPtr->ThreadID;
 printf("Thread %d: Started on socket %d\n",ThreadID,DataSock);
 /* wait for data to show up */
 if(!wilDataIsReady(DataSock,3000))
   {printf("No data on data socket\n");
    ParamPtr->IsRunning = FALSE;
    return;
   }
 Sleep(0);
 /* read socket */
 Code = wilReadLine(DataSock,(LPSTR)InBuffer,MAX_BUF);
 printf("Thread %d: %d bytes read\n", ThreadID, Code);
 /* remove trailing carriage return / line feed */
 Ptr = strchr((LPSTR)InBuffer, '\r');
 if(Ptr) *Ptr = '\0';
 printf("Thread %d: Fingering [%s]\n", ThreadID, (LPSTR)InBuffer);
 /* formulate response */
 Sleep(0);
 if(lstrcmpi((LPSTR)InBuffer, (LPSTR)"Mike")==0)
   lstrcpy((LPSTR)Temp,(LPSTR)"Mike Marshall <mike@marshallsoft.com>\r\n");
 else if(lstrcmpi((LPSTR)InBuffer, (LPSTR)"Pam")==0)
   lstrcpy((LPSTR)Temp,(LPSTR)"Pam Marshall <pam@marshallsoft.com>\r\n");
 else if(lstrcmpi((LPSTR)InBuffer, (LPSTR)"Lauren")==0)
   lstrcpy((LPSTR)Temp,(LPSTR)"Lauren Marshall <lauren@marshallsoft.com>\r\n");
 else
   lstrcpy((LPSTR)Temp,"No such user\r\n");
 /* send response */
 wilWriteString(DataSock,(LPSTR)Temp);
 wilWriteString(DataSock,(LPSTR)Common1);
 wilWriteString(DataSock,(LPSTR)Common2);
 wilWriteString(DataSock,(LPSTR)Common3);
 /* allow time for other side to read socket before closing */
 Sleep(650);
 /* close socket */
 wilCloseSocket(DataSock,0);
 /* thread has completed */
 ParamPtr->IsRunning = FALSE;
 printf((LPSTR)Temp,"Thread %d\n: Completed.\n", ThreadID);
}

int FindFreeSlot(void)
{int i;
 for(i=0;i<NBR_THREADS;i++)
   if(!FingerParamData[i].IsRunning) return i;
 return -1;
}

/*** main ***/

void main(void)
{int i, Code;
 int ThreadID;
 SOCKET DataSock;
 int Version;
 int Build;
 /* initialize */
 for(i=0;i<NBR_THREADS;i++)
   {FingerParamData[i].IsRunning = FALSE;
    FingerParamData[i].ThreadID = i;
    FingerParamData[i].DataSock = 0;
   }
 printf("Starting FINGER Server 3/4/2000.\n");
 printf("Accepting up to %d concurrent clients.\n",NBR_THREADS);
 /* attach WINSOCK */
 printf("Attaching WIL32.DLL\n");
 Code = wilAttach();
 if(Code<0) DisplayError(Code,"wilAttach fails:");
 else
   {Version = wilDebug(WIL_GET_VERSION);
    Build = wilDebug(WIL_GET_BUILD);
    printf("WIL32 Version: %1d.%1d.%1d Build %d\n",
       0x0f&(Version>>8),0x0f&(Version>>4),0x0f&Version,Build);
    printf("   Local Name: ");
    wilGetMyHostName((LPSTR)Temp, MAX_BUF);
    printf("%s\n",Temp);
    printf("   Local Addr: ");
    wilGetMyHostDotted(0,(LPSTR)Temp, MAX_BUF);
    printf("%s\n",Temp);
   }

 /* get local host domain name */
 if(!wilGetMyHostName((char *)HostName, MAX_BUF))
   {DisplayError(0, "Cannot get local host name");
    ShutDown();
   }
 /* get local host IP address */
 HostAddr = wilGetHostAddr((char *)HostName,0);
 if(HostAddr==0)
   {DisplayError(0, "Cannot get local IP addess");
    ShutDown();
   }
 /* create listener socket */
 ListenSock = wilTcpSocket();
 if((int)ListenSock<=0)
   {DisplayError((int)Code, "wilListen:");
    ShutDown();
   }
 /* bind address & port number */
 Code = wilBind(ListenSock, HostAddr, FINGER_PORT);
 if(Code<=0)
   {DisplayError((int)Code, "wilBind:");
    ShutDown();
   }
 /* listen for incoming request */
 Code = wilListen(ListenSock, NBR_THREADS);
 if(Code<=0)
  {DisplayError(Code, NULL);
   ShutDown();
  }
 Sleep(0);
 printf("\nType ^C to exit. Listening ...\n");
 /* wait for connection attempt */
 while(TRUE)
   {Sleep(0);

    /* any incoming connection ? */
    if(!wilDataIsReady(ListenSock,0)) continue;
    printf("    Main: Data incoming...\n");
    /* accept the connection */
    DataSock = wilAccept(ListenSock,ONE_SEC);
    if((int)DataSock<=0)
      {DisplayError((int)Code, "Accept:");
       continue;
      }
    printf("    Main: DataSock = %d\n",(int)DataSock);
    printf("    Main: Connection is accepted\n");
    /* find free thread */
    ThreadID = FindFreeSlot();
    if(ThreadID>=0)
      {/* save data */
       FingerParamData[ThreadID].DataSock = DataSock;
       FingerParamData[ThreadID].IsRunning = TRUE;
       /* start thread */
       _beginthread(FingerThread, 0, (void *)&FingerParamData[ThreadID]);
      }
   } /* end-while(TRUE)*/
}


