/*
 * @@ Wedit generated application. Written Fri Jun 23 18:43:53 2000
 * @@header: \lcc_workINDENT\indentdlgres.h
 * @@resources: \lcc_work\INDENT\indentdlg.rc
 * Do not edit outside the indicated areas
 */
/*
 * <---------------------------------------------------------------------->
 */
/*
 * <---------------------------------------------------------------------->
 */
#include <windows.h>
#include <windowsx.h>
#include <commctrl.h>
#include <shellapi.h> // Note: link in additional library shell32.lib
#include <string.h>
#include <stdio.h>
#include "indentdlgres.h"

/*
 * <---------------------------------------------------------------------->
 */

/*
 * Literals
 */
#define			WD_MAX_FILES		128
#define			WD_MAX_FILE_SIZE	(WD_MAX_FILES * MAX_PATH)

/*
 * input filenames
 */
char            wd_input_file[WD_MAX_FILE_SIZE];
char            wd_infile_list[WD_MAX_FILES][MAX_PATH];

/*
 * Boolean options are stored in a table
 */
typedef struct tagOptionsTable
{
   int             id;          // ID of the check button in the dialog box

   char           *Description; // Long string that can be shown in the TEXT
   // field

   char           *command;     // Positive command passed to indentMain if
   // box is ON

   char           *nocommand;   // Negative command passed to indentMain if
   // box is OFF

   int             isdefault;   // Whether this should be ON by default

}
OPTIONSTABLE;

/*
 * Most options have both positive and negative forms
 * Some options have only a single form, which is rather strange
 * Options must be sorted alphabetically, with the longest versions first, substring options last,
 * else the indent parser won't work
 */
OPTIONSTABLE    OptionsTable[] = {
   // option bbb doesn't seem to exist for some reason
   // {102, "Blank line before every block comment",              "bbb",
   // "-nbbb", 0},
   {104, "blanklines around conditional compilation", "-bacc", "-nbacc", 0}
   ,
   {105, "blanklines after procedure name", "-badp", "-nbadp", 0}
   ,
   {106, "blanklines after declarations", "-bad", "-nbad", 1}
   ,
   {107, "blanklines after procedures", "-bap", "-nbap", 1}
   ,
   {103, "Newline after each comma in a declaration", "-bc", "-nbc", 0}
   ,
   // The K&R option has only a positive form and makes tri-state with the
   // Pascal option
   {109, "braces on struct decl_line (K+R)", "-bls", "", 0}
   ,
   {108, "Allign braces left (Pascal)", "-bl", "-nbl", 1}
   ,
   {115, "blank after sizeof", "-bs", "-nbs", 0}
   ,
   {116, "comment delimiter on blankline", "-cdb", "-ncdb", 1}
   ,
   {118, "cuddle else", "-ce", "-nce", 1}
   ,
   {119, "cast space", "-cs", "-ncs", 1}
   ,
   {120, "ljust decl", "-dj", "-ndj", 0}
   ,
   {121, "extra expression indent", "-eei", "-neei", 0}
   ,
   {122, "else if", "-ei", "-nei", 1}
   ,
   {123, "format col1 comments", "-fc1", "-nfc1", 0}
   ,
   {124, "format comments", "-fca", "-nfca", 1}
   ,
   {125, "leave preproc space", "-lps", "-nlps", 0}
   ,
   {126, "lineup to parens", "-lp", "-nlp", 1}
   ,
   {127, "proc calls space", "-pcs", "-npcs", 0}
   ,
   {128, "procnames start line", "-psl", "-npsl", 0}
   ,
   {129, "pointer as binop", "-ps", "-nps", 0}
   ,
   {130, "star comment cont", "-sc", "-nsc", 1}
   ,
   {131, "swallow optional blanklines", "-sob", "-nsob", 1}
   ,
   {132, "space sp semicolon", "-ss", "-nss", 0}
   ,
   {133, "verbose", "-v", "-nv", 0}
   ,
   {0, NULL, NULL, NULL, 0}
};

/*
 * Integer values are stored in a table
 */
typedef struct
{
   int             id;          // ID of the check button in the dialog box

   char           *Description; // Long string that can be shown in the TEXT
   // field

   char           *command;     // Default command passed to indentMain

   int             val;         // command value

}
INT_TABLE_TYP;

INT_TABLE_TYP   int_table[] =
{
   {111, "brace indent", "-bli", 0}
   ,
   {112, "case brace indent", "-cbi", -1}
   ,
   {148, "declaration comment column", "-cd", 33}
   ,
   {156, "continuation indent", "-ci", 3}
   ,
   {163, "case indentation", "-cli", 0,}
   ,
   {113, "else endif col", "-cp", 33}
   ,
   {154, "line comment indentation", "-c", 3}
   ,
   {149, "declaration indentation", "-di", 16}
   ,
   {114, "unindent displace", "-d", 0}
   ,
   {152, "parameter indentation", "-ip", 3}
   ,
   {117, "ind size", "-i", 3}
   ,
   {134, "comment max col", "-lc", 0}
   ,
   {135, "max col", "-l", 78}
   ,
   {136, "paren indent", "-pi", -1}
   ,
   {146, "tab size", "-ts", 0}
   ,
   {0, NULL, NULL, 0}
};

/*
 * prototypes
 */
static BOOL CALLBACK DialogFunc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam);
void            werror(int errnum);
int             make_backup(char *fname);
BOOL            DlgFileSelected(char *extension, char *title, char *filelist);

/*********************************************************************
* Name:			ShowDbgMsg
* Description:	Debug message window
* Constraints;	none
*********************************************************************/
void            ShowDbgMsg(char *msg)
{
   MessageBox(NULL, msg, "WinDent", MB_OK);
}

/*********************************************************************
* Name:			DlgFileSelected
* Description:	File dialogue
* Constraints;	none
*********************************************************************/
BOOL            DlgFileSelected(char *extension, char *title, char *filelist)
{
   BOOL            fileflag = FALSE; // success

   char            filename[MAX_PATH] = "";
   OPENFILENAME    ofn;         // file data structure

   char            filefilter[256] = "All Files (*.*)^*.*^"; // initial file

   // filter

   char            filepath[MAX_PATH] = "";
   char           *ptr;
   int             i, j;

   // fix the filter string
   // replace the caret with 0 to satisfy the silly double NULL strings
   // format
   for (ptr = filefilter; *ptr != 0; ptr++)
      if (*ptr == '^')
         *ptr = '\0';

   /*
    * Set all structure members to zero.
    */
   memset(&ofn, 0, sizeof(OPENFILENAME));
   strcpy(filename, "*.*");
   filepath[0] = 0; // MUST be empty initially

   filelist[0] = 0;
   fileflag = FALSE;

   // open a file dialog and get one or more file names
   // this dialog has a lot of options, therefore
   // only the really useful ones are used, to keep things simple
   // returns only a single file name
   ofn.lStructSize = sizeof(OPENFILENAME);
   ofn.hwndOwner = NULL;
   ofn.hInstance = NULL;

   ofn.lpstrFilter = filefilter; // initial filter, 0 delimited

   // string of filters
   // terminated with double NULL

   ofn.lpstrCustomFilter = NULL;
   ofn.nMaxCustFilter = 0;
   ofn.nFilterIndex = 1; // 0 = No files, only dirs, 1

   // = first filter, 2 = second
   // filter etc

   ofn.lpstrFile = filepath; // start name search and

   // returns full file path(s)

   ofn.nMaxFile = sizeof(filepath);
   ofn.lpstrFileTitle = filename; // returns file name only

   ofn.nMaxFileTitle = MAX_PATH; // MUST be >= 256!!!

   ofn.lpstrInitialDir = ""; // initial directory

   ofn.lpstrTitle = title; // dialogue box title string

   ofn.Flags = OFN_EXPLORER | OFN_ALLOWMULTISELECT; // explorer type

   // dialogue, multiple
   // files

   ofn.nFileOffset = 0; // returns offset to first

   // file name in filepath

   ofn.nFileExtension = 0;
   ofn.lpstrDefExt = extension; // default extension

   ofn.lCustData = 0;
   ofn.lpfnHook = NULL;
   ofn.lpTemplateName = "";

   // Open the file dialogue
   fileflag = GetOpenFileName(&ofn); // open the dialogue and get

   // the file name
   if (fileflag)
   {
      // add file name(s) to the file list
      // replace the NULLs with quotes to get rid of the silly double NULL
      // strings format
      filelist[0] = 0x22;
      for (j = 1, i = ofn.nFileOffset; i < sizeof(filepath) - 1; i++)
      {
         if ((filepath[i] == 0) && (filepath[i + 1] == 0))
            i = sizeof(filepath);
         else if (filepath[i] == 0)
         {
            filelist[j++] = 0x22;
            filelist[j++] = ' ';
            filelist[j++] = 0x22;
         } else
            filelist[j++] = filepath[i];
      }
      filelist[j++] = 0x22;
      filelist[j] = 0;

      // truncate the file path to indicate just that...
      filepath[ofn.nFileOffset] = 0;

   }
   return fileflag;
}

/**********************************************************************
* Name:			WinMain
* Description:	Win main just registers a class of the same type that the dialog class, and
* 				then calls DialogBox. Then it exits. The return value is the return value of
* 				the dialog procedure.
**********************************************************************/
int APIENTRY    WinMain(HINSTANCE hinst, HINSTANCE hinstPrev, LPSTR lpCmdLine, int nCmdShow)
{
   WNDCLASS        wc;

   memset(&wc, 0, sizeof(wc));
   wc.lpfnWndProc = DefDlgProc;
   wc.cbWndExtra = DLGWINDOWEXTRA;
   wc.hInstance = hinst;
   wc.hCursor = LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground = (HBRUSH) (COLOR_WINDOW + 1);
   wc.lpszClassName = "indentdlg";

   RegisterClass(&wc);

   // Batch file operation
   // Get the command line, if any
   if (lpCmdLine && *lpCmdLine)
      strcpy(wd_input_file, lpCmdLine);

   return DialogBox(hinst, MAKEINTRESOURCE(IDD_MAINDIALOG), NULL, (DLGPROC) DialogFunc);

}

/*********************************************************************
* Name:			InitializeApp
* Description:	You should add your initialization code here. This function will be called
* 				when the dialog box receives the WM_INITDIALOG message.
* Constraints:	none
*********************************************************************/
static int      InitializeApp(HWND hDlg, WPARAM wParam, LPARAM lParam)
{
   int             i = 0;
   char            int_str[16] = "";

   /*
    * Make this window a drop file target
    */
   DragAcceptFiles(hDlg, TRUE);

   /*
    * set all the boolean check boxes
    */
   while (OptionsTable[i].id)
   {
      if (OptionsTable[i].isdefault)
      {
         CheckDlgButton(hDlg, OptionsTable[i].id, 1);
      } else
         CheckDlgButton(hDlg, OptionsTable[i].id, 0);
      i++;
   }

   /*
    * set all the numeric fields
    */
   i = 0;
   while (int_table[i].id)
   {
      sprintf(int_str, "%d", int_table[i].val);
      SetDlgItemText(hDlg, int_table[i].id, int_str);
      i++;
   }

   /*
    * Batch file operation
    * See whether a filename was supplied on the command line
    */
   if (strlen(wd_input_file) > 0)
   {
      // display it and go execute indent
      SetDlgItemText(hDlg, IDFILE, wd_input_file);
      return 0;
   } else
      return 1;
}

/*********************************************************************
* Name:			make_backup
* Description:	Backup the input file
*				Called from indent parser
* Constraints;	none
*********************************************************************/
#define BSIZE	20000
int             make_backup(char *fname)
{
   FILE           *in, *out;
   char           *outbuf;
   int             c;

   outbuf = malloc(BSIZE);
   if (outbuf == NULL)
   {
      ShowDbgMsg("No more memory");
      return 0;
   }
   in = fopen(fname, "rb");

   if (in == NULL)
   {
      ShowDbgMsg("Impossible to open input file. Abort.");
      return 0;
   }
   strcpy(outbuf, fname);
   strcat(outbuf, ".bak");
   out = fopen(outbuf, "wb");
   if (out == NULL)
   {
      ShowDbgMsg("Impossible to create the backup file. Disk write protected?");
      return 0;
   }
   /*
    * Make a backup of the input file, using block read/write
    */
   do
   {
      c = (int) fread(outbuf, 1, BSIZE, in);
      if (c > 0)
      {
         if (fwrite(outbuf, 1, c, out) != c)
         {
            ShowDbgMsg("Write error when making backup. Disk Full?");
            break;
         }
      }
   }
   while (c > 0);

   /*
    * close files and cleanup memory
    */
   fclose(in);
   fclose(out);
   free(outbuf);

   return 1;
}

/*********************************************************************
* Name:			ReadArgumentsAndStart
* Description:	Run the indent parser
* Constraints;	none
*********************************************************************/
extern int      indentmain(int, char **);
int             ReadArgumentsAndStart(HWND hwnd)
{
   int             i = 0;
   int             argc = 2;
   char           *argv[512];
   char            int_str[16];
   char           *str_ptr;

   /*
    * zap the argument string
    */
   memset(argv, 0, sizeof(argv));

   /*
    * Concatenate the options into a command line for indent
    * Load the application name and file names
    */
   argv[0] = "indent.exe";
   // argv[1] = wd_input_file;

   /*
    * Search for multiple file names in the list
    * Remove the quotes and null terminate each substring, since indent doesn't like quotes
    * TBD: Note that this means that indent can't handle file names with spaces in them
    *      This is a problem that will need fixing in future
    */
   argc = 1;
   // ShowDbgMsg(wd_input_file);
   str_ptr = strchr(wd_input_file, 0x22);
   // ShowDbgMsg(str_ptr);
   while (str_ptr != NULL)
   {
      str_ptr++;
      argv[argc++] = str_ptr;
      // ShowDbgMsg(str_ptr);
      str_ptr = strchr(str_ptr, 0x22);
      *str_ptr = 0;
      str_ptr++;
      str_ptr = strchr(str_ptr, 0x22);
   }

   /*
    * do all the boolean commands
    */
   while (OptionsTable[i].id)
   {
      if (IsDlgButtonChecked(hwnd, OptionsTable[i].id))
      {
         if (strlen(OptionsTable[i].command) > 0)
            argv[argc++] = OptionsTable[i].command;
      } else
      {
         if (strlen(OptionsTable[i].nocommand) > 0)
            argv[argc++] = OptionsTable[i].nocommand;
      }
      i++;
   }

   /*
    * * do all the numeric commands
    */
   i = 0;
   while (int_table[i].id)
   {
      GetDlgItemText(hwnd, int_table[i].id, int_str, sizeof(int_str));
      strcat(int_table[i].command, int_str);
      argv[argc++] = int_table[i].command;
      i++;
   }

   /*
    * go and run indent
    * TBD: Open a console for debug printf messages
    */
   // AllocConsole();
   indentmain(argc, argv);

   return 1;
}

/*********************************************************************
* Name:			DialogFunc
* Description:	This is the main function for the dialog. It handles all messages. Do what your
* 				application needs to do here.
*********************************************************************/
static BOOL CALLBACK DialogFunc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
   UINT            numfiles;
   char            pathname[256] = "hello.txt";
   HDROP           hdrop;
   char            inputfile[512];

   switch (msg)
   {
      /*
       * This message means the dialog is started but not yet visible. Do
       * All initializations here
       */
   case WM_INITDIALOG:
      if (InitializeApp(hwndDlg, wParam, lParam) == FALSE)
      {
         // Batch file operation
         // If a filename was supplied on command line then run immediately
         // and return
         if (!GetDlgItemText(hwndDlg, IDFILE, wd_input_file, 500))
         {
            ShowDbgMsg("You must enter a file name to indent");
            return TRUE;
         }
         ReadArgumentsAndStart(hwndDlg);
         EndDialog(hwndDlg, 0);
      }
      return TRUE;

      /*
       * By default, IDOK means close this dialog returning 1, IDCANCEL
       * means close this dialog returning zero
       */
   case WM_COMMAND:
      switch (LOWORD(wParam))
      {
      case IDOK:
         if (!GetDlgItemText(hwndDlg, IDFILE, wd_input_file, 500))
         {
            ShowDbgMsg("You must enter a file name to indent");
            return 1;
         }
         ReadArgumentsAndStart(hwndDlg);

         // TBD: Indent doesn't close the file when done
         // It relies on the OS to close it when the app terminates
         // This bug precludes processing of multiple files!!!
         EndDialog(hwndDlg, 1);
         return 1;

      case IDCANCEL:
         EndDialog(hwndDlg, 0);
         return 1;

      case IDBROWSE:

         if (DlgFileSelected("C Files|*.c", "Enter name of file to be indented", inputfile))
         {
            strcpy(wd_input_file, inputfile);
            SetDlgItemText(hwndDlg, IDFILE, wd_input_file);
         }
         break;
      }
      break;

      /*
       * By default, WM_CLOSE is equivalent to CANCEL
       */
   case WM_CLOSE:
      EndDialog(hwndDlg, 0);
      return TRUE;

   case WM_DROPFILES:
      // get a pointer to the drop file list
      hdrop = (HDROP) wParam;

      // get number of files in list
      numfiles = DragQueryFile(hdrop, -1, NULL, 0);

      // sprintf(teststring, "Numfiles=%04x", numfiles);
      // MessageBox(NULL,teststring,"Number of Files Dropped",MB_OK);

      // process a file, if any
      // handle multiple dropped files in a loop
      while (numfiles)
      {
         // get the first file name
         // NOTE: The file name index is one less than the number of files
         DragQueryFile(hdrop, --numfiles, pathname, MAX_PATH);
         // MessageBox(NULL,pathname,"Dropped Filename",MB_OK);

         // Dropped files require the full path
         // Since the application doesn't know where they are coming from
         if (sizeof(wd_input_file) - strlen(pathname) - strlen(wd_input_file) - 4)
         {
            strcat(wd_input_file, " \"");
            strcat(wd_input_file, pathname);
            strcat(wd_input_file, "\"");
         }
         // write it to the edit box
         SetDlgItemText(hwndDlg, IDFILE, wd_input_file);
      }
      // free the dropped files list
      DragFinish(hdrop);
      break;

   }
   return FALSE;
}

/*********************************************************************
* Name:			werror
* Description:	Error trap for the exit() function used by indent
*               Put a breakpoint here to catch exit()
* Constraints;	none
*********************************************************************/
void            werror(int errnum)
{
   printf("ERROR %d!!!", errnum);
}
