/*
 * Decompiled with CFR 0.152.
 */
package stec.ss;

import stec.ss.ssException;
import stec.ss.ssToken;

class ssValue {
    private static final String _ = "Copyright (c) 1997-1999 Manuel J. Goyenechea. All rights reserved.";
    private int type;
    private String sValue;
    private double dValue;
    private int iValue;
    private long lValue;
    private Object oValue;

    protected ssValue(Object object) {
        this.type = object == null ? 700 : 600;
        this.oValue = object;
    }

    protected ssValue(String string) {
        if (string == null) {
            this.type = 700;
            this.sValue = string;
            return;
        }
        this.type = 200;
        this.sValue = new String(string);
    }

    protected ssValue(double d) {
        this.type = 500;
        this.dValue = d;
    }

    protected ssValue(int n) {
        this.type = 300;
        this.iValue = n;
    }

    protected ssValue(long l) {
        this.type = 400;
        this.lValue = l;
    }

    protected ssValue(ssValue ssValue2) throws Exception {
        this.type = ssValue2.type;
        switch (this.type) {
            case 600: {
                this.oValue = ssValue2.getObjectValue();
                return;
            }
            case 200: {
                this.sValue = ssValue2.getStringValue();
                return;
            }
            case 500: {
                this.dValue = ssValue2.getDoubleValue();
                return;
            }
            case 300: {
                this.iValue = ssValue2.getIntegerValue();
                return;
            }
            case 400: {
                this.lValue = ssValue2.getLongValue();
                return;
            }
            case 700: {
                this.oValue = null;
                return;
            }
        }
        throw new ssException(8, "value type", ssValue2.getTypeString());
    }

    protected ssValue(boolean bl) {
        this.type = 300;
        if (bl) {
            this.iValue = 1;
            return;
        }
        this.iValue = 0;
    }

    protected ssValue(Object object, boolean bl) {
        this.type = 600;
        this.oValue = object;
    }

    protected ssValue(String string, boolean bl) {
        this.type = 200;
        this.sValue = new String(string);
    }

    protected ssValue(double d, boolean bl) {
        this.type = 500;
        this.dValue = d;
    }

    protected ssValue(int n, boolean bl) {
        this.type = 300;
        this.iValue = n;
    }

    protected ssValue(long l, boolean bl) {
        this.type = 400;
        this.lValue = l;
    }

    protected ssValue(ssValue ssValue2, boolean bl) throws Exception {
        this.type = ssValue2.type;
        switch (this.type) {
            case 600: {
                this.oValue = ssValue2.getObjectValue();
                return;
            }
            case 200: {
                this.sValue = ssValue2.getStringValue();
                return;
            }
            case 500: {
                this.dValue = ssValue2.getDoubleValue();
                return;
            }
            case 300: {
                this.iValue = ssValue2.getIntegerValue();
                return;
            }
            case 400: {
                this.lValue = ssValue2.getLongValue();
                return;
            }
            case 700: {
                this.oValue = null;
                return;
            }
        }
        throw new ssException(8, "value type", ssValue2.getTypeString());
    }

    protected ssValue(boolean bl, boolean bl2) {
        this.type = 200;
        if (bl) {
            this.iValue = 1;
            return;
        }
        this.iValue = 0;
    }

    protected static final ssValue copy(ssValue ssValue2) throws Exception {
        switch (ssValue2.type) {
            case 600: {
                return new ssValue(ssValue2.getObjectValue());
            }
            case 200: {
                return new ssValue(ssValue2.getStringValue());
            }
            case 300: {
                return new ssValue(ssValue2.getIntegerValue());
            }
            case 400: {
                return new ssValue(ssValue2.getLongValue());
            }
            case 500: {
                return new ssValue(ssValue2.getDoubleValue());
            }
        }
        throw new ssException(8, "value type", ssValue2.getTypeString());
    }

    protected static final ssValue copy(ssValue ssValue2, boolean bl) throws Exception {
        switch (ssValue2.type) {
            case 600: {
                return new ssValue(ssValue2.getObjectValue(), bl);
            }
            case 200: {
                return new ssValue(ssValue2.getStringValue(), bl);
            }
            case 300: {
                return new ssValue(ssValue2.getIntegerValue(), bl);
            }
            case 400: {
                return new ssValue(ssValue2.getLongValue(), bl);
            }
            case 500: {
                return new ssValue(ssValue2.getDoubleValue(), bl);
            }
        }
        throw new ssException(8, "value type", ssValue2.getTypeString());
    }

    protected final Object getObjectValue() throws Exception {
        switch (this.type) {
            case 200: {
                return new String(this.sValue);
            }
            case 500: {
                return new Double(this.dValue);
            }
            case 300: {
                return new Integer(this.iValue);
            }
            case 400: {
                return new Long(this.lValue);
            }
            case 600: {
                return this.oValue;
            }
        }
        throw new ssException(8, "value type", this.getTypeString());
    }

    protected final String getStringValue() throws Exception {
        switch (this.type) {
            case 200: {
                return this.sValue;
            }
            case 500: {
                return String.valueOf(this.dValue);
            }
            case 300: {
                return String.valueOf(this.iValue);
            }
            case 400: {
                return String.valueOf(this.lValue);
            }
            case 600: {
                return String.valueOf(this.oValue);
            }
        }
        throw new ssException(8, "value type", this.getTypeString());
    }

    protected final int getIntegerValue() throws Exception {
        switch (this.type) {
            case 200: {
                return Integer.parseInt(this.sValue);
            }
            case 500: {
                return new Double(this.dValue).intValue();
            }
            case 300: {
                return this.iValue;
            }
            case 400: {
                return (int)this.lValue;
            }
        }
        throw new ssException(8, "value type", this.getTypeString());
    }

    protected final long getLongValue() throws Exception {
        switch (this.type) {
            case 200: {
                return Long.parseLong(this.sValue);
            }
            case 500: {
                return new Double(this.dValue).longValue();
            }
            case 300: {
                return this.iValue;
            }
            case 400: {
                return this.lValue;
            }
        }
        throw new ssException(8, "value type", this.getTypeString());
    }

    protected final double getDoubleValue() throws Exception {
        switch (this.type) {
            case 200: {
                return Double.valueOf(this.sValue);
            }
            case 500: {
                return this.dValue;
            }
            case 300: {
                return this.iValue;
            }
            case 400: {
                return this.lValue;
            }
        }
        throw new ssException(8, "value type", this.getTypeString());
    }

    protected static final ssValue evaluateBinary(byte by, ssValue ssValue2, ssValue ssValue3) throws Exception {
        if (ssValue2.type == 700 && true || ssValue3.type == 700 && true) {
            return ssValue.evaluateBinaryNull(by, ssValue2, ssValue3);
        }
        if (ssValue2.type == 200 && true || ssValue3.type == 200 && true) {
            return ssValue.evaluateBinaryString(by, ssValue2.getStringValue(), ssValue3.getStringValue());
        }
        switch (ssValue2.type) {
            case 500: {
                return ssValue.evaluateBinaryDouble(by, ssValue2.getDoubleValue(), ssValue3.getDoubleValue());
            }
            case 300: {
                switch (ssValue2.type) {
                    case 500: {
                        return ssValue.evaluateBinaryDouble(by, ssValue2.getDoubleValue(), ssValue3.getDoubleValue());
                    }
                    case 300: {
                        return ssValue.evaluateBinaryInteger(by, ssValue2.getIntegerValue(), ssValue3.getIntegerValue());
                    }
                    case 400: {
                        return ssValue.evaluateBinaryLong(by, ssValue2.getLongValue(), ssValue3.getLongValue());
                    }
                }
                throw new ssException(8, "value type", ssValue3.getTypeString());
            }
            case 400: {
                switch (ssValue2.type) {
                    case 500: {
                        return ssValue.evaluateBinaryDouble(by, ssValue2.getDoubleValue(), ssValue3.getDoubleValue());
                    }
                    case 300: {
                        return ssValue.evaluateBinaryLong(by, ssValue2.getLongValue(), ssValue3.getLongValue());
                    }
                    case 400: {
                        return ssValue.evaluateBinaryLong(by, ssValue2.getLongValue(), ssValue3.getLongValue());
                    }
                }
                throw new ssException(8, "value type", ssValue3.getTypeString());
            }
        }
        throw new ssException(8, "value type", ssValue2.getTypeString());
    }

    private static final ssValue evaluateBinaryString(byte by, String string, String string2) throws Exception {
        switch (by) {
            case 61: {
                return new ssValue(string.compareTo(string2) == 0);
            }
            case 53: {
                return new ssValue(string.compareTo(string2) != 0);
            }
            case 60: {
                return new ssValue(string.compareTo(string2) < 0);
            }
            case 54: {
                return new ssValue(string.compareTo(string2) <= 0);
            }
            case 62: {
                return new ssValue(string.compareTo(string2) > 0);
            }
            case 55: {
                return new ssValue(string.compareTo(string2) >= 0);
            }
            case 56: {
                return new ssValue(string.length() != 0 && string2.length() != 0);
            }
            case 57: {
                return new ssValue(string.length() != 0 || string2.length() != 0);
            }
            case 43: {
                return new ssValue(string.concat(string2));
            }
        }
        throw new ssException(24, "operation", ssToken.sToken(by), "String");
    }

    private static final ssValue evaluateBinaryDouble(byte by, double d, double d2) throws Exception {
        switch (by) {
            case 61: {
                return new ssValue(d == d2);
            }
            case 53: {
                return new ssValue(d != d2);
            }
            case 60: {
                return new ssValue(d < d2);
            }
            case 54: {
                return new ssValue(d <= d2);
            }
            case 62: {
                return new ssValue(d > d2);
            }
            case 55: {
                return new ssValue(d >= d2);
            }
            case 56: {
                return new ssValue(d != 0.0 && d2 != 0.0);
            }
            case 57: {
                return new ssValue(d != 0.0 || d2 != 0.0);
            }
            case 43: {
                return new ssValue(d + d2);
            }
            case 45: {
                return new ssValue(d - d2);
            }
            case 42: {
                return new ssValue(d * d2);
            }
            case 47: {
                return new ssValue(d / d2);
            }
        }
        throw new ssException(24, "operation", ssToken.sToken(by), "Double");
    }

    private static final ssValue evaluateBinaryInteger(byte by, int n, int n2) throws Exception {
        switch (by) {
            case 61: {
                return new ssValue(n == n2);
            }
            case 53: {
                return new ssValue(n != n2);
            }
            case 60: {
                return new ssValue(n < n2);
            }
            case 54: {
                return new ssValue(n <= n2);
            }
            case 62: {
                return new ssValue(n > n2);
            }
            case 55: {
                return new ssValue(n >= n2);
            }
            case 56: {
                return new ssValue(n != 0 && n2 != 0);
            }
            case 57: {
                return new ssValue(n != 0 || n2 != 0);
            }
            case 38: {
                return new ssValue(n & n2);
            }
            case 124: {
                return new ssValue(n | n2);
            }
            case 94: {
                return new ssValue(n ^ n2);
            }
            case 43: {
                return new ssValue(n + n2);
            }
            case 45: {
                return new ssValue(n - n2);
            }
            case 42: {
                return new ssValue(n * n2);
            }
            case 47: {
                return new ssValue(n / n2);
            }
        }
        throw new ssException(24, "operation", ssToken.sToken(by), "Integer");
    }

    private static final ssValue evaluateBinaryLong(byte by, long l, long l2) throws Exception {
        switch (by) {
            case 61: {
                return new ssValue(l == l2);
            }
            case 53: {
                return new ssValue(l != l2);
            }
            case 60: {
                return new ssValue(l < l2);
            }
            case 54: {
                return new ssValue(l <= l2);
            }
            case 62: {
                return new ssValue(l > l2);
            }
            case 55: {
                return new ssValue(l >= l2);
            }
            case 56: {
                return new ssValue(l != 0L && l2 != 0L);
            }
            case 57: {
                return new ssValue(l != 0L || l2 != 0L);
            }
            case 38: {
                return new ssValue(l & l2);
            }
            case 124: {
                return new ssValue(l | l2);
            }
            case 94: {
                return new ssValue(l ^ l2);
            }
            case 43: {
                return new ssValue(l + l2);
            }
            case 45: {
                return new ssValue(l - l2);
            }
            case 42: {
                return new ssValue(l * l2);
            }
            case 47: {
                return new ssValue(l / l2);
            }
        }
        throw new ssException(24, "operation", ssToken.sToken(by), "Long");
    }

    private static final ssValue evaluateBinaryNull(byte by, ssValue ssValue2, ssValue ssValue3) throws Exception {
        switch (by) {
            case 61: {
                return new ssValue(ssValue2.type == 700 == (ssValue3.type == 700));
            }
            case 53: {
                return new ssValue(ssValue2.type == 700 != (ssValue3.type == 700));
            }
            case 56: {
                return new ssValue(ssValue2.type == 700 && true && ssValue3.type == 700 && true);
            }
            case 57: {
                return new ssValue(ssValue2.type == 700 && true || ssValue3.type == 700 && true);
            }
        }
        throw new ssException(25, "operation", ssValue2.getTypeString(), ssToken.sToken(by), ssValue2.getTypeString());
    }

    protected static final ssValue evaluateUnary(byte by, ssValue ssValue2) throws Exception {
        switch (ssValue2.type) {
            case 700: {
                return ssValue.evaluateUnaryNull(by, ssValue2);
            }
            case 200: {
                return ssValue.evaluateUnaryString(by, ssValue2.getStringValue());
            }
            case 500: {
                return ssValue.evaluateUnaryDouble(by, ssValue2.getDoubleValue());
            }
            case 300: {
                return ssValue.evaluateUnaryInteger(by, ssValue2.getIntegerValue());
            }
            case 400: {
                return ssValue.evaluateUnaryLong(by, ssValue2.getLongValue());
            }
        }
        throw new ssException(26, "operation", ssToken.sToken(by), ssValue2.getTypeString());
    }

    private static final ssValue evaluateUnaryString(byte by, String string) throws Exception {
        switch (by) {
            case 61: {
                return new ssValue(string);
            }
            case 33: {
                return new ssValue(string.length() == 0);
            }
        }
        throw new ssException(26, "operation", ssToken.sToken(by), "String");
    }

    private static final ssValue evaluateUnaryDouble(byte by, double d) throws Exception {
        switch (by) {
            case 61: {
                return new ssValue(d);
            }
            case 33: {
                return new ssValue(d == 0.0);
            }
            case 45: {
                return new ssValue(-d);
            }
            case 43: {
                return new ssValue(d);
            }
        }
        throw new ssException(26, "operation", ssToken.sToken(by), "Double");
    }

    private static final ssValue evaluateUnaryInteger(byte by, int n) throws Exception {
        switch (by) {
            case 61: {
                return new ssValue(n);
            }
            case 33: {
                return new ssValue(n == 0);
            }
            case 45: {
                return new ssValue(-n);
            }
            case 43: {
                return new ssValue(n);
            }
        }
        throw new ssException(26, "operation", ssToken.sToken(by), "Integer");
    }

    private static final ssValue evaluateUnaryLong(byte by, long l) throws Exception {
        switch (by) {
            case 61: {
                return new ssValue(l);
            }
            case 33: {
                return new ssValue(l == 0L);
            }
            case 45: {
                return new ssValue(-l);
            }
            case 43: {
                return new ssValue(l);
            }
        }
        throw new ssException(26, "operation", ssToken.sToken(by), "Long");
    }

    private static final ssValue evaluateUnaryNull(byte by, ssValue ssValue2) throws Exception {
        if (by == 61) {
            return new ssValue(ssValue2);
        }
        throw new ssException(26, "operation", ssToken.sToken(by), ssValue2.getTypeString());
    }

    protected final int getType() {
        return this.type;
    }

    protected final String getTypeString() {
        switch (this.type) {
            case 600: {
                return "object";
            }
            case 200: {
                return "string";
            }
            case 500: {
                return "double";
            }
            case 300: {
                return "integer";
            }
            case 400: {
                return "long";
            }
            case 700: {
                return "null";
            }
        }
        return Integer.toString(this.type);
    }

    protected final boolean isObject() {
        return this.type == 600;
    }

    protected final boolean isString() {
        return this.type == 200;
    }

    protected final boolean isNumeric() {
        switch (this.type) {
            case 300: 
            case 400: 
            case 500: {
                return true;
            }
            case 200: {
                try {
                    Double.valueOf(this.sValue).doubleValue();
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
        }
        return false;
    }

    protected final boolean isDouble() {
        return this.type == 500;
    }

    protected final boolean isInteger() {
        return this.type == 300;
    }

    protected final boolean isLong() {
        return this.type == 400;
    }

    protected final boolean isNull() {
        return this.type == 700;
    }

    protected final boolean isTrue() throws Exception {
        switch (this.type) {
            case 200: {
                return this.sValue.length() != 0;
            }
            case 500: {
                return this.dValue != 0.0;
            }
            case 300: {
                return this.iValue != 0;
            }
            case 400: {
                return this.lValue != 0L;
            }
        }
        throw new ssException(8, "value type", this.getTypeString());
    }

    protected final boolean isFalse() throws Exception {
        return !this.isTrue();
    }
}

