/*
 * Decompiled with CFR 0.152.
 */
package stec.ss;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Hashtable;
import stec.ss.ssCookie;
import stec.ss.ssException;
import stec.ss.ssSystem;

abstract class ssResponse {
    private static final String _ = "Copyright (c) 1997-1999 Manuel J. Goyenechea. All rights reserved.";
    protected static final int status_ok = 200;
    protected static final int status_created = 201;
    protected static final int status_accepted = 202;
    protected static final int status_partial_information = 203;
    protected static final int status_no_content = 204;
    protected static final int status_moved_permanently = 301;
    protected static final int status_moved_temporarily = 302;
    protected static final int status_not_modified = 304;
    protected static final int status_bad_request = 400;
    protected static final int status_unauthorized = 401;
    protected static final int status_forbidden = 403;
    protected static final int status_not_found = 404;
    protected static final int status_internal_server_error = 500;
    protected static final int status_not_implemented = 501;
    protected static final int status_bad_gateway = 502;
    protected static final int status_gateway_timeout = 503;
    protected boolean headerSent = false;
    protected long content_length;
    protected Hashtable headers;
    protected Hashtable cookies;
    protected ByteArrayOutputStream bufferedOutputStream;
    protected boolean isBuffered = false;
    protected int status = 200;
    protected String charset;
    protected String content_type = "text/html";
    protected long last_modified = -1L;
    protected long expires = -1L;
    protected String content_encoding;
    protected boolean cache_content = false;
    protected boolean isRaw = false;
    protected OutputStream os;
    protected ssSystem system;

    protected ssResponse() {
    }

    protected ssResponse(ssSystem ssSystem2) {
        this.system = ssSystem2;
    }

    protected final void setStatus(int n) {
        this.status = n;
    }

    protected final int getStatus() {
        return this.status;
    }

    protected final long getContentLength() {
        if (this.bufferedOutputStream == null) {
            return this.content_length;
        }
        return this.content_length + (long)this.bufferedOutputStream.size();
    }

    protected final void setContentLength(long l) {
        this.content_length = l;
    }

    protected static final String encode(String string) {
        return URLEncoder.encode(string);
    }

    protected final Hashtable Headers() throws ssException {
        if (this.headers != null) {
            return this.headers;
        }
        if (!this.system.gListOption && this.content_length > 0L) {
            throw new ssException(19, "Headers()");
        }
        this.headers = new Hashtable();
        return this.headers;
    }

    protected final String Headers(String string) throws ssException {
        Hashtable hashtable = this.Headers();
        if (hashtable == null) {
            return null;
        }
        Object v = hashtable.get(string);
        if (v == null) {
            return null;
        }
        return (String)v;
    }

    protected final String Headers(String string, String string2) throws ssException {
        if (!this.system.gListOption && this.content_length > 0L) {
            throw new ssException(19, "Headers()");
        }
        Hashtable hashtable = this.Headers();
        if (hashtable == null) {
            return null;
        }
        return hashtable.put(string, string2);
    }

    protected final Hashtable Cookies() throws ssException {
        if (this.cookies != null) {
            return this.cookies;
        }
        if (!this.system.gListOption && this.content_length > 0L) {
            throw new ssException(19, "Cookies()");
        }
        this.cookies = new Hashtable();
        return this.cookies;
    }

    protected final ssCookie Cookies(String string) throws ssException {
        Hashtable hashtable = this.Cookies();
        if (hashtable == null) {
            return null;
        }
        Object v = hashtable.get(string);
        if (v == null) {
            return null;
        }
        return (ssCookie)v;
    }

    protected final ssCookie Cookies(ssCookie ssCookie2) throws ssException {
        if (!this.system.gListOption && this.content_length > 0L) {
            throw new ssException(19, "Cookies()");
        }
        Hashtable hashtable = this.Cookies();
        if (hashtable == null) {
            return null;
        }
        ssCookie ssCookie3 = hashtable.put(ssCookie2.getName(), ssCookie2);
        if (ssCookie3 == null) {
            return null;
        }
        return ssCookie3;
    }

    protected final ssCookie Cookies(String string, String string2) throws ssException {
        if (!this.system.gListOption && this.content_length > 0L) {
            throw new ssException(19, "Cookies()");
        }
        Hashtable hashtable = this.Cookies();
        if (hashtable == null) {
            return null;
        }
        ssCookie ssCookie2 = new ssCookie(string, string2);
        ssCookie ssCookie3 = hashtable.put(string, ssCookie2);
        if (ssCookie3 == null) {
            return null;
        }
        return ssCookie3;
    }

    protected final boolean getIsBuffered() {
        return this.isBuffered;
    }

    protected final void setIsBuffered(boolean bl) throws ssException, IOException {
        if (bl == this.isBuffered) {
            return;
        }
        if (bl) {
            if (!this.system.gListOption && this.content_length > 0L) {
                throw new ssException(19, "setIsBuffered()");
            }
            this.bufferedOutputStream = new ByteArrayOutputStream();
            this.content_length = 0L;
        } else {
            if (this.isBuffered) {
                this.flush();
            }
            this.bufferedOutputStream = null;
        }
        this.isBuffered = bl;
    }

    protected final void reset() throws ssException {
        if (!this.isBuffered) {
            throw new ssException(18, "reset()");
        }
        this.bufferedOutputStream.reset();
    }

    protected final void flush() throws ssException, IOException {
        if (!this.isBuffered) {
            throw new ssException(18, "flush()");
        }
        if (this.bufferedOutputStream.size() > 0) {
            this.content_length += (long)this.bufferedOutputStream.size();
            if (!this.isRaw) {
                this.sendHeader();
            }
            this.bufferedOutputStream.writeTo(this.os);
            this.os.flush();
            this.bufferedOutputStream.reset();
            return;
        }
        if (!this.isRaw) {
            this.sendHeader();
        }
    }

    protected final void write(int n) throws IOException {
        if (this.isBuffered) {
            this.bufferedOutputStream.write(n);
            return;
        }
        if (!this.isRaw) {
            this.sendHeader();
        }
        this.os.write(n);
        ++this.content_length;
    }

    protected final void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.isBuffered) {
            this.bufferedOutputStream.write(byArray, n, n2);
            return;
        }
        if (!this.isRaw) {
            this.sendHeader();
        }
        this.os.write(byArray, n, n2);
        this.content_length += (long)byArray.length;
    }

    protected final void write(byte[] byArray) throws IOException {
        if (this.isBuffered) {
            this.bufferedOutputStream.write(byArray);
            return;
        }
        if (!this.isRaw) {
            this.sendHeader();
        }
        this.os.write(byArray);
        this.content_length += (long)byArray.length;
    }

    protected final void print(String string) throws IOException {
        if (this.isBuffered) {
            this.write(string.getBytes());
            return;
        }
        if (!this.isRaw) {
            this.sendHeader();
        }
        this.os.write(string.getBytes());
        this.content_length += (long)string.length();
    }

    protected final void println(String string) throws IOException {
        this.print(String.valueOf(string) + '\n');
    }

    protected final String bufferToString() throws ssException {
        if (!this.isBuffered) {
            throw new ssException(18, "bufferToString()");
        }
        return this.bufferedOutputStream.toString();
    }

    protected final byte[] bufferToByteArray() throws ssException {
        if (!this.isBuffered) {
            throw new ssException(18, "bufferToByteArray()");
        }
        return this.bufferedOutputStream.toByteArray();
    }

    protected final void setCharset(String string) {
        this.charset = string;
    }

    protected final String getCharset() {
        return this.charset;
    }

    protected final void setContentType(String string) {
        this.content_type = string;
    }

    protected final String getContentType() {
        return this.content_type;
    }

    protected final void setLastModified(long l) {
        this.last_modified = l;
    }

    protected final long getLastModified() {
        if (this.last_modified == -1L) {
            this.last_modified = this.system.lastModified();
        }
        return this.last_modified;
    }

    protected final void setExpires(long l) {
        this.expires = l;
    }

    protected final long getExpires() {
        return this.expires;
    }

    protected final void setContentEncoding(String string) {
        this.content_encoding = string;
    }

    protected final String getContentEncoding() {
        return this.content_encoding;
    }

    protected final void setCacheContent(boolean bl) {
        this.cache_content = bl;
    }

    protected final boolean getCacheContent() {
        return this.cache_content;
    }

    protected final boolean getIsRaw() {
        return this.isRaw;
    }

    protected final void setIsRaw(boolean bl) throws ssException {
        if (!this.system.gListOption && this.content_length > 0L) {
            throw new ssException(19, "setIsRaw()");
        }
        this.isRaw = bl;
    }

    protected final void log(String string) throws Exception {
        this.system.log(string);
    }

    protected final String charset() {
        if (this.charset == null) {
            return null;
        }
        return "charset=" + this.charset;
    }

    protected abstract void sendHeader();

    protected abstract void redirect(String var1) throws ssException, IOException;
}

