
`  Dir Class
`  Scriptol-Php - (c) 2001  D.G Sureau
`  www.scriptol.com

`  This is a wrapper to directory and related functions in Php
`  plus general purpose functions added to, and that use them

`  The path separator is "/" under Unix and Windows


class Dir

 dyn handle = 0          ` a PHP ressource
 int total = 0
 text name = ""

 ` OPEN - Open a directory
 boolean open(text path)
   handle = opendir(path)
   name = path
 return true


 ` CLOSE - Close the directory
 void close()
  closedir(handle);
 return


 ` NEXT
 ` Get the next filename in the directory and increments the pointer
 ` Return nil if no more file

 text nextFile():   return readdir(handle)


 ` BEGIN - Go to the first entry
 void begin():   rewinddir(handle);  return


 ` EXISTS - Test if a file exists
 boolean exists(text dname): return file_exists(dname)


 ` SIZE - Return the size of a file
 int size(text fname):   return filesize(fname)


 ` TYPE - Return the type of an entry: file, dir, etc...
 text type(text fname):   return filetype(fname)

 ` ISFILE
 boolean isFile(text fname) return filetype(fname) = "file"

 ` ISDIR
 boolean isDir(text fname)
  text t = type(fname)
  if t = "link" ? return false
  if t != "dir" ? return false
 return true

 ` RENAME
 boolean rename(text oldname, text newname) return rename(oldname, newname)

 ` DELETE
 boolean delete(text fname) return unlink(fname)

 ` MERGE - Merge elements of path
 text merge(text path, text filename)
   if path = "" ? return filename
   if filename = "" ? return path
   if (path[path.length()-1] <> "/") and (filename[0] <> "/") ? path + "/"
 return path + filename


 ` SPLIT EXT - Split the node and the extension of a filename or path
 text, text splitExt(text path)
   int l = path.length()
   if l = 0 ? return "", ""
   for int x in l - 1 .. 0 step -1
    if path[x] = "." ? return path[--x], path[x + 1..]
   /for
 return path, ""


 ` GETLIST
 ` Return the list of all filenames in a directory
 ` If the path doesn't exist or is not a directory, return an empty list

 array getList(text path)
   array dlist = ()
   if not exists(path) ? return dlist
   if type(path) <> "dir" ? return dlist
   open(path)

   begin()
   do
     text fname = nextFile()
     if fname = nil ? break
     if fname in (".", "..") ? continue
     dlist.push(fname)
   /do forever
   close()
 return dlist


`  DISPDIR
`  Displays the content of a directory with size of files
`  Returns number of files, number of dirs, total size.
 
 int, int, int dispDir(text path)
   total = 0             ` total size of all files
   int files = 0         ` counter of files
   int dirs = 0          ` counter of subdirectories
   text sizestr = ""     ` the size as a string or <dir>

   if not exists(path) or (type(path) <> "dir")
     print path, "no found"
     exit()
   /if

   open(path)       ` open the directory
   begin()               ` move the pointer to the first entry

   do
     text fname = nextFile()                 ` the name of an entry
     text fullname = merge(path , fname)
     if fname = nil ? break
     if fname in (".", "..") ? continue  ` ignore these

     if type(fullname)
     = "dir" :              ` if a subdirectory
               sizestr = "<dir>"
               dirs + 1
     = "file" :             ` if a file
               number si = size(fullname)
               sizestr = strval(si)
               files + 1
               total + si   ` add size to total
     else:
               sizestr = "<unknow type>"
     /if
     print pad(fname, 32), pad(sizestr, 9, " ", $(STR_PAD_LEFT))

   /do forever

   close()
   print pad(strval(files), 20, " ", $(STR_PAD_LEFT)), "files(s)   ", total, "bytes"
   print pad(strval(dirs), 20, " ", $(STR_PAD_LEFT)) , "dir(s)"

 return files, dirs, total

/class

// testing
//Dir mydir
//mydir.dispDir("c:/")
