<HTML>
<HEAD>
<TITLE>Scriptol PHP</TITLE>
<STYLE TYPE="text/css" MEDIA=screen >
<!--
 BODY { font-family: "Courrier New", Courrier, mono, Monospaced, Arial }
 TABLE { font-family: "Courrier New", Courrier, mono, Monospaced, Arial  }
 H3 { font-size: 12pt; color: #333399 }
 H4 { font-size: 11pt; color: #333399 }
 H5 { font-size: 10pt; color: #333399 }
 H6 { font-size: 9pt;  color: #333399 }
 H7 { font-size: 9pt;  color: #333399 }
 PRE { font-family: "Courrier New", Courrier, mono, Monospaced, Arial;  color: #000099 }
 A:link { text-decoration: none; color: #33cc66 }
 A:visited { text-decoration: none; color: #009933 }
 A:hover { text-decoration: none; color: #66ff99 }
-->
</STYLE>
</HEAD>
<BODY bgcolor=#FFFFFF>
<center>Scriptol PHP</center>
<center>Common reference manual</center>
<center>(c) 2001 by D.G. Sureau</center>
<center>www.scriptol.com</center>
<br><hr>
<TABLE align="center" width="500">
<TR><TD>
&nbsp<a href="#title0"><span style="font size=14ptcolor=green">Overview</span></a><br>
&nbsp<a href="#title1"><span style="font size=14ptcolor=green">About this manual</span></a><br>
&nbsp<a href="#title2"><span style="font size=14ptcolor=green">Compiling a Scriptol program</span></a><br>
&nbsp<a href="#title3"><span style="font size=14ptcolor=green">Scriptol file</span></a><br>
&nbsp<a href="#title4"><span style="font size=14ptcolor=green">Scriptol in html page</span></a><br>
&nbsp<a href="#title5"><span style="font size=14ptcolor=green">Statement</span></a><br>
&nbsp<a href="#title6"><span style="font size=14ptcolor=green">Comment</span></a><br>
&nbsp<a href="#title7"><span style="font size=14ptcolor=green">Symbols</span></a><br>
&nbsp<a href="#title8"><span style="font size=14ptcolor=green">Variable or primitives</span></a><br>
&nbsp&nbsp<a href="#title9"><span style="font size=12ptcolor=green"> Declaration</span></a><br>
&nbsp<a href="#title10"><span style="font size=14ptcolor=green">Constant</span></a><br>
&nbsp<a href="#title11"><span style="font size=14ptcolor=green">External variables and constants</span></a><br>
&nbsp<a href="#title12"><span style="font size=14ptcolor=green">Assignment</span></a><br>
&nbsp&nbsp<a href="#title13"><span style="font size=12ptcolor=green"> Multiple assignments</span></a><br>
&nbsp&nbsp&nbsp<a href="#title14"><span style="font size=11ptcolor=green">  The complete rule</span></a><br>
&nbsp&nbsp&nbsp<a href="#title15"><span style="font size=11ptcolor=green">  Reversing assignment</span></a><br>
&nbsp&nbsp<a href="#title16"><span style="font size=12ptcolor=green"> Tips</span></a><br>
&nbsp<a href="#title17"><span style="font size=14ptcolor=green">Operators</span></a><br>
&nbsp&nbsp<a href="#title18"><span style="font size=12ptcolor=green"> Precedence</span></a><br>
&nbsp<a href="#title19"><span style="font size=14ptcolor=green">Function</span></a><br>
&nbsp<a href="#title20"><span style="font size=14ptcolor=green">Arguments of a function: the alias modifier</span></a><br>
&nbsp<a href="#title21"><span style="font size=14ptcolor=green">The main function</span></a><br>
&nbsp<a href="#title22"><span style="font size=14ptcolor=green">Print and echo</span></a><br>
&nbsp&nbsp<a href="#title23"><span style="font size=12ptcolor=green"> Print</span></a><br>
&nbsp&nbsp<a href="#title24"><span style="font size=12ptcolor=green"> Echo</span></a><br>
&nbsp<a href="#title25"><span style="font size=14ptcolor=green">Control structures</span></a><br>
&nbsp<a href="#title26"><span style="font size=14ptcolor=green">The if construct</span></a><br>
&nbsp&nbsp<a href="#title27"><span style="font size=12ptcolor=green"> One-instruction</span></a><br>
&nbsp&nbsp<a href="#title28"><span style="font size=12ptcolor=green"> Multi-lines</span></a><br>
&nbsp<a href="#title29"><span style="font size=14ptcolor=green">The composite if construct</span></a><br>
&nbsp&nbsp<a href="#title30"><span style="font size=12ptcolor=green"> The match operator</span></a><br>
&nbsp<a href="#title31"><span style="font size=14ptcolor=green">The for construct</span></a><br>
&nbsp&nbsp<a href="#title32"><span style="font size=12ptcolor=green"> One-instruction for</span></a><br>
&nbsp<a href="#title33"><span style="font size=14ptcolor=green">The scan construct</span></a><br>
&nbsp<a href="#title34"><span style="font size=14ptcolor=green">The while construct</span></a><br>
&nbsp&nbsp<a href="#title35"><span style="font size=12ptcolor=green"> The while let option</span></a><br>
&nbsp&nbsp<a href="#title36"><span style="font size=12ptcolor=green"> Simplified syntax</span></a><br>
&nbsp&nbsp<a href="#title37"><span style="font size=12ptcolor=green"> The forever option</span></a><br>
&nbsp<a href="#title38"><span style="font size=14ptcolor=green">The do while construct</span></a><br>
&nbsp<a href="#title39"><span style="font size=14ptcolor=green">The do case construct</span></a><br>
&nbsp<a href="#title40"><span style="font size=14ptcolor=green">The do until construct</span></a><br>
&nbsp<a href="#title41"><span style="font size=14ptcolor=green">The enum construct</span></a><br>
&nbsp<a href="#title42"><span style="font size=14ptcolor=green">Indexing</span></a><br>
&nbsp<a href="#title43"><span style="font size=14ptcolor=green">Interval</span></a><br>
&nbsp<a href="#title44"><span style="font size=14ptcolor=green">Numbers</span></a><br>
&nbsp<a href="#title45"><span style="font size=14ptcolor=green">Text</span></a><br>
&nbsp<a href="#title46"><span style="font size=14ptcolor=green">Sequence and list</span></a><br>
&nbsp<a href="#title47"><span style="font size=14ptcolor=green">Array</span></a><br>
&nbsp&nbsp<a href="#title48"><span style="font size=12ptcolor=green"> Making an array</span></a><br>
&nbsp&nbsp<a href="#title49"><span style="font size=12ptcolor=green"> Indexing and reading an array</span></a><br>
&nbsp&nbsp<a href="#title50"><span style="font size=12ptcolor=green"> Reading with iterator</span></a><br>
&nbsp&nbsp&nbsp<a href="#title51"><span style="font size=11ptcolor=green">  Modifying an array</span></a><br>
&nbsp&nbsp&nbsp<a href="#title52"><span style="font size=11ptcolor=green">  Sorting and other methods</span></a><br>
&nbsp<a href="#title53"><span style="font size=14ptcolor=green">Dictionary</span></a><br>
&nbsp&nbsp&nbsp<a href="#title54"><span style="font size=11ptcolor=green">  Making a dict</span></a><br>
&nbsp&nbsp&nbsp<a href="#title55"><span style="font size=11ptcolor=green">  Indexing a dict</span></a><br>
&nbsp&nbsp&nbsp<a href="#title56"><span style="font size=11ptcolor=green">  Reading a dict</span></a><br>
&nbsp&nbsp&nbsp<a href="#title57"><span style="font size=11ptcolor=green">  Reading with iterator</span></a><br>
&nbsp&nbsp&nbsp<a href="#title58"><span style="font size=11ptcolor=green">  Modifying a dict</span></a><br>
&nbsp&nbsp&nbsp<a href="#title59"><span style="font size=11ptcolor=green">  Sorting and other methods</span></a><br>
&nbsp&nbsp&nbsp<a href="#title60"><span style="font size=11ptcolor=green">  Interval and dictionary</span></a><br>
&nbsp&nbsp&nbsp<a href="#title61"><span style="font size=11ptcolor=green">  Extracting, replacing</span></a><br>
&nbsp<a href="#title62"><span style="font size=14ptcolor=green">File</span></a><br>
&nbsp<a href="#title63"><span style="font size=14ptcolor=green">Scopes</span></a><br>
&nbsp&nbsp<a href="#title64"><span style="font size=12ptcolor=green"> Scope of variables</span></a><br>
&nbsp&nbsp<a href="#title65"><span style="font size=12ptcolor=green"> External variables</span></a><br>
&nbsp<a href="#title66"><span style="font size=14ptcolor=green">Classe and Object</span></a><br>
&nbsp&nbsp<a href="#title67"><span style="font size=12ptcolor=green"> Constructor</span></a><br>
&nbsp&nbsp<a href="#title68"><span style="font size=12ptcolor=green"> Static methods</span></a><br>
&nbsp&nbsp<a href="#title69"><span style="font size=12ptcolor=green"> Inheritance</span></a><br>
&nbsp<a href="#title70"><span style="font size=14ptcolor=green">Included files</span></a><br>
&nbsp<a href="#title71"><span style="font size=14ptcolor=green">Native PHP</span></a><br>
&nbsp<a href="#title72"><span style="font size=14ptcolor=green">Library</span></a><br>
&nbsp<a href="#title73"><span style="font size=14ptcolor=green">Useful functions</span></a><br>
&nbsp<a href="#title74"><span style="font size=14ptcolor=green">Appendix I: Using the JAVA API with Scriptol</span></a><br>
&nbsp&nbsp<a href="#title75"><span style="font size=12ptcolor=green"> Full example</span></a><br>
&nbsp<a href="#title76"><span style="font size=14ptcolor=green">Appendix II: Differences with other languages</span></a><br>
&nbsp&nbsp<a href="#title77"><span style="font size=12ptcolor=green"> Other languages</span></a><br>
&nbsp&nbsp<a href="#title78"><span style="font size=12ptcolor=green"> Php</span></a><br>
&nbsp&nbsp<a href="#title79"><span style="font size=12ptcolor=green"> C++ and Java</span></a><br>
&nbsp&nbsp<a href="#title80"><span style="font size=12ptcolor=green"> Python</span></a><br>
</TD></TR>
</TABLE>
<HR><br>



<h3><a name="title0"></a>
Overview</h3> <pre>

 Scriptol PHP is the first version of the new Scriptol programming
language. The next version will produce C++ code, and other will follow.
 The goal of the language is to be simple, natural and thus to reduce
risk of errors by the programmer. Scriptol means to "Scripting
oriented language", and script here has the sense of "scenario".
 I use PHP as a back-end first, because I think the need is great for an
Internet language that, apart to be natural and easy to learn, allows
complete error checking at compiling, not at run time.
 Scriptol may be embedded inside a html page and is converted to
the same page with PHP code, ready for the Net. It has the simplicity
of ASP, but works on all Unix station, thanks to PHP.
 The language has been defined according to the seven rules displayed
on the site. Each construct is the result of a deep reflexion,
to reach the best in simplicity and safety. When the rules were not
sufficient to make a decision, I have kept that is familiar to
programmers, coming from the most used language, that are C++, Java,
and Html.


</PRE>
<h3><a name="title1"></a>
About this manual</h3> <pre>

 Please note that the [ ] symbols included into syntax of statements
are usually not part of the syntax and denote an optional item, but
for indexing and intervals.


</PRE>
<h3><a name="title2"></a>
Compiling a Scriptol program</h3> <pre>

 The command is:   sol options filename
 If the file is compiled, the program is launched, else it compiles.
 The command "sol filename" compiles while the source has errors.
 Options are:
 none     (no option) compile a scriptol file or run if already compiled.
 -web:    to compile code embedded inside html page and make a php file.
 -php4:   add the .php4 extension rather than the .php one.
 -run:    compile if needed only, then invoque the Php interpreter.
 -build:  compile or recompile the file and included ones.
 -obf:    obfuscate more the Php code (enterprise edition only).

 The options can be abbreviated at the first letter, excepted the php 4 one
that is abbreviated with the 4 number. In short:
-b      forces to compile.
-r      forces to run.
-4      change to the ".php4" extension.


</PRE>
<h3><a name="title3"></a>
Scriptol file</h3> <pre>

 A Scriptol file holds a sequence of statements.
 In the Scriptol Php version, any kind of statement may be written
in a file, outside the body of function, the whole file is
processed as a sequence of commands.
 The file may have the sol extension or any other, and will be
converted into a file with the php extension.


</PRE>
<h3><a name="title4"></a>
Scriptol in html page</h3> <pre>

 For Scriptol code embedded inside html, it should be inserted
inside the following tags:
      <?sol      //                ...code...  ?>
or    <script language=scriptol>   ...code...  </script>
      or  'scriptol' or  "scriptol"
 The "script" keyword may be required by some html editors.
 The last line of a Scriptol script must be terminated by a semi
colon or an end of line, before the ?> symbol.

 The simplest way to use a Scriptol script is to call it from a
Php page, that holds a simple include statement:
Ex:
 <?php
    include_once("count.php");
    update("manual.dat");
 ?>
 This example calls a Php counter inside the count.php file, build from
the count.sol file with the command: sol -web count.sol
 (See at www.scriptol.net).


</PRE>
<h3><a name="title5"></a>
Statement</h3> <pre>

 A statement is ended by a semi-colon or by the end of the line.
 When a statement exceeds the width of a line, the line is concatened
with the following one providing that it is ended by a comma, or by
an operator. The '\' symbol is not used by Scriptol.
 Multiple statements on a same line are separated by a semi-colon. This
is provided mostly to leave freedom to programmers, but may be useful
if you insert Scriptol code into an html page and the editor
concatenates the lines!


</PRE>
<h3><a name="title6"></a>
Comment</h3> <pre>

 A single line comment start with ` and ends with the end of line.
 The // symbol is allowed also.
 A multi-lines comment starts with /* and ends with */.


</PRE>
<h3><a name="title7"></a>
Symbols</h3> <pre>

 The Scriptol language does not use same symbols for conceptually
different usages.
 The ";" sign is a end of statement terminator.
 The "," is a separator. It separates elements of an initializer,
or of a tuple.
 The ":" sign builds an association. It attaches a body to a header,
a value to a key, a method to an object, and so one...
 The "." sign uses an association. It associates a method call to the
object.
 The ".." and "--" are interval symbols. They separate the limits of
an interval of two numbers, for indexing or scanning.
 () are grouping symbols. They group sub-expressions, or elements of an array.
 [] are indexing symbols. They denote an index or an interval.
 "?" is a question mark as in natural language. It terminates a condition
in one-line control structures.
 Apart the usual arithmetical operators, the language uses  "<>"
as a "not equal" operator (or "!=").
 ":-" is the implication operator. (Level 2)
 "&" , "|", "<<" are standard binary operators.
 "#" is the list intersection operator.
 "||" is the list union operator.
 Boolean operators are "and", "or", "not".


</PRE>
<h3><a name="title8"></a>
Variable or primitives</h3> <pre>

 Variables are basic objects. When used as arguments of a
function, the function uses a copy of them, and doesn't
modify the original, while it uses an alias for other objects.

 Scriptol Php's primitives are these:
 number     any king of number.
 integer    a rounded number to integer part.
 int        equivalent to integer.
 real       a number allowing decimals.
 boolean    the true or false value.
 text       a string of characters.
 array      a dynamic list of objects
 dict       a list of couples key:value.
 dyn        generic element of array or value of dict.
 file       a file.

 When converted to Php, all variables become dynamic and are prefixed
by a $. But the type is required by the Scriptol compiler to perform various
tranformations.

</PRE>
<h3><a name="title9"></a>
 Declaration</h3> <pre>

 The declaration of a variable has the form:
 type var
 Ex:  int x
 Multiple declaration is allowed in the form:
 type name = value, name = value, ...
 Ex:  int x = 0, y = 0
 This form is not allowed: int x, y = 0, 0


</PRE>
<h3><a name="title10"></a>
Constant</h3> <pre>

 The constant modifier defines a variable whose value can't change.
 Ex:
 constant integer x = 5     // you can't assign to x another value.

 There are predefined constants in the langage:
 true        matches an expression that is true.
 false       the opposite.
 zero        the 0 value.
 nil         object not found inside a sequence (Not In List).
 null        value of an object when not created yet.


</PRE>
<h3><a name="title11"></a>
External variables and constants</h3> <pre>

 The $ is used by Scriptol to mark variables of the Php language.
 The $ sign is transmitted to the Php generated code.
 Their scope is external, they are not tested for type. They are
usable inside the body of a class unlike global objects.
 They are transmitted directly to the target file, as functions.

 The syntax for a native Php constant is:
   $(constant_name)
 the $ sign and parenthesis are removed into the Php code.
 The scope is external.


</PRE>
<h3><a name="title12"></a>
Assignment</h3> <pre>

 The syntax of a simple assignment is:
   identifier = expression

 Scriptol allows to assign and perform another operation at the same time.
 The syntax of such an augmented assignment is:
   identifier operator expression
 Augmented operators are:  + - * / mod << >> | & ^ #  ||
 Ex:   a = 1            // give a the value 1
 Ex:   a + 1            // add 1 to a
 Ex:   a * (x + 2)      // multiply a by the expression
 Ex:   a = a * (x + 2)  // similar to above
 The corresponding Php statements are:
    $a = 1;
    $a += 1;
    $a *= $x + 1;
    $a = $a * ($x + 2)

</PRE>
<h3><a name="title13"></a>
 Multiple assignments</h3> <pre>

 Ex:  x, y, z = 1, x2, 8
 The number of expressions at right must either match the number of targets
at left or be a single value assigned to several variables.
 Ex:  x, y, z = 0
 The multiple assignment allows mainly a function to return several values.

</PRE>
<h4><a name="title14"></a>
  The complete rule</h4> <pre>

 You may assign several variables together:
- a value or expression.
- an array or dict.
- a function's call.
- a tuple of values or expressions separated by commas.
 In the case of array or dict, of a tuple, or a function returning several
values, the variables from 1 to n are assigned the items from 1 to n, in the
same order. If the number doesn't match, it is an error.
 If the function returns a single value, the same value is assigned to all
variables at left.
 In other cases, the same right value or expression is assigned to all
variables.

</PRE>
<h4><a name="title15"></a>
  Reversing assignment</h4> <pre>

 If we can assign several variables from the content of an array, we can
also create an array with the content of variables:
 array a = (varname1, varname2, etc...)

</PRE>
<h3><a name="title16"></a>
 Tips</h3> <pre>

 Multiple assignement at function call is converted in a Php List()
statement. This statement assigns elements from right to left. This may
causes order is not what expected when elements are in the form a[index],
b[index], etc...
 The expected array's content is:  array( 0: value0, 1: value1, ...)
but it is rather that:  array(...  1: value1, 0:value0)
 Try a.kSort().


</PRE>
<h3><a name="title17"></a>
Operators</h3> <pre>

 The comparison operators are:   = < > <= >=
 There are two different operators: != and <>
 The "in" operator tests the inclusion of an element in a sequence:
string in a text, object in an array, value in a range.
 Ex:  if "a" in line ? print "in text"
 Ex:  if x in 1..10 ? print "in range"

 The binary operators are:
 & (and) | (or)  ^ (exclusive or)  ~ (not)   << (shift left) >> (shift right).


</PRE>
<h3><a name="title18"></a>
 Precedence</h3> <pre>

 Unary operator have precedence over binary ones. Among binary operators,
precedence is denoted by parenthesis.


</PRE>
<h3><a name="title19"></a>
Function</h3> <pre>

 A function starts with a header and ends with the "return" keyword.
 The header has the form:
  return-type [, return-type]* identifier ( parameters )
  Ex:   int myfunc(int x)
  Ex:   int, boolean myfunc(text t, int i)
  The return type is required and the type of arguments also. You can
 use "void" if the function return nothing.

  A parameter may have a default value and be omitted.
  Ex:   void myfunc(text a = "demo")
        call:  myfunc() ou myfunc(some-text)

 The body is a list of statements, including some "return" if needed.
 The ending statement is a return with zero, one, or several values.
 Ex:   return
 Ex:   return x
 Ex:   return x, y, 5

 A call to a function may assign zero, one, or several variables.
 Ex:   myfunc()
 Ex:   a = myfunc()
 Ex:   a,b,c = myfunc()


</PRE>
<h3><a name="title20"></a>
Arguments of a function: the alias modifier</h3> <pre>

 When a function has object ass arguments, the name of arguments are
aliases of the objects, and any change inside the function
are made in fact on the original objects.
 By default, primitives are copy and other arguments are aliases.
 You can change the defaults with a modifier:
C++? "clone": the object become a copy of the original.
"alias": the name of the primitive becomes an alias of the original.

Ex:
void func(number x)
  x + 1
 print x
return

void funcalias(alias number x)
  x + 1
 print x
return

number y = 5
func(y)
print y
>>> should display 6 then 5

funcalias(y)
print y
>>>  should display 6 then 6.


</PRE>
<h3><a name="title21"></a>
The main function</h3> <pre>

 It is useful to pass arguments to a program, from the command line.
 To do that in Scriptol (as in Php) read the $argv Php variable.
 To mimic the way C++ passes arguments to a program, declare a function
"main", and call it with argv (and argc if needed) as argument.
    void main(array arglist, int argnum)
      print argnum, "arguments"
      scan arglist
        print arglist[]
      /scan
    return
    main($argv, $argc) // argv and argc are external Php variables.


</PRE>
<h3><a name="title22"></a>
Print and echo</h3> <pre>

</PRE>
<h3><a name="title23"></a>
 Print</h3> <pre>

 Syntax:  void print expression [, expression]
 Displays a formatted text.
  Each comma results in a white space, and a newline is sent
 after the text.
 Ex:  print "demo", 5
   Php:  echo "demo", " ", 5, "\n";
 A single print statement, without argument, send a line feed.
 Ex:  print
   Php:  echo "\n";

</PRE>
<h3><a name="title24"></a>
 Echo</h3> <pre>

 Syntax: void echo expression [, expression]
 Displays a text as is.
 There is no white space between expressions nor line feed at end.
 Ex:  echo "demo", 5
 Php:  echo "demo", 5;
  The string following the print or echo statement is transmitted
 to php as is. If it contains the $ sign, that is indicates a
variable to the php interpreter.
 Ex:
  a = 10
  echo "score $a"
  >>> this displays: score 10.


</PRE>
<h3><a name="title25"></a>
Control structures</h3> <pre>

 The control structures are:
 if
   normal if.
   one-instruction if.
   composite if.
 for
   normal for.
   one-instruction for.
   - options: in interval, in array.
 scan
   by function.
   one-instruction scan.
   tag scan.
 while
   normal while.
   one-instruction while.
   - options: let, forever.
 do while
   normal.
   case / else / always.
   - option: forever.
 do until
 enum
   simple enum.
   dict enum.

 Scriptol has different syntaxes for single line and multi-lines
control structures.

 A one-instruction control structure has the form:
     structure-name expression ? statement
 There is no ending but the end of line. A semi-colon, if present after
the statement, terminates the whole construct.
 The statement is any basic statement and can't be a control structure.

 A multi-lines control structure has the form:
    structure-name expression
      ... statements ...
    /structure-name
 This is similar to the syntax of html and allows to differentiate endings
of different blocks, unlike for C, the syntax of which being a source of
confusion for compilers.


</PRE>
<h3><a name="title26"></a>
The if construct</h3> <pre>

</PRE>
<h3><a name="title27"></a>
 One-instruction</h3> <pre>

 Syntax:
  if boolean condition ? statement
  [else statement]
  or: if condition ? statement ; else statement
  One must read the line as this:
     if control structure, is condition true? Yes, action...
  Ex:  if a = 5 ? break
  Ex:  if a < 5 ? print "less"
       else print "more/equal"
  Ex:  if a = 1 ? print "1"; else print "?"


</PRE>
<h3><a name="title28"></a>
 Multi-lines</h3> <pre>

 Syntax:
  if boolean condition [:]
    ... statements ...
  else            // optional
    ... statements ...    //
  /if
 N.B.: The colon is optional after the condition, as the semi-colon
after a statement, but is required to concatenate the lines.

  Ex:
  if a = 5
    a + 3
    print a
  /if

  Ex:
  if (x + y) > 8
    print "> 8"
  else
    print "<= 8"
  /if

  E:
  if a = 4 : a + 3 ; print a ; else print "else"; /if


</PRE>
<h3><a name="title29"></a>
The composite if construct</h3> <pre>

  The switch case construct of C++ or Java doesn't exists in Scriptol as
it is too weak and useless.
 It is replaced by a more powerful variant of the if construct, that
can match any type of variable, and various types of comparisons.

 The syntax is:
 if not-boolean expression [:]
 operator expression : statements
 operator expression : statements
 else
   ... statements ...
 /if

 A not-boolean expression, is an ident, a litteral, or any expression
that doesn't return a boolean true or false value.
 There are no "break" keyword after a case group. A break will causes
an exit from the control structure outer to the "if".
 The valid operators are:
    =, <, >, <=, >= != <>
 The "else" here is not imposed but recommended, it is equivalent to the
"default" item in the switch case of C.

 Ex:
 if a
 = 1: print 1
 = 2: print 2
 > 2: print ">2"
 else print "<1"
 /if

</PRE>
<h3><a name="title30"></a>
 The match operator</h3> <pre>

 The "match" operator, by default performs a search of the object
following "if" in a list of textual expressions.
Ex:
 if "x"
 match "xx" : print "found"
 match "ax" : print "found"
 else: print "nofound"
 /if
 The two terms must be expressions that evaluate to texts.

 The match function may be replaced thanks to a define statement:
 define match "function"
 Ex: define match "ereg"


</PRE>
<h3><a name="title31"></a>
The for construct</h3> <pre>

 This construct scans either a range or a sequence and puts each
item in a variable.

 Syntax:
 for variable in start..end [step s] [:]
   ... statements ...
 /for

 Start, end, step are either identifiers or constants.
 The step is optional, the default value is 1.
 The end value is included in the range.
 The end's value may inferior to the start's one, providing that they
are litteral integers, and the step is negative (can be a variable).

 Syntax:
 for variable in array-expression [:]
   ... statements ...
 /for

 In this case, the content of an expression is scanned and each item
assignated to the variable.  The expression must be an array or an
expression that returns an array.

 Ex:  for i in 1..10
        print i
      /for

 Ex:  for x in a..b
        print x
      /for

 Ex:  for w in myarray
        print w
      /for

 Ex:  for w in arr1 + (arr2 # arr3[0..5])
        print w
      /for


</PRE>
<h3><a name="title32"></a>
 One-instruction for</h3> <pre>

 The one-instruction shortened syntax is:
 for ident in list ? basic-statement

 Ex:  for w in mylist ? print w
 Ex:  for x in 10..1 step -1 ? print w + 10


</PRE>
<h3><a name="title33"></a>
The scan construct</h3> <pre>

 This is a simplified form of the for construct with arrays.
 Syntax:
 scan a [,b, etc...] by f
 - a, b, etc... are arrays.
 - f is the name of a function.
 This applies the function to each item of the arrays providing that the
function has as many arguments as there are arrays.
 For the item modified by the function, the "alias" modifier must be put
before the type of the argument.
 N.B.: Indexes of an array are not the positions inside the array:
a[1] can return an item that has a position that is not 1 (see Array).

 Other syntax:
 scan a
   ... statements ...
 /scan
 In this form, each item of the array(s) is(are) processed by the statements
inside the body of the constuct. The current item is accessed with the []
empty indexing.
 The one-instruction syntax is also allowed:
 scan a ? statement

 Ex:
 array a = (1,2,3,4)
 void fun(number x) : print x * x; return
 scan a by fun

 Ex:
 scan a : print a[] * a[]; /scan

 These two examples have the same result.
 One can modify the array by a[] = ...

 Ex:
 scan a ? a[] = 0
 Ex:
 scan a
  a[] * a[]
  print a[]
 /scan

 Example with several arrays:
     void mulfun(dyn a, dyn b)  print a * b; return
     scan a,b by mulfun
 or:
     scan a,b
       print a[] * b[]
     /scan
 or:
     scan a,b? print a[] * b[]


</PRE>
<h3><a name="title34"></a>
The while construct</h3> <pre>

 One-instruction
   while expression ? instruction

 Multi-lines
   while expression [:]
     ... statements ...
   /while
 A "break" statement exits the loop.
 A "continue" statement skip all that follows and starts a new loop.

 The Php equivalent is:
   while (expression)
   {  statements }

</PRE>
<h3><a name="title35"></a>
 The while let option</h3> <pre>

 This syntax is recommended to avoid the risk of infinite loops.
 The assignment that do the tested expression evolves, may be moved
after the /while by the mean of the "let" statement.
 Ex:
   while x < 10
     print x
   /while let x + 1
 The Php equivalent (not the generated one) is:
   while (x < 10) {
    print x
    x += 1
   }

 However, the "continue" statement has not the same effect, it jumps
to the incrementor (x + 1) in Scriptol, while it starts a new loop in
the standard Php construct (not the generated one).

</PRE>
<h3><a name="title36"></a>
 Simplified syntax</h3> <pre>

 A while with the let option may be written simply as:
   while condition
   ...statements...
   let incrementor
 This is even the recommended syntax.
 Ex:
   while x < 10 ? print x; let x + 1


</PRE>
<h3><a name="title37"></a>
 The forever option</h3> <pre>

 The condition is replaced by the "forever" keyword, and we enter
an infinite loop, exited by a "break".


</PRE>
<h3><a name="title38"></a>
The do while construct</h3> <pre>

 Le block of statements is performed while the condition is true.
 Syntax:
   do
     ... statements ...
   /do while expression
 Ex:
   do
    print x
    x + 1
   /do while x < 3

 Options
 - do
   /do
   without while is valid and useful with case groups.
 - do
   /do forever
   performs an infinite loop, and requires a break to exit.


</PRE>
<h3><a name="title39"></a>
The do case construct</h3> <pre>

  This is a powerful pattern-matching constrol structure. It contains
one or several case groups followed by an optional else and an
optional always.
 One case group only is processed, the one the condition of which
if first matched.

  Syntax:
  do
   case condition : statements
   [ case condition : statements ]
   [ else statements ]
   [ always statements ]
  /do [while expression]

- A condition if followed by a colon or a newline.
 The "else" and "always" keywords also, for simplicity.
- The "else" group is equivalent to "default" in the C switch case.
- The "always" group, if present, is performed in any cases.
- The same options of the do .. while constructs above are available.
- May end with /do, /do forever, /do while expression.
 When the forever or the while option are used, the construct
becomes a DFA (Deterministic Finite-state Automata). A break must end it.
 Please note that a "break" must not be used at end of a case group (as
in C): it will exit the whole construct, not the case group!


</PRE>
<h3><a name="title40"></a>
The do until construct</h3> <pre>

 It is similar to the do while one. No "/do" required.
 The block of statemetns is performed until the condition becomes true.
 Syntax:
 do
  ... statements ...
 until expression


</PRE>
<h3><a name="title41"></a>
The enum construct</h3> <pre>

  Enum, as in C, allows to assign sequential integer values to
identifier, but in Scriptol, it allows to assign any value of any type.
 The identifier and the value are separated by a colon.
 You can use also an equal to assign an integer, for the sequence
continue from this number.

  Syntax:
  enum: ZERO, ONE, TWO, THREE /enum
  This assigns 0 to zero, 1 to one, and so one.
  This is equivalent to:
  constant integer ZERO = 0
  constant integer ONE = 1
  etc...

  enum: ZERO:"0", ONE:"1", TWO:"2" /enum
  This is as:
  constant text ZERO = "0"
  constant text ONE = "1"
  etc...

  The one-line syntax is (? is optional):
  enum [?] ZERO, ONE, TWO, THREE
  enum [?] ZERO:"0", ONE:0.1, TWO:2

  Example:
  enum? ZERO, ONE, FOUR = 4, FIVE
  This associates the numbers 0,1,4,5

  Example:
  enum: READ:"r", WRITE:"w", APPEND:"a"  /enum
  file f
  f.open("test", READ)
  while not f.eof()
   print f.readline()
  /while
  f.close()

  These statements have no Php equivalent. They are even not
converted into Php statements. This is just a construct of the
language for the compiler.
 A value may be a literal number or text and nothing else.


</PRE>
<h3><a name="title42"></a>
Indexing</h3> <pre>

  The syntax of an index in a text or an array: is [index].
  Index must be a simple expression without square brackets embedded inside.
  A simple expression is a literal number, an identifier, a function call,
or an arithmetical expression, and must be resolved as an integer value.


</PRE>
<h3><a name="title43"></a>
Interval</h3> <pre>

  The syntax of an interval inside a text or an array is: [start..end].
  Start and end are simple expressions as above.
  The last item is included in the range. To not include it, use an
  alternate operator  --
  a[0 -- 100]  is equivalent to a[0 .. 99]
  a[x -- y] is equivalent to a[x..y-1]


</PRE>
<h3><a name="title44"></a>
Numbers</h3> <pre>

 Methods may be associated either to a variable or literal number.
 Methods of integer (or int):
 toReal()           // upgrade to real.
 toText()           // convert to text.

 Methods of real:
 toInt()            // round to integer.
 toText()

 Methods on number:
 toInt(), toReal(),  toText()


</PRE>
<h3><a name="title45"></a>
Text</h3> <pre>

  A text is a basic objet with methods, that holds a string of any character.
This object is converted to Php functions with the string as parameter.
 When a text is the argument of a function, the function uses a copy of the
text, not an alias on the original one.

 Syntax:
 text s                // create a text.
 s = "str"             // initialize.
 n = s.length()        // get the length.
 n = s.len()           // as above.
 n = s.compare(s2)     // compare lexicographically two texts (ignore case).
                       // return -1, 0, 1.
 n = s.identical(s2)   // compare, doesn't ignore case. Return -1, 0, 1
 n = s.find(s2)        // returns the position of text s2 inside s.
                       // return "nil" if no found.
 s = s.fill(s2, num)   // fill s with s2 num times.
 s = s.lower()         // convert to lowercase.
 s = s.upper()         // convert to uppercase.
 s = s.capitalize()    // convert the first char to uppercase.
 i = s.toInt()         // convert to an integer.
 r = s.toReal()        // convert to a real.
 s = s.replace(st, rt) // replace each occurence of st by rt.
 s = s.trim()          // remove heading and trailing control codes/blanks.
 s = s.rtrim()         // remove trailing controls/blanks
 s = s.ltrim()         // remove heading controls/blanks
 array a = s.toarray(sep)
                       // split a text inside s into an array of items
                       // separated inside s by sep.
 s = s.wrap(size)      // wordwrap the text.

 s = s[i]              // get a char.
 s[i] = s2             // replace a char, s2 should be a one-char text.
 s = s[i..j]           // get a sub-string, from i until j included.
 s[i..j] = s           // replace a sub string.
 s[i..j] = ""          // remove a sub string.


</PRE>
<h3><a name="title46"></a>
Sequence and list</h3> <pre>

 A sequence is either a static (text) or dynamic, associative list (array or
 dict).
 Operations on sequence are those of list, minus the # one.
 Operations on associative lists are these:
 []   : index, slice, or splice.
 +    : merge two sequences.
 -    : remove from a sequence, another one.
 =    : compare two sequences.
 in   : test if an object is in a sequence.
 #    : intersects two sequences (gives common elements).
 ||   : union without doubloons of two lists.

 If you want to test if a sequence a is inside another one b, write that:
  if (a # b) = a ? print "a in b"


</PRE>
<h3><a name="title47"></a>
Array</h3> <pre>

 An array is a dymamic and associative list of object or literals.
 An empty array is symbolized by ().
 An array initializer is a list of expressions separated by commas and
enclosed between parenthesis. A variable is a valid element. The initializer
starts with the keyword "array".
 If the array initializer has several values, this keyword can be omitted.
  Ex:  x = a + (8,9)             ` the compiler recognizes an array
  Ex:  x = a + array(8)          ` the compiler needs for the keyword
  Ex:  array a = (3)             ` the compiler guesses it is an array!
 The "+" is the sole valid operator for arrays.

 The order of items inside an array is not their numerical indexes,
that are only keywords to retrieve the items (according to Php).
 Ex:  a[1] = "a"
      a[2] = "b"
      scan a ? print a[]
      >>> should print:  a b
      array a = ()              ` clear the array
      a[2] = "b"                ` b is the first item, index 2
      a[1] = "a"                ` a is the second item, index 1
      scan a ? print a[]
      >>> should print:  b a
 The second assigned item has the second position, but its index is 1.
If you omit to clear the array, the initial positions of the indexes
will be kept.


</PRE>
<h3><a name="title48"></a>
 Making an array</h3> <pre>

 Syntax:
   array a              // create an array.
   array a = (x,y,...)  // create and initialize an array.


</PRE>
<h3><a name="title49"></a>
 Indexing and reading an array</h3> <pre>

  The items inside an array are accessed by the position.
  The indexes may be negative, and thus start from the last item.

  Syntax:
   a.size()             // return the number of items.
   a[pos]               // the item at position pos
   a[pos..end]          // the range between pos and end included.
   a[..end]             // from the start to position end.
   a[pos..]             // from position pos to the end of array.
   a[..]                // get the whole array (useless)


</PRE>
<h3><a name="title50"></a>
 Reading with iterator</h3> <pre>

  Syntax:
   v = a[]              // get the pointed out value.
   v = a.begin()        // point out the first item, assign it or no.
   v = a.end()          // point out the last item.
   a.inc()              // increment the pointer.
   a.dec()              // decrement the pointer.
   i = a.index()        // return the index of the pointed out item.


</PRE>
<h4><a name="title51"></a>
  Modifying an array</h4> <pre>

  Syntax:
   a[n] = x             // replace the item at position n.
   push(val)            // add an item at end.
   object = pop()       // get the last item and remove it.
   object = pop(i)      // get the item at position i and remove it.
   object = shift()     // read and remove the first item.
   unshift(val)         // insert an item at first position.
   insert(pos, val)     // insert an item at the pos position.
   c = a.append(b)      // concatenate two arrays.
   a = ()               // clear the whole array.
   a[pos] = ()          // remove an item.
   a[pos..end] = ()     // remove a range of items.
   a[pos..end]= b       // replace a range by an array/item.


</PRE>
<h4><a name="title52"></a>
  Sorting and other methods</h4> <pre>

  a.sort()                // sort the values (numbers, texts).
  a.kSort()               // order the indexes, association being preserved.
  a = a.unique()          // remove doubloons.
  int a.find(obj)         // search for an item, return the index or nil.
  a.display()             // print the array.
  text a.totext(text sep) // convert into a text with separator
  object rand()           // read an item at random location.
  a.arrange()             // set indexes in good 0..n order.
                          // (correct the way PHP process arrays).
  boolean load(text fname, inc_path) // load the "fname" file into the array.
                          // see at the file function of Php
  object min()            // get the lowest items.
  object max()            // get the highest items.
  number sum()            // calculates the sum of items.


</PRE>
<h3><a name="title53"></a>
Dictionary</h3> <pre>

 A dict is a dymamic list of couple key and value.
 Keys are always texts. Values may be any objects.  Key and value may be
variables.
 The format for a couple key and value is:   key:value.
 The Php equivalent is key => value.
 An empty dict is symbolized by ().
 A dict initializer is a list of couples separated by commas and enclosed
by parenthesis.


</PRE>
<h4><a name="title54"></a>
  Making a dict</h4> <pre>

  Syntax:
   dict d                   // create a dict.
   dict d = (x:v, y:w,...)  // create and initialize a dict.
   

</PRE>
<h4><a name="title55"></a>
  Indexing a dict</h4> <pre>

   Les items in an dict are accessed by the position or by the key.
   The index may be a variable.
   Thus a variable must be declared as "text" to be used as key.
   Syntax:   d["key"]     get the first item with the key "key".


</PRE>
<h4><a name="title56"></a>
  Reading a dict</h4> <pre>

  Syntax:
   d.size()              // return the number of items.
   v = d["key"]          // get the value associated with the key.


</PRE>
<h4><a name="title57"></a>
  Reading with iterator</h4> <pre>

  Syntax:
   v = d[]              // get the pointed out value. Or d.value().
   v = d.begin()        // point out the first item.
   v = d.end()          // point out the last item.
   d.inc()              // increment the pointer.
   d.dec()              // decrement the pointer.
   k = d.key()          // return the key of the pointed out item.
   v = d.value()        // get the value pointed out.
   k,v = d.key(), d.value()        //  read the couple key:value

</PRE>
<h4><a name="title58"></a>
  Modifying a dict</h4> <pre>

   Syntax:
   d[key] = value       // replace a value or add the couple key, value
                        // if the key is not already inside the dict.
   d[key] = ()          // remove an item.
   d.push(val)          // add a value to the end of the dict.
   d.unshift(val)       // insert a value at beginning.
   v = d.pop()          // get the last value and remove it. Pointer unchanged.
                        // use d.end() and d.value() to get the key also.
   v = d.shift()        // read the first value and remove the item.
   d = ()               // clear the dict.


</PRE>
<h4><a name="title59"></a>
  Sorting and other methods</h4> <pre>

   d.sort()             // sort according to the values (ascending order).
   d.kSort()            // order the keys, association being preserved.
   d = d.unique()       // remove doubloons from the dictionary.
   text d.find(obj)     // search for a value, return the key or nil.
   d.flip()             // values become keys and conversely.
   d.display()          // display the content.
   text d.totext(text sep)  // create a text from the values with a separator.
   value d.rand()       // read a value at a random location.
   dict d.merge(d2)     // merge keys of two dictionaries. Values of d2.
                        // replace those of d when they have the same key.
   value d.min()        // get the lowest value.
   value d.max()        // get the highest value.
   number sum()         // calculates the sum of items.
   boolean load(text fname, inc_path) // load the "fname" file into the dict.
                        // see at the file function of Php

</PRE>
<h4><a name="title60"></a>
  Interval and dictionary</h4> <pre>

 The right way to use a dictionary is by the means of keys or
iterator. In some case, it mays be useful to access a range of
items directly. For this purpose, some features of array are
added to dict. Use them with care as this is very confusing.
 When adding an element or another dictionary to a dict, by the
way of interval, push, unshift, Php generate a new key for the item.
The new key is a number. If you replace a range by another dict,
some of the items may be lost. This also does happen when merging.

  Syntax:
   d[pos..end]           // the range between pos and end.
   d[..end]              // from first item to position end.
   d[pos..]              // from position pos to last item in dict.
   d[..]                 // the whole dict (useless).

</PRE>
<h4><a name="title61"></a>
  Extracting, replacing</h4> <pre>

   b = d[pos..end]       // make a sub dict.
   d[pos..end] = ()      // remove a range of items.
   d[pos..end] = b       // replace a range by a dict or an item.

  Examples of display:
  Should print all keys and values in the dictionary.

  // creating the dictionary
  dict d = ("a":"alia", "b":"beatrix", "c":"claudia")

  // internal display
  d.display()

  // display by for
  for k,v in d : print $k,$v; /for

  // display by iterator
  number i = 0
  d.begin()
  while i < d.size()
    print "$i)", d.key(), d[]
    d.inc()
  /while let i + 1

  Example: get the last couple
  the order is important as d.end() move the pointer to end
  v,k = d.end(), d.key()


</PRE>
<h3><a name="title62"></a>
File</h3> <pre>

 File is another virtual object, for processing local or distant
files.
 For a complete explanation of the file system, see "fopen" in the
php manual.

 Syntax:
 file fname                 ' declare a file.
 fname.open(path, mode)     ' open the file with the path, and the mode.
   Path types:
   http://       ' by http distant file.
   ftp://        ' by ftp distant file.
   other:        ' local file.
   Mode type:
   "r"           ' read only.
   "w"           ' write only.
   "a"           ' append at end of file, write only.
   "r+"          ' read or write at start of file.
 t = fname.readline()       ' read a line terminated by an newline code.
 t = fname.read(int)        ' read a block from the file.
 fname.write(text)          ' write the text into the file.
 fname.close()              ' close the file.
 boolean = fname.eof()      ' return true at end of the file.

 The error construct
 After an open statement, the construct error /error or error ?
should be executed when an access error occurs. However the Php interpreter
may stop the program before the construct is processed, is depending of the
configuration.
 Ex:
 fname.open("text", "r")
 error? exit()


</PRE>
<h3><a name="title63"></a>
Scopes</h3> <pre>

 To avoid confusion, Scriptol doesn't allow a same name given to
different variables in embedded scopes (for example, the global
scope and the one of a function), but successive scopes can reuse
the same names.

</PRE>
<h3><a name="title64"></a>
 Scope of variables</h3> <pre>

 The scope of a variable is the block of statements inside which
it is declared: global, class, function or delimited block.
 Delimited block are body of if, while, do, case, etc...
 The header of the for construct is inside the outer scope.
 The parameters of a function are inside the scope of the function.
 Inside a function, if a variable is referenced before any assignment,
it references to a global variable if it exists, otherwise this is an error.
 Inside a method of a class, if it is referenced before any assignment,
it references to a member if this member exists, otherwise this is an error.
 Global variables are not visible inside classes, but the Php ones.

</PRE>
<h3><a name="title65"></a>
 External variables</h3> <pre>

 External variables (those of Php, Apache, etc...) are always in the scope,
since there is no control for them (look at the "External variable" section).
 Thus, you have to know their name to avoid using a name that will become
that of a Php variable, when the "$" will be added to. Or you should
avoid to use all uppercase names.


</PRE>
<h3><a name="title66"></a>
Classe and Object</h3> <pre>

 A class is a structure which contains variables (attributes) and has
functions (methods).
 Once a class is defined, it become a complex type and an unlimited number
of instances (objects) may be declared with this type.
 Then, we use attributes and methods of the object with a command in the form:
    object.attribute
    object.method()
 A class may inherits from another class's items (members) with the "is"
operator.

 Example of a class declaration:
 class car is vehicle
   ...body...
 /class

 Example of a method declaration:
 int thespeed = 50
 void car.speed(int i)
   int x = thespeed * 2
 return x

 Example of reference:
 car mycar
 print mycar.speed()

</PRE>
<h3><a name="title67"></a>
 Constructor</h3> <pre>

 A constructor is a method the name of which being that of the class,
and that is call when creating an instance of the class.
 The syntax of an instance creation is:
 classname instancename(arguments)
 If the constructor has not arguments, the parenthesis must be omitted.
Empty parenthesis are not allowed. The constructor must return a void
type.

 Ex:
 class demo
  void demo(int x)          ` constructor
    ...
  return
 /class
 demo mydemo(10)            ` instance


</PRE>
<h3><a name="title68"></a>
 Static methods</h3> <pre>

 It is convenient to store all functions relative to a task into a
class. You can then call these methods directly along with the class
name without to declare an instance.
 Ex: node, ext = Dir.splitExt(path)


</PRE>
<h3><a name="title69"></a>
 Inheritance</h3> <pre>

 A class may inherit from attributes and method of another one, if it
is declared as a subclass of it.
 The syntax is:
 class name is othername
 The class "name" inherits of attributes and methods of "othername".
 This works also for static methods.
 Ex:
 class car
   int power = 1500
   int getPower() return power
 /class
 class formulaone is car
   int speed
   int getSpeed()
     speed = getPower() / 4
   return speed
 /class
 formulaone f1
 print f1.power               // attribute of the superclass
 print f1.getPower()          // method of the superclass
 print f1.getSpeed()          // method of the class itself


</PRE>
<h3><a name="title70"></a>
Included files</h3> <pre>

 The syntax to include an external scriptol file is this:
      include "filename"
 Parenthesis are optional. (Simple or double) quotes are required.
 If you want to use directly a Php file, and the compiler not
to compile it, see below...


</PRE>
<h3><a name="title71"></a>
Native PHP</h3> <pre>

 If you want to insert Php code directly into your program, use these
symbols:
 <-  start of included code.
 ->  end of included code.
 The symbol are removed and the Php code remain inside the compiled one.
 The compiler doesn't process it, it is as a comment for the compiler,
but unlike comment it remain into the generated file.
 If you want to insert an entire Php page, use this:
 <-include("thepage.php");->
 You don't have to change anything in the page.


</PRE>
<h3><a name="title72"></a>
Library</h3> <pre>

 Scriptol Php has no library and doesn't need for one. As it compiles to
Php code, it may use the Php library. Any Php function can be used directly.
 No control is performed on arguments and return type of the Php functions.
 In the future, a lot of function will be installed in a translation table
to allow the compiler performing such controls.
 The most frequently used are already present, and are listed below.


</PRE>
<h3><a name="title73"></a>
Useful functions</h3> <pre>

 These functions come from Php, and are included in the common Scriptol
language. The Php name is given in the list if it is different.

number abs(number)
  Returns the absolute value of a number.

text chr(integer)
  Returns the ASCII character for a value.
  Ex: chr(32) return a blank space.

boolean chdir(text)
  Change the current directory. Returns true or false.

boolean delete(text)
  Deletes a file.
  (See: unlink)

void die(text message)
  Displays a message and exits the program.

void eval(text)
  Executes some code exactly as Php one, stored in the argument.
  To execute a whole file, use "exec" instead.

void exec(text command [, array results])
  Executes a command.
  An array may be provided to get the lines displayed by this command.

void exit()
  Exits the program. Can send a message.

int intval(text t, int base)
  Convert a text to an integer, according to the base (default 10).

scalar min(scalar, ...)  or max.
  Min returns the lowest object among arguments.
  Max returns the greater one.

boolean mkdir(text)
  Creates a sub-directory.

integer ord(text)
  Get the ASCII value of a character.
  Ex: ord(" ") returns 32.

text pad(text t, len l [, text c] [, int o])
  Pad a text with blank space or the given string of chars.
  t: text to pad.
  l: length to reach.
  c: text to add, the default are blank spaces.
  o: options STR_PAD_LEFT, STR_PAD_BOTH, default is at right.
  (See: str_pad)

number pow(number base, number exponent)
  Return the power of a number.

number rand()
  Generate a random number.

array range(int first, int last)
  Generates an array of integers from first to last.

boolean rename(text oldname, text newname)
  Renames a file.  Returns true or false.

boolean rmdir(text)
  Delete a sub-directory.

real round(real x, integer decinum)
  Rounds x, with the given number of decimals.

number sqrt(number)
  Returns the square of a number.

text str(number)
  Convert a number to a text.
  (See: strval)

text system(text commant)
  Pass a command to operating system. Returns last line displayed.

array union(array, array)
  Return the union of two lists, with no doubloons.

array unique(array)
  Remove doubloons among values.


</PRE>
<h3><a name="title74"></a>
Appendix I: Using the JAVA API with Scriptol</h3> <pre>

 Since the version 1.0m, Scriptol implements the declaration of Java
objects, thanks to the "java" modifier, and providing the Java extension
is activated (see at the install card).
 In the same way you include files the content of which you want to use,
each Java class you use must be imported, with the full path according
to Java's style.
 Once a Java class is imported, you declare instances and call methods
exactly as you do for Scriptol classes.
 The syntax is:
 import java classpath-classname
 If the word "java" begins the path, the compiler recognizes it and the
modifier may be omitted:
 Ex:
 import java java.awt.Dialog          ...is a valid declaration
 import java.awt.Dialog               ...is valid too
 import java MyClass                  ...is a valid declaration
 import MyClass                       ...is not valid for a Java class

 If you declare your own Java classes, they must be in separated files,
and the files must have the name of the class with the java extension.
It has to be compiled by javac.
 Ex: The class MyClass must be stored into a MyClass.java file.

</PRE>
<h3><a name="title75"></a>
 Full example</h3> <pre>

 import java.awt.Dialog      ... the Dialog class imported in name space
 Dialog myDialog             ... an instance is declared
 myDialog.setVisible(1)      ... a method is called



</PRE>
<h3><a name="title76"></a>
Appendix II: Differences with other languages</h3> <pre>

Apart the obvious differences in the syntax, you should be aware or some more
subtle difference between Scriptol and the previous language you may be used
with.

</PRE>
<h3><a name="title77"></a>
 Other languages</h3> <pre>

- Scriptol doesn't allow performing both assignment and test in an expression.
The statement if(x = y) in c++ both lets y assigned to x and tests if x is 0.
 In Scriptol, this tests is x equals y. The == operators is not used by
Scriptol.
- The statement x = x + 2, is written x + 2 in Scriptol. This is the way
human thinks. (Ex: my car has moved one km, rather than: my car has moved from
the current place to the current place plus one km!)
- Scriptol is case-sensitive. C, Php are not. Using a same ident with
different cases is an error.

</PRE>
<h3><a name="title78"></a>
 Php</h3> <pre>

- Variables are local by default in Php. In Scriptol, if they are not declared
  in the local scope, they are global. This is converted automatically.
- A range of elements is denoted by the number of the first one and the number
  of elements in Php. In Scriptol, by the first and the last element of the
  range.
- There is no "elseif" in Scriptol, but several pattern-matching constructs are
  provided instead.

</PRE>
<h3><a name="title79"></a>
 C++ and Java</h3> <pre>

- Scriptol doesn't allow to reuse the name of a variable in an embedded scope.
  A variable inside a function can't have the name of a global variable or an
  attribute.
- Global variables are not accessible inside a class, as in C++.

</PRE>
<h3><a name="title80"></a>
 Python</h3> <pre>

- Tuples are objects in Python. They are constructs of the language in Scriptol.
  You can't assign a name to a tuple.
- A sequence initializer has the format (a, b, ...) in Scriptol. This initializes
  a tuple in Python. A tuple in Scriptol has the format a,b,... without
  parenthesis.
- The ":" terminator is required in Python at end of a heading. It is required
  in Scriptol only if the body of the construct starts on the same line that the
  heading.
- A range in Python, [first:last] has the last element not included. It is
  included in Scriptol (but a different syntax allows not to include it).



<hr><br><i>I.N.P.I. registered #114223 - October 12, 2001
(c) copyright by D.G. Sureau - www.scriptol.com</i>

</PRE>
</BODY>
</HTML>
