/*
 * NOT COPYRIGHTED by Babes-Bolyai University, Cluj-Napoca
 *
 * You have unlimited rights to use this file, which is part of your
 * CASE-generated application.  It is provided "as is" without express
 * or implied warranty.
 */

#ifndef __CODE_GENERATION_MACROS_H__
#define __CODE_GENERATION_MACROS_H__

#include <ocl>
#include <map>

#ifndef CG_DEF_PRED
#define CG_DEF_PRED(type) __OclPred<type>
#endif

#ifndef CG_DEF_ALLOCATOR
#define CG_DEF_ALLOCATOR(type) __OclAllocator<type>
#endif

#ifndef CG_NAMESPACE_OCL
#ifndef __OCL_NO_NAMESPACES
#define CG_NAMESPACE_OCL ocl::
#else
#define CG_NAMESPACE_OCL
#endif
#endif

#ifndef CG_NAMESPACE_STD
#ifndef __OCL_NO_STD
#define CG_NAMESPACE_STD std::
#else
#define CG_NAMESPACE_STD
#endif
#endif


/////////////////////////////////////////////////////////////////////////////
// Code generation - helper macros

/////////////////////////////////////////////////////////////////////////////

#define DECLARE_UNARY_ASSOCIATION(role_name, role_type) \
public: role_type* role_name;

#define IMPLEMENT_UNARY_ASSOCIATION(role_name, role_type)

/////////////////////////////////////////////////////////////////////////////

#define DECLARE_MULTIPLE_ASSOCIATION(role_name, role_type, collection_type) \
public: CG_NAMESPACE_OCL collection_type<role_type*> role_name;

#define IMPLEMENT_MULTIPLE_ASSOCIATION(role_name, role_type, collection_type)

/////////////////////////////////////////////////////////////////////////////

#define DECLARE_UNARY_ASSOCIATION_QUALIFIED(role_name, role_type, \
    qualifier_type) \
public: CG_NAMESPACE_STD map<qualifier_type, role_type*, \
    CG_DEF_PRED(qualifier_type) > role_name;

#define IMPLEMENT_UNARY_ASSOCIATION_QUALIFIED(role_name, role_type, \
    qualifier_type)

/////////////////////////////////////////////////////////////////////////////

#define DECLARE_MULTIPLE_ASSOCIATION_QUALIFIED(role_name, role_type, \
    qualifier_type, collection_type) \
public: CG_NAMESPACE_STD map<qualifier_type, \
    CG_NAMESPACE_OCL collection_type<role_type*>, \
    CG_DEF_PRED(qualifier_type) > role_name;

#define IMPLEMENT_MULTIPLE_ASSOCIATION_QUALIFIED(role_name, role_type, \
    qualifier_type, collection_type)

/////////////////////////////////////////////////////////////////////////////

#define DECLARE_UNARY_AGGREGATION(role_name, role_type) \
public: role_type role_name;

#define IMPLEMENT_UNARY_AGGREGATION(role_name, role_type)

/////////////////////////////////////////////////////////////////////////////

#define DECLARE_MULTIPLE_AGGREGATION(role_name, role_type) \
public: CG_NAMESPACE_OCL Sequence<role_type, \
	CG_DEF_ALLOCATOR(role_type) > role_name;

#define IMPLEMENT_MULTIPLE_AGGREGATION(role_name, role_type)

/////////////////////////////////////////////////////////////////////////////

#endif // __CODE_GENERATION_MACROS_H__
