//
//
//                                /\    /\
//                               /  \  /  \
//                              /    \/    \
//                             /  /\    /\  \
//                            /  /  \  /  Y T H O S
//                           /  /    \/    \  \
//                          /  /            \  \
//                         /__/              \__\
//
//                  Microsoft Windows 95/98/NT Version
//
//  Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Chuck Walbourn
//
// mythos.hpp
//
// The MythOS Collection provides many diverse tools for development of
// entertainment software.  This header contains the MythosSystem class for
// coordinated use of the various Mythos components.
//
//

#ifndef __MYTHOS_HPP
#define __MYTHOS_HPP    1

#ifdef __WATCOMC__
#pragma pack(1);
#endif

#ifdef _MSC_VER
#pragma pack(push,1)
#endif

//
//
//                                Includes
//
//

#include <string.h>

#include "debug.h"
#include "portable.h"

#include <ivory.hpp>
#include <chronos.hpp>

#include <felix.hpp>
#include <xfile.hpp>

#include <bozo.hpp>
#include <max.hpp>

#include <vangogh.hpp>
#include <gutenbrg.hpp>
#include <escher.hpp>

#include "mythos.h"

//
//
//                                Classes
//
//

class MythosSystem
{
public:
    //Ŀ
    // Public data members                                                  
    //
    IvorySystem     Ivory;
    BozoSystem      Bozo;
    MaxSystem       Max;
    ChronosSystem   Chronos;
    GBergSystem     Gutenberg;
    VngoSystem      Vangogh;
    EschSystem      Escher;

    //Ŀ
    // Constructor/Destructors                                              
    //
    MythosSystem(ulong ivory_size = 2*1024*1024,
                 ivory_init_codes ivory_opt = IVORY_RESERVE_STATIC);
    virtual ~MythosSystem();

    //Ŀ
    // Library control                                                      
    //
    int init(ulong esch_arena_size=ESCH_DEFAULT_ARENA,
             ulong esch_sort_size=ESCH_DEFAULT_SORT,
             IvorySubAlloc *bozo_alloc = 0);

    //Ŀ
    // Utility routines                                                     
    //
    int atexit( register void ( *__func )( void ) ) { return mythos_atexit(__func); }
    void atexit_remove( register void ( *__func )( void ) ) { mythos_atexit_remove(__func); }

    int detect_mmx() { return mythos_detect_mmx(); }
    int detect_amd3d() { return mythos_detect_amd3d(); }
};

#ifdef __WATCOMC__
#pragma pack();
#endif

#ifdef _MSC_VER
#pragma pack(pop)
#endif

#endif

// End of header - mythos.hpp 

