//
//                  ooo        ooooo
//                  `88.       .888'
//                   888b     d'888   .oooo.   oooo    ooo
//                   8 Y88. .P  888  `P  )88b   `88b..8P'
//                   8  `888'   888   .oP"888     Y888'
//                   8    Y     888  d8(  888   .o8"'88b
//                  o8o        o888o `Y888""8o o88'   888o
//
//                          Across the event horizon...
//
//                       Microsoft Windows 95/98/NT Version
//
//  Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Dan Higdon
//
// maxvmap.hpp
//
// Value Mapper
//
//  This module provides facilities to convert linear values into
// non-linear ranges.  These ranges are defined by tables, which may
// be generated by utility members or some user-interface element.
// See MaxVMap.CPP for more details.
//
//

#ifndef __MAXVMAP_HPP
#define __MAXVMAP_HPP

#ifdef _MSC_VER
#pragma pack(push,1)
#endif

//
//
//                                Includes
//
//

#include <portable.h>

//
//
//                                Pragmas
//
//

//
//
//                                Equates
//
//

//
//
//                               Structures
//
//

//
//
//                                Classes
//
//

//
// MaxValueBase -
//  This class provides a common base for MaxValueMap and MaxUValueMap.
// There is nothing earth-shattering in this class, and since the
// constructor is hidden, noone can create one directly.
//  The most interesting members of this class are the static members
// that can be used to create mapping tables.  Versions are supplied for
// both signed and unsigned, linear and bezier.
//
class MaxValueBase
{
protected:
    ushort  table_size_shift;
    ushort  table_size_mask;

    MaxValueBase (ushort _bits, ushort _table_size)
        { set_shift (_bits, _table_size); }

    void set_shift (ushort _bits, ushort _table_size);

public:
    static void make_linear (short  *table, ushort table_size, short  start, short  end);
    static void make_linear (ushort *table, ushort table_size, ushort start, ushort end);

    static void make_bez (ushort *table, ushort table_size,
                                         ushort start,  ushort end,
                                         ushort pointx, ushort pointy);
    static void make_bez (short  *table, ushort table_size,
                                         short  start,  short end,
                                         ushort pointx, short pointy);

};


//
// MaxValueMap -
//  Create a mapping "function" that can map signed integers into signed
// integers based on a mapping table.  Values are interpolated based on
// the contents of the table.
//
class MaxValueMap: public MaxValueBase
{
    short const *table;

public:
    // Construction
    MaxValueMap (ushort _table_size, short const *_table):
        MaxValueBase (15, _table_size),
        table (_table)
    { }

    // Redefine the map (note that you can change the contents of
    // table without having to call this member).
    // _table_size must be 2^X+1, where X is [1..15]
    void set_map (ushort _table_size, short const *_table)
    {
        table = _table;
        set_shift (15, _table_size);
    }

    // Perform the mapping
    short operator() (short) const;
};


//
// MaxUValueMap -
//  Create a mapping "function" that can map unsigned integers into unsigned
// integers based on a mapping table.  Values are interpolated based on
// the contents of the table.
//
class MaxUValueMap: public MaxValueBase
{
    ushort const    *table;

public:
    // Construction
    MaxUValueMap (ushort _table_size, ushort const *_table):
        MaxValueBase (16, _table_size),
        table (_table)
    { }

    // Redefine the map (note that you can change the contents of
    // table without having to call this member).
    // _table_size must be 2^X+1, where X is [1..15]
    void set_map (ushort _table_size, ushort const *_table)
    {
        table = _table;
        set_shift (16, _table_size);
    }

    // Perform the mapping
    ushort operator() (ushort) const;
};


//
//
//                               Prototypes
//
//

#ifdef _MSC_VER
#pragma pack(pop)
#endif

#endif

// End of header - maxvmap.hpp 
