//
//                oooooooooo.
//                `888'   `Y8b
//                 888     888  .ooooo.    oooooooo  .ooooo.
//                 888oooo888' d88' `88b  d'""7d8P  d88' `88b
//                 888    `88b 888   888    .d8P'   888   888
//                 888    .88P 888   888  .d8P'  .P 888   888
//                o888bood8P'  `Y8bod8P' d8888888P  `Y8bod8P'
//                           _
//                          /_\     |    _  _ | _ ._
//                         /   \  \_||_|(_|(_||(/_|
//                                       _| _|
//                     Microsoft Windows 95/98/NT Version
//
//  Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Dan Higdon
//
// Bozo C++ Wrapper class
//
//      This module contains the high-level C++ code for Bozo's object
// oriented tasking structures.  Since Bozo is a C library, it is
// intentionally very simple.  These wrapper classes add much functionality
// not present in the base Bozo library.  In particular, the concept of
// a task heirarchy is created, where the parent task of a given task
// creates and destroys its "children".  This module is not really a
// proper wrapper, since it knows too much about Bozo.
//
// Revision History 
// $Id: bzwrap.cpp 1.2 1994/12/04 22:25:53 hdan Exp hdan $
//
// $Log: bzwrap.cpp $
// Revision 1.2  1994/12/04 22:25:53  hdan
// Cleaned up the member function names (no leading capital letter!).
//
// Revision 1.1  1994/11/09 04:38:07  hdan
// Initial revision
//
//
//

//
//
//                                Includes
//
//

#include <assert.h>
#include <ivory.hpp>

#include "bzwrap.hpp"

//
//
//                                Equates
//
//

//
//
//                               Structures
//
//

//
//
//                               Routines
//
//

//
//
//                                 Data
//
//

//
//
//                              Code (methods)
//
//


BozoSystem::BozoSystem (IvorySubAlloc *stackspace)
{
    main_task = bz_init_task (stackspace);
}

BozoSystem::~BozoSystem ()
{
    ivory_free ((void **)&main_task);   // No delete, cuz this is a wrapper!
}

BozoSystem::operator bz_task* () const
{
    return main_task;
}


void BozoSystem::set_allocator (IvorySubAlloc *allocator)
{
    bz_set_allocator (allocator);
}



//Ŀ
//  A little hack to make the dispatcher work.  This is the real task,      
//  but it runs the polymorphicly overloaded Run() member function.         
//  (I actually wanted to put the member function itself into the task,     
//  but there was a conflict with which function would be loaded, since     
//  constructors are called from base out.)                                 
//
void BozoTask::iRun (BozoTask *it)
{
    it->run();

    // If the task exits on its own accord, remember so that we don't
    // terminate it twice!

    // If we get here, the current task needs to be destroyed.
    assert (Task == it->task);
    if (it->task)
    {
        it->task = 0;
        ::bz_return ();
    }
    // The else case should never happen, since it is illegal to execute
    // this after the task has been destroyed.
}


//Ŀ
//  API for creating and scheduling a new coroutine                         
//
BozoTask::BozoTask (int _stack_size):
    stack_size (_stack_size),
    parent (Task),
    task (0)
{
}

//Ŀ
//  API for creating and scheduling a new coroutine                         
//
BozoTask::~BozoTask()
{
    // We might get destroyed twice!  Wouldn't want that, would we?
    if (task)
    {
        // Since this task is now free, go on a clean it up
        bz_task *tsk = task;
        task = 0;
        ::bz_term (tsk);
    }
}


//Ŀ
//  API for creating and scheduling a new coroutine                         
//
bz_task *BozoTask::init (bz_task_queue *q)
{
    assert (q != 0);

    // If there's no task, create one
    if (task == 0)
        task = bz_create ((bz_task_func)iRun, stack_size, this);

    // If we now have a task, enter it into the queue and return success
    if (task != 0)
        bzqueue_enter (q, task);

    // Return the task pointer (or null if it fails)
    return task;
}


//Ŀ
//  API for creating and scheduling a new coroutine                         
//
void BozoTask::run ()
{
    // Not much to do in the base case, since this is the "empty task"
}


// End of file - bzwrap.cpp 
